/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.matrix;

import io.fair_acc.math.TRandom;
import io.fair_acc.math.matrix.MatrixD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularValueDecomposition {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingularValueDecomposition.class);
    private static final int MAX_SVD_CONVERSION_LIMIT = 30;
    private static final double TEST_SVD_THRESHOLD = 1.0E-10;
    private static final double TEST_INVERT_THRESHOLD = 1.0E-6;
    private boolean fInit;
    private boolean fInitSVD;
    private MatrixD finputMatrix;
    private MatrixD feigenVectorsU;
    private MatrixD feigenVectorsV;
    private MatrixD fEigenValues;
    private MatrixD fInverseEigenValues;
    private double fCut;

    public SingularValueDecomposition() {
        this.fInit = false;
        this.fInitSVD = false;
        this.fCut = 1.0E-20;
    }

    public SingularValueDecomposition(MatrixD matrixD) {
        int n2 = matrixD.getRowDimension();
        int n3 = matrixD.getColumnDimension();
        this.fInitSVD = false;
        this.fCut = 1.0E-20;
        this.finputMatrix = new MatrixD(n2, n3);
        this.feigenVectorsU = new MatrixD(n2, n3);
        this.fEigenValues = new MatrixD(n3, n3);
        this.fInverseEigenValues = new MatrixD(n3, n3);
        this.feigenVectorsV = new MatrixD(n3, n3);
        this.finputMatrix = matrixD.copy();
        this.fInit = true;
        this.fInitSVD = false;
    }

    public double cond() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        double d2 = this.fEigenValues.get(0, 0);
        int n2 = this.getEigenVectorMatrixU().getRowDimension();
        int n3 = this.getEigenVectorMatrixU().getColumnDimension();
        int n4 = Math.min(n2, n3) - 1;
        double d3 = this.fEigenValues.get(n4, n4);
        return d2 / d3;
    }

    public boolean decompose() {
        return this.decompose(false);
    }

    public boolean decompose(boolean bl2) {
        int n2;
        int n3;
        double[] dArray;
        if (!this.fInit) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().log("no matrix specified");
            }
            return false;
        }
        int n4 = this.finputMatrix.getRowDimension();
        int n5 = this.finputMatrix.getColumnDimension();
        if (n4 == 0 || n5 == 0) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().log(String.format("null matrix specified (%d,%d)", n4, n5));
            }
            return false;
        }
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5 * n5];
        if (bl2) {
            MatrixD matrixD = this.finputMatrix.transpose().times(this.finputMatrix);
            n4 = n5 = matrixD.getRowDimension();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log(String.format("reduced to %dx%d matrix", n5, n5));
            }
            dArray = new double[n5 * n5];
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    dArray[n3 * n5 + n2] = matrixD.get(n3, n2);
                }
            }
        } else {
            dArray = new double[n4 * n5];
            for (int i2 = 0; i2 < n4; ++i2) {
                for (n3 = 0; n3 < n5; ++n3) {
                    dArray[i2 * n5 + n3] = this.finputMatrix.get(i2, n3);
                }
            }
        }
        SingularValueDecomposition.svdcmp(dArray, n4, n5, dArray2, dArray3);
        if (bl2) {
            SingularValueDecomposition.sortEigenValues(dArray2, dArray3);
        } else {
            SingularValueDecomposition.sortEigenValues(dArray, dArray2, dArray3, n4);
        }
        this.fInverseEigenValues.times(0.0);
        this.fEigenValues.times(0.0);
        if (bl2) {
            for (var7_8 = 0; var7_8 < n5; ++var7_8) {
                double d2 = Math.sqrt(dArray2[var7_8]);
                this.fEigenValues.set(var7_8, var7_8, d2);
                if (d2 == 0.0) {
                    this.fInverseEigenValues.set(var7_8, var7_8, 0.0);
                    continue;
                }
                this.fInverseEigenValues.set(var7_8, var7_8, 1.0 / d2);
            }
        } else {
            for (var7_8 = 0; var7_8 < n5; ++var7_8) {
                double d3 = dArray2[var7_8];
                this.fEigenValues.set(var7_8, var7_8, d3);
                if (d3 == 0.0) {
                    this.fInverseEigenValues.set(var7_8, var7_8, 0.0);
                    continue;
                }
                this.fInverseEigenValues.set(var7_8, var7_8, 1.0 / d3);
            }
        }
        if (bl2) {
            MatrixD matrixD = new MatrixD(n5, n5);
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n3 * n5;
                for (int i3 = 0; i3 < n5; ++i3) {
                    this.feigenVectorsV.set(n3, i3, dArray3[n2 + i3]);
                    double d4 = this.fInverseEigenValues.get(i3, i3);
                    matrixD.set(n3, i3, d4 * dArray3[n2 + i3]);
                }
            }
            this.feigenVectorsU = this.finputMatrix.times(matrixD);
        } else {
            MatrixD matrixD = new MatrixD(n5, n5);
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n3 * n5;
                for (int i4 = 0; i4 < n5; ++i4) {
                    this.feigenVectorsV.set(n3, i4, dArray3[n2 + i4]);
                    double d5 = this.fInverseEigenValues.get(i4, i4);
                    matrixD.set(n3, i4, d5 * dArray3[n2 + i4]);
                }
            }
            this.feigenVectorsU = this.finputMatrix.times(matrixD);
        }
        this.fInitSVD = true;
        return true;
    }

    public MatrixD getEigenSolution(int n2) {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int n3 = this.feigenVectorsU.getRowDimension();
        MatrixD matrixD = new MatrixD(n3, 1);
        for (int i2 = 0; i2 < n3; ++i2) {
            matrixD.set(i2, 0, this.feigenVectorsU.get(i2, n2));
        }
        return matrixD;
    }

    public MatrixD getEigenValues() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.fEigenValues;
    }

    public MatrixD getEigenVector(int n2) {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int n3 = this.feigenVectorsV.getRowDimension();
        MatrixD matrixD = new MatrixD(n3, 1);
        for (int i2 = 0; i2 < n3; ++i2) {
            matrixD.set(i2, 0, this.feigenVectorsV.get(i2, n2));
        }
        return matrixD;
    }

    public MatrixD getEigenVectorMatrixU() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.feigenVectorsU;
    }

    public MatrixD getEigenVectorMatrixV() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.feigenVectorsV;
    }

    public MatrixD getInverse() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.getInverse(false, -1);
    }

    public MatrixD getInverse(boolean bl2, int n2) {
        int n3 = this.feigenVectorsU.getRowDimension();
        int n4 = this.feigenVectorsU.getColumnDimension();
        int n5 = n2;
        if (n5 < 0) {
            n5 = this.fEigenValues.getRowDimension() - 1;
        }
        if (n5 < 0 || n5 >= n4) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().log(String.format("selected number of eigenvalues %d exceeds maximum %d . et to max", n5, n4));
            }
            n5 = n4;
        }
        if (!this.fInitSVD) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log(String.format("forced decomposition of %dx%d matrix", n3, n4));
            }
            this.decompose(false);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log(String.format("cut below %e and max %d eigenvalues", this.fCut, n5));
        }
        MatrixD matrixD = new MatrixD(n4, n4);
        double d2 = this.fEigenValues.get(0, 0);
        for (int i2 = 0; i2 < n4; ++i2) {
            double d3 = this.fEigenValues.get(i2, i2);
            if (!(d3 / d2 > this.fCut) || i2 > n5) {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.atDebug().log(String.format("discarding from eigenvalue %d", i2 + 1));
                break;
            }
            matrixD.set(i2, i2, this.fInverseEigenValues.get(i2, i2));
        }
        MatrixD matrixD2 = this.feigenVectorsU.transpose();
        MatrixD matrixD3 = this.feigenVectorsV.times(matrixD.times(matrixD2));
        return matrixD3;
    }

    public MatrixD getMatrix() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.feigenVectorsU.times(this.fEigenValues.times(this.feigenVectorsV.transpose()));
    }

    public MatrixD getPseudoInverseEigenvalues() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.fInverseEigenValues.copy();
    }

    public double[] getSingularValues() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int n2 = this.fEigenValues.getColumnDimension();
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = this.fEigenValues.get(i2, i2);
        }
        return dArray;
    }

    public double getThreshold() {
        return this.fCut;
    }

    public double getTol() {
        return this.getThreshold();
    }

    public MatrixD getU() {
        return this.getEigenVectorMatrixU();
    }

    public MatrixD getV() {
        return this.getEigenVectorMatrixV();
    }

    private static double mySIGN(double d2, double d3) {
        return d3 >= 0.0 ? Math.abs(d2) : -Math.abs(d2);
    }

    @Deprecated
    public double norm2() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.fEigenValues.get(0, 0);
    }

    private static double pythagoras(double d2, double d3) {
        double d4;
        double d5 = Math.abs(d2);
        if (d5 > (d4 = Math.abs(d3))) {
            return d5 * Math.sqrt(1.0 + SingularValueDecomposition.square(d4 / d5));
        }
        return d4 == 0.0 ? 0.0 : d4 * Math.sqrt(1.0 + SingularValueDecomposition.square(d5 / d4));
    }

    public int rank() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int n2 = 0;
        double d2 = Math.pow(2.0, -52.0);
        int n3 = this.getEigenVectorMatrixU().getRowDimension();
        int n4 = this.getEigenVectorMatrixU().getColumnDimension();
        double d3 = this.fEigenValues.get(0, 0);
        double d4 = (double)Math.max(n3, n4) * d3 * d2;
        for (int i2 = 0; i2 < this.fEigenValues.getColumnDimension(); ++i2) {
            double d5 = this.fEigenValues.get(i2, i2);
            if (!(d5 > d4)) continue;
            ++n2;
        }
        return n2;
    }

    public void setMatrix(MatrixD matrixD) {
        int n2 = matrixD.getRowDimension();
        int n3 = matrixD.getColumnDimension();
        this.fInitSVD = false;
        this.fCut = 1.0E-20;
        this.finputMatrix = new MatrixD(n2, n3);
        this.feigenVectorsU = new MatrixD(n2, n3);
        this.fEigenValues = new MatrixD(n3, n3);
        this.fInverseEigenValues = new MatrixD(n3, n3);
        this.feigenVectorsV = new MatrixD(n3, n3);
        this.finputMatrix = matrixD.copy();
        this.fInit = true;
        this.fInitSVD = false;
    }

    public void setThreshold(double d2) {
        this.fCut = d2;
    }

    public void setTol(double d2) {
        this.setThreshold(d2);
    }

    private static void sortEigenValues(double[] dArray, double[] dArray2) {
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            int n3;
            int n4 = i2;
            double d2 = dArray[n4];
            for (n3 = i2 + 1; n3 < n2; ++n3) {
                if (!(dArray[n3] >= d2)) continue;
                n4 = n3;
                d2 = dArray[n4];
            }
            if (n4 == i2) continue;
            dArray[n4] = dArray[i2];
            dArray[i2] = d2;
            for (n3 = 0; n3 < n2; ++n3) {
                d2 = dArray2[n3 * n2 + i2];
                dArray2[n3 * n2 + i2] = dArray2[n3 * n2 + n4];
                dArray2[n3 * n2 + n4] = d2;
            }
        }
    }

    private static void sortEigenValues(double[] dArray, double[] dArray2, double[] dArray3, int n2) {
        int n3 = dArray2.length;
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            double d2 = dArray2[n5];
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (!(dArray2[n4] >= d2)) continue;
                n5 = n4;
                d2 = dArray2[n5];
            }
            if (n5 == i2) continue;
            dArray2[n5] = dArray2[i2];
            dArray2[i2] = d2;
            for (n4 = 0; n4 < n3; ++n4) {
                d2 = dArray3[n4 * n3 + i2];
                dArray3[n4 * n3 + i2] = dArray3[n4 * n3 + n5];
                dArray3[n4 * n3 + n5] = d2;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                d2 = dArray[n4 * n3 + i2];
                dArray[n4 * n3 + i2] = dArray[n4 * n3 + n5];
                dArray[n4 * n3 + n5] = d2;
            }
        }
    }

    private static double square(double d2) {
        return d2 * d2;
    }

    private static void svdcmp(double[] dArray, int n2, int n3, double[] dArray2, double[] dArray3) {
        double d2;
        int n4;
        int n5 = 0;
        int n6 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray4 = new double[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            int n7;
            int n8;
            double d6;
            int n9;
            n5 = n4 + 1;
            dArray4[n4] = d5 * d4;
            d4 = 0.0;
            double d7 = 0.0;
            d5 = 0.0;
            if (n4 < n2) {
                for (n9 = n4; n9 < n2; ++n9) {
                    d5 += Math.abs(dArray[n9 * n3 + n4]);
                }
                if (d5 != 0.0) {
                    for (n9 = n4; n9 < n2; ++n9) {
                        int n10 = n9 * n3 + n4;
                        dArray[n10] = dArray[n10] / d5;
                        d7 += dArray[n9 * n3 + n4] * dArray[n9 * n3 + n4];
                    }
                    double d8 = dArray[n4 * n3 + n4];
                    d4 = -SingularValueDecomposition.mySIGN(Math.sqrt(d7), d8);
                    d6 = d8 * d4 - d7;
                    dArray[n4 * n3 + n4] = d8 - d4;
                    for (n8 = n5; n8 < n3; ++n8) {
                        d7 = 0.0;
                        for (n7 = n4; n7 < n2; ++n7) {
                            d7 += dArray[n7 * n3 + n4] * dArray[n7 * n3 + n8];
                        }
                        d8 = d7 / d6;
                        for (n7 = n4; n7 < n2; ++n7) {
                            int n11 = n7 * n3 + n8;
                            dArray[n11] = dArray[n11] + d8 * dArray[n7 * n3 + n4];
                        }
                    }
                    for (n8 = n4; n8 < n2; ++n8) {
                        int n12 = n8 * n3 + n4;
                        dArray[n12] = dArray[n12] * d5;
                    }
                }
            }
            dArray2[n4] = d5 * d4;
            d4 = 0.0;
            d7 = 0.0;
            d5 = 0.0;
            if (n4 < n2 && n4 != n3 - 1) {
                for (n9 = n5; n9 < n3; ++n9) {
                    d5 += Math.abs(dArray[n4 * n3 + n9]);
                }
                if (d5 != 0.0) {
                    for (n9 = n5; n9 < n3; ++n9) {
                        int n13 = n4 * n3 + n9;
                        dArray[n13] = dArray[n13] / d5;
                        d7 += dArray[n4 * n3 + n9] * dArray[n4 * n3 + n9];
                    }
                    double d9 = dArray[n4 * n3 + n5];
                    d4 = -SingularValueDecomposition.mySIGN(Math.sqrt(d7), d9);
                    d6 = d9 * d4 - d7;
                    dArray[n4 * n3 + n5] = d9 - d4;
                    for (n8 = n5; n8 < n3; ++n8) {
                        dArray4[n8] = dArray[n4 * n3 + n8] / d6;
                    }
                    for (n8 = n5; n8 < n2; ++n8) {
                        d7 = 0.0;
                        for (n7 = n5; n7 < n3; ++n7) {
                            d7 += dArray[n8 * n3 + n7] * dArray[n4 * n3 + n7];
                        }
                        for (n7 = n5; n7 < n3; ++n7) {
                            int n14 = n8 * n3 + n7;
                            dArray[n14] = dArray[n14] + d7 * dArray4[n7];
                        }
                    }
                    for (n8 = n5; n8 < n3; ++n8) {
                        int n15 = n4 * n3 + n8;
                        dArray[n15] = dArray[n15] * d5;
                    }
                }
            }
            d3 = Math.max(d3, Math.abs(dArray2[n4]) + Math.abs(dArray4[n4]));
        }
        n4 = n3 - 1;
        while (n4 >= 0) {
            if (n4 < n3 - 1) {
                int n16;
                if (d4 != 0.0) {
                    for (n16 = n5; n16 < n3; ++n16) {
                        dArray3[n16 * n3 + n4] = dArray[n4 * n3 + n16] / dArray[n4 * n3 + n5] / d4;
                    }
                    for (n16 = n5; n16 < n3; ++n16) {
                        int n17;
                        d2 = 0.0;
                        for (n17 = n5; n17 < n3; ++n17) {
                            d2 += dArray[n4 * n3 + n17] * dArray3[n17 * n3 + n16];
                        }
                        for (n17 = n5; n17 < n3; ++n17) {
                            int n18 = n17 * n3 + n16;
                            dArray3[n18] = dArray3[n18] + d2 * dArray3[n17 * n3 + n4];
                        }
                    }
                }
                for (n16 = n5; n16 < n3; ++n16) {
                    dArray3[n4 * n3 + n16] = 0.0;
                    dArray3[n16 * n3 + n4] = 0.0;
                }
            }
            dArray3[n4 * n3 + n4] = 1.0;
            d4 = dArray4[n4];
            n5 = n4--;
        }
        for (n4 = Math.min(n2 - 1, n3 - 1); n4 >= 0; --n4) {
            int n19;
            n5 = n4 + 1;
            d4 = dArray2[n4];
            for (n19 = n5; n19 < n3; ++n19) {
                dArray[n4 * n3 + n19] = 0.0;
            }
            if (d4 == 0.0) {
                for (n19 = n4; n19 < n2; ++n19) {
                    dArray[n19 * n3 + n4] = 0.0;
                }
            } else {
                d4 = 1.0 / d4;
                for (n19 = n5; n19 < n3; ++n19) {
                    d2 = 0.0;
                    for (int i2 = n5; i2 < n2; ++i2) {
                        d2 += dArray[i2 * n3 + n4] * dArray[i2 * n3 + n19];
                    }
                    double d10 = d2 / dArray[n4 * n3 + n4] * d4;
                    for (int i3 = n4; i3 < n2; ++i3) {
                        int n20 = i3 * n3 + n19;
                        dArray[n20] = dArray[n20] + d10 * dArray[i3 * n3 + n4];
                    }
                }
                for (n19 = n4; n19 < n2; ++n19) {
                    int n21 = n19 * n3 + n4;
                    dArray[n21] = dArray[n21] * d4;
                }
            }
            int n22 = n4 * n3 + n4;
            dArray[n22] = dArray[n22] + 1.0;
        }
        block27: for (n4 = n3 - 1; n4 >= 0; --n4) {
            for (int i4 = 1; i4 <= 30; ++i4) {
                double d11;
                double d12;
                boolean bl2 = true;
                for (n5 = n4; n5 > 0; --n5) {
                    n6 = n5 - 1;
                    if (Math.abs(dArray4[n5]) + d3 == d3) {
                        bl2 = false;
                        break;
                    }
                    if (Math.abs(dArray2[n6]) + d3 == d3) break;
                }
                if (bl2) {
                    d12 = 0.0;
                    d11 = 1.0;
                    for (int i5 = n5; i5 <= n4; ++i5) {
                        double d13;
                        double d14 = d11 * dArray4[i5];
                        dArray4[i5] = d12 * dArray4[i5];
                        if (Math.abs(d14) + d3 == d3) break;
                        d4 = dArray2[i5];
                        dArray2[i5] = d13 = SingularValueDecomposition.pythagoras(d14, d4);
                        d13 = 1.0 / d13;
                        d12 = d4 * d13;
                        d11 = -d14 * d13;
                        for (int i6 = 0; i6 < n2; ++i6) {
                            int n23 = i6 * n3;
                            double d15 = dArray[n23 + n6];
                            double d16 = dArray[n23 + i5];
                            dArray[n23 + n6] = d15 * d12 + d16 * d11;
                            dArray[n23 + i5] = d16 * d12 - d15 * d11;
                        }
                    }
                }
                d12 = dArray2[n4];
                if (n5 == n4) {
                    if (!(d12 < 0.0)) continue block27;
                    dArray2[n4] = -d12;
                    for (int i7 = 0; i7 < n3; ++i7) {
                        dArray3[i7 * n3 + n4] = -dArray3[i7 * n3 + n4];
                    }
                    continue block27;
                }
                if (i4 == 30) {
                    if (!LOGGER.isWarnEnabled()) continue block27;
                    LOGGER.atWarn().log(String.format("no convergence in %d svdcmp iterations", 30));
                    continue block27;
                }
                d11 = dArray2[n5];
                n6 = n4 - 1;
                double d17 = dArray2[n6];
                d4 = dArray4[n6];
                double d18 = dArray4[n4];
                double d19 = ((d17 - d12) * (d17 + d12) + (d4 - d18) * (d4 + d18)) / (2.0 * d18 * d17);
                d4 = SingularValueDecomposition.pythagoras(d19, 1.0);
                d19 = ((d11 - d12) * (d11 + d12) + d18 * (d17 / (d19 + SingularValueDecomposition.mySIGN(d4, d19)) - d18)) / d11;
                double d20 = 1.0;
                double d21 = 1.0;
                for (int i8 = n5; i8 <= n6; ++i8) {
                    int n24;
                    int n25;
                    int n26 = i8 + 1;
                    d4 = dArray4[n26];
                    d17 = dArray2[n26];
                    d18 = d21 * d4;
                    d4 = d20 * d4;
                    dArray4[i8] = d12 = SingularValueDecomposition.pythagoras(d19, d18);
                    d20 = d19 / d12;
                    d21 = d18 / d12;
                    d19 = d11 * d20 + d4 * d21;
                    d4 = d4 * d20 - d11 * d21;
                    d18 = d17 * d21;
                    d17 *= d20;
                    for (n25 = 0; n25 < n3; ++n25) {
                        n24 = n25 * n3;
                        d11 = dArray3[n24 + i8];
                        d12 = dArray3[n24 + n26];
                        dArray3[n24 + i8] = d11 * d20 + d12 * d21;
                        dArray3[n24 + n26] = d12 * d20 - d11 * d21;
                    }
                    dArray2[i8] = d12 = SingularValueDecomposition.pythagoras(d19, d18);
                    if (d12 != 0.0) {
                        d12 = 1.0 / d12;
                        d20 = d19 * d12;
                        d21 = d18 * d12;
                    }
                    d19 = d20 * d4 + d21 * d17;
                    d11 = d20 * d17 - d21 * d4;
                    for (n25 = 0; n25 < n2; ++n25) {
                        n24 = n25 * n3;
                        d17 = dArray[n24 + i8];
                        d12 = dArray[n24 + n26];
                        dArray[n24 + i8] = d17 * d20 + d12 * d21;
                        dArray[n24 + n26] = d12 * d20 - d17 * d21;
                    }
                }
                dArray4[n5] = 0.0;
                dArray4[n4] = d19;
                dArray2[n4] = d11;
            }
        }
    }

    public boolean testInvert() {
        return this.testInvert(1.0E-6);
    }

    public boolean testInvert(double d2) {
        double d3 = this.getTol();
        this.setTol(0.0);
        MatrixD matrixD = this.getInverse();
        MatrixD matrixD2 = this.finputMatrix;
        MatrixD matrixD3 = matrixD.times(matrixD2);
        this.setTol(d3);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log(String.format("dimension of test matrix %dx%d", matrixD3.getRowDimension(), matrixD3.getColumnDimension()));
        }
        int n2 = this.fEigenValues.getRowDimension() - 1;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log(String.format("max/min eigenvalue ratio: %+e", this.fEigenValues.get(0, 0) / this.fEigenValues.get(n2, n2)));
        }
        for (int i2 = 0; i2 < matrixD3.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < matrixD3.getColumnDimension(); ++i3) {
                if (i2 == i3) {
                    matrixD3.set(i2, i3, matrixD3.get(i2, i3) - 1.0);
                }
                if (!(Math.abs(matrixD3.get(i2, i3)) > d2)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atWarn().addArgument(i2).addArgument(i3).addArgument(matrixD3.get(i2, i3)).log("TestInvert() - found that element ({},{}) differs {} from zero!");
                }
                return false;
            }
        }
        return true;
    }

    public boolean testSVD() {
        return this.testSVD(1.0E-10);
    }

    public boolean testSVD(double d2) {
        MatrixD matrixD = this.finputMatrix.minus(this.getMatrix());
        for (int i2 = 0; i2 < matrixD.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < matrixD.getColumnDimension(); ++i3) {
                if (!(Math.abs(matrixD.get(i2, i3)) > d2)) continue;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.atWarn().log(String.format("found that element (%d,%d) differs %e from zero!", i2, i3, matrixD.get(i2, i3)));
                }
                return false;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        TRandom tRandom = new TRandom(1L);
        MatrixD matrixD = new MatrixD(200, 100);
        for (int i2 = 0; i2 < matrixD.getRowDimension(); ++i2) {
            for (int i3 = 0; i3 < matrixD.getColumnDimension(); ++i3) {
                double d2 = TRandom.Integer(10L);
                matrixD.set(i2, i3, d2);
            }
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrixD);
        MatrixD matrixD2 = null;
        MatrixD matrixD3 = null;
        boolean bl2 = true;
        if (singularValueDecomposition.decompose(true)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.atInfo().log("decompose() - square intermediate matrix - successful");
            }
            matrixD2 = singularValueDecomposition.getEigenValues();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.atInfo().log("decompose() - failed");
        }
        if (singularValueDecomposition.decompose(false)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.atInfo().log("decompose() - successful");
            }
            matrixD3 = singularValueDecomposition.getEigenValues();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.atInfo().log("decompose() - failed");
        }
        if (matrixD2 != null && matrixD3 != null) {
            for (var7_10 = 0; var7_10 < matrixD2.getRowDimension(); ++var7_10) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.atInfo().addArgument(var7_10).addArgument(matrixD2.get(var7_10, var7_10)).addArgument(matrixD3.get(var7_10, var7_10)).addArgument(matrixD2.get(var7_10, var7_10) - matrixD3.get(var7_10, var7_10)).log("eigenvalue({}) = {} vs {}   diff = {}");
            }
        } else if (matrixD2 != null) {
            for (var7_10 = 0; var7_10 < matrixD2.getRowDimension(); ++var7_10) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.atInfo().addArgument(var7_10).addArgument(matrixD2.get(var7_10, var7_10)).log("eigenvalue({}) = {}");
            }
        } else if (matrixD3 != null) {
            for (var7_10 = 0; var7_10 < matrixD3.getRowDimension(); ++var7_10) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.atInfo().addArgument(var7_10).addArgument(matrixD3.get(var7_10, var7_10)).log("eigenvalue({}) = {}");
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.atInfo().addArgument(singularValueDecomposition.norm2()).log("norm2 = %lf");
            LOGGER.atInfo().addArgument(singularValueDecomposition.cond()).log("cond = {}");
            LOGGER.atInfo().addArgument(singularValueDecomposition.rank()).log("rank = {}");
            LOGGER.atInfo().log("check - testSVD()");
        }
        if (singularValueDecomposition.testSVD()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.atInfo().log("testSVD() - passed");
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().log("testSVD() - failed");
        }
        LOGGER.atInfo().log("check - testInvert()");
        if (singularValueDecomposition.testInvert()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.atInfo().log("testInvert() - passed");
            }
        } else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().log("testInvert() - failed");
            }
            if (matrixD.getRowDimension() < 20 && matrixD.getColumnDimension() < 20) {
                MatrixD matrixD4 = singularValueDecomposition.getEigenValues();
                MatrixD matrixD5 = singularValueDecomposition.getPseudoInverseEigenvalues();
                MatrixD matrixD6 = singularValueDecomposition.getEigenVectorMatrixU();
                MatrixD matrixD7 = singularValueDecomposition.getEigenVectorMatrixV();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.atInfo().log("eigenvalues x pseudo-inverse eigenvalue matrix =");
                    matrixD4.times(matrixD5).print(4, 3);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.atInfo().log("V x Vt =");
                    matrixD7.times(matrixD7.transpose()).print(4, 2);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.atInfo().log("U x Ut =");
                    matrixD6.times(matrixD6.transpose()).print(4, 2);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.atInfo().log("Ut x U =");
                    matrixD6.transpose().times(matrixD6).print(4, 2);
                }
            }
        }
    }
}

