/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class Biquad {
    public double mA0;
    public double mA1;
    public double mA2;
    public double mB1;
    public double mB2;
    public double mB0;

    public void applyScale(double d2) {
        this.mB0 *= d2;
        this.mB1 *= d2;
        this.mB2 *= d2;
    }

    public double getA0() {
        return this.mA0;
    }

    public double getA1() {
        return this.mA1 * this.mA0;
    }

    public double getA2() {
        return this.mA2 * this.mA0;
    }

    public double getB0() {
        return this.mB0 * this.mA0;
    }

    public double getB1() {
        return this.mB1 * this.mA0;
    }

    public double getB2() {
        return this.mB2 * this.mA0;
    }

    public Complex response(double d2) {
        double d3 = this.getA0();
        double d4 = this.getA1();
        double d5 = this.getA2();
        double d6 = this.getB0();
        double d7 = this.getB1();
        double d8 = this.getB2();
        double d9 = Math.PI * 2 * d2;
        Complex complex = ComplexUtils.polar2Complex((double)1.0, (double)(-d9));
        Complex complex2 = ComplexUtils.polar2Complex((double)1.0, (double)(-2.0 * d9));
        Complex complex3 = new Complex(1.0);
        Complex complex4 = new Complex(1.0);
        Complex complex5 = new Complex(d6 / d3);
        complex5 = complex5.add(complex.multiply(d7 / d3));
        complex5 = complex5.add(complex2.multiply(d8 / d3));
        Complex complex6 = new Complex(1.0);
        complex6 = complex6.add(complex.multiply(d4 / d3));
        complex6 = complex6.add(complex2.multiply(d5 / d3));
        complex3 = complex3.multiply(complex5);
        complex4 = complex4.multiply(complex6);
        return complex3.divide(complex4);
    }

    public void setCoefficients(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.mA0 = d2;
        this.mA1 = d3 / d2;
        this.mA2 = d4 / d2;
        this.mB0 = d5 / d2;
        this.mB1 = d6 / d2;
        this.mB2 = d7 / d2;
    }

    public void setIdentity() {
        this.setCoefficients(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void setOnePole(Complex complex, Complex complex2) {
        double d2 = 1.0;
        double d3 = -complex.getReal();
        double d4 = 0.0;
        double d5 = -complex2.getReal();
        double d6 = 1.0;
        double d7 = 0.0;
        this.setCoefficients(1.0, d3, 0.0, d5, 1.0, 0.0);
    }

    public void setPoleZeroPair(PoleZeroPair poleZeroPair) {
        if (poleZeroPair.isSinglePole()) {
            this.setOnePole(poleZeroPair.poles.first, poleZeroPair.zeros.first);
        } else {
            this.setTwoPole(poleZeroPair.poles.first, poleZeroPair.zeros.first, poleZeroPair.poles.second, poleZeroPair.zeros.second);
        }
    }

    public void setTwoPole(Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = 1.0;
        if (complex.getImaginary() == 0.0) {
            d5 = -(complex.getReal() + complex3.getReal());
            d4 = complex.getReal() * complex3.getReal();
        } else {
            d5 = -2.0 * complex.getReal();
            d4 = complex.abs() * complex.abs();
        }
        double d7 = 1.0;
        if (complex2.getImaginary() == 0.0) {
            d3 = -(complex2.getReal() + complex4.getReal());
            d2 = complex2.getReal() * complex4.getReal();
        } else {
            d3 = -2.0 * complex2.getReal();
            d2 = complex2.abs() * complex2.abs();
        }
        this.setCoefficients(1.0, d5, d4, 1.0, d3, d2);
    }
}

