/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.math.ArrayUtils;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;

public class ArrayMath {
    protected static final String DIVISOR = "divisor";
    protected static final String IN = "in";
    protected static final String MULTIPLICATOR = "multiplicator";
    protected static final String VALUE = "value";

    ArrayMath() {
        throw new IllegalStateException("Utility class");
    }

    public static double[] add(double[] dArray, double d2) {
        return ArrayMath.add(dArray, 0, d2, dArray.length);
    }

    public static double[] add(double[] dArray, double[] dArray2) {
        return ArrayMath.add(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] add(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(VALUE, dArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, dArray2.length);
        double[] dArray3 = new double[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray3[i2] = dArray[i2 + n2] + dArray2[i2 + n3];
        }
        return dArray3;
    }

    public static double[] add(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = dArray[i2 + n2] + d2;
        }
        return dArray2;
    }

    public static double[] addInPlace(double[] dArray, double d2) {
        return ArrayMath.addInPlace(dArray, 0, d2, dArray.length);
    }

    public static double[] addInPlace(double[] dArray, double[] dArray2) {
        return ArrayMath.addInPlace(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] addInPlace(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(VALUE, dArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, dArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            dArray[n5] = dArray[n5] + dArray2[i2 + n3];
        }
        return dArray;
    }

    public static double[] addInPlace(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] + d2;
        }
        return dArray;
    }

    public static float[] add(float[] fArray, float f2) {
        return ArrayMath.add(fArray, 0, f2, fArray.length);
    }

    public static float[] add(float[] fArray, float[] fArray2) {
        return ArrayMath.add(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] add(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(VALUE, fArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, fArray2.length);
        float[] fArray3 = new float[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            fArray3[i2] = fArray[i2 + n2] + fArray2[i2 + n3];
        }
        return fArray3;
    }

    public static float[] add(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = fArray[i2 + n2] + f2;
        }
        return fArray2;
    }

    public static float[] addInPlace(float[] fArray, float f2) {
        return ArrayMath.addInPlace(fArray, 0, f2, fArray.length);
    }

    public static float[] addInPlace(float[] fArray, float[] fArray2) {
        return ArrayMath.addInPlace(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] addInPlace(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(VALUE, fArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, fArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            fArray[n5] = fArray[n5] + fArray2[i2 + n3];
        }
        return fArray;
    }

    public static float[] addInPlace(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] + f2;
        }
        return fArray;
    }

    public static int[] add(int[] nArray, int n2) {
        return ArrayMath.add(nArray, 0, n2, nArray.length);
    }

    public static int[] add(int[] nArray, int[] nArray2) {
        return ArrayMath.add(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] add(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(VALUE, nArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, nArray2.length);
        int[] nArray3 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray3[i2] = nArray[i2 + n2] + nArray2[i2 + n3];
        }
        return nArray3;
    }

    public static int[] add(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        int[] nArray2 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray2[i2] = nArray[i2 + n2] + n3;
        }
        return nArray2;
    }

    public static int[] addInPlace(int[] nArray, int n2) {
        return ArrayMath.addInPlace(nArray, 0, n2, nArray.length);
    }

    public static int[] addInPlace(int[] nArray, int[] nArray2) {
        return ArrayMath.addInPlace(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] addInPlace(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(VALUE, nArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, nArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            nArray[n5] = nArray[n5] + nArray2[i2 + n3];
        }
        return nArray;
    }

    public static int[] addInPlace(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        int n5 = n2;
        while (n5 < n4 + n2) {
            int n6 = n5++;
            nArray[n6] = nArray[n6] + n3;
        }
        return nArray;
    }

    public static long[] add(long[] lArray, long l2) {
        return ArrayMath.add(lArray, 0, l2, lArray.length);
    }

    public static long[] add(long[] lArray, long[] lArray2) {
        return ArrayMath.add(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] add(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(VALUE, lArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, lArray2.length);
        long[] lArray3 = new long[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            lArray3[i2] = lArray[i2 + n2] + lArray2[i2 + n3];
        }
        return lArray3;
    }

    public static long[] add(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        long[] lArray2 = new long[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray2[i2] = lArray[i2 + n2] + l2;
        }
        return lArray2;
    }

    public static long[] addInPlace(long[] lArray, long l2) {
        return ArrayMath.addInPlace(lArray, 0, l2, lArray.length);
    }

    public static long[] addInPlace(long[] lArray, long[] lArray2) {
        return ArrayMath.addInPlace(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] addInPlace(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(VALUE, lArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, lArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            lArray[n5] = lArray[n5] + lArray2[i2 + n3];
        }
        return lArray;
    }

    public static long[] addInPlace(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            lArray[n5] = lArray[n5] + l2;
        }
        return lArray;
    }

    public static short[] add(short[] sArray, short s2) {
        return ArrayMath.add(sArray, 0, s2, sArray.length);
    }

    public static short[] add(short[] sArray, short[] sArray2) {
        return ArrayMath.add(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] add(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(VALUE, sArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, sArray2.length);
        short[] sArray3 = new short[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            sArray3[i2] = (short)(sArray[i2 + n2] + sArray2[i2 + n3]);
        }
        return sArray3;
    }

    public static short[] add(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        short[] sArray2 = new short[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray2[i2] = (short)(sArray[i2 + n2] + s2);
        }
        return sArray2;
    }

    public static short[] addInPlace(short[] sArray, short s2) {
        return ArrayMath.addInPlace(sArray, 0, s2, sArray.length);
    }

    public static short[] addInPlace(short[] sArray, short[] sArray2) {
        return ArrayMath.addInPlace(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] addInPlace(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(VALUE, sArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, sArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            sArray[n5] = (short)(sArray[n5] + sArray2[i2 + n3]);
        }
        return sArray;
    }

    public static short[] addInPlace(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            sArray[n5] = (short)(sArray[n5] + s2);
        }
        return sArray;
    }

    public static double[] decibel(double[] dArray) {
        return ArrayMath.decibel(dArray, 0, dArray.length);
    }

    public static double[] decibel(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = 20.0 * MathBase.log10(dArray[i2 + n2]);
        }
        return dArray2;
    }

    public static double[] decibelInPlace(double[] dArray) {
        return ArrayMath.decibelInPlace(dArray, 0, dArray.length);
    }

    public static double[] decibelInPlace(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3, dArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            dArray[i2] = 20.0 * MathBase.log10(dArray[i2]);
        }
        return dArray;
    }

    public static float[] decibel(float[] fArray) {
        return ArrayMath.decibel(fArray, 0, fArray.length);
    }

    public static float[] decibel(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = (float)(20.0 * MathBase.log10(fArray[i2 + n2]));
        }
        return fArray2;
    }

    public static float[] decibelInPlace(float[] fArray) {
        return ArrayMath.decibelInPlace(fArray, 0, fArray.length);
    }

    public static float[] decibelInPlace(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3, fArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            fArray[i2] = (float)(20.0 * MathBase.log10(fArray[i2]));
        }
        return fArray;
    }

    public static double[] divide(double[] dArray, double d2) {
        return ArrayMath.divide(dArray, 0, d2, dArray.length);
    }

    public static double[] divide(double[] dArray, double[] dArray2) {
        return ArrayMath.divide(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] divide(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(DIVISOR, dArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, dArray2.length);
        double[] dArray3 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray3[i2] = dArray2[i2 + n3] == 0.0 ? Double.NaN : dArray[i2 + n2] / dArray2[i2 + n3];
        }
        return dArray3;
    }

    public static double[] divide(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        if (d2 == 0.0) {
            return ArrayMath.notANumberInPlace(dArray2);
        }
        double d3 = 1.0 / d2;
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = dArray[i2 + n2] * d3;
        }
        return dArray2;
    }

    public static double[] divideInPlace(double[] dArray, double d2) {
        return ArrayMath.divideInPlace(dArray, 0, d2, dArray.length);
    }

    public static double[] divideInPlace(double[] dArray, double[] dArray2) {
        return ArrayMath.divideInPlace(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] divideInPlace(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(DIVISOR, dArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, dArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if (dArray2[i2 + n2] == 0.0) {
                dArray[i2] = Double.NaN;
                continue;
            }
            int n5 = i2 + n2;
            dArray[n5] = dArray[n5] / dArray2[i2 + n3];
        }
        return dArray;
    }

    public static double[] divideInPlace(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        if (d2 == 0.0) {
            return ArrayMath.notANumberInPlace(dArray);
        }
        double d3 = 1.0 / d2;
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] * d3;
        }
        return dArray;
    }

    public static float[] divide(float[] fArray, float f2) {
        return ArrayMath.divide(fArray, 0, f2, fArray.length);
    }

    public static float[] divide(float[] fArray, float[] fArray2) {
        return ArrayMath.divide(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] divide(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(DIVISOR, fArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, fArray2.length);
        float[] fArray3 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = (double)fArray2[i2 + n3] == 0.0 ? Float.NaN : fArray[i2 + n2] / fArray2[i2 + n3];
        }
        return fArray3;
    }

    public static float[] divide(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        if ((double)f2 == 0.0) {
            return ArrayMath.notANumberInPlace(fArray2);
        }
        float f3 = 1.0f / f2;
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = fArray[i2 + n2] * f3;
        }
        return fArray2;
    }

    public static float[] divideInPlace(float[] fArray, float f2) {
        return ArrayMath.divideInPlace(fArray, 0, f2, fArray.length);
    }

    public static float[] divideInPlace(float[] fArray, float[] fArray2) {
        return ArrayMath.divideInPlace(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] divideInPlace(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(DIVISOR, fArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, fArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if ((double)fArray2[i2 + n2] == 0.0) {
                fArray[i2] = Float.NaN;
                continue;
            }
            int n5 = i2 + n2;
            fArray[n5] = fArray[n5] / fArray2[i2 + n3];
        }
        return fArray;
    }

    public static float[] divideInPlace(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        if ((double)f2 == 0.0) {
            return ArrayMath.notANumberInPlace(fArray);
        }
        float f3 = 1.0f / f2;
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] * f3;
        }
        return fArray;
    }

    public static long[] divide(long[] lArray, long l2) {
        return ArrayMath.divide(lArray, 0, l2, lArray.length);
    }

    public static long[] divide(long[] lArray, long[] lArray2) {
        return ArrayMath.divide(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] divide(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(DIVISOR, lArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, lArray2.length);
        long[] lArray3 = new long[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if ((double)lArray2[i2 + n3] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            lArray3[i2 + n2] = lArray[i2 + n2] / lArray2[i2 + n3];
        }
        return lArray3;
    }

    public static long[] divide(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        long[] lArray2 = new long[n3];
        if ((double)l2 == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray2[i2 + n2] = lArray[i2 + n2] / l2;
        }
        return lArray2;
    }

    public static long[] divideInPlace(long[] lArray, long l2) {
        return ArrayMath.divideInPlace(lArray, 0, l2, lArray.length);
    }

    public static long[] divideInPlace(long[] lArray, long[] lArray2) {
        return ArrayMath.divideInPlace(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] divideInPlace(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(DIVISOR, lArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, lArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if ((double)lArray2[i2 + n3] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            int n5 = i2 + n2;
            lArray[n5] = lArray[n5] / lArray2[i2 + n3];
        }
        return lArray;
    }

    public static long[] divideInPlace(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3, lArray.length);
        if ((double)l2 == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            lArray[n5] = lArray[n5] / l2;
        }
        return lArray;
    }

    public static int[] divide(int[] nArray, int n2) {
        return ArrayMath.divide(nArray, 0, n2, nArray.length);
    }

    public static int[] divide(int[] nArray, int[] nArray2) {
        return ArrayMath.divide(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] divide(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(DIVISOR, nArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, nArray2.length);
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if ((double)nArray2[i2 + n3] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            nArray3[i2 + n2] = nArray[i2 + n2] / nArray2[i2 + n3];
        }
        return nArray3;
    }

    public static int[] divide(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        int[] nArray2 = new int[n4];
        if ((double)n3 == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray2[i2 + n2] = nArray[i2 + n2] / n3;
        }
        return nArray2;
    }

    public static int[] divideInPlace(int[] nArray, int n2) {
        return ArrayMath.divideInPlace(nArray, 0, n2, nArray.length);
    }

    public static int[] divideInPlace(int[] nArray, int[] nArray2) {
        return ArrayMath.divideInPlace(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] divideInPlace(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(DIVISOR, nArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, nArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if ((double)nArray2[i2 + n3] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            int n5 = i2 + n2;
            nArray[n5] = nArray[n5] / nArray2[i2 + n3];
        }
        return nArray;
    }

    public static int[] divideInPlace(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4, nArray.length);
        if ((double)n3 == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        int n5 = n2;
        while (n5 < n4 + n2) {
            int n6 = n5++;
            nArray[n6] = nArray[n6] / n3;
        }
        return nArray;
    }

    public static short[] divide(short[] sArray, short s2) {
        return ArrayMath.divide(sArray, 0, s2, sArray.length);
    }

    public static short[] divide(short[] sArray, short[] sArray2) {
        return ArrayMath.divide(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] divide(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(DIVISOR, sArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, sArray2.length);
        short[] sArray3 = new short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if ((double)sArray2[i2 + n3] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            sArray3[i2 + n2] = (short)(sArray[i2 + n2] / sArray2[i2 + n3]);
        }
        return sArray3;
    }

    public static short[] divide(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        short[] sArray2 = new short[n3];
        if ((double)s2 == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray2[i2 + n2] = (short)(sArray[i2 + n2] / s2);
        }
        return sArray2;
    }

    public static short[] divideInPlace(short[] sArray, short s2) {
        return ArrayMath.divideInPlace(sArray, 0, s2, sArray.length);
    }

    public static short[] divideInPlace(short[] sArray, short[] sArray2) {
        return ArrayMath.divideInPlace(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] divideInPlace(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(DIVISOR, sArray2);
        AssertUtils.gtOrEqual(DIVISOR, n4 + n3, sArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if ((double)sArray2[i2 + n3] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            int n5 = i2 + n2;
            sArray[n5] = (short)(sArray[n5] / sArray2[i2 + n3]);
        }
        return sArray;
    }

    public static short[] divideInPlace(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3, sArray.length);
        if ((double)s2 == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            sArray[n5] = (short)(sArray[n5] / s2);
        }
        return sArray;
    }

    public static double[] inverseDecibel(double[] dArray) {
        return ArrayMath.inverseDecibel(dArray, 0, dArray.length);
    }

    public static double[] inverseDecibel(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2 + n2] = Math.pow(10.0, dArray[i2] / 20.0);
        }
        return dArray2;
    }

    public static double[] inverseDecibelInPlace(double[] dArray) {
        return ArrayMath.inverseDecibelInPlace(dArray, 0, dArray.length);
    }

    public static double[] inverseDecibelInPlace(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            dArray[i2] = Math.pow(10.0, dArray[i2] / 20.0);
        }
        return dArray;
    }

    public static float[] inverseDecibel(float[] fArray) {
        return ArrayMath.inverseDecibel(fArray, 0, fArray.length);
    }

    public static float[] inverseDecibel(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2 + n2] = (float)Math.pow(10.0, fArray[i2] / 20.0f);
        }
        return fArray2;
    }

    public static float[] inverseDecibelInPlace(float[] fArray) {
        return ArrayMath.inverseDecibelInPlace(fArray, 0, fArray.length);
    }

    public static float[] inverseDecibelInPlace(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            fArray[i2] = (float)Math.pow(10.0, fArray[i2] / 20.0f);
        }
        return fArray;
    }

    public static double[] multiply(double[] dArray, double d2) {
        return ArrayMath.multiply(dArray, 0, d2, dArray.length);
    }

    public static double[] multiply(double[] dArray, double[] dArray2) {
        return ArrayMath.multiply(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] multiply(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(MULTIPLICATOR, dArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, dArray2.length);
        double[] dArray3 = new double[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray3[i2] = dArray[i2 + n2] * dArray2[i2 + n3];
        }
        return dArray3;
    }

    public static double[] multiply(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = dArray[i2 + n2] * d2;
        }
        return dArray2;
    }

    public static double[] multiplyInPlace(double[] dArray, double d2) {
        return ArrayMath.multiplyInPlace(dArray, 0, d2, dArray.length);
    }

    public static double[] multiplyInPlace(double[] dArray, double[] dArray2) {
        return ArrayMath.multiplyInPlace(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] multiplyInPlace(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(MULTIPLICATOR, dArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, dArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            dArray[n5] = dArray[n5] * dArray2[i2 + n3];
        }
        return dArray;
    }

    public static double[] multiplyInPlace(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] * d2;
        }
        return dArray;
    }

    public static float[] multiply(float[] fArray, float f2) {
        return ArrayMath.multiply(fArray, 0, f2, fArray.length);
    }

    public static float[] multiply(float[] fArray, float[] fArray2) {
        return ArrayMath.multiply(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] multiply(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(MULTIPLICATOR, fArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, fArray2.length);
        float[] fArray3 = new float[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            fArray3[i2] = fArray[i2 + n2] * fArray2[i2 + n3];
        }
        return fArray3;
    }

    public static float[] multiply(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = fArray[i2 + n2] * f2;
        }
        return fArray2;
    }

    public static float[] multiplyInPlace(float[] fArray, float f2) {
        return ArrayMath.multiplyInPlace(fArray, 0, f2, fArray.length);
    }

    public static float[] multiplyInPlace(float[] fArray, float[] fArray2) {
        return ArrayMath.multiplyInPlace(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] multiplyInPlace(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(MULTIPLICATOR, fArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, fArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            fArray[n5] = fArray[n5] * fArray2[i2 + n3];
        }
        return fArray;
    }

    public static float[] multiplyInPlace(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] * f2;
        }
        return fArray;
    }

    public static int[] multiply(int[] nArray, int n2) {
        return ArrayMath.multiply(nArray, 0, n2, nArray.length);
    }

    public static int[] multiply(int[] nArray, int[] nArray2) {
        return ArrayMath.multiply(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] multiply(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(MULTIPLICATOR, nArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, nArray2.length);
        int[] nArray3 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray3[i2] = nArray[i2 + n2] * nArray2[i2 + n3];
        }
        return nArray3;
    }

    public static int[] multiply(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        int[] nArray2 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray2[i2] = nArray[i2 + n2] * n3;
        }
        return nArray2;
    }

    public static int[] multiplyInPlace(int[] nArray, int n2) {
        return ArrayMath.multiplyInPlace(nArray, 0, n2, nArray.length);
    }

    public static int[] multiplyInPlace(int[] nArray, int[] nArray2) {
        return ArrayMath.multiplyInPlace(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] multiplyInPlace(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(MULTIPLICATOR, nArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, nArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            nArray[n5] = nArray[n5] * nArray2[i2 + n3];
        }
        return nArray;
    }

    public static int[] multiplyInPlace(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        int n5 = n2;
        while (n5 < n4 + n2) {
            int n6 = n5++;
            nArray[n6] = nArray[n6] * n3;
        }
        return nArray;
    }

    public static long[] multiply(long[] lArray, long l2) {
        return ArrayMath.multiply(lArray, 0, l2, lArray.length);
    }

    public static long[] multiply(long[] lArray, long[] lArray2) {
        return ArrayMath.multiply(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] multiply(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(MULTIPLICATOR, lArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, lArray2.length);
        long[] lArray3 = new long[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            lArray3[i2] = lArray[i2 + n2] * lArray2[i2 + n3];
        }
        return lArray3;
    }

    public static long[] multiply(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        long[] lArray2 = new long[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray2[i2] = lArray[i2 + n2] * l2;
        }
        return lArray2;
    }

    public static long[] multiplyInPlace(long[] lArray, long l2) {
        return ArrayMath.multiplyInPlace(lArray, 0, l2, lArray.length);
    }

    public static long[] multiplyInPlace(long[] lArray, long[] lArray2) {
        return ArrayMath.multiplyInPlace(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] multiplyInPlace(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(MULTIPLICATOR, lArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, lArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            lArray[n5] = lArray[n5] * lArray2[i2 + n3];
        }
        return lArray;
    }

    public static long[] multiplyInPlace(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            lArray[n5] = lArray[n5] * l2;
        }
        return lArray;
    }

    public static short[] multiply(short[] sArray, short s2) {
        return ArrayMath.multiply(sArray, 0, s2, sArray.length);
    }

    public static short[] multiply(short[] sArray, short[] sArray2) {
        return ArrayMath.multiply(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] multiply(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(MULTIPLICATOR, sArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, sArray2.length);
        short[] sArray3 = new short[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            sArray3[i2] = (short)(sArray[i2 + n2] * sArray2[i2 + n3]);
        }
        return sArray3;
    }

    public static short[] multiply(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        short[] sArray2 = new short[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray2[i2] = (short)(sArray[i2 + n2] * s2);
        }
        return sArray2;
    }

    public static short[] multiplyInPlace(short[] sArray, short s2) {
        return ArrayMath.multiplyInPlace(sArray, 0, s2, sArray.length);
    }

    public static short[] multiplyInPlace(short[] sArray, short[] sArray2) {
        return ArrayMath.multiplyInPlace(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] multiplyInPlace(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(MULTIPLICATOR, sArray2);
        AssertUtils.gtOrEqual(MULTIPLICATOR, n4 + n3, sArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            sArray[n5] = (short)(sArray[n5] * sArray2[i2 + n3]);
        }
        return sArray;
    }

    public static short[] multiplyInPlace(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            sArray[n5] = (short)(sArray[n5] * s2);
        }
        return sArray;
    }

    public static double[] notANumber(int n2) {
        double[] dArray = new double[n2];
        ArrayUtils.fillArray(dArray, 0, n2, Double.NaN);
        return dArray;
    }

    public static double[] notANumberInPlace(double[] dArray) {
        return ArrayMath.notANumberInPlace(dArray, 0, dArray.length);
    }

    public static double[] notANumberInPlace(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        ArrayUtils.fillArray(dArray, n2, n2 + n3, Double.NaN);
        return dArray;
    }

    public static float[] notANumberFloat(int n2) {
        float[] fArray = new float[n2];
        ArrayUtils.fillArray(fArray, 0, n2, Float.NaN);
        return fArray;
    }

    public static float[] notANumberInPlace(float[] fArray) {
        return ArrayMath.notANumberInPlace(fArray, 0, fArray.length);
    }

    public static float[] notANumberInPlace(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        ArrayUtils.fillArray(fArray, n2, n2 + n3, Float.NaN);
        return fArray;
    }

    public static double[] sqr(double[] dArray) {
        return ArrayMath.sqr(dArray, 0, dArray.length);
    }

    public static double[] sqr(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = dArray[i2 + n2] * dArray[i2 + n2];
        }
        return dArray2;
    }

    public static double[] sqrInPlace(double[] dArray) {
        return ArrayMath.sqrInPlace(dArray, 0, dArray.length);
    }

    public static double[] sqrInPlace(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            dArray[i2] = dArray[i2] * dArray[i2];
        }
        return dArray;
    }

    public static float[] sqr(float[] fArray) {
        return ArrayMath.sqr(fArray, 0, fArray.length);
    }

    public static float[] sqr(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = fArray[i2 + n2] * fArray[i2 + n2];
        }
        return fArray2;
    }

    public static float[] sqrInPlace(float[] fArray) {
        return ArrayMath.sqrInPlace(fArray, 0, fArray.length);
    }

    public static float[] sqrInPlace(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            fArray[i2] = fArray[i2] * fArray[i2];
        }
        return fArray;
    }

    public static int[] sqr(int[] nArray) {
        return ArrayMath.sqr(nArray, 0, nArray.length);
    }

    public static int[] sqr(int[] nArray, int n2, int n3) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, nArray.length);
        int[] nArray2 = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray2[i2] = nArray[i2 + n2] * nArray[i2 + n2];
        }
        return nArray2;
    }

    public static int[] sqrInPlace(int[] nArray) {
        return ArrayMath.sqrInPlace(nArray, 0, nArray.length);
    }

    public static int[] sqrInPlace(int[] nArray, int n2, int n3) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, nArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            nArray[i2] = nArray[i2] * nArray[i2];
        }
        return nArray;
    }

    public static long[] sqr(long[] lArray) {
        return ArrayMath.sqr(lArray, 0, lArray.length);
    }

    public static long[] sqr(long[] lArray, int n2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        long[] lArray2 = new long[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray2[i2] = lArray[i2 + n2] * lArray[i2 + n2];
        }
        return lArray2;
    }

    public static long[] sqrInPlace(long[] lArray) {
        return ArrayMath.sqrInPlace(lArray, 0, lArray.length);
    }

    public static long[] sqrInPlace(long[] lArray, int n2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            lArray[i2] = lArray[i2] * lArray[i2];
        }
        return lArray;
    }

    public static short[] sqr(short[] sArray) {
        return ArrayMath.sqr(sArray, 0, sArray.length);
    }

    public static short[] sqr(short[] sArray, int n2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        short[] sArray2 = new short[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray2[i2] = (short)(sArray[i2 + n2] * sArray[i2 + n2]);
        }
        return sArray2;
    }

    public static short[] sqrInPlace(short[] sArray) {
        return ArrayMath.sqrInPlace(sArray, 0, sArray.length);
    }

    public static short[] sqrInPlace(short[] sArray, int n2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            sArray[i2] = (short)(sArray[i2] * sArray[i2]);
        }
        return sArray;
    }

    public static double[] sqrt(double[] dArray) {
        return ArrayMath.sqrt(dArray, 0, dArray.length);
    }

    public static double[] sqrt(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = MathBase.sqrt(dArray[i2 + n2]);
        }
        return dArray2;
    }

    public static double[] sqrtInPlace(double[] dArray) {
        return ArrayMath.sqrtInPlace(dArray, 0, dArray.length);
    }

    public static double[] sqrtInPlace(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            dArray[i2] = MathBase.sqrt(dArray[i2]);
        }
        return dArray;
    }

    public static float[] sqrt(float[] fArray) {
        return ArrayMath.sqrt(fArray, 0, fArray.length);
    }

    public static float[] sqrt(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = (float)MathBase.sqrt(fArray[i2 + n2]);
        }
        return fArray2;
    }

    public static float[] sqrtInPlace(float[] fArray) {
        return ArrayMath.sqrtInPlace(fArray, 0, fArray.length);
    }

    public static float[] sqrtInPlace(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            fArray[i2] = (float)MathBase.sqrt(fArray[i2]);
        }
        return fArray;
    }

    public static double[] subtract(double[] dArray, double d2) {
        return ArrayMath.subtract(dArray, 0, d2, dArray.length);
    }

    public static double[] subtract(double[] dArray, double[] dArray2) {
        return ArrayMath.subtract(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] subtract(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(VALUE, dArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, dArray2.length);
        double[] dArray3 = new double[n4];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray3[i2] = dArray[i2 + n2] - dArray2[i2 + n3];
        }
        return dArray3;
    }

    public static double[] subtract(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = dArray[i2 + n2] - d2;
        }
        return dArray2;
    }

    public static double[] subtractInPlace(double[] dArray, double d2) {
        return ArrayMath.subtractInPlace(dArray, 0, d2, dArray.length);
    }

    public static double[] subtractInPlace(double[] dArray, double[] dArray2) {
        return ArrayMath.subtractInPlace(dArray, 0, dArray2, 0, dArray.length);
    }

    public static double[] subtractInPlace(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, dArray.length);
        AssertUtils.notNull(VALUE, dArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, dArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            dArray[n5] = dArray[n5] - dArray2[i2 + n3];
        }
        return dArray;
    }

    public static double[] subtractInPlace(double[] dArray, int n2, double d2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] - d2;
        }
        return dArray;
    }

    public static float[] subtract(float[] fArray, float f2) {
        return ArrayMath.subtract(fArray, 0, f2, fArray.length);
    }

    public static float[] subtract(float[] fArray, float[] fArray2) {
        return ArrayMath.subtract(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] subtract(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(VALUE, fArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, fArray2.length);
        float[] fArray3 = new float[n4];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = fArray[i2 + n2] - fArray2[i2 + n3];
        }
        return fArray3;
    }

    public static float[] subtract(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = fArray[i2 + n2] - f2;
        }
        return fArray2;
    }

    public static float[] subtractInPlace(float[] fArray, float f2) {
        return ArrayMath.subtractInPlace(fArray, 0, f2, fArray.length);
    }

    public static float[] subtractInPlace(float[] fArray, float[] fArray2) {
        return ArrayMath.subtractInPlace(fArray, 0, fArray2, 0, fArray.length);
    }

    public static float[] subtractInPlace(float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, fArray.length);
        AssertUtils.notNull(VALUE, fArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, fArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            fArray[n5] = fArray[n5] - fArray2[i2 + n3];
        }
        return fArray;
    }

    public static float[] subtractInPlace(float[] fArray, int n2, float f2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] - f2;
        }
        return fArray;
    }

    public static int[] subtract(int[] nArray, int n2) {
        return ArrayMath.subtract(nArray, 0, n2, nArray.length);
    }

    public static int[] subtract(int[] nArray, int[] nArray2) {
        return ArrayMath.subtract(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] subtract(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(VALUE, nArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, nArray2.length);
        int[] nArray3 = new int[n4];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = nArray[i2 + n2] - nArray2[i2 + n3];
        }
        return nArray3;
    }

    public static int[] subtract(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        int[] nArray2 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray2[i2] = nArray[i2 + n2] - n3;
        }
        return nArray2;
    }

    public static int[] subtractInPlace(int[] nArray, int n2) {
        return ArrayMath.subtractInPlace(nArray, 0, n2, nArray.length);
    }

    public static int[] subtractInPlace(int[] nArray, int[] nArray2) {
        return ArrayMath.subtractInPlace(nArray, 0, nArray2, 0, nArray.length);
    }

    public static int[] subtractInPlace(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        AssertUtils.notNull(VALUE, nArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, nArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            nArray[n5] = nArray[n5] - nArray2[i2 + n3];
        }
        return nArray;
    }

    public static int[] subtractInPlace(int[] nArray, int n2, int n3, int n4) {
        AssertUtils.notNull(IN, nArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, nArray.length);
        int n5 = n2;
        while (n5 < n4 + n2) {
            int n6 = n5++;
            nArray[n6] = nArray[n6] - n3;
        }
        return nArray;
    }

    public static long[] subtract(long[] lArray, long l2) {
        return ArrayMath.subtract(lArray, 0, l2, lArray.length);
    }

    public static long[] subtract(long[] lArray, long[] lArray2) {
        return ArrayMath.subtract(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] subtract(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(VALUE, lArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, lArray2.length);
        long[] lArray3 = new long[n4];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray3[i2] = lArray[i2 + n2] - lArray2[i2 + n3];
        }
        return lArray3;
    }

    public static long[] subtract(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        long[] lArray2 = new long[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray2[i2] = lArray[i2 + n2] - l2;
        }
        return lArray2;
    }

    public static long[] subtractInPlace(long[] lArray, long l2) {
        return ArrayMath.subtractInPlace(lArray, 0, l2, lArray.length);
    }

    public static long[] subtractInPlace(long[] lArray, long[] lArray2) {
        return ArrayMath.subtractInPlace(lArray, 0, lArray2, 0, lArray.length);
    }

    public static long[] subtractInPlace(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, lArray.length);
        AssertUtils.notNull(VALUE, lArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, lArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            lArray[n5] = lArray[n5] - lArray2[i2 + n3];
        }
        return lArray;
    }

    public static long[] subtractInPlace(long[] lArray, int n2, long l2, int n3) {
        AssertUtils.notNull(IN, lArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, lArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            lArray[n5] = lArray[n5] - l2;
        }
        return lArray;
    }

    public static short[] subtract(short[] sArray, short s2) {
        return ArrayMath.subtract(sArray, 0, s2, sArray.length);
    }

    public static short[] subtract(short[] sArray, short[] sArray2) {
        return ArrayMath.subtract(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] subtract(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(VALUE, sArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, sArray2.length);
        short[] sArray3 = new short[n4];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray3[i2] = (short)(sArray[i2 + n2] - sArray2[i2 + n3]);
        }
        return sArray3;
    }

    public static short[] subtract(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        short[] sArray2 = new short[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray2[i2] = (short)(sArray[i2 + n2] - s2);
        }
        return sArray2;
    }

    public static short[] subtractInPlace(short[] sArray, short s2) {
        return ArrayMath.subtractInPlace(sArray, 0, s2, sArray.length);
    }

    public static short[] subtractInPlace(short[] sArray, short[] sArray2) {
        return ArrayMath.subtractInPlace(sArray, 0, sArray2, 0, sArray.length);
    }

    public static short[] subtractInPlace(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n4 + n2, sArray.length);
        AssertUtils.notNull(VALUE, sArray2);
        AssertUtils.gtOrEqual(VALUE, n4 + n3, sArray2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 + n2;
            sArray[n5] = (short)(sArray[n5] - sArray2[i2 + n3]);
        }
        return sArray;
    }

    public static short[] subtractInPlace(short[] sArray, int n2, short s2, int n3) {
        AssertUtils.notNull(IN, sArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, sArray.length);
        int n4 = n2;
        while (n4 < n3 + n2) {
            int n5 = n4++;
            sArray[n5] = (short)(sArray[n5] - s2);
        }
        return sArray;
    }

    public static double[] tenLog10(double[] dArray) {
        return ArrayMath.tenLog10(dArray, 0, dArray.length);
    }

    public static double[] tenLog10(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = 10.0 * MathBase.log10(dArray[i2 + n2]);
        }
        return dArray2;
    }

    public static double[] tenLog10InPlace(double[] dArray) {
        return ArrayMath.tenLog10InPlace(dArray, 0, dArray.length);
    }

    public static double[] tenLog10InPlace(double[] dArray, int n2, int n3) {
        AssertUtils.notNull(IN, dArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, dArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            dArray[i2] = 10.0 * MathBase.log10(dArray[i2]);
        }
        return dArray;
    }

    public static float[] tenLog10(float[] fArray) {
        return ArrayMath.tenLog10(fArray, 0, fArray.length);
    }

    public static float[] tenLog10(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        float[] fArray2 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray2[i2] = (float)(10.0 * MathBase.log10(fArray[i2 + n2]));
        }
        return fArray2;
    }

    public static float[] tenLog10InPlace(float[] fArray) {
        return ArrayMath.tenLog10InPlace(fArray, 0, fArray.length);
    }

    public static float[] tenLog10InPlace(float[] fArray, int n2, int n3) {
        AssertUtils.notNull(IN, fArray);
        AssertUtils.gtOrEqual(IN, n3 + n2, fArray.length);
        for (int i2 = n2; i2 < n3 + n2; ++i2) {
            fArray[i2] = (float)(10.0 * MathBase.log10(fArray[i2]));
        }
        return fArray;
    }
}

