/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;

public class SoftHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_RETENTION_SIZE = 100;
    private final Map<K, SoftValue<V, K>> map;
    private final int retentionSize;
    private final Queue<V> strongReferences;
    private final ReentrantLock strongReferencesLock;
    private final ReferenceQueue<? super V> queue;

    public SoftHashMap() {
        this(100);
    }

    public SoftHashMap(int n2) {
        this.retentionSize = Math.max(0, n2);
        this.queue = new ReferenceQueue();
        this.strongReferencesLock = new ReentrantLock();
        this.map = new ConcurrentHashMap<K, SoftValue<V, K>>();
        this.strongReferences = new ConcurrentLinkedQueue<V>();
    }

    public SoftHashMap(Map<K, V> map) {
        this(100);
        this.putAll(map);
    }

    public SoftHashMap(Map<K, V> map, int n2) {
        this(n2);
        this.putAll(map);
    }

    @Override
    public void clear() {
        this.strongReferencesLock.lock();
        try {
            this.strongReferences.clear();
        }
        finally {
            this.strongReferencesLock.unlock();
        }
        this.processQueue();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        this.processQueue();
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        this.processQueue();
        Collection<V> collection = this.values();
        return collection != null && collection.contains(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        Set<K> set = this.map.keySet();
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap(set.size());
        for (Object e2 : set) {
            V v2 = this.get(e2);
            if (v2 == null) continue;
            concurrentHashMap.put(e2, v2);
        }
        return concurrentHashMap.entrySet();
    }

    @Override
    public V get(Object object) {
        this.processQueue();
        V v2 = null;
        SoftValue<V, K> softValue = this.map.get(object);
        if (softValue != null) {
            v2 = (V)softValue.get();
            if (v2 == null) {
                this.map.remove(object);
            } else {
                this.addToStrongReferences(v2);
            }
        }
        return v2;
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.map.keySet();
    }

    @Override
    public V put(K k2, V v2) {
        this.processQueue();
        SoftValue<? super V, K> softValue = new SoftValue<V, K>(v2, k2, this.queue);
        SoftValue<? super V, K> softValue2 = this.map.put(k2, softValue);
        this.addToStrongReferences(v2);
        return softValue2 == null ? null : (V)softValue2.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null || map.isEmpty()) {
            this.processQueue();
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        this.processQueue();
        SoftValue<V, K> softValue = this.map.remove(object);
        return softValue == null ? null : (V)softValue.get();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        Set<K> set = this.map.keySet();
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<V> arrayList = new ArrayList<V>(set.size());
        for (Object e2 : set) {
            V v2 = this.get(e2);
            if (v2 == null) continue;
            arrayList.add(v2);
        }
        return arrayList;
    }

    private void addToStrongReferences(V v2) {
        this.strongReferencesLock.lock();
        try {
            this.strongReferences.add(v2);
            this.trimStrongReferencesIfNecessary();
        }
        finally {
            this.strongReferencesLock.unlock();
        }
    }

    private void processQueue() {
        SoftValue softValue;
        while ((softValue = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(softValue.key);
        }
    }

    private void trimStrongReferencesIfNecessary() {
        while (this.strongReferences.size() > this.retentionSize) {
            this.strongReferences.poll();
        }
    }

    private static class SoftValue<V, K>
    extends SoftReference<V> {
        private final K key;

        private SoftValue(V v2, K k2, ReferenceQueue<? super V> referenceQueue) {
            super(v2, referenceQueue);
            this.key = k2;
        }
    }
}

