/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class MultiArrayObject<U>
extends MultiArray<U[]> {
    public static <T> MultiArrayObject wrap(T[] TArray) {
        return MultiArrayObject.wrap(TArray, 0, TArray.length);
    }

    public static <T> MultiArrayObject wrap(T[] TArray, int n2, int n3) {
        return new MultiArray1DObject<T>(TArray, new int[]{n3}, n2);
    }

    public static <T> MultiArrayObject wrap(T[] TArray, int[] nArray) {
        return MultiArrayObject.wrap(TArray, 0, nArray);
    }

    public static <T> MultiArrayObject wrap(T[] TArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, TArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DObject<T>(TArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DObject<T>(TArray, nArray, n2);
            }
        }
        return new MultiArrayObject<T>(TArray, nArray, n2);
    }

    public static <T> MultiArrayObject allocate(int[] nArray, Class<T[]> clazz) {
        switch (nArray.length) {
            case 1: {
                try {
                    return new MultiArray1DObject<T>(clazz.getConstructor(Integer.TYPE).newInstance(nArray[0]), nArray, 0);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    throw new IllegalArgumentException("Could not allocate array for given type", reflectiveOperationException);
                }
            }
            case 2: {
                try {
                    return new MultiArray2DObject<T>(clazz.getConstructor(Integer.TYPE).newInstance(nArray[0] * nArray[1]), nArray, 0);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    throw new IllegalArgumentException("Could not allocate array for given type", reflectiveOperationException);
                }
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        try {
            return new MultiArrayObject<T>(clazz.getConstructor(Integer.TYPE).newInstance(n2), nArray, 0);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException("Could not allocate array for given type", reflectiveOperationException);
        }
    }

    protected MultiArrayObject(U[] UArray, int[] nArray, int n2) {
        super(UArray, nArray, n2);
    }

    public void setStrided(int n2, U u2) {
        ((Object[])this.elements)[n2 + this.offset] = u2;
    }

    public void set(int[] nArray, U u2) {
        ((Object[])this.elements)[this.getIndex((int[])nArray)] = u2;
    }

    public U getStrided(int n2) {
        return (U)((Object[])this.elements)[n2 + this.offset];
    }

    public U get(int[] nArray) {
        return (U)((Object[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayObject)) {
            return false;
        }
        MultiArrayObject multiArrayObject = (MultiArrayObject)object;
        return Arrays.equals(this.dimensions, multiArrayObject.dimensions) && Arrays.equals((Object[])this.elements, this.offset, this.offset + this.getElementsCount(), (Object[])multiArrayObject.elements, multiArrayObject.offset, multiArrayObject.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + ((Object[])this.elements)[i2].hashCode();
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DObject<U>
    extends MultiArrayObject<U> {
        protected MultiArray1DObject(U[] UArray, int[] nArray, int n2) {
            super(UArray, nArray, n2);
        }

        public U get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, U u2) {
            this.setStrided(n2, u2);
        }
    }

    public static class MultiArray2DObject<U>
    extends MultiArrayObject<U> {
        private final int stride;

        protected MultiArray2DObject(U[] UArray, int[] nArray, int n2) {
            super(UArray, nArray, n2);
            this.stride = nArray[1];
        }

        public U get(int n2, int n3) {
            return (U)((Object[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, U u2) {
            ((Object[])this.elements)[this.offset + n3 + n2 * this.stride] = u2;
        }

        public U[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((Object[])this.elements, n3, n3 + this.stride);
        }
    }
}

