/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.fastutil;

import io.fair_acc.dataset.spi.fastutil.ArrayUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class IntArrayList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected transient int[] a;
    protected int size;

    public void forEach(IntConsumer intConsumer) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            intConsumer.accept(this.a[i2]);
        }
    }

    public IntStream stream() {
        return Arrays.stream(this.a, 0, this.size);
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected IntArrayList(int[] nArray, boolean bl2) {
        this.a = nArray;
    }

    public IntArrayList(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial capacity (" + n2 + ") is negative");
        }
        this.a = n2 == 0 ? IntArrays.EMPTY_ARRAY : new int[n2];
    }

    public IntArrayList() {
        this.a = IntArrays.DEFAULT_EMPTY_ARRAY;
    }

    public int[] elements() {
        return this.a;
    }

    public static IntArrayList wrap(int[] nArray, int n2) {
        if (n2 > nArray.length) {
            throw new IllegalArgumentException("The specified length (" + n2 + ") is greater than the array size (" + nArray.length + ")");
        }
        IntArrayList intArrayList = new IntArrayList(nArray, false);
        intArrayList.size = n2;
        return intArrayList;
    }

    public static IntArrayList wrap(int[] nArray) {
        return IntArrayList.wrap(nArray, nArray.length);
    }

    public void ensureCapacity(int n2) {
        if (n2 <= this.a.length || this.a == IntArrays.DEFAULT_EMPTY_ARRAY && n2 <= 10) {
            return;
        }
        this.a = IntArrays.ensureCapacity(this.a, n2, this.size);
        assert (this.size <= this.a.length);
    }

    private void grow(int n2) {
        if (n2 <= this.a.length) {
            return;
        }
        if (this.a != IntArrays.DEFAULT_EMPTY_ARRAY) {
            n2 = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)n2);
        } else if (n2 < 10) {
            n2 = 10;
        }
        this.a = IntArrays.forceCapacity(this.a, n2, this.size);
        assert (this.size <= this.a.length);
    }

    public void add(int n2, int n3) {
        this.ensureIndex(n2);
        this.grow(this.size + 1);
        if (n2 != this.size) {
            System.arraycopy(this.a, n2, this.a, n2 + 1, this.size - n2);
        }
        this.a[n2] = n3;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    public boolean add(int n2) {
        this.grow(this.size + 1);
        this.a[this.size++] = n2;
        assert (this.size <= this.a.length);
        return true;
    }

    public int getInt(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[n2];
    }

    public int indexOf(int n2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (n2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(int n2) {
        int n3 = this.size;
        while (n3-- != 0) {
            if (n2 != this.a[n3]) continue;
            return n3;
        }
        return -1;
    }

    public int removeInt(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        int n3 = this.a[n2];
        --this.size;
        if (n2 != this.size) {
            System.arraycopy(this.a, n2 + 1, this.a, n2, this.size - n2);
        }
        assert (this.size <= this.a.length);
        return n3;
    }

    public boolean rem(int n2) {
        int n3 = this.indexOf(n2);
        if (n3 == -1) {
            return false;
        }
        this.removeInt(n3);
        assert (this.size <= this.a.length);
        return true;
    }

    public int set(int n2, int n3) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        int n4 = this.a[n2];
        this.a[n2] = n3;
        return n4;
    }

    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    public int size() {
        return this.size;
    }

    public void size(int n2) {
        if (n2 > this.a.length) {
            this.a = IntArrays.forceCapacity(this.a, n2, this.size);
        }
        if (n2 > this.size) {
            Arrays.fill(this.a, this.size, n2, 0);
        }
        this.size = n2;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n2) {
        if (n2 >= this.a.length || this.size == this.a.length) {
            return;
        }
        int[] nArray = new int[Math.max(n2, this.size)];
        System.arraycopy(this.a, 0, nArray, 0, this.size);
        this.a = nArray;
        assert (this.size <= this.a.length);
    }

    public void getElements(int n2, int[] nArray, int n3, int n4) {
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        System.arraycopy(this.a, n2, nArray, n3, n4);
    }

    public void removeElements(int n2, int n3) {
        ArrayUtil.ensureFromTo(this.size, n2, n3);
        System.arraycopy(this.a, n3, this.a, n2, this.size - n3);
        this.size -= n3 - n2;
    }

    public void addElements(int n2, int[] nArray, int n3, int n4) {
        this.ensureIndex(n2);
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        this.grow(this.size + n4);
        System.arraycopy(this.a, n2, this.a, n2 + n4, this.size - n2);
        System.arraycopy(nArray, n3, this.a, n2, n4);
        this.size += n4;
    }

    public void addElements(int n2, int[] nArray) {
        this.addElements(n2, nArray, 0, nArray.length);
    }

    public void setElements(int n2, int[] nArray, int n3, int n4) {
        this.ensureIndex(n2);
        IntArrays.ensureOffsetLength(nArray, n3, n4);
        if (n2 + n4 > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(nArray, n3, this.a, n2, n4);
    }

    public void setElements(int[] nArray) {
        this.setElements(0, nArray);
    }

    public void setElements(int n2, int[] nArray) {
        this.setElements(n2, nArray, 0, nArray.length);
    }

    public int[] toArray(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.a, 0, nArray, 0, this.size);
        return nArray;
    }

    public boolean removeAll(Collection<?> collection) {
        int n2;
        int[] nArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (collection.contains(nArray[n2])) continue;
            nArray[n3++] = nArray[n2];
        }
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    public IntArrayList clone() {
        IntArrayList intArrayList = new IntArrayList(this.size);
        System.arraycopy(this.a, 0, intArrayList.a, 0, this.size);
        intArrayList.size = this.size;
        return intArrayList;
    }

    public boolean equals(IntArrayList intArrayList) {
        if (intArrayList == this) {
            return true;
        }
        int n2 = this.size();
        if (n2 != intArrayList.size()) {
            return false;
        }
        int[] nArray = this.a;
        int[] nArray2 = intArrayList.a;
        while (n2-- != 0) {
            if (nArray[n2] == nArray2[n2]) continue;
            return false;
        }
        return true;
    }

    public int compareTo(IntArrayList intArrayList) {
        int n2;
        int n3 = this.size();
        int n4 = intArrayList.size();
        int[] nArray = this.a;
        int[] nArray2 = intArrayList.a;
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            int n5 = nArray[n2];
            int n6 = nArray2[n2];
            int n7 = Integer.compare(n5, n6);
            if (n7 == 0) continue;
            return n7;
        }
        return n2 < n4 ? -1 : (n2 < n3 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutputStream.writeInt(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a = new int[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = objectInputStream.readInt();
        }
    }

    private static class IntArrays {
        public static final int[] EMPTY_ARRAY = new int[0];
        public static final int[] DEFAULT_EMPTY_ARRAY = new int[0];

        private IntArrays() {
        }

        public static void ensureOffsetLength(int[] nArray, int n2, int n3) {
            IntArrays.ensureOffsetLength(nArray.length, n2, n3);
        }

        public static void ensureOffsetLength(int n2, int n3, int n4) {
            if (n3 < 0) {
                throw new ArrayIndexOutOfBoundsException("Offset (" + n3 + ") is negative");
            }
            if (n4 < 0) {
                throw new IllegalArgumentException("Length (" + n4 + ") is negative");
            }
            if (n3 + n4 > n2) {
                throw new ArrayIndexOutOfBoundsException("Last index (" + (n3 + n4) + ") is greater than array length (" + n2 + ")");
            }
        }

        public static int[] ensureCapacity(int[] nArray, int n2, int n3) {
            return n2 > nArray.length ? IntArrays.forceCapacity(nArray, n2, n3) : nArray;
        }

        public static int[] forceCapacity(int[] nArray, int n2, int n3) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
            return nArray2;
        }
    }
}

