/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.utils.NumberFormatter;
import io.fair_acc.chartfx.utils.Schubfach;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.util.Objects;
import javafx.util.StringConverter;

public class NumberFormatterImpl
extends StringConverter<Number>
implements NumberFormatter {
    public static final char DEFAULT_DECIMAL_SEPARATOR = ' ';
    static final int ALL_DIGITS = -1;
    private int decimalPlaces = -1;
    private static final int MAX_EXP_LENGTH = 5;
    private static final int MAX_CHARS_DOUBLE = 29;
    private static final int MAX_PLAIN_EXP = 7;
    private static final long DIGITS_18 = 100000000000000000L;
    byte[] bytes = new byte[29];
    int length = 0;
    boolean isExponentialForm = false;
    private static final int MASK_28 = 0xFFFFFFF;
    byte DOT = (byte)46;
    byte[] EXP = DEFAULT_EXP;
    private static final byte[] DEFAULT_EXP = new byte[]{69};
    private static final byte ZERO = 48;
    private static final byte MINUS = 45;

    public NumberFormatterImpl() {
        this.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance());
    }

    public NumberFormatterImpl(int n2, boolean bl2) {
        this();
        this.setDecimalPlaces(n2);
        this.setExponentialForm(bl2);
    }

    public Number fromString(String string) {
        return Double.parseDouble(string);
    }

    @Override
    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    @Override
    public boolean isExponentialForm() {
        return this.isExponentialForm;
    }

    @Override
    public NumberFormatter setExponentialForm(boolean bl2) {
        this.isExponentialForm = bl2;
        return this;
    }

    @Override
    public NumberFormatter setDecimalPlaces(int n2) {
        this.decimalPlaces = Math.max(-1, n2);
        return this;
    }

    @Override
    public String toString(double d2) {
        switch (Schubfach.encodeDouble(d2, this::encodeDouble)) {
            case 0: {
                return this.bytesToString();
            }
            case 1: 
            case 2: {
                this.encodeZero();
                return this.length == 1 ? "0" : this.bytesToString();
            }
            case 3: {
                return "+inf";
            }
            case 4: {
                return "-inf";
            }
        }
        return "NaN";
    }

    public String toString(Number number) {
        return this.toString(number.doubleValue());
    }

    private void encodeDouble(boolean bl2, long l2, int n2) {
        int n3;
        boolean bl3;
        this.length = 0;
        if (bl2) {
            this.append((byte)45);
        }
        int n4 = Schubfach.getDecimalLength(l2);
        l2 *= Schubfach.getNormalizationScale(17, n4);
        boolean bl4 = bl3 = this.isExponentialForm || (n2 += n4) > 7;
        if (this.decimalPlaces >= 0 && (l2 += Schubfach.getRoundingOffset(n3 = this.decimalPlaces + (bl3 ? 1 : n2))) >= 100000000000000000L) {
            l2 /= 10L;
            ++n2;
        }
        long l3 = Math.multiplyHigh(l2, 193428131138340668L) >>> 20;
        int n5 = (int)(l3 * 1441151881L >>> 57);
        int n6 = (int)(l3 - 100000000L * (long)n5);
        int n7 = (int)(l2 - 100000000L * l3);
        if (bl3) {
            this.toExponentialFormat(n5, n6, n7, n2);
        } else if (n2 > 0) {
            this.toPlainFormat(n5, n6, n7, n2);
        } else {
            this.toPlainFormatWithLeadingZeros(n5, n6, n7, n2);
        }
    }

    private void toExponentialFormat(int n2, int n3, int n4, int n5) {
        this.appendDigit(n2);
        if (this.decimalPlaces > 0) {
            this.append(this.DOT);
            this.appendNDigits(n3, n4, this.decimalPlaces);
        } else if (this.decimalPlaces == -1) {
            this.append(this.DOT);
            this.append8Digits(n3);
            this.lowDigits(n4);
        }
        this.exponent(n5 - 1);
    }

    private void toPlainFormat(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        this.appendDigit(n2);
        int n8 = this.y(n3);
        for (n7 = 1; n7 < n5; ++n7) {
            n6 = 10 * n8;
            this.appendDigit(n6 >>> 28);
            n8 = n6 & 0xFFFFFFF;
        }
        if (this.decimalPlaces == 0) {
            return;
        }
        this.append(this.DOT);
        if (this.decimalPlaces == -1) {
            while (n7 <= 8) {
                n6 = 10 * n8;
                this.appendDigit(n6 >>> 28);
                n8 = n6 & 0xFFFFFFF;
                ++n7;
            }
            this.lowDigits(n4);
        } else {
            int n9;
            for (n9 = this.decimalPlaces; n7 <= 8 && n9 > 0; --n9, ++n7) {
                n6 = 10 * n8;
                this.appendDigit(n6 >>> 28);
                n8 = n6 & 0xFFFFFFF;
            }
            this.appendNDigits(n4, n9);
        }
    }

    private void toPlainFormatWithLeadingZeros(int n2, int n3, int n4, int n5) {
        this.append((byte)48);
        if (this.decimalPlaces == 0) {
            return;
        }
        this.append(this.DOT);
        if (this.decimalPlaces == -1) {
            int n6;
            for (n6 = this.bytes.length - this.length; n5 < 0 && n6 > 0; --n6, ++n5) {
                this.append((byte)48);
            }
            if (n6 > 0) {
                this.appendDigit(n2);
                this.appendNDigits(n3, n4, Math.min(n6 - 1, 16));
            }
            this.removeTrailingZeroes();
        } else {
            int n7;
            for (n7 = Math.min(this.decimalPlaces, n6); n5 < 0 && n7 > 0; --n7, ++n5) {
                this.append((byte)48);
            }
            if (n7 > 0) {
                this.appendDigit(n2);
                this.appendNDigits(n3, n4, n7 - 1);
            }
        }
    }

    private void encodeZero() {
        this.length = 0;
        this.append((byte)48);
        if (this.decimalPlaces > 0) {
            this.append(this.DOT);
            for (int i2 = 0; i2 < this.decimalPlaces; ++i2) {
                this.append((byte)48);
            }
        }
        if (this.isExponentialForm) {
            this.append(this.EXP);
            this.append((byte)48);
        }
    }

    private void append(byte by2) {
        this.bytes[this.length++] = by2;
    }

    private void append(byte[] byArray) {
        for (byte by2 : byArray) {
            this.append(by2);
        }
    }

    private void appendDigit(int n2) {
        this.bytes[this.length++] = (byte)(48 + n2);
    }

    private void append8Digits(int n2) {
        int n3 = this.y(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n4 = 10 * n3;
            this.appendDigit(n4 >>> 28);
            n3 = n4 & 0xFFFFFFF;
        }
    }

    private void lowDigits(int n2) {
        if (n2 != 0) {
            this.append8Digits(n2);
        }
        this.removeTrailingZeroes();
    }

    private int appendNDigits(int n2, int n3, int n4) {
        if (n4 > 0) {
            n4 -= this.appendNDigits(n2, n4);
        }
        if (n4 > 0) {
            n4 -= this.appendNDigits(n3, n4);
        }
        return n4;
    }

    private int appendNDigits(int n2, int n3) {
        if (n3 <= 0) {
            return 0;
        }
        if (n3 > 8) {
            n3 = 8;
        }
        int n4 = this.y(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = 10 * n4;
            this.appendDigit(n5 >>> 28);
            n4 = n5 & 0xFFFFFFF;
        }
        return n3;
    }

    private void removeTrailingZeroes() {
        while (this.bytes[this.length - 1] == 48) {
            --this.length;
        }
        if (this.bytes[this.length - 1] == this.DOT) {
            --this.length;
        }
    }

    private int y(int n2) {
        return (int)(Math.multiplyHigh((long)(n2 + 1) << 28, 193428131138340668L) >>> 20) - 1;
    }

    private void exponent(int n2) {
        this.append(this.EXP);
        if (n2 < 0) {
            this.append((byte)45);
            n2 = -n2;
        }
        if (n2 < 10) {
            this.appendDigit(n2);
            return;
        }
        int n3 = n2 * 103 >>> 10;
        this.appendDigit(n3);
        this.appendDigit(n2 - 10 * n3);
    }

    private String bytesToString() {
        return new String(this.bytes, 0, this.length, StandardCharsets.ISO_8859_1);
    }

    public NumberFormatterImpl setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        String string = decimalFormatSymbols.getExponentSeparator();
        if (string.length() > 5) {
            throw new IllegalArgumentException("Exponent separator can't be longer than 5");
        }
        this.EXP = Objects.equals(string, "E") ? DEFAULT_EXP : string.getBytes(StandardCharsets.ISO_8859_1);
        this.DOT = (byte)decimalFormatSymbols.getDecimalSeparator();
        return this;
    }
}

