/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class RttMeasurementFlyweight
extends HeaderFlyweight {
    public static final short REPLY_FLAG = 128;
    public static final int HEADER_LENGTH = 40;
    private static final int SESSION_ID_FIELD_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int ECHO_TIMESTAMP_FIELD_OFFSET = 16;
    private static final int RECEPTION_DELTA_FIELD_OFFSET = 24;
    private static final int RECEIVER_ID_FIELD_OFFSET = 32;

    public RttMeasurementFlyweight() {
    }

    public RttMeasurementFlyweight(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public RttMeasurementFlyweight(UnsafeBuffer unsafeBuffer) {
        super(unsafeBuffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight sessionId(int n2) {
        this.putInt(8, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight streamId(int n2) {
        this.putInt(12, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long echoTimestampNs() {
        return this.getLong(16, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight echoTimestampNs(long l2) {
        this.putLong(16, l2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receptionDelta() {
        return this.getLong(24, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight receptionDelta(long l2) {
        this.putLong(24, l2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receiverId() {
        return this.getLong(32, ByteOrder.LITTLE_ENDIAN);
    }

    public RttMeasurementFlyweight receiverId(long l2) {
        this.putLong(32, l2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public String toString() {
        return "RTTM{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(RttMeasurementFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " echo-timestamp=" + this.echoTimestampNs() + " reception-delta=" + this.receptionDelta() + " receiver-id=" + this.receiverId() + "}";
    }
}

