/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import org.agrona.BitUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class TermGapScanner {
    private static final int ALIGNED_HEADER_LENGTH = BitUtil.align(32, 32);

    public static int scanForGap(UnsafeBuffer unsafeBuffer, int n2, int n3, int n4, GapHandler gapHandler) {
        int n5;
        int n6 = n3;
        while ((n5 = FrameDescriptor.frameLengthVolatile(unsafeBuffer, n6)) > 0 && (n6 += BitUtil.align(n5, 32)) < n4) {
        }
        n5 = n6;
        if (n6 < n4) {
            int n7 = n4 - ALIGNED_HEADER_LENGTH;
            while (n6 < n7) {
                if (0 == unsafeBuffer.getIntVolatile(n6 += 32)) continue;
                n6 -= ALIGNED_HEADER_LENGTH;
                break;
            }
            int n8 = n6 - n5 + ALIGNED_HEADER_LENGTH;
            gapHandler.onGap(n2, n5, n8);
        }
        return n5;
    }

    @FunctionalInterface
    public static interface GapHandler {
        public void onGap(int var1, int var2, int var3);
    }
}

