/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.RetransmitSender;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;

public final class RetransmitHandler {
    private final BiInt2ObjectMap<RetransmitAction> activeRetransmitsMap = new BiInt2ObjectMap();
    private final RetransmitAction[] retransmitActionPool = new RetransmitAction[16];
    private final NanoClock nanoClock;
    private final FeedbackDelayGenerator delayGenerator;
    private final FeedbackDelayGenerator lingerTimeoutGenerator;
    private final AtomicCounter invalidPackets;

    public RetransmitHandler(NanoClock nanoClock, AtomicCounter atomicCounter, FeedbackDelayGenerator feedbackDelayGenerator, FeedbackDelayGenerator feedbackDelayGenerator2) {
        this.nanoClock = nanoClock;
        this.invalidPackets = atomicCounter;
        this.delayGenerator = feedbackDelayGenerator;
        this.lingerTimeoutGenerator = feedbackDelayGenerator2;
        for (int i2 = 0; i2 < 16; ++i2) {
            this.retransmitActionPool[i2] = new RetransmitAction();
        }
    }

    public void onNak(int n2, int n3, int n4, int n5, RetransmitSender retransmitSender) {
        if (!this.isInvalid(n3, n5) && null == this.activeRetransmitsMap.get(n2, n3) && this.activeRetransmitsMap.size() < 16) {
            RetransmitAction retransmitAction = this.assignRetransmitAction();
            retransmitAction.termId = n2;
            retransmitAction.termOffset = n3;
            retransmitAction.length = Math.min(n4, n5 - n3);
            long l2 = this.delayGenerator.generateDelay();
            if (0L == l2) {
                retransmitSender.resend(n2, n3, retransmitAction.length);
                retransmitAction.linger(this.lingerTimeoutGenerator.generateDelay(), this.nanoClock.nanoTime());
            } else {
                retransmitAction.delay(l2, this.nanoClock.nanoTime());
            }
            this.activeRetransmitsMap.put(n2, n3, retransmitAction);
        }
    }

    public void onRetransmitReceived(int n2, int n3) {
        RetransmitAction retransmitAction = this.activeRetransmitsMap.get(n2, n3);
        if (null != retransmitAction && State.DELAYED == retransmitAction.state) {
            this.activeRetransmitsMap.remove(n2, n3);
            retransmitAction.cancel();
        }
    }

    public void processTimeouts(long l2, RetransmitSender retransmitSender) {
        if (this.activeRetransmitsMap.size() > 0) {
            for (RetransmitAction retransmitAction : this.retransmitActionPool) {
                if (State.DELAYED == retransmitAction.state && retransmitAction.expireNs - l2 < 0L) {
                    retransmitSender.resend(retransmitAction.termId, retransmitAction.termOffset, retransmitAction.length);
                    retransmitAction.linger(this.lingerTimeoutGenerator.generateDelay(), this.nanoClock.nanoTime());
                    continue;
                }
                if (State.LINGERING != retransmitAction.state || retransmitAction.expireNs - l2 >= 0L) continue;
                retransmitAction.cancel();
                this.activeRetransmitsMap.remove(retransmitAction.termId, retransmitAction.termOffset);
            }
        }
    }

    private boolean isInvalid(int n2, int n3) {
        boolean bl2;
        boolean bl3 = bl2 = n2 > n3 - 32 || n2 < 0;
        if (bl2) {
            this.invalidPackets.increment();
        }
        return bl2;
    }

    private RetransmitAction assignRetransmitAction() {
        for (RetransmitAction retransmitAction : this.retransmitActionPool) {
            if (State.INACTIVE != retransmitAction.state) continue;
            return retransmitAction;
        }
        throw new IllegalStateException("maximum number of active RetransmitActions reached");
    }

    static final class RetransmitAction {
        long expireNs;
        int termId;
        int termOffset;
        int length;
        State state = State.INACTIVE;

        RetransmitAction() {
        }

        void delay(long l2, long l3) {
            this.state = State.DELAYED;
            this.expireNs = l3 + l2;
        }

        void linger(long l2, long l3) {
            this.state = State.LINGERING;
            this.expireNs = l3 + l2;
        }

        void cancel() {
            this.state = State.INACTIVE;
        }
    }

    static enum State {
        DELAYED,
        LINGERING,
        INACTIVE;

    }
}

