/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DefaultNameResolver;
import io.aeron.driver.DriverNameResolverCache;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpNameResolutionTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.protocol.HeaderFlyweight;
import io.aeron.protocol.ResolutionEntryFlyweight;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

final class DriverNameResolver
implements AutoCloseable,
UdpNameResolutionTransport.UdpFrameHandler,
NameResolver {
    static NameResolver bootstrapNameResolver = DefaultNameResolver.INSTANCE;
    private static final String RESOLVER_NEIGHBORS_COUNTER_LABEL = "Resolver neighbors";
    private static final long SELF_RESOLUTION_INTERVAL_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final long NEIGHBOR_RESOLUTION_INTERVAL_MS = TimeUnit.SECONDS.toMillis(2L);
    private static final long TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final long WORK_INTERVAL_MS = 10L;
    private final ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned(65504, 64);
    private final UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
    private final HeaderFlyweight headerFlyweight = new HeaderFlyweight(this.unsafeBuffer);
    private final ResolutionEntryFlyweight resolutionEntryFlyweight = new ResolutionEntryFlyweight();
    private final ArrayList<Neighbor> neighborList = new ArrayList();
    private final UdpNameResolutionTransport transport;
    private final DriverNameResolverCache cache;
    private final NameResolver delegateResolver;
    private final AtomicCounter invalidPackets;
    private final AtomicCounter shortSends;
    private final AtomicCounter neighborsCounter;
    private final AtomicCounter cacheEntriesCounter;
    private final byte[] nameTempBuffer = new byte[512];
    private final byte[] addressTempBuffer = new byte[16];
    private final String localDriverName;
    private InetSocketAddress localSocketAddress;
    private final byte[] localName;
    private byte[] localAddress;
    private final String[] bootstrapNeighbors;
    private InetSocketAddress bootstrapNeighborAddress;
    private long bootstrapNeighborResolveDeadlineMs;
    private final long neighborTimeoutMs = TIMEOUT_MS;
    private final long selfResolutionIntervalMs = SELF_RESOLUTION_INTERVAL_MS;
    private final long neighborResolutionIntervalMs = NEIGHBOR_RESOLUTION_INTERVAL_MS;
    private final int mtuLength;
    private final boolean preferIPv6 = false;
    private long workDeadlineMs = 0L;
    private long selfResolutionDeadlineMs;
    private long neighborResolutionDeadlineMs;

    DriverNameResolver(MediaDriver.Context context) {
        this.mtuLength = context.mtuLength();
        this.invalidPackets = context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS);
        this.shortSends = context.systemCounters().get(SystemCounterDescriptor.SHORT_SENDS);
        this.delegateResolver = context.nameResolver();
        long l2 = context.epochClock().time();
        this.bootstrapNeighbors = null != context.resolverBootstrapNeighbor() ? context.resolverBootstrapNeighbor().split(",") : null;
        this.bootstrapNeighborAddress = null != this.bootstrapNeighbors ? this.resolveBootstrapNeighbor() : null;
        this.bootstrapNeighborResolveDeadlineMs = l2 + TIMEOUT_MS;
        this.localSocketAddress = null != context.resolverInterface() ? UdpNameResolutionTransport.getInterfaceAddress(context.resolverInterface()) : new InetSocketAddress("0.0.0.0", 0);
        this.localDriverName = null != context.resolverName() ? context.resolverName() : DriverNameResolver.getCanonicalName();
        this.localName = this.localDriverName.getBytes(StandardCharsets.US_ASCII);
        this.localAddress = this.localSocketAddress.getAddress().getAddress();
        this.selfResolutionDeadlineMs = 0L;
        this.neighborResolutionDeadlineMs = l2 + this.neighborResolutionIntervalMs;
        this.cache = new DriverNameResolverCache(TIMEOUT_MS);
        UdpChannel udpChannel = UdpChannel.parse("aeron:udp?endpoint=localhost:8050");
        this.transport = new UdpNameResolutionTransport(udpChannel, this.localSocketAddress, this.unsafeBuffer, context);
        this.neighborsCounter = context.countersManager().newCounter(RESOLVER_NEIGHBORS_COUNTER_LABEL, 15);
        this.cacheEntriesCounter = context.countersManager().newCounter("Resolver cache entries: name=" + this.localDriverName, 16);
        this.openDatagramChannel();
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.transport, this.cache);
    }

    @Override
    public int doWork(long l2) {
        int n2 = 0;
        if (l2 > this.workDeadlineMs) {
            this.workDeadlineMs = l2 + 10L;
            n2 += this.transport.poll(this, l2);
            n2 += this.cache.timeoutOldEntries(l2, this.cacheEntriesCounter);
            n2 += this.timeoutNeighbors(l2);
            if (l2 > this.selfResolutionDeadlineMs) {
                this.sendSelfResolutions(l2);
            }
            if (l2 > this.neighborResolutionDeadlineMs) {
                this.sendNeighborResolutions(l2);
            }
        }
        return n2;
    }

    @Override
    public InetAddress resolve(String string, String string2, boolean bl2) {
        DriverNameResolverCache.CacheEntry cacheEntry = this.cache.lookup(string, (byte)1);
        InetAddress inetAddress = null;
        try {
            if (null == cacheEntry) {
                if (string.equals(this.localDriverName)) {
                    return this.localSocketAddress.getAddress();
                }
                return this.delegateResolver.resolve(string, string2, bl2);
            }
            inetAddress = InetAddress.getByAddress(cacheEntry.address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        DefaultNameResolver.INSTANCE.resolveHook(this.getClass().getSimpleName(), string, inetAddress);
        return inetAddress;
    }

    @Override
    public String lookup(String string, String string2, boolean bl2) {
        return this.delegateResolver.lookup(string, string2, bl2);
    }

    @Override
    public int onFrame(UnsafeBuffer unsafeBuffer, int n2, InetSocketAddress inetSocketAddress, long l2) {
        if (this.headerFlyweight.headerType() == 7) {
            for (int i2 = 8; n2 > i2; i2 += this.resolutionEntryFlyweight.entryLength()) {
                this.resolutionEntryFlyweight.wrap(unsafeBuffer, i2, n2 - i2);
                if (n2 - i2 < this.resolutionEntryFlyweight.entryLength()) {
                    this.invalidPackets.increment();
                    return 0;
                }
                this.onResolutionEntry(this.resolutionEntryFlyweight, inetSocketAddress, l2);
            }
            return n2;
        }
        return 0;
    }

    static String getCanonicalName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            LangUtil.rethrowUnchecked(unknownHostException);
        }
        return string;
    }

    static String getCanonicalName(String string) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    private void openDatagramChannel() {
        this.transport.openDatagramChannel(null);
        InetSocketAddress inetSocketAddress = this.transport.boundAddress();
        if (null != inetSocketAddress) {
            this.localSocketAddress = inetSocketAddress;
            this.localAddress = inetSocketAddress.getAddress().getAddress();
            this.neighborsCounter.appendToLabel(this.buildNeighborsCounterLabel(""));
        }
    }

    private String buildNeighborsCounterLabel(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(": bound ").append(this.transport.bindAddressAndPort());
        if (null != this.bootstrapNeighborAddress) {
            stringBuilder.append(" bootstrap ").append(NetworkUtil.formatAddressAndPort(this.bootstrapNeighborAddress.getAddress(), this.bootstrapNeighborAddress.getPort()));
        }
        return stringBuilder.toString();
    }

    private int timeoutNeighbors(long l2) {
        int n2;
        int n3 = 0;
        ArrayList<Neighbor> arrayList = this.neighborList;
        for (int i2 = n2 = arrayList.size() - 1; i2 >= 0; --i2) {
            Neighbor neighbor = arrayList.get(i2);
            if (l2 <= neighbor.timeOfLastActivityMs + this.neighborTimeoutMs) continue;
            Neighbor.neighborRemoved(l2, neighbor.socketAddress);
            ArrayListUtil.fastUnorderedRemove(arrayList, i2, n2--);
            ++n3;
        }
        n2 = arrayList.size();
        if (this.neighborsCounter.getWeak() != (long)n2) {
            this.neighborsCounter.setOrdered(n2);
        }
        return n3;
    }

    private void sendSelfResolutions(long l2) {
        this.byteBuffer.clear();
        int n2 = 8;
        boolean bl2 = true;
        this.headerFlyweight.headerType(7).flags((short)0).version((short)0);
        this.resolutionEntryFlyweight.wrap(this.unsafeBuffer, 8, this.unsafeBuffer.capacity() - 8);
        this.resolutionEntryFlyweight.resType((byte)1).flags((short)128).udpPort((short)this.localSocketAddress.getPort()).ageInMs(0).putAddress(this.localAddress).putName(this.localName);
        int n3 = this.resolutionEntryFlyweight.entryLength() + 8;
        this.headerFlyweight.frameLength(n3);
        this.byteBuffer.limit(n3);
        boolean bl3 = null != this.bootstrapNeighborAddress;
        for (Neighbor object : this.neighborList) {
            this.sendResolutionFrameTo(this.byteBuffer, object.socketAddress);
            if (!bl3 || !object.socketAddress.equals(this.bootstrapNeighborAddress)) continue;
            bl3 = false;
        }
        if (bl3) {
            if (l2 > this.bootstrapNeighborResolveDeadlineMs) {
                InetSocketAddress inetSocketAddress = this.bootstrapNeighborAddress;
                this.bootstrapNeighborAddress = this.resolveBootstrapNeighbor();
                this.bootstrapNeighborResolveDeadlineMs = l2 + TIMEOUT_MS;
                if (!inetSocketAddress.equals(this.bootstrapNeighborAddress)) {
                    this.neighborsCounter.updateLabel(this.buildNeighborsCounterLabel(RESOLVER_NEIGHBORS_COUNTER_LABEL));
                    for (Neighbor neighbor : this.neighborList) {
                        if (!neighbor.socketAddress.equals(this.bootstrapNeighborAddress)) continue;
                        bl3 = false;
                        break;
                    }
                }
            }
            if (bl3) {
                this.sendResolutionFrameTo(this.byteBuffer, this.bootstrapNeighborAddress);
            }
        }
        this.selfResolutionDeadlineMs = l2 + this.selfResolutionIntervalMs;
    }

    private void sendResolutionFrameTo(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        byteBuffer.position(0);
        int n2 = byteBuffer.remaining();
        int n3 = this.transport.sendTo(byteBuffer, inetSocketAddress);
        if (0 <= n3 && n3 < n2) {
            this.shortSends.increment();
        }
    }

    private void onResolutionEntry(ResolutionEntryFlyweight resolutionEntryFlyweight, InetSocketAddress inetSocketAddress, long l2) {
        byte by2 = resolutionEntryFlyweight.resType();
        boolean bl2 = 128 == this.resolutionEntryFlyweight.flags();
        byte[] byArray = this.addressTempBuffer;
        int n2 = this.resolutionEntryFlyweight.getAddress(this.addressTempBuffer);
        if (bl2 && ResolutionEntryFlyweight.isAnyLocalAddress(this.addressTempBuffer, n2)) {
            byArray = inetSocketAddress.getAddress().getAddress();
        }
        int n3 = this.resolutionEntryFlyweight.getName(this.nameTempBuffer);
        long l3 = l2 - (long)this.resolutionEntryFlyweight.ageInMs();
        int n4 = this.resolutionEntryFlyweight.udpPort();
        if (n4 == this.localSocketAddress.getPort() && DriverNameResolverCache.byteSubsetEquals(this.nameTempBuffer, this.localName, n3)) {
            return;
        }
        this.cache.addOrUpdateEntry(this.nameTempBuffer, n3, l3, by2, byArray, n4, this.cacheEntriesCounter);
        int n5 = this.findNeighborByAddress(byArray, n2, n4);
        if (-1 == n5) {
            byte[] byArray2 = Arrays.copyOf(byArray, n2);
            try {
                Neighbor neighbor = new Neighbor(new InetSocketAddress(InetAddress.getByAddress(byArray2), n4), l3);
                Neighbor.neighborAdded(l2, neighbor.socketAddress);
                this.neighborList.add(neighbor);
                this.neighborsCounter.setOrdered(this.neighborList.size());
            }
            catch (Exception exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        } else if (bl2) {
            this.neighborList.get((int)n5).timeOfLastActivityMs = l3;
        }
    }

    private int findNeighborByAddress(byte[] byArray, int n2, int n3) {
        int n4 = this.neighborList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            InetSocketAddress inetSocketAddress = this.neighborList.get((int)i2).socketAddress;
            if (!DriverNameResolverCache.byteSubsetEquals(byArray, inetSocketAddress.getAddress().getAddress(), n2) || n3 != inetSocketAddress.getPort()) continue;
            return i2;
        }
        return -1;
    }

    private void sendNeighborResolutions(long l2) {
        DriverNameResolverCache.Iterator iterator = this.cache.resetIterator();
        while (iterator.hasNext()) {
            int n2;
            this.byteBuffer.clear();
            this.headerFlyweight.headerType(7).flags((short)0).version((short)0);
            int n3 = 8;
            while (iterator.hasNext()) {
                DriverNameResolverCache.CacheEntry cacheEntry = iterator.next();
                if (n3 + ResolutionEntryFlyweight.entryLengthRequired(cacheEntry.type, cacheEntry.name.length) > this.mtuLength) {
                    iterator.rewindNext();
                    break;
                }
                this.resolutionEntryFlyweight.wrap(this.unsafeBuffer, n3, this.unsafeBuffer.capacity() - n3);
                this.resolutionEntryFlyweight.resType(cacheEntry.type).flags((short)0).udpPort((short)cacheEntry.port).ageInMs((int)(l2 - cacheEntry.timeOfLastActivityMs)).putAddress(cacheEntry.address).putName(cacheEntry.name);
                n2 = this.resolutionEntryFlyweight.entryLength();
                n3 += n2;
            }
            this.headerFlyweight.frameLength(n3);
            this.byteBuffer.limit(n3);
            n2 = this.neighborList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Neighbor neighbor = this.neighborList.get(i2);
                this.sendResolutionFrameTo(this.byteBuffer, neighbor.socketAddress);
            }
        }
        this.neighborResolutionDeadlineMs = l2 + this.neighborResolutionIntervalMs;
    }

    private InetSocketAddress resolveBootstrapNeighbor() {
        Exception exception = null;
        for (String string : this.bootstrapNeighbors) {
            try {
                return UdpNameResolutionTransport.getInetSocketAddress(string, bootstrapNameResolver);
            }
            catch (Exception exception2) {
                if (null == exception) {
                    exception = exception2;
                    continue;
                }
                exception.addSuppressed(exception2);
            }
        }
        if (null != exception) {
            LangUtil.rethrowUnchecked(exception);
        }
        return null;
    }

    static class Neighbor {
        final InetSocketAddress socketAddress;
        long timeOfLastActivityMs;

        Neighbor(InetSocketAddress inetSocketAddress, long l2) {
            this.socketAddress = inetSocketAddress;
            this.timeOfLastActivityMs = l2;
        }

        static void neighborAdded(long l2, InetSocketAddress inetSocketAddress) {
        }

        static void neighborRemoved(long l2, InetSocketAddress inetSocketAddress) {
        }
    }
}

