/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.LogBuffers;
import io.aeron.Publication;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public final class ConcurrentPublication
extends Publication {
    ConcurrentPublication(ClientConductor clientConductor, String string, int n2, int n3, ReadablePosition readablePosition, int n4, LogBuffers logBuffers, long l2, long l3) {
        super(clientConductor, string, n2, n3, readablePosition, n4, logBuffers, l2, l3);
    }

    @Override
    public long availableWindow() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile() - this.position();
    }

    @Override
    public long offer(DirectBuffer directBuffer, int n2, int n3, ReservedValueSupplier reservedValueSupplier) {
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.positionLimit.getVolatile();
            int n4 = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int n5 = LogBufferDescriptor.indexByTermCount(n4);
            UnsafeBuffer unsafeBuffer = this.termBuffers[n5];
            int n6 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + n5 * 8;
            long l4 = this.logMetaDataBuffer.getLongVolatile(n6);
            int n7 = LogBufferDescriptor.termOffset(l4, unsafeBuffer.capacity());
            int n8 = LogBufferDescriptor.termId(l4);
            if (n4 != n8 - this.initialTermId) {
                return -3L;
            }
            long l5 = LogBufferDescriptor.computePosition(n8, n7, this.positionBitsToShift, this.initialTermId);
            if (l5 < l3) {
                if (n3 <= this.maxPayloadLength) {
                    this.checkPositiveLength(n3);
                    l2 = this.appendUnfragmentedMessage(unsafeBuffer, n6, directBuffer, n2, n3, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(n3);
                    l2 = this.appendFragmentedMessage(unsafeBuffer, n6, directBuffer, n2, n3, reservedValueSupplier);
                }
            } else {
                l2 = this.backPressureStatus(l5, n3);
            }
        }
        return l2;
    }

    @Override
    public long offer(DirectBuffer directBuffer, int n2, int n3, DirectBuffer directBuffer2, int n4, int n5, ReservedValueSupplier reservedValueSupplier) {
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.positionLimit.getVolatile();
            int n6 = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int n7 = LogBufferDescriptor.indexByTermCount(n6);
            UnsafeBuffer unsafeBuffer = this.termBuffers[n7];
            int n8 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + n7 * 8;
            long l4 = this.logMetaDataBuffer.getLongVolatile(n8);
            int n9 = LogBufferDescriptor.termOffset(l4, unsafeBuffer.capacity());
            int n10 = LogBufferDescriptor.termId(l4);
            if (n6 != n10 - this.initialTermId) {
                return -3L;
            }
            long l5 = LogBufferDescriptor.computePosition(n10, n9, this.positionBitsToShift, this.initialTermId);
            int n11 = ConcurrentPublication.validateAndComputeLength(n3, n5);
            if (l5 < l3) {
                if (n11 <= this.maxPayloadLength) {
                    l2 = this.appendUnfragmentedMessage(unsafeBuffer, n8, directBuffer, n2, n3, directBuffer2, n4, n5, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(n11);
                    l2 = this.appendFragmentedMessage(unsafeBuffer, n8, directBuffer, n2, n3, directBuffer2, n4, n5, reservedValueSupplier);
                }
            } else {
                l2 = this.backPressureStatus(l5, n11);
            }
        }
        return l2;
    }

    @Override
    public long offer(DirectBufferVector[] directBufferVectorArray, ReservedValueSupplier reservedValueSupplier) {
        int n2 = DirectBufferVector.validateAndComputeLength(directBufferVectorArray);
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.positionLimit.getVolatile();
            int n3 = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int n4 = LogBufferDescriptor.indexByTermCount(n3);
            UnsafeBuffer unsafeBuffer = this.termBuffers[n4];
            int n5 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + n4 * 8;
            long l4 = this.logMetaDataBuffer.getLongVolatile(n5);
            int n6 = LogBufferDescriptor.termOffset(l4, unsafeBuffer.capacity());
            int n7 = LogBufferDescriptor.termId(l4);
            if (n3 != n7 - this.initialTermId) {
                return -3L;
            }
            long l5 = LogBufferDescriptor.computePosition(n7, n6, this.positionBitsToShift, this.initialTermId);
            if (l5 < l3) {
                if (n2 <= this.maxPayloadLength) {
                    l2 = this.appendUnfragmentedMessage(unsafeBuffer, n5, directBufferVectorArray, n2, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(n2);
                    l2 = this.appendFragmentedMessage(unsafeBuffer, n5, directBufferVectorArray, n2, reservedValueSupplier);
                }
            } else {
                l2 = this.backPressureStatus(l5, n2);
            }
        }
        return l2;
    }

    @Override
    public long tryClaim(int n2, BufferClaim bufferClaim) {
        this.checkPayloadLength(n2);
        long l2 = -4L;
        if (!this.isClosed) {
            long l3 = this.positionLimit.getVolatile();
            int n3 = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int n4 = LogBufferDescriptor.indexByTermCount(n3);
            UnsafeBuffer unsafeBuffer = this.termBuffers[n4];
            int n5 = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + n4 * 8;
            long l4 = this.logMetaDataBuffer.getLongVolatile(n5);
            int n6 = LogBufferDescriptor.termOffset(l4, unsafeBuffer.capacity());
            int n7 = LogBufferDescriptor.termId(l4);
            if (n3 != n7 - this.initialTermId) {
                return -3L;
            }
            long l5 = LogBufferDescriptor.computePosition(n7, n6, this.positionBitsToShift, this.initialTermId);
            l2 = l5 < l3 ? this.claim(unsafeBuffer, n5, n2, bufferClaim) : this.backPressureStatus(l5, n2);
        }
        return l2;
    }

    private long appendUnfragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBuffer directBuffer, int n3, int n4, ReservedValueSupplier reservedValueSupplier) {
        int n5 = n4 + 32;
        int n6 = BitUtil.align(n5, 32);
        int n7 = unsafeBuffer.capacity();
        long l2 = this.logMetaDataBuffer.getAndAddLong(n2, n6);
        int n8 = LogBufferDescriptor.termId(l2);
        int n9 = LogBufferDescriptor.termOffset(l2, n7);
        int n10 = n9 + n6;
        long l3 = LogBufferDescriptor.computePosition(n8, n10, this.positionBitsToShift, this.initialTermId);
        if (n10 > n7) {
            return this.handleEndOfLog(unsafeBuffer, n7, n8, n9, l3);
        }
        this.headerWriter.write(unsafeBuffer, n9, n5, n8);
        unsafeBuffer.putBytes(n9 + 32, directBuffer, n3, n4);
        if (null != reservedValueSupplier) {
            long l4 = reservedValueSupplier.get(unsafeBuffer, n9, n5);
            unsafeBuffer.putLong(n9 + 24, l4, ByteOrder.LITTLE_ENDIAN);
        }
        FrameDescriptor.frameLengthOrdered(unsafeBuffer, n9, n5);
        return l3;
    }

    private long appendFragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBuffer directBuffer, int n3, int n4, ReservedValueSupplier reservedValueSupplier) {
        int n5;
        int n6 = ConcurrentPublication.computeFramedLength(n4, this.maxPayloadLength);
        int n7 = unsafeBuffer.capacity();
        long l2 = this.logMetaDataBuffer.getAndAddLong(n2, n6);
        int n8 = LogBufferDescriptor.termId(l2);
        int n9 = LogBufferDescriptor.termOffset(l2, n7);
        int n10 = n9 + n6;
        long l3 = LogBufferDescriptor.computePosition(n8, n10, this.positionBitsToShift, this.initialTermId);
        if (n10 > n7) {
            return this.handleEndOfLog(unsafeBuffer, n7, n8, n9, l3);
        }
        int n11 = n9;
        byte by2 = -128;
        int n12 = n4;
        do {
            n5 = Math.min(n12, this.maxPayloadLength);
            int n13 = n5 + 32;
            int n14 = BitUtil.align(n13, 32);
            this.headerWriter.write(unsafeBuffer, n11, n13, n8);
            unsafeBuffer.putBytes(n11 + 32, directBuffer, n3 + (n4 - n12), n5);
            if (n12 <= this.maxPayloadLength) {
                by2 = (byte)(by2 | 0x40);
            }
            FrameDescriptor.frameFlags(unsafeBuffer, n11, by2);
            if (null != reservedValueSupplier) {
                long l4 = reservedValueSupplier.get(unsafeBuffer, n11, n13);
                unsafeBuffer.putLong(n11 + 24, l4, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, n11, n13);
            by2 = 0;
            n11 += n14;
        } while ((n12 -= n5) > 0);
        return l3;
    }

    private long appendUnfragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6, ReservedValueSupplier reservedValueSupplier) {
        int n7 = n4 + n6 + 32;
        int n8 = BitUtil.align(n7, 32);
        int n9 = unsafeBuffer.capacity();
        long l2 = this.logMetaDataBuffer.getAndAddLong(n2, n8);
        int n10 = LogBufferDescriptor.termId(l2);
        int n11 = LogBufferDescriptor.termOffset(l2, n9);
        int n12 = n11 + n8;
        long l3 = LogBufferDescriptor.computePosition(n10, n12, this.positionBitsToShift, this.initialTermId);
        if (n12 > n9) {
            return this.handleEndOfLog(unsafeBuffer, n9, n10, n11, l3);
        }
        this.headerWriter.write(unsafeBuffer, n11, n7, n10);
        unsafeBuffer.putBytes(n11 + 32, directBuffer, n3, n4);
        unsafeBuffer.putBytes(n11 + 32 + n4, directBuffer2, n5, n6);
        if (null != reservedValueSupplier) {
            long l4 = reservedValueSupplier.get(unsafeBuffer, n11, n7);
            unsafeBuffer.putLong(n11 + 24, l4, ByteOrder.LITTLE_ENDIAN);
        }
        FrameDescriptor.frameLengthOrdered(unsafeBuffer, n11, n7);
        return l3;
    }

    private long appendFragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6, ReservedValueSupplier reservedValueSupplier) {
        int n7;
        int n8 = n4 + n6;
        int n9 = ConcurrentPublication.computeFramedLength(n8, this.maxPayloadLength);
        int n10 = unsafeBuffer.capacity();
        long l2 = this.logMetaDataBuffer.getAndAddLong(n2, n9);
        int n11 = LogBufferDescriptor.termId(l2);
        int n12 = LogBufferDescriptor.termOffset(l2, n10);
        int n13 = n12 + n9;
        long l3 = LogBufferDescriptor.computePosition(n11, n13, this.positionBitsToShift, this.initialTermId);
        if (n13 > n10) {
            return this.handleEndOfLog(unsafeBuffer, n10, n11, n12, l3);
        }
        int n14 = n12;
        byte by2 = -128;
        int n15 = n8;
        int n16 = 0;
        int n17 = 0;
        do {
            n7 = Math.min(n15, this.maxPayloadLength);
            int n18 = n7 + 32;
            int n19 = BitUtil.align(n18, 32);
            this.headerWriter.write(unsafeBuffer, n14, n18, n11);
            int n20 = 0;
            int n21 = n14 + 32;
            do {
                int n22;
                int n23;
                if ((n23 = n4 - n16) > 0) {
                    n22 = Math.min(n7 - n20, n23);
                    unsafeBuffer.putBytes(n21, directBuffer, n3 + n16, n22);
                    n20 += n22;
                    n21 += n22;
                    n16 += n22;
                    continue;
                }
                n22 = Math.min(n7 - n20, n6 - n17);
                unsafeBuffer.putBytes(n21, directBuffer2, n5 + n17, n22);
                n20 += n22;
                n21 += n22;
                n17 += n22;
            } while (n20 < n7);
            if (n15 <= this.maxPayloadLength) {
                by2 = (byte)(by2 | 0x40);
            }
            FrameDescriptor.frameFlags(unsafeBuffer, n14, by2);
            if (null != reservedValueSupplier) {
                long l4 = reservedValueSupplier.get(unsafeBuffer, n14, n18);
                unsafeBuffer.putLong(n14 + 24, l4, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, n14, n18);
            by2 = 0;
            n14 += n19;
        } while ((n15 -= n7) > 0);
        return l3;
    }

    private long appendUnfragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBufferVector[] directBufferVectorArray, int n3, ReservedValueSupplier reservedValueSupplier) {
        int n4 = n3 + 32;
        int n5 = BitUtil.align(n4, 32);
        int n6 = unsafeBuffer.capacity();
        long l2 = this.logMetaDataBuffer.getAndAddLong(n2, n5);
        int n7 = LogBufferDescriptor.termId(l2);
        int n8 = LogBufferDescriptor.termOffset(l2, n6);
        int n9 = n8 + n5;
        long l3 = LogBufferDescriptor.computePosition(n7, n9, this.positionBitsToShift, this.initialTermId);
        if (n9 > n6) {
            return this.handleEndOfLog(unsafeBuffer, n6, n7, n8, l3);
        }
        this.headerWriter.write(unsafeBuffer, n8, n4, n7);
        int n10 = n8 + 32;
        for (DirectBufferVector directBufferVector : directBufferVectorArray) {
            unsafeBuffer.putBytes(n10, directBufferVector.buffer(), directBufferVector.offset(), directBufferVector.length());
            n10 += directBufferVector.length();
        }
        if (null != reservedValueSupplier) {
            long l4 = reservedValueSupplier.get(unsafeBuffer, n8, n4);
            unsafeBuffer.putLong(n8 + 24, l4, ByteOrder.LITTLE_ENDIAN);
        }
        FrameDescriptor.frameLengthOrdered(unsafeBuffer, n8, n4);
        return l3;
    }

    private long appendFragmentedMessage(UnsafeBuffer unsafeBuffer, int n2, DirectBufferVector[] directBufferVectorArray, int n3, ReservedValueSupplier reservedValueSupplier) {
        int n4;
        int n5 = ConcurrentPublication.computeFramedLength(n3, this.maxPayloadLength);
        int n6 = unsafeBuffer.capacity();
        long l2 = this.logMetaDataBuffer.getAndAddLong(n2, n5);
        int n7 = LogBufferDescriptor.termId(l2);
        int n8 = LogBufferDescriptor.termOffset(l2, n6);
        int n9 = n8 + n5;
        long l3 = LogBufferDescriptor.computePosition(n7, n9, this.positionBitsToShift, this.initialTermId);
        if (n9 > n6) {
            return this.handleEndOfLog(unsafeBuffer, n6, n7, n8, l3);
        }
        int n10 = n8;
        byte by2 = -128;
        int n11 = n3;
        int n12 = 0;
        int n13 = 0;
        do {
            n4 = Math.min(n11, this.maxPayloadLength);
            int n14 = n4 + 32;
            int n15 = BitUtil.align(n14, 32);
            this.headerWriter.write(unsafeBuffer, n10, n14, n7);
            int n16 = 0;
            int n17 = n10 + 32;
            do {
                DirectBufferVector directBufferVector = directBufferVectorArray[n12];
                int n18 = directBufferVector.length() - n13;
                int n19 = Math.min(n4 - n16, n18);
                unsafeBuffer.putBytes(n17, directBufferVector.buffer(), directBufferVector.offset() + n13, n19);
                n16 += n19;
                n17 += n19;
                n13 += n19;
                if (n18 > n19) continue;
                ++n12;
                n13 = 0;
            } while (n16 < n4);
            if (n11 <= this.maxPayloadLength) {
                by2 = (byte)(by2 | 0x40);
            }
            FrameDescriptor.frameFlags(unsafeBuffer, n10, by2);
            if (null != reservedValueSupplier) {
                long l4 = reservedValueSupplier.get(unsafeBuffer, n10, n14);
                unsafeBuffer.putLong(n10 + 24, l4, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, n10, n14);
            by2 = 0;
            n10 += n15;
        } while ((n11 -= n4) > 0);
        return l3;
    }

    private long claim(UnsafeBuffer unsafeBuffer, int n2, int n3, BufferClaim bufferClaim) {
        int n4 = n3 + 32;
        int n5 = BitUtil.align(n4, 32);
        int n6 = unsafeBuffer.capacity();
        long l2 = this.logMetaDataBuffer.getAndAddLong(n2, n5);
        int n7 = LogBufferDescriptor.termId(l2);
        int n8 = LogBufferDescriptor.termOffset(l2, n6);
        int n9 = n8 + n5;
        long l3 = LogBufferDescriptor.computePosition(n7, n9, this.positionBitsToShift, this.initialTermId);
        if (n9 > n6) {
            return this.handleEndOfLog(unsafeBuffer, n6, n7, n8, l3);
        }
        this.headerWriter.write(unsafeBuffer, n8, n4, n7);
        bufferClaim.wrap(unsafeBuffer, n8, n4);
        return l3;
    }

    private long handleEndOfLog(UnsafeBuffer unsafeBuffer, int n2, int n3, int n4, long l2) {
        if (n4 < n2) {
            int n5 = n2 - n4;
            this.headerWriter.write(unsafeBuffer, n4, n5, n3);
            FrameDescriptor.frameType(unsafeBuffer, n4, 0);
            FrameDescriptor.frameLengthOrdered(unsafeBuffer, n4, n5);
        }
        if (l2 >= this.maxPossiblePosition) {
            return -5L;
        }
        LogBufferDescriptor.rotateLog(this.logMetaDataBuffer, n3 - this.initialTermId, n3);
        return -3L;
    }
}

