/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools.rectangle.change;

import impl.org.controlsfx.tools.rectangle.Edge2D;
import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import impl.org.controlsfx.tools.rectangle.change.AbstractRatioRespectingChangeStrategy;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

abstract class AbstractFixedEdgeChangeStrategy
extends AbstractRatioRespectingChangeStrategy {
    private final Rectangle2D bounds;
    private Edge2D fixedEdge;

    protected AbstractFixedEdgeChangeStrategy(boolean bl2, double d2, Rectangle2D rectangle2D) {
        super(bl2, d2);
        this.bounds = rectangle2D;
    }

    protected abstract Edge2D getFixedEdge();

    private final Rectangle2D createFromEdges(Point2D point2D) {
        Point2D point2D2 = Rectangles2D.inRectangle(this.bounds, point2D);
        if (this.isRatioFixed()) {
            return Rectangles2D.forEdgeAndOpposingPointAndRatioWithinBounds(this.fixedEdge, point2D2, this.getRatio(), this.bounds);
        }
        return Rectangles2D.forEdgeAndOpposingPoint(this.fixedEdge, point2D2);
    }

    @Override
    protected final Rectangle2D doBegin(Point2D point2D) {
        boolean bl2;
        boolean bl3 = bl2 = !this.bounds.contains(point2D);
        if (bl2) {
            throw new IllegalArgumentException("The change's start point (" + point2D + ") must lie within the bounds (" + this.bounds + ").");
        }
        this.fixedEdge = this.getFixedEdge();
        return this.createFromEdges(point2D);
    }

    @Override
    protected Rectangle2D doContinue(Point2D point2D) {
        return this.createFromEdges(point2D);
    }

    @Override
    protected final Rectangle2D doEnd(Point2D point2D) {
        Rectangle2D rectangle2D = this.createFromEdges(point2D);
        this.fixedEdge = null;
        return rectangle2D;
    }
}

