/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools.rectangle;

import java.util.Objects;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;

public class Edge2D {
    private final Point2D centerPoint;
    private final Orientation orientation;
    private final double length;

    public Edge2D(Point2D point2D, Orientation orientation, double d2) {
        Objects.requireNonNull(point2D, "The specified center point must not be null.");
        Objects.requireNonNull(orientation, "The specified orientation must not be null.");
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The length must not be negative, i.e. zero or a positive value is alowed.");
        }
        this.centerPoint = point2D;
        this.orientation = orientation;
        this.length = d2;
    }

    public Point2D getUpperLeft() {
        if (this.isHorizontal()) {
            double d2 = this.centerPoint.getX() - this.length / 2.0;
            double d3 = this.centerPoint.getY();
            return new Point2D(d2, d3);
        }
        double d4 = this.centerPoint.getX();
        double d5 = this.centerPoint.getY() - this.length / 2.0;
        return new Point2D(d4, d5);
    }

    public Point2D getLowerRight() {
        if (this.isHorizontal()) {
            double d2 = this.centerPoint.getX() + this.length / 2.0;
            double d3 = this.centerPoint.getY();
            return new Point2D(d2, d3);
        }
        double d4 = this.centerPoint.getX();
        double d5 = this.centerPoint.getY() + this.length / 2.0;
        return new Point2D(d4, d5);
    }

    public double getOrthogonalDifference(Point2D point2D) {
        Objects.requireNonNull(point2D, "The other point must nt be null.");
        if (this.isHorizontal()) {
            return point2D.getY() - this.centerPoint.getY();
        }
        return point2D.getX() - this.centerPoint.getX();
    }

    public Point2D getCenterPoint() {
        return this.centerPoint;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == Orientation.HORIZONTAL;
    }

    public boolean isVertical() {
        return this.orientation == Orientation.VERTICAL;
    }

    public double getLength() {
        return this.length;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.centerPoint == null ? 0 : this.centerPoint.hashCode());
        long l2 = Double.doubleToLongBits(this.length);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        n3 = 31 * n3 + (this.orientation == null ? 0 : this.orientation.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Edge2D edge2D = (Edge2D)object;
        if (this.centerPoint == null ? edge2D.centerPoint != null : !this.centerPoint.equals((Object)edge2D.centerPoint)) {
            return false;
        }
        if (Double.doubleToLongBits(this.length) != Double.doubleToLongBits(edge2D.length)) {
            return false;
        }
        return this.orientation == edge2D.orientation;
    }

    public String toString() {
        return "Edge2D [centerX = " + this.centerPoint.getX() + ", centerY = " + this.centerPoint.getY() + ", orientation = " + this.orientation + ", length = " + this.length + "]";
    }
}

