/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.HorizontalHeaderColumn;
import java.util.BitSet;
import java.util.ConcurrentModificationException;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalHeader
extends TableHeaderRow {
    final GridViewSkin gridViewSkin;
    private int lastColumnResized = -1;
    private boolean working = true;
    protected BitSet selectedColumns = new BitSet();
    private final InvalidationListener verticalHeaderListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            HorizontalHeader.this.updateTableWidth();
        }
    };
    private final ChangeListener<Boolean> horizontalHeaderVisibilityListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl2, Boolean bl3) {
            HorizontalHeader.this.updateHorizontalHeaderVisibility(bl3);
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> change) {
            while (change.next()) {
                for (SpreadsheetColumn spreadsheetColumn : change.getRemoved()) {
                    HorizontalHeader.this.unfixColumn(spreadsheetColumn);
                }
                for (SpreadsheetColumn spreadsheetColumn : change.getAddedSubList()) {
                    HorizontalHeader.this.fixColumn(spreadsheetColumn);
                }
            }
            HorizontalHeader.this.updateHighlightSelection();
        }
    };
    private final InvalidationListener selectionListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            HorizontalHeader.this.updateHighlightSelection();
        }
    };

    public HorizontalHeader(GridViewSkin gridViewSkin) {
        super((TableViewSkinBase)gridViewSkin);
        this.gridViewSkin = gridViewSkin;
    }

    public void init() {
        SpreadsheetView spreadsheetView = this.gridViewSkin.handle.getView();
        this.updateHorizontalHeaderVisibility(spreadsheetView.isShowColumnHeader());
        spreadsheetView.showRowHeaderProperty().addListener(this.verticalHeaderListener);
        this.gridViewSkin.verticalHeader.verticalHeaderWidthProperty().addListener(this.verticalHeaderListener);
        spreadsheetView.showColumnHeaderProperty().addListener(this.horizontalHeaderVisibilityListener);
        this.gridViewSkin.getSelectedColumns().addListener(this.selectionListener);
        spreadsheetView.getFixedColumns().addListener(this.fixedColumnsListener);
        Platform.runLater(() -> {
            for (SpreadsheetColumn spreadsheetColumn : spreadsheetView.getFixedColumns()) {
                this.fixColumn(spreadsheetColumn);
            }
            this.requestLayout();
            this.installHeaderMouseEvent();
        });
        this.getRootHeader().getColumnHeaders().addListener(observable -> {
            for (SpreadsheetColumn spreadsheetColumn : spreadsheetView.getFixedColumns()) {
                this.fixColumn(spreadsheetColumn);
            }
            this.updateHighlightSelection();
            this.installHeaderMouseEvent();
        });
    }

    void clearSelectedColumns() {
        this.selectedColumns.clear();
    }

    protected void updateTableWidth() {
        Rectangle rectangle;
        super.updateTableWidth();
        double d2 = 0.0;
        if (this.working && this.gridViewSkin != null && this.gridViewSkin.spreadsheetView != null && this.gridViewSkin.spreadsheetView.showRowHeaderProperty().get() && this.gridViewSkin.verticalHeader != null) {
            d2 += this.gridViewSkin.verticalHeader.getVerticalHeaderWidth();
        }
        rectangle.setWidth((rectangle = (Rectangle)this.getClip()).getWidth() == 0.0 ? 0.0 : rectangle.getWidth() - d2);
    }

    protected void updateScrollX() {
        super.updateScrollX();
        this.gridViewSkin.horizontalPickers.updateScrollX();
        if (this.working) {
            this.requestLayout();
            ((HorizontalHeaderColumn)this.getRootHeader()).layoutFixedColumns();
        }
    }

    protected NestedTableColumnHeader createRootHeader() {
        return new HorizontalHeaderColumn(null);
    }

    private void installHeaderMouseEvent() {
        for (TableColumnHeader tableColumnHeader : this.getRootHeader().getColumnHeaders()) {
            EventHandler eventHandler = mouseEvent -> {
                if (mouseEvent.isPrimaryButtonDown()) {
                    this.headerClicked((TableColumn)tableColumnHeader.getTableColumn(), (MouseEvent)mouseEvent);
                }
            };
            ((Node)tableColumnHeader.getChildrenUnmodifiable().get(0)).setOnMousePressed(eventHandler);
        }
    }

    private void headerClicked(TableColumn tableColumn, MouseEvent mouseEvent) {
        TableView.TableViewSelectionModel tableViewSelectionModel = this.gridViewSkin.handle.getGridView().getSelectionModel();
        int n2 = this.gridViewSkin.getItemCount() - 1;
        int n3 = tableColumn.getTableView().getColumns().indexOf((Object)tableColumn);
        TablePosition tablePosition = tableViewSelectionModel.getTableView().getFocusModel().getFocusedCell();
        if (mouseEvent.isShortcutDown()) {
            BitSet bitSet = (BitSet)this.selectedColumns.clone();
            tableViewSelectionModel.selectRange(0, (TableColumnBase)tableColumn, n2, (TableColumnBase)tableColumn);
            this.selectedColumns.or(bitSet);
            this.selectedColumns.set(n3);
        } else if (mouseEvent.isShiftDown() && tablePosition != null && tablePosition.getTableColumn() != null) {
            tableViewSelectionModel.clearSelection();
            tableViewSelectionModel.selectRange(0, (TableColumnBase)tableColumn, n2, (TableColumnBase)tablePosition.getTableColumn());
            tableViewSelectionModel.getTableView().getFocusModel().focus(0, tablePosition.getTableColumn());
            int n4 = Math.min(n3, tablePosition.getColumn());
            int n5 = Math.max(n3, tablePosition.getColumn());
            this.selectedColumns.set(n4, n5 + 1);
        } else {
            tableViewSelectionModel.clearSelection();
            tableViewSelectionModel.selectRange(0, (TableColumnBase)tableColumn, n2, (TableColumnBase)tableColumn);
            tableViewSelectionModel.getTableView().getFocusModel().focus(0, tableColumn);
            this.selectedColumns.set(n3);
        }
    }

    private void fixColumn(SpreadsheetColumn spreadsheetColumn) {
        this.addStyleHeader(this.gridViewSkin.spreadsheetView.getViewColumn(this.gridViewSkin.spreadsheetView.getColumns().indexOf((Object)spreadsheetColumn)));
    }

    private void unfixColumn(SpreadsheetColumn spreadsheetColumn) {
        try {
            this.removeStyleHeader(this.gridViewSkin.spreadsheetView.getViewColumn(this.gridViewSkin.spreadsheetView.getColumns().indexOf((Object)spreadsheetColumn)));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private void removeStyleHeader(Integer n2) {
        if (this.getRootHeader().getColumnHeaders().size() > n2) {
            ((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(n2.intValue())).getStyleClass().removeAll((Object[])new String[]{"fixed"});
        }
    }

    private void addStyleHeader(Integer n2) {
        if (this.getRootHeader().getColumnHeaders().size() > n2) {
            ((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(n2.intValue())).getStyleClass().addAll((Object[])new String[]{"fixed"});
        }
    }

    private void updateHighlightSelection() {
        for (Object object : this.getRootHeader().getColumnHeaders()) {
            object.getStyleClass().removeAll((Object[])new String[]{"selected"});
        }
        ObservableList<Integer> observableList = this.gridViewSkin.getSelectedColumns();
        for (Integer n2 : observableList) {
            if (this.getRootHeader().getColumnHeaders().size() <= n2) continue;
            ((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(n2.intValue())).getStyleClass().addAll((Object[])new String[]{"selected"});
        }
    }

    private void updateHorizontalHeaderVisibility(boolean bl2) {
        this.working = bl2;
        this.setManaged(this.working);
        if (!bl2) {
            this.getStyleClass().add((Object)"invisible");
        } else {
            this.getStyleClass().remove((Object)"invisible");
            this.requestLayout();
            ((HorizontalHeaderColumn)this.getRootHeader()).layoutFixedColumns();
            this.updateHighlightSelection();
        }
    }

    protected double computePrefHeight(double d2) {
        if (!this.gridViewSkin.handle.getView().isShowColumnHeader()) {
            return 0.0;
        }
        double d3 = this.getRootHeader().prefHeight(d2);
        d3 = d3 == 0.0 ? 24.0 : d3;
        double d4 = this.snappedTopInset() + d3 + this.snappedBottomInset();
        d4 = d4 < 24.0 ? 24.0 : d4;
        return d4;
    }
}

