/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class PromptLinesWrapper<T extends Control> {
    private final Supplier<Text> promptTextSupplier;
    private T control;
    public StackPane line = new StackPane();
    public StackPane focusedLine = new StackPane();
    public StackPane promptContainer = new StackPane();
    private JFXAnimationTimer focusTimer;
    private JFXAnimationTimer unfocusTimer;
    private double initScale = 0.05;
    public final Scale promptTextScale = new Scale(1.0, 1.0, 0.0, 0.0);
    private final Scale scale = new Scale(this.initScale, 1.0);
    public final Rectangle clip = new Rectangle();
    public ObjectProperty<Paint> animatedPromptTextFill;
    public BooleanBinding usePromptText;
    private ObjectProperty<Paint> promptTextFill;
    private ObservableValue<?> valueProperty;
    private ObservableValue<String> promptTextProperty;
    private boolean animating = false;
    private double contentHeight = 0.0;

    public PromptLinesWrapper(T t2, ObjectProperty<Paint> objectProperty, ObservableValue<?> observableValue, ObservableValue<String> observableValue2, Supplier<Text> supplier) {
        this.control = t2;
        this.promptTextSupplier = supplier;
        this.promptTextFill = objectProperty;
        this.valueProperty = observableValue;
        this.promptTextProperty = observableValue2;
    }

    public void init(Runnable runnable, Node ... nodeArray) {
        this.animatedPromptTextFill = new SimpleObjectProperty((Object)((Paint)this.promptTextFill.get()));
        this.usePromptText = Bindings.createBooleanBinding(this::usePromptText, (Observable[])new Observable[]{this.valueProperty, this.promptTextProperty, ((IFXLabelFloatControl)this.control).labelFloatProperty(), this.promptTextFill});
        this.line.setManaged(false);
        this.line.getStyleClass().add((Object)"input-line");
        this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((IFXLabelFloatControl)this.control).getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.focusedLine.setManaged(false);
        this.focusedLine.getStyleClass().add((Object)"input-focused-line");
        this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((IFXLabelFloatControl)this.control).getFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.focusedLine.setOpacity(0.0);
        this.focusedLine.getTransforms().add((Object)this.scale);
        if (this.usePromptText.get()) {
            runnable.run();
        }
        this.usePromptText.addListener(observable -> {
            runnable.run();
            this.control.requestLayout();
        });
        Supplier supplier = () -> this.promptTextSupplier.get() == null ? null : this.promptTextSupplier.get().translateYProperty();
        this.focusTimer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)1.0), JFXKeyValue.builder().setTarget(this.focusedLine.opacityProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> this.control.isFocused()).build()), new JFXKeyFrame(Duration.millis((double)160.0), JFXKeyValue.builder().setTarget(this.scale.xProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> this.control.isFocused()).build(), JFXKeyValue.builder().setTarget(this.animatedPromptTextFill).setEndValueSupplier(() -> ((IFXLabelFloatControl)this.control).getFocusColor()).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> this.control.isFocused() && ((IFXLabelFloatControl)this.control).isLabelFloat()).build(), JFXKeyValue.builder().setTargetSupplier(supplier).setEndValueSupplier(() -> -this.contentHeight).setAnimateCondition(() -> ((IFXLabelFloatControl)this.control).isLabelFloat()).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.xProperty()).setEndValue(0.85).setAnimateCondition(() -> ((IFXLabelFloatControl)this.control).isLabelFloat()).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.yProperty()).setEndValue(0.85).setAnimateCondition(() -> ((IFXLabelFloatControl)this.control).isLabelFloat()).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.unfocusTimer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)160.0), JFXKeyValue.builder().setTargetSupplier(supplier).setEndValue(0).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.xProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget(this.promptTextScale.yProperty()).setEndValue(1).setInterpolator(Interpolator.EASE_BOTH).build()));
        this.promptContainer.getStyleClass().add((Object)"prompt-container");
        this.promptContainer.setManaged(false);
        this.promptContainer.setMouseTransparent(true);
        this.clip.setSmooth(false);
        this.clip.setX(0.0);
        this.clip.widthProperty().bind((ObservableValue)this.promptContainer.widthProperty());
        this.promptContainer.setClip((Node)this.clip);
        this.focusTimer.setOnFinished(() -> {
            this.animating = false;
        });
        this.unfocusTimer.setOnFinished(() -> {
            this.animating = false;
        });
        this.focusTimer.setCacheNodes(nodeArray);
        this.unfocusTimer.setCacheNodes(nodeArray);
        this.control.focusedProperty().addListener(observable -> {
            if (this.control.isFocused()) {
                this.focus();
            } else {
                this.unFocus();
            }
        });
        this.promptTextFill.addListener(observable -> {
            if (!((IFXLabelFloatControl)this.control).isLabelFloat() || !this.control.isFocused()) {
                this.animatedPromptTextFill.set((Object)((Paint)this.promptTextFill.get()));
            }
        });
        this.updateDisabled();
    }

    private Object getControlValue() {
        Object object = this.valueProperty.getValue();
        object = this.validateComboBox(object);
        return object;
    }

    private Object validateComboBox(Object object) {
        if (this.control instanceof ComboBox && ((ComboBox)this.control).isEditable()) {
            String string = ((ComboBox)this.control).getEditor().getText();
            object = string == null || string.isEmpty() ? null : object;
        }
        return object;
    }

    private void focus() {
        this.unfocusTimer.stop();
        this.animating = true;
        this.runTimer(this.focusTimer, true);
    }

    private void unFocus() {
        this.focusTimer.stop();
        this.scale.setX(this.initScale);
        this.focusedLine.setOpacity(0.0);
        if (((IFXLabelFloatControl)this.control).isLabelFloat()) {
            this.animatedPromptTextFill.set((Object)((Paint)this.promptTextFill.get()));
            Object object = this.getControlValue();
            if (object == null || object.toString().isEmpty()) {
                this.animating = true;
                this.runTimer(this.unfocusTimer, true);
            }
        }
    }

    public void updateFocusColor() {
        Paint paint = ((IFXLabelFloatControl)this.control).getFocusColor();
        this.focusedLine.setBackground(paint == null ? Background.EMPTY : new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    public void updateUnfocusColor() {
        Paint paint = ((IFXLabelFloatControl)this.control).getUnFocusColor();
        this.line.setBackground(paint == null ? Background.EMPTY : new Background(new BackgroundFill[]{new BackgroundFill(paint, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    private void updateLabelFloat(boolean bl2) {
        if (((IFXLabelFloatControl)this.control).isLabelFloat()) {
            if (this.control.isFocused()) {
                this.animateFloatingLabel(true, bl2);
            } else {
                Object object = this.getControlValue();
                this.animateFloatingLabel(object != null && !object.toString().isEmpty(), bl2);
            }
        }
    }

    private void animateFloatingLabel(boolean bl2, boolean bl3) {
        if (this.promptTextSupplier.get() == null) {
            return;
        }
        if (bl2) {
            if (this.promptTextSupplier.get().getTranslateY() != -this.contentHeight) {
                this.unfocusTimer.stop();
                this.runTimer(this.focusTimer, bl3);
            }
        } else if (this.promptTextSupplier.get().getTranslateY() != 0.0) {
            this.focusTimer.stop();
            this.runTimer(this.unfocusTimer, bl3);
        }
    }

    private void runTimer(JFXAnimationTimer jFXAnimationTimer, boolean bl2) {
        if (bl2) {
            if (!jFXAnimationTimer.isRunning()) {
                jFXAnimationTimer.start();
            }
        } else {
            jFXAnimationTimer.applyEndValues();
        }
    }

    private boolean usePromptText() {
        Object object = this.getControlValue();
        String string = (String)this.promptTextProperty.getValue();
        boolean bl2 = ((IFXLabelFloatControl)this.control).isLabelFloat();
        return bl2 || string != null && (object == null || object.toString().isEmpty()) && !string.isEmpty() && !((Paint)this.promptTextFill.get()).equals(Color.TRANSPARENT);
    }

    public void layoutLines(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.contentHeight = d7;
        this.clip.setY(-this.contentHeight);
        this.clip.setHeight(d6 + this.contentHeight);
        this.focusedLine.resizeRelocate(d2, d6, d4, this.focusedLine.prefHeight(-1.0));
        this.line.resizeRelocate(d2, d6, d4, this.line.prefHeight(-1.0));
        this.promptContainer.resizeRelocate(d2, d3, d4, d5);
        this.scale.setPivotX(d4 / 2.0);
    }

    public void updateLabelFloatLayout() {
        if (!this.animating) {
            this.updateLabelFloat(false);
        } else if (this.unfocusTimer.isRunning()) {
            this.unfocusTimer.stop();
            this.updateLabelFloat(true);
        }
    }

    public void invalid() {
        if (this.control.isFocused()) {
            this.focus();
        }
    }

    public void updateDisabled() {
        boolean bl2 = this.control.isDisable();
        this.line.setBorder(!bl2 ? Border.EMPTY : new Border(new BorderStroke[]{new BorderStroke(((IFXLabelFloatControl)this.control).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(1.0))}));
        this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(bl2 ? Color.TRANSPARENT : ((IFXLabelFloatControl)this.control).getUnFocusColor()), CornerRadii.EMPTY, Insets.EMPTY)}));
    }
}

