/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class JFXListCell<T>
extends ListCell<T> {
    protected JFXRippler cellRippler = new JFXRippler((Node)this){

        @Override
        protected Node getMask() {
            Region region = new Region();
            JFXNodeUtils.updateBackground(JFXListCell.this.getBackground(), region);
            double d2 = this.control.getLayoutBounds().getWidth();
            double d3 = this.control.getLayoutBounds().getHeight();
            region.resize(d2, d3);
            return region;
        }

        @Override
        protected void positionControl(Node node) {
        }
    };
    protected Node cellContent;
    private Rectangle clip;
    private Timeline expandAnimation;
    private Timeline gapAnimation;
    private double animatedHeight = 0.0;
    private boolean playExpandAnimation = false;
    private boolean selectionChanged = false;
    @Deprecated
    private BooleanProperty expandedProperty = new SimpleBooleanProperty(false);
    private static final String DEFAULT_STYLE_CLASS = "jfx-list-cell";

    public JFXListCell() {
        this.initialize();
        this.initListeners();
    }

    private void initListeners() {
        this.listViewProperty().addListener((observableValue2, listView, listView2) -> {
            if (listView2 != null && this.getListView() instanceof JFXListView) {
                ((JFXListView)((Object)listView2)).currentVerticalGapProperty().addListener((observableValue, number, number2) -> {
                    this.cellRippler.rippler.setClip(null);
                    if (number2.doubleValue() != 0.0) {
                        this.playExpandAnimation = true;
                        this.getListView().requestLayout();
                    } else {
                        double d2 = this.clip.getY() * 2.0;
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)(-d2 / 2.0 - d2 * (double)this.getIndex()), Interpolator.EASE_BOTH)})});
                        this.gapAnimation.play();
                        this.gapAnimation.setOnFinished(actionEvent -> {
                            this.requestLayout();
                            Platform.runLater(() -> this.getListView().requestLayout());
                        });
                    }
                });
                this.selectedProperty().addListener((observableValue, bl2, bl3) -> {
                    if (bl3.booleanValue()) {
                        this.selectionChanged = true;
                    }
                });
            }
        });
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.cellRippler.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        double d2 = this.getGap();
        if (this.clip == null) {
            this.clip = new Rectangle(0.0, d2 / 2.0, this.getWidth(), this.getHeight() - d2);
            this.setClip((Node)this.clip);
        } else {
            if (d2 != 0.0) {
                if (this.playExpandAnimation || this.selectionChanged) {
                    if (this.playExpandAnimation) {
                        this.setTranslateY(-d2 / 2.0 + -d2 * (double)this.getIndex());
                        this.clip.setY(d2 / 2.0);
                        this.clip.setHeight(this.getHeight() - d2);
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                        this.playExpandAnimation = false;
                    } else if (this.selectionChanged) {
                        this.clip.setY(0.0);
                        this.clip.setHeight(this.getHeight());
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.clip.yProperty(), (Object)(d2 / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.clip.heightProperty(), (Object)(this.getHeight() - d2), Interpolator.EASE_BOTH)})});
                    }
                    this.playExpandAnimation = false;
                    this.selectionChanged = false;
                    this.gapAnimation.play();
                } else {
                    if (this.gapAnimation != null) {
                        this.gapAnimation.stop();
                    }
                    this.setTranslateY(0.0);
                    this.clip.setY(d2 / 2.0);
                    this.clip.setHeight(this.getHeight() - d2);
                }
            } else {
                this.setTranslateY(0.0);
                this.clip.setY(0.0);
                this.clip.setHeight(this.getHeight());
            }
            this.clip.setX(0.0);
            this.clip.setWidth(this.getWidth());
        }
        if (!this.getChildren().contains((Object)this.cellRippler)) {
            this.makeChildrenTransparent();
            this.getChildren().add(0, (Object)this.cellRippler);
            this.cellRippler.rippler.clear();
        }
        if (this.getGraphic() != null && this.getGraphic().getStyleClass().contains((Object)"sublist-container")) {
            this.getStyleClass().add((Object)"sublist-item");
        } else {
            this.getStyleClass().remove((Object)"sublist-item");
        }
    }

    protected void makeChildrenTransparent() {
        for (Node node : this.getChildren()) {
            if (node instanceof Label) {
                Set set = node.lookupAll("Text");
                for (Node node2 : set) {
                    node2.setMouseTransparent(true);
                }
                continue;
            }
            if (!(node instanceof Shape)) continue;
            node.setMouseTransparent(true);
        }
    }

    protected void updateItem(T t2, boolean bl4) {
        super.updateItem(t2, bl4);
        if (bl4) {
            this.setText(null);
            this.setGraphic(null);
            this.setMouseTransparent(true);
            this.setStyle("-fx-background-color:TRANSPARENT;");
        } else {
            this.setMouseTransparent(false);
            this.setStyle(null);
            if (t2 instanceof Node) {
                this.setText(null);
                Node node = this.getGraphic();
                Node node2 = (Node)t2;
                if (node == null || !node.equals(node2)) {
                    this.cellContent = node2;
                    this.cellRippler.rippler.cacheRippleClip(false);
                    if (node2 instanceof JFXRippler) {
                        this.cellRippler.ripplerFillProperty().bind(((JFXRippler)node2).ripplerFillProperty());
                        this.cellRippler.maskTypeProperty().bind(((JFXRippler)node2).maskTypeProperty());
                        this.cellRippler.positionProperty().bind(((JFXRippler)node2).positionProperty());
                        this.cellContent = ((JFXRippler)node2).getControl();
                    } else if (node2 instanceof JFXListView) {
                        ((JFXListView)this.getListView()).addSublist((JFXListView)node2, this.getIndex());
                        this.getStyleClass().add((Object)"sublist-item");
                        if (this.getPadding() != null) {
                            this.setPadding(new Insets(this.getPadding().getTop(), 0.0, this.getPadding().getBottom(), 0.0));
                        }
                        StackPane stackPane = new StackPane();
                        stackPane.getStyleClass().add((Object)"sublist-header");
                        SVGGlyph sVGGlyph = new SVGGlyph(0, "ANGLE_RIGHT", "M340 548.571q0 7.429-5.714 13.143l-266.286 266.286q-5.714 5.714-13.143 5.714t-13.143-5.714l-28.571-28.571q-5.714-5.714-5.714-13.143t5.714-13.143l224.571-224.571-224.571-224.571q-5.714-5.714-5.714-13.143t5.714-13.143l28.571-28.571q5.714-5.714 13.143-5.714t13.143 5.714l266.286 266.286q5.714 5.714 5.714 13.143z", (Paint)Color.BLACK);
                        sVGGlyph.setStyle("-fx-min-width:0.4em;-fx-max-width:0.4em;-fx-min-height:0.6em;-fx-max-height:0.6em;");
                        sVGGlyph.getStyleClass().add((Object)"drop-icon");
                        stackPane.getChildren().setAll((Object[])new Node[]{((JFXListView)node2).getGroupnode(), sVGGlyph});
                        StackPane.setMargin((Node)sVGGlyph, (Insets)new Insets(0.0, 19.0, 0.0, 0.0));
                        StackPane.setAlignment((Node)sVGGlyph, (Pos)Pos.CENTER_RIGHT);
                        StackPane stackPane2 = new StackPane();
                        stackPane2.setMinHeight(0.0);
                        stackPane2.setMaxHeight(0.0);
                        stackPane2.getChildren().setAll((Object[])new Node[]{node2});
                        stackPane2.setTranslateY(this.snappedBottomInset());
                        stackPane2.setOpacity(0.0);
                        StackPane.setMargin((Node)node2, (Insets)new Insets(-1.0, -1.0, 0.0, -1.0));
                        VBox vBox = new VBox();
                        vBox.getChildren().setAll((Object[])new Node[]{stackPane, stackPane2});
                        vBox.getStyleClass().add((Object)"sublist-container");
                        VBox.setVgrow((Node)stackPane, (Priority)Priority.ALWAYS);
                        this.cellContent = vBox;
                        this.cellRippler.ripplerPane.addEventHandler(MouseEvent.ANY, mouseEvent -> mouseEvent.consume());
                        vBox.addEventHandler(MouseEvent.ANY, mouseEvent -> {
                            if (!mouseEvent.isConsumed()) {
                                this.cellRippler.ripplerPane.fireEvent(mouseEvent);
                                mouseEvent.consume();
                            }
                        });
                        this.cellRippler.ripplerPane.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                            if (!mouseEvent.isConsumed()) {
                                mouseEvent.consume();
                                vBox.fireEvent(mouseEvent);
                            }
                        });
                        this.cellRippler.rippler.cacheRippleClip(true);
                        this.setOnMouseClicked(mouseEvent -> mouseEvent.consume());
                        vBox.setOnMouseClicked(mouseEvent -> {
                            double d2;
                            mouseEvent.consume();
                            if (this.expandAnimation != null && this.expandAnimation.getStatus() == Animation.Status.RUNNING) {
                                this.expandAnimation.stop();
                            }
                            this.expandedProperty.set(!this.expandedProperty.get());
                            double d3 = node2.prefHeight(-1.0) * (double)(this.expandedProperty.get() ? 1 : -1);
                            double d4 = this.expandedProperty.get() ? this.getHeight() + d3 : this.prefHeight(-1.0);
                            double d5 = d2 = this.expandedProperty.get() ? d3 : 0.0;
                            if (this.expandedProperty.get()) {
                                this.updateClipHeight(d4);
                                this.getListView().setPrefHeight(this.getListView().getHeight() + d3 + this.animatedHeight);
                            }
                            this.animatedHeight = d3;
                            int n2 = this.expandedProperty.get() ? 1 : 0;
                            this.expandAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)stackPane2.minHeightProperty(), (Object)d2, Interpolator.EASE_BOTH), new KeyValue((WritableValue)stackPane2.maxHeightProperty(), (Object)d2, Interpolator.EASE_BOTH), new KeyValue((WritableValue)stackPane2.opacityProperty(), (Object)n2, Interpolator.EASE_BOTH)})});
                            if (!this.expandedProperty.get()) {
                                this.expandAnimation.setOnFinished(actionEvent -> {
                                    this.updateClipHeight(d4);
                                    this.getListView().setPrefHeight(this.getListView().getHeight() + d3);
                                    this.animatedHeight = 0.0;
                                });
                            }
                            this.expandAnimation.play();
                        });
                        this.expandedProperty.addListener((observableValue, bl2, bl3) -> {
                            if (bl3.booleanValue()) {
                                new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)sVGGlyph.rotateProperty(), (Object)90, Interpolator.EASE_BOTH)})}).play();
                            } else {
                                new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)sVGGlyph.rotateProperty(), (Object)0, Interpolator.EASE_BOTH)})}).play();
                            }
                        });
                    }
                    ((Region)this.cellContent).setMaxHeight(this.cellContent.prefHeight(-1.0));
                    this.setGraphic(this.cellContent);
                }
            } else {
                this.setText(t2 == null ? "null" : t2.toString());
                this.setGraphic(null);
            }
            boolean bl5 = this.getListView() instanceof JFXListView;
            if (bl5 && ((JFXListView)this.getListView()).isShowTooltip()) {
                if (t2 instanceof Label) {
                    this.setTooltip(new Tooltip(((Label)t2).getText()));
                } else if (this.getText() != null) {
                    this.setTooltip(new Tooltip(this.getText()));
                }
            }
        }
    }

    private void updateClipHeight(double d2) {
        this.clip.setHeight(d2 - this.getGap());
    }

    @Deprecated
    public BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    @Deprecated
    public void setExpanded(boolean bl2) {
        this.expandedProperty.set(bl2);
    }

    @Deprecated
    public boolean isExpanded() {
        return this.expandedProperty.get();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setPadding(new Insets(8.0, 12.0, 8.0, 12.0));
    }

    protected double computePrefHeight(double d2) {
        double d3 = this.getGap();
        return super.computePrefHeight(d2) + d3;
    }

    private double getGap() {
        return this.getListView() instanceof JFXListView ? (((JFXListView)this.getListView()).isExpanded().booleanValue() ? ((JFXListView)this.getListView()).currentVerticalGapProperty().get() : 0.0) : 0.0;
    }
}

