/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXCheckBoxSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXCheckBox
extends CheckBox {
    private static final String DEFAULT_STYLE_CLASS = "jfx-check-box";
    private static final String USER_AGENT_STYLESHEET = JFoenixResources.load("css/controls/jfx-check-box.css").toExternalForm();
    private StyleableObjectProperty<Paint> checkedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$000(), (Object)this, "checkedColor", (Object)Color.valueOf((String)"#0F9D58"));
    private StyleableObjectProperty<Paint> unCheckedColor = new SimpleStyleableObjectProperty(StyleableProperties.access$100(), (Object)this, "unCheckedColor", (Object)Color.valueOf((String)"#5A5A5A"));
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.access$200(), (Object)this, "disableVisualFocus", false);

    public JFXCheckBox(String string) {
        super(string);
        this.initialize();
    }

    public JFXCheckBox() {
        this.initialize();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < stackTraceElementArray.length && i2 < 15; ++i2) {
            if (!stackTraceElementArray[i2].getClassName().toLowerCase().contains(".scenebuilder.kit.fxom.")) continue;
            this.setText("CheckBox");
            break;
        }
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXCheckBoxSkin(this);
    }

    public String getUserAgentStylesheet() {
        return USER_AGENT_STYLESHEET;
    }

    public Paint getCheckedColor() {
        return this.checkedColor == null ? Color.valueOf((String)"#0F9D58") : (Paint)this.checkedColor.get();
    }

    public StyleableObjectProperty<Paint> checkedColorProperty() {
        return this.checkedColor;
    }

    public void setCheckedColor(Paint paint) {
        this.checkedColor.set((Object)paint);
    }

    public Paint getUnCheckedColor() {
        return this.unCheckedColor == null ? Color.valueOf((String)"#5A5A5A") : (Paint)this.unCheckedColor.get();
    }

    public StyleableObjectProperty<Paint> unCheckedColorProperty() {
        return this.unCheckedColor;
    }

    public void setUnCheckedColor(Paint paint) {
        this.unCheckedColor.set((Object)paint);
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean bl2) {
        this.disableVisualFocusProperty().set(bl2.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXCheckBox.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXCheckBox, Paint> CHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-checked-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#0F9D58")){

            public boolean isSettable(JFXCheckBox jFXCheckBox) {
                return jFXCheckBox.checkedColor == null || !jFXCheckBox.checkedColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox jFXCheckBox) {
                return jFXCheckBox.checkedColorProperty();
            }
        };
        private static final CssMetaData<JFXCheckBox, Paint> UNCHECKED_COLOR = new CssMetaData<JFXCheckBox, Paint>("-jfx-unchecked-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#5A5A5A")){

            public boolean isSettable(JFXCheckBox jFXCheckBox) {
                return jFXCheckBox.unCheckedColor == null || !jFXCheckBox.unCheckedColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXCheckBox jFXCheckBox) {
                return jFXCheckBox.unCheckedColorProperty();
            }
        };
        private static final CssMetaData<JFXCheckBox, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXCheckBox, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXCheckBox jFXCheckBox) {
                return jFXCheckBox.disableVisualFocus == null || !jFXCheckBox.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXCheckBox jFXCheckBox) {
                return jFXCheckBox.disableVisualFocusProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return CHECKED_COLOR;
        }

        static /* synthetic */ CssMetaData access$100() {
            return UNCHECKED_COLOR;
        }

        static /* synthetic */ CssMetaData access$200() {
            return DISABLE_VISUAL_FOCUS;
        }

        static {
            ArrayList arrayList = new ArrayList(CheckBox.getClassCssMetaData());
            Collections.addAll(arrayList, CHECKED_COLOR, UNCHECKED_COLOR, DISABLE_VISUAL_FOCUS);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

