/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2Authorization;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.pkce.AuthorizationUrlWithPKCE;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCEService;
import com.github.scribejava.core.revoke.TokenTypeHint;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OAuth20Service
extends OAuthService {
    private static final String VERSION = "2.0";
    private static final PKCEService PKCE_SERVICE = new PKCEService();
    private final DefaultApi20 api;

    public OAuth20Service(DefaultApi20 defaultApi20, OAuthConfig oAuthConfig) {
        super(oAuthConfig);
        this.api = defaultApi20;
    }

    protected OAuth2AccessToken sendAccessTokenRequestSync(OAuthRequest oAuthRequest) throws IOException, InterruptedException, ExecutionException {
        return this.api.getAccessTokenExtractor().extract(this.execute(oAuthRequest));
    }

    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest oAuthRequest) {
        return this.sendAccessTokenRequestAsync(oAuthRequest, null);
    }

    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest oAuthRequest, OAuthAsyncRequestCallback<OAuth2AccessToken> oAuthAsyncRequestCallback) {
        return this.execute(oAuthRequest, oAuthAsyncRequestCallback, new OAuthRequest.ResponseConverter<OAuth2AccessToken>(){

            @Override
            public OAuth2AccessToken convert(Response response) throws IOException {
                return OAuth20Service.this.getApi().getAccessTokenExtractor().extract(response);
            }
        });
    }

    public Future<OAuth2AccessToken> getAccessTokenAsync(String string) {
        return this.getAccessToken(string, null, null);
    }

    public Future<OAuth2AccessToken> getAccessTokenAsync(String string, String string2) {
        return this.getAccessToken(string, null, string2);
    }

    public OAuth2AccessToken getAccessToken(String string) throws IOException, InterruptedException, ExecutionException {
        return this.getAccessToken(string, (String)null);
    }

    public OAuth2AccessToken getAccessToken(String string, String string2) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest oAuthRequest = this.createAccessTokenRequest(string, string2);
        return this.sendAccessTokenRequestSync(oAuthRequest);
    }

    public Future<OAuth2AccessToken> getAccessToken(String string, OAuthAsyncRequestCallback<OAuth2AccessToken> oAuthAsyncRequestCallback, String string2) {
        OAuthRequest oAuthRequest = this.createAccessTokenRequest(string, string2);
        return this.sendAccessTokenRequestAsync(oAuthRequest, oAuthAsyncRequestCallback);
    }

    public Future<OAuth2AccessToken> getAccessToken(String string, OAuthAsyncRequestCallback<OAuth2AccessToken> oAuthAsyncRequestCallback) {
        return this.getAccessToken(string, oAuthAsyncRequestCallback, null);
    }

    protected OAuthRequest createAccessTokenRequest(String string) {
        OAuthRequest oAuthRequest = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        OAuthConfig oAuthConfig = this.getConfig();
        this.api.getClientAuthenticationType().addClientAuthentication(oAuthRequest, oAuthConfig);
        oAuthRequest.addParameter("code", string);
        oAuthRequest.addParameter("redirect_uri", oAuthConfig.getCallback());
        String string2 = oAuthConfig.getScope();
        if (string2 != null) {
            oAuthRequest.addParameter("scope", string2);
        }
        oAuthRequest.addParameter("grant_type", "authorization_code");
        return oAuthRequest;
    }

    protected OAuthRequest createAccessTokenRequest(String string, String string2) {
        OAuthRequest oAuthRequest = this.createAccessTokenRequest(string);
        if (string2 != null) {
            oAuthRequest.addParameter("code_verifier", string2);
        }
        return oAuthRequest;
    }

    public Future<OAuth2AccessToken> refreshAccessTokenAsync(String string) {
        return this.refreshAccessToken(string, null);
    }

    public OAuth2AccessToken refreshAccessToken(String string) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest oAuthRequest = this.createRefreshTokenRequest(string);
        return this.sendAccessTokenRequestSync(oAuthRequest);
    }

    public Future<OAuth2AccessToken> refreshAccessToken(String string, OAuthAsyncRequestCallback<OAuth2AccessToken> oAuthAsyncRequestCallback) {
        OAuthRequest oAuthRequest = this.createRefreshTokenRequest(string);
        return this.sendAccessTokenRequestAsync(oAuthRequest, oAuthAsyncRequestCallback);
    }

    protected OAuthRequest createRefreshTokenRequest(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The refreshToken cannot be null or empty");
        }
        OAuthRequest oAuthRequest = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getRefreshTokenEndpoint());
        this.api.getClientAuthenticationType().addClientAuthentication(oAuthRequest, this.getConfig());
        oAuthRequest.addParameter("refresh_token", string);
        oAuthRequest.addParameter("grant_type", "refresh_token");
        return oAuthRequest;
    }

    public OAuth2AccessToken getAccessTokenPasswordGrant(String string, String string2) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest oAuthRequest = this.createAccessTokenPasswordGrantRequest(string, string2);
        return this.sendAccessTokenRequestSync(oAuthRequest);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String string, String string2) {
        return this.getAccessTokenPasswordGrantAsync(string, string2, null);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String string, String string2, OAuthAsyncRequestCallback<OAuth2AccessToken> oAuthAsyncRequestCallback) {
        OAuthRequest oAuthRequest = this.createAccessTokenPasswordGrantRequest(string, string2);
        return this.sendAccessTokenRequestAsync(oAuthRequest, oAuthAsyncRequestCallback);
    }

    protected OAuthRequest createAccessTokenPasswordGrantRequest(String string, String string2) {
        OAuthRequest oAuthRequest = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        OAuthConfig oAuthConfig = this.getConfig();
        oAuthRequest.addParameter("username", string);
        oAuthRequest.addParameter("password", string2);
        String string3 = oAuthConfig.getScope();
        if (string3 != null) {
            oAuthRequest.addParameter("scope", string3);
        }
        oAuthRequest.addParameter("grant_type", "password");
        this.api.getClientAuthenticationType().addClientAuthentication(oAuthRequest, oAuthConfig);
        return oAuthRequest;
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrantAsync() {
        return this.getAccessTokenClientCredentialsGrant(null);
    }

    public OAuth2AccessToken getAccessTokenClientCredentialsGrant() throws IOException, InterruptedException, ExecutionException {
        OAuthRequest oAuthRequest = this.createAccessTokenClientCredentialsGrantRequest();
        return this.sendAccessTokenRequestSync(oAuthRequest);
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrant(OAuthAsyncRequestCallback<OAuth2AccessToken> oAuthAsyncRequestCallback) {
        OAuthRequest oAuthRequest = this.createAccessTokenClientCredentialsGrantRequest();
        return this.sendAccessTokenRequestAsync(oAuthRequest, oAuthAsyncRequestCallback);
    }

    protected OAuthRequest createAccessTokenClientCredentialsGrantRequest() {
        OAuthRequest oAuthRequest = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        OAuthConfig oAuthConfig = this.getConfig();
        this.api.getClientAuthenticationType().addClientAuthentication(oAuthRequest, oAuthConfig);
        String string = oAuthConfig.getScope();
        if (string != null) {
            oAuthRequest.addParameter("scope", string);
        }
        oAuthRequest.addParameter("grant_type", "client_credentials");
        return oAuthRequest;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public void signRequest(String string, OAuthRequest oAuthRequest) {
        this.api.getSignatureType().signRequest(string, oAuthRequest);
    }

    public void signRequest(OAuth2AccessToken oAuth2AccessToken, OAuthRequest oAuthRequest) {
        this.signRequest(oAuth2AccessToken == null ? null : oAuth2AccessToken.getAccessToken(), oAuthRequest);
    }

    public AuthorizationUrlWithPKCE getAuthorizationUrlWithPKCE() {
        return this.getAuthorizationUrlWithPKCE(null);
    }

    public AuthorizationUrlWithPKCE getAuthorizationUrlWithPKCE(Map<String, String> map) {
        PKCE pKCE = PKCE_SERVICE.generatePKCE();
        return new AuthorizationUrlWithPKCE(pKCE, this.getAuthorizationUrl(map, pKCE));
    }

    public String getAuthorizationUrl() {
        return this.getAuthorizationUrl(null, null);
    }

    public String getAuthorizationUrl(Map<String, String> map) {
        return this.getAuthorizationUrl(map, null);
    }

    public String getAuthorizationUrl(PKCE pKCE) {
        return this.getAuthorizationUrl(null, pKCE);
    }

    public String getAuthorizationUrl(Map<String, String> map, PKCE pKCE) {
        Map<String, String> map2;
        if (pKCE == null) {
            map2 = map;
        } else {
            map2 = map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
            map2.putAll(pKCE.getAuthorizationUrlParams());
        }
        return this.api.getAuthorizationUrl(this.getConfig(), map2);
    }

    public DefaultApi20 getApi() {
        return this.api;
    }

    protected OAuthRequest createRevokeTokenRequest(String string, TokenTypeHint tokenTypeHint) {
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.POST, this.api.getRevokeTokenEndpoint());
        this.api.getClientAuthenticationType().addClientAuthentication(oAuthRequest, this.getConfig());
        oAuthRequest.addParameter("token", string);
        if (tokenTypeHint != null) {
            oAuthRequest.addParameter("token_type_hint", tokenTypeHint.toString());
        }
        return oAuthRequest;
    }

    public Future<Void> revokeTokenAsync(String string) {
        return this.revokeTokenAsync(string, null);
    }

    public Future<Void> revokeTokenAsync(String string, TokenTypeHint tokenTypeHint) {
        return this.revokeToken(string, null, tokenTypeHint);
    }

    public void revokeToken(String string) throws IOException, InterruptedException, ExecutionException {
        this.revokeToken(string, (TokenTypeHint)null);
    }

    public void revokeToken(String string, TokenTypeHint tokenTypeHint) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest oAuthRequest = this.createRevokeTokenRequest(string, tokenTypeHint);
        this.checkForErrorRevokeToken(this.execute(oAuthRequest));
    }

    public Future<Void> revokeToken(String string, OAuthAsyncRequestCallback<Void> oAuthAsyncRequestCallback) {
        return this.revokeToken(string, oAuthAsyncRequestCallback, null);
    }

    public Future<Void> revokeToken(String string, OAuthAsyncRequestCallback<Void> oAuthAsyncRequestCallback, TokenTypeHint tokenTypeHint) {
        OAuthRequest oAuthRequest = this.createRevokeTokenRequest(string, tokenTypeHint);
        return this.execute(oAuthRequest, oAuthAsyncRequestCallback, new OAuthRequest.ResponseConverter<Void>(){

            @Override
            public Void convert(Response response) throws IOException {
                OAuth20Service.this.checkForErrorRevokeToken(response);
                return null;
            }
        });
    }

    private void checkForErrorRevokeToken(Response response) throws IOException {
        if (response.getCode() != 200) {
            OAuth2AccessTokenJsonExtractor.instance().generateError(response.getBody());
        }
    }

    public OAuth2Authorization extractAuthorization(String string) {
        OAuth2Authorization oAuth2Authorization = new OAuth2Authorization();
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            n2 = string.length();
        }
        block8: for (String string2 : string.substring(string.indexOf(63) + 1, n2).split("&")) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2) continue;
            switch (stringArray[0]) {
                case "code": {
                    oAuth2Authorization.setCode(stringArray[1]);
                    continue block8;
                }
                case "state": {
                    oAuth2Authorization.setState(stringArray[1]);
                    continue block8;
                }
            }
        }
        return oAuth2Authorization;
    }
}

