/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.java8;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class Base64 {
    private Base64() {
    }

    public static Encoder getEncoder() {
        return Encoder.RFC4648;
    }

    public static Encoder getUrlEncoder() {
        return Encoder.RFC4648_URLSAFE;
    }

    public static Encoder getMimeEncoder() {
        return Encoder.RFC2045;
    }

    public static Encoder getMimeEncoder(int n2, byte[] byArray) {
        Objects.requireNonNull(byArray);
        int[] nArray = Decoder.FROM_BASE_64;
        for (byte by2 : byArray) {
            if (nArray[by2 & 0xFF] == -1) continue;
            throw new IllegalArgumentException("Illegal base64 line separator character 0x" + Integer.toString(by2, 16));
        }
        if (n2 <= 0) {
            return Encoder.RFC4648;
        }
        return new Encoder(false, byArray, n2 >> 2 << 2, true);
    }

    public static Decoder getDecoder() {
        return Decoder.RFC4648;
    }

    public static Decoder getUrlDecoder() {
        return Decoder.RFC4648_URLSAFE;
    }

    public static Decoder getMimeDecoder() {
        return Decoder.RFC2045;
    }

    private static class DecInputStream
    extends InputStream {
        private final InputStream is;
        private final boolean isMIME;
        private final int[] base64;
        private int bits;
        private int nextin = 18;
        private int nextout = -8;
        private boolean eof;
        private boolean closed;
        private final byte[] sbBuf = new byte[1];

        DecInputStream(InputStream inputStream, int[] nArray, boolean bl2) {
            this.is = inputStream;
            this.base64 = nArray;
            this.isMIME = bl2;
        }

        @Override
        public int read() throws IOException {
            return this.read(this.sbBuf, 0, 1) == -1 ? -1 : this.sbBuf[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof && this.nextout < 0) {
                return -1;
            }
            if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                throw new IndexOutOfBoundsException();
            }
            int n4 = n2;
            if (this.nextout >= 0) {
                do {
                    if (n3 == 0) {
                        return n2 - n4;
                    }
                    byArray[n2++] = (byte)(this.bits >> this.nextout);
                    --n3;
                    this.nextout -= 8;
                } while (this.nextout >= 0);
                this.bits = 0;
            }
            while (n3 > 0) {
                int n5 = this.is.read();
                if (n5 == -1) {
                    this.eof = true;
                    if (this.nextin != 18) {
                        if (this.nextin == 12) {
                            throw new IOException("Base64 stream has one un-decoded dangling byte.");
                        }
                        byArray[n2++] = (byte)(this.bits >> 16);
                        --n3;
                        if (this.nextin == 0) {
                            if (n3 == 0) {
                                this.bits >>= 8;
                                this.nextout = 0;
                            } else {
                                byArray[n2++] = (byte)(this.bits >> 8);
                            }
                        }
                    }
                    if (n2 == n4) {
                        return -1;
                    }
                    return n2 - n4;
                }
                if (n5 == 61) {
                    if (this.nextin == 18 || this.nextin == 12 || this.nextin == 6 && this.is.read() != 61) {
                        throw new IOException("Illegal base64 ending sequence:" + this.nextin);
                    }
                    byArray[n2++] = (byte)(this.bits >> 16);
                    --n3;
                    if (this.nextin == 0) {
                        if (n3 == 0) {
                            this.bits >>= 8;
                            this.nextout = 0;
                        } else {
                            byArray[n2++] = (byte)(this.bits >> 8);
                        }
                    }
                    this.eof = true;
                    break;
                }
                if ((n5 = this.base64[n5]) == -1) {
                    if (this.isMIME) continue;
                    throw new IOException("Illegal base64 character " + Integer.toString(n5, 16));
                }
                this.bits |= n5 << this.nextin;
                if (this.nextin == 0) {
                    this.nextin = 18;
                    this.nextout = 16;
                    while (this.nextout >= 0) {
                        byArray[n2++] = (byte)(this.bits >> this.nextout);
                        this.nextout -= 8;
                        if (--n3 != 0 || this.nextout < 0) continue;
                        return n2 - n4;
                    }
                    this.bits = 0;
                    continue;
                }
                this.nextin -= 6;
            }
            return n2 - n4;
        }

        @Override
        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.is.close();
            }
        }
    }

    private static class EncOutputStream
    extends FilterOutputStream {
        private int leftover;
        private int b0;
        private int b1;
        private int b2;
        private boolean closed;
        private final char[] base64;
        private final byte[] newline;
        private final int linemax;
        private final boolean doPadding;
        private int linepos;

        EncOutputStream(OutputStream outputStream, char[] cArray, byte[] byArray, int n2, boolean bl2) {
            super(outputStream);
            this.base64 = cArray;
            this.newline = byArray;
            this.linemax = n2;
            this.doPadding = bl2;
        }

        @Override
        public void write(int n2) throws IOException {
            byte[] byArray = new byte[]{(byte)(n2 & 0xFF)};
            this.write(byArray, 0, 1);
        }

        private void checkNewline() throws IOException {
            if (this.linepos == this.linemax) {
                this.out.write(this.newline);
                this.linepos = 0;
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return;
            }
            if (this.leftover != 0) {
                if (this.leftover == 1) {
                    this.b1 = byArray[n2++] & 0xFF;
                    if (--n3 == 0) {
                        ++this.leftover;
                        return;
                    }
                }
                this.b2 = byArray[n2++] & 0xFF;
                --n3;
                this.checkNewline();
                this.out.write(this.base64[this.b0 >> 2]);
                this.out.write(this.base64[this.b0 << 4 & 0x3F | this.b1 >> 4]);
                this.out.write(this.base64[this.b1 << 2 & 0x3F | this.b2 >> 6]);
                this.out.write(this.base64[this.b2 & 0x3F]);
                this.linepos += 4;
            }
            int n4 = n3 / 3;
            this.leftover = n3 - n4 * 3;
            while (n4-- > 0) {
                this.checkNewline();
                int n5 = (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                this.out.write(this.base64[n5 >>> 18 & 0x3F]);
                this.out.write(this.base64[n5 >>> 12 & 0x3F]);
                this.out.write(this.base64[n5 >>> 6 & 0x3F]);
                this.out.write(this.base64[n5 & 0x3F]);
                this.linepos += 4;
            }
            if (this.leftover == 1) {
                this.b0 = byArray[n2++] & 0xFF;
            } else if (this.leftover == 2) {
                this.b0 = byArray[n2++] & 0xFF;
                this.b1 = byArray[n2++] & 0xFF;
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                if (this.leftover == 1) {
                    this.checkNewline();
                    this.out.write(this.base64[this.b0 >> 2]);
                    this.out.write(this.base64[this.b0 << 4 & 0x3F]);
                    if (this.doPadding) {
                        this.out.write(61);
                        this.out.write(61);
                    }
                } else if (this.leftover == 2) {
                    this.checkNewline();
                    this.out.write(this.base64[this.b0 >> 2]);
                    this.out.write(this.base64[this.b0 << 4 & 0x3F | this.b1 >> 4]);
                    this.out.write(this.base64[this.b1 << 2 & 0x3F]);
                    if (this.doPadding) {
                        this.out.write(61);
                    }
                }
                this.leftover = 0;
                this.out.close();
            }
        }
    }

    public static class Decoder {
        private final boolean isURL;
        private final boolean isMIME;
        private static final int[] FROM_BASE_64;
        private static final int[] FROM_BASE_64_URL;
        static final Decoder RFC4648;
        static final Decoder RFC4648_URLSAFE;
        static final Decoder RFC2045;

        private Decoder(boolean bl2, boolean bl3) {
            this.isURL = bl2;
            this.isMIME = bl3;
        }

        public byte[] decode(byte[] byArray) {
            byte[] byArray2 = new byte[this.outLength(byArray, 0, byArray.length)];
            int n2 = this.decode0(byArray, 0, byArray.length, byArray2);
            if (n2 != byArray2.length) {
                byArray2 = Arrays.copyOf(byArray2, n2);
            }
            return byArray2;
        }

        public byte[] decode(String string) {
            return this.decode(string.getBytes(StandardCharsets.ISO_8859_1));
        }

        public int decode(byte[] byArray, byte[] byArray2) {
            int n2 = this.outLength(byArray, 0, byArray.length);
            if (byArray2.length < n2) {
                throw new IllegalArgumentException("Output byte array is too small for decoding all input bytes");
            }
            return this.decode0(byArray, 0, byArray.length, byArray2);
        }

        public ByteBuffer decode(ByteBuffer byteBuffer) {
            int n2 = byteBuffer.position();
            try {
                int n3;
                int n4;
                byte[] byArray;
                if (byteBuffer.hasArray()) {
                    byArray = byteBuffer.array();
                    n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                    n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
                    byteBuffer.position(byteBuffer.limit());
                } else {
                    byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    n4 = 0;
                    n3 = byArray.length;
                }
                byte[] byArray2 = new byte[this.outLength(byArray, n4, n3)];
                return ByteBuffer.wrap(byArray2, 0, this.decode0(byArray, n4, n3, byArray2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                byteBuffer.position(n2);
                throw illegalArgumentException;
            }
        }

        public InputStream wrap(InputStream inputStream) {
            Objects.requireNonNull(inputStream);
            return new DecInputStream(inputStream, this.isURL ? FROM_BASE_64_URL : FROM_BASE_64, this.isMIME);
        }

        private int outLength(byte[] byArray, int n2, int n3) {
            int[] nArray = this.isURL ? FROM_BASE_64_URL : FROM_BASE_64;
            int n4 = 0;
            int n5 = n3 - n2;
            if (n5 == 0) {
                return 0;
            }
            if (n5 < 2) {
                if (this.isMIME && nArray[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            if (this.isMIME) {
                int n6 = 0;
                while (n2 < n3) {
                    int n7;
                    if ((n7 = byArray[n2++] & 0xFF) == 61) {
                        n5 -= n3 - n2 + 1;
                        break;
                    }
                    if ((n7 = nArray[n7]) != -1) continue;
                    ++n6;
                }
                n5 -= n6;
            } else if (byArray[n3 - 1] == 61) {
                ++n4;
                if (byArray[n3 - 2] == 61) {
                    ++n4;
                }
            }
            if (n4 == 0 && (n5 & 3) != 0) {
                n4 = 4 - (n5 & 3);
            }
            return 3 * ((n5 + 3) / 4) - n4;
        }

        private int decode0(byte[] byArray, int n2, int n3, byte[] byArray2) {
            int[] nArray = this.isURL ? FROM_BASE_64_URL : FROM_BASE_64;
            int n4 = 0;
            int n5 = 0;
            int n6 = 18;
            while (n2 < n3) {
                int n7 = byArray[n2++] & 0xFF;
                if ((n7 = nArray[n7]) < 0) {
                    if (n7 == -2) {
                        if ((n6 != 6 || n2 != n3 && byArray[n2++] == 61) && n6 != 18) break;
                        throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                    }
                    if (this.isMIME) continue;
                    throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(byArray[n2 - 1], 16));
                }
                n5 |= n7 << n6;
                if ((n6 -= 6) >= 0) continue;
                byArray2[n4++] = (byte)(n5 >> 16);
                byArray2[n4++] = (byte)(n5 >> 8);
                byArray2[n4++] = (byte)n5;
                n6 = 18;
                n5 = 0;
            }
            if (n6 == 6) {
                byArray2[n4++] = (byte)(n5 >> 16);
            } else if (n6 == 0) {
                byArray2[n4++] = (byte)(n5 >> 16);
                byArray2[n4++] = (byte)(n5 >> 8);
            } else if (n6 == 12) {
                throw new IllegalArgumentException("Last unit does not have enough valid bits");
            }
            while (n2 < n3) {
                if (this.isMIME && nArray[byArray[n2++]] < 0) continue;
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + n2);
            }
            return n4;
        }

        static {
            int n2;
            FROM_BASE_64 = new int[256];
            Arrays.fill(FROM_BASE_64, -1);
            for (n2 = 0; n2 < Encoder.TO_BASE_64.length; ++n2) {
                Decoder.FROM_BASE_64[Encoder.TO_BASE_64[n2]] = n2;
            }
            Decoder.FROM_BASE_64[61] = -2;
            FROM_BASE_64_URL = new int[256];
            Arrays.fill(FROM_BASE_64_URL, -1);
            for (n2 = 0; n2 < Encoder.TO_BASE_64_URL.length; ++n2) {
                Decoder.FROM_BASE_64_URL[Encoder.TO_BASE_64_URL[n2]] = n2;
            }
            Decoder.FROM_BASE_64_URL[61] = -2;
            RFC4648 = new Decoder(false, false);
            RFC4648_URLSAFE = new Decoder(true, false);
            RFC2045 = new Decoder(false, true);
        }
    }

    public static class Encoder {
        private final byte[] newline;
        private final int linemax;
        private final boolean isURL;
        private final boolean doPadding;
        private static final char[] TO_BASE_64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private static final char[] TO_BASE_64_URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        private static final int MIMELINEMAX = 76;
        private static final byte[] CRLF = new byte[]{13, 10};
        static final Encoder RFC4648 = new Encoder(false, null, -1, true);
        static final Encoder RFC4648_URLSAFE = new Encoder(true, null, -1, true);
        static final Encoder RFC2045 = new Encoder(false, CRLF, 76, true);

        private Encoder(boolean bl2, byte[] byArray, int n2, boolean bl3) {
            this.isURL = bl2;
            this.newline = byArray;
            this.linemax = n2;
            this.doPadding = bl3;
        }

        private int outLength(int n2) {
            int n3;
            if (this.doPadding) {
                n3 = 4 * ((n2 + 2) / 3);
            } else {
                int n4 = n2 % 3;
                n3 = 4 * (n2 / 3) + (n4 == 0 ? 0 : n4 + 1);
            }
            if (this.linemax > 0) {
                n3 += (n3 - 1) / this.linemax * this.newline.length;
            }
            return n3;
        }

        public byte[] encode(byte[] byArray) {
            int n2 = this.outLength(byArray.length);
            byte[] byArray2 = new byte[n2];
            int n3 = this.encode0(byArray, 0, byArray.length, byArray2);
            if (n3 != byArray2.length) {
                return Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }

        public int encode(byte[] byArray, byte[] byArray2) {
            int n2 = this.outLength(byArray.length);
            if (byArray2.length < n2) {
                throw new IllegalArgumentException("Output byte array is too small for encoding all input bytes");
            }
            return this.encode0(byArray, 0, byArray.length, byArray2);
        }

        public String encodeToString(byte[] byArray) {
            byte[] byArray2 = this.encode(byArray);
            return new String(byArray2, 0, 0, byArray2.length);
        }

        public ByteBuffer encode(ByteBuffer byteBuffer) {
            int n2;
            int n3 = this.outLength(byteBuffer.remaining());
            byte[] byArray = new byte[n3];
            if (byteBuffer.hasArray()) {
                n2 = this.encode0(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit(), byArray);
                byteBuffer.position(byteBuffer.limit());
            } else {
                byte[] byArray2 = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray2);
                n2 = this.encode0(byArray2, 0, byArray2.length, byArray);
            }
            if (n2 != byArray.length) {
                byArray = Arrays.copyOf(byArray, n2);
            }
            return ByteBuffer.wrap(byArray);
        }

        public OutputStream wrap(OutputStream outputStream) {
            Objects.requireNonNull(outputStream);
            return new EncOutputStream(outputStream, this.isURL ? TO_BASE_64_URL : TO_BASE_64, this.newline, this.linemax, this.doPadding);
        }

        public Encoder withoutPadding() {
            if (!this.doPadding) {
                return this;
            }
            return new Encoder(this.isURL, this.newline, this.linemax, false);
        }

        private int encode0(byte[] byArray, int n2, int n3, byte[] byArray2) {
            int n4;
            int n5;
            char[] cArray = this.isURL ? TO_BASE_64_URL : TO_BASE_64;
            int n6 = n2;
            int n7 = (n3 - n2) / 3 * 3;
            int n8 = n2 + n7;
            if (this.linemax > 0 && n7 > this.linemax / 4 * 3) {
                n7 = this.linemax / 4 * 3;
            }
            int n9 = 0;
            while (n6 < n8) {
                n5 = Math.min(n6 + n7, n8);
                n4 = n6;
                int n10 = n9;
                while (n4 < n5) {
                    int n11 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                    byArray2[n10++] = (byte)cArray[n11 >>> 18 & 0x3F];
                    byArray2[n10++] = (byte)cArray[n11 >>> 12 & 0x3F];
                    byArray2[n10++] = (byte)cArray[n11 >>> 6 & 0x3F];
                    byArray2[n10++] = (byte)cArray[n11 & 0x3F];
                }
                n4 = (n5 - n6) / 3 * 4;
                n9 += n4;
                n6 = n5;
                if (n4 != this.linemax || n6 >= n3) continue;
                for (byte by2 : this.newline) {
                    byArray2[n9++] = by2;
                }
            }
            if (n6 < n3) {
                n5 = byArray[n6++] & 0xFF;
                byArray2[n9++] = (byte)cArray[n5 >> 2];
                if (n6 == n3) {
                    byArray2[n9++] = (byte)cArray[n5 << 4 & 0x3F];
                    if (this.doPadding) {
                        byArray2[n9++] = 61;
                        byArray2[n9++] = 61;
                    }
                } else {
                    n4 = byArray[n6++] & 0xFF;
                    byArray2[n9++] = (byte)cArray[n5 << 4 & 0x3F | n4 >> 4];
                    byArray2[n9++] = (byte)cArray[n4 << 2 & 0x3F];
                    if (this.doPadding) {
                        byArray2[n9++] = 61;
                    }
                }
            }
            return n9;
        }
    }
}

