/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import java.io.Serializable;

public class StreamWriteConstraints
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_DEPTH = 1000;
    protected final int _maxNestingDepth;
    private static StreamWriteConstraints DEFAULT = new StreamWriteConstraints(1000);

    public static void overrideDefaultStreamWriteConstraints(StreamWriteConstraints streamWriteConstraints) {
        DEFAULT = streamWriteConstraints == null ? new StreamWriteConstraints(1000) : streamWriteConstraints;
    }

    protected StreamWriteConstraints(int n2) {
        this._maxNestingDepth = n2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StreamWriteConstraints defaults() {
        return DEFAULT;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public int getMaxNestingDepth() {
        return this._maxNestingDepth;
    }

    public void validateNestingDepth(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNestingDepth) {
            throw this._constructException("Document nesting depth (%d) exceeds the maximum allowed (%d, from %s)", n2, this._maxNestingDepth, this._constrainRef("getMaxNestingDepth"));
        }
    }

    protected StreamConstraintsException _constructException(String string, Object ... objectArray) throws StreamConstraintsException {
        throw new StreamConstraintsException(String.format(string, objectArray));
    }

    protected String _constrainRef(String string) {
        return "`StreamWriteConstraints." + string + "()`";
    }

    public static final class Builder {
        private int maxNestingDepth;

        public Builder maxNestingDepth(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot set maxNestingDepth to a negative value");
            }
            this.maxNestingDepth = n2;
            return this;
        }

        Builder() {
            this(1000);
        }

        Builder(int n2) {
            this.maxNestingDepth = n2;
        }

        Builder(StreamWriteConstraints streamWriteConstraints) {
            this.maxNestingDepth = streamWriteConstraints._maxNestingDepth;
        }

        public StreamWriteConstraints build() {
            return new StreamWriteConstraints(this.maxNestingDepth);
        }
    }
}

