/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import atlantafx.base.util.BBCodeHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.geometry.Pos;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import org.jetbrains.annotations.Nullable;

public class BBCodeParser {
    public static final Set<String> RESERVED_TAGS = Set.of("abbr", "align", "b", "caption", "center", "code", "color", "email", "heading", "font", "hr", "i", "indent", "label", "left", "li", "ol", "right", "s", "size", "small", "span", "style", "sub", "sup", "u", "ul", "url", "alert", "em", "fieldset", "h1", "h2", "h3", "h4", "icon", "img", "info", "kbd", "list", "media", "plain", "pre", "quote", "spoiler", "stop", "table", "tooltip", "td", "th", "tr", "warning");
    private final String input;
    private final BBCodeHandler handler;
    private final Set<String> processedTags;
    private final Deque<String> openTags = new ArrayDeque<String>();
    private int offset = 0;
    private int lastClosingPos = 0;

    public BBCodeParser(String string, BBCodeHandler bBCodeHandler) {
        this(string, bBCodeHandler, RESERVED_TAGS);
    }

    public BBCodeParser(String string, BBCodeHandler bBCodeHandler, @Nullable Set<String> set) {
        this.input = Objects.requireNonNull(string, "Input can't be null.");
        this.handler = Objects.requireNonNull(bBCodeHandler, "Handler can't be null.");
        this.processedTags = Objects.requireNonNullElse(set, RESERVED_TAGS);
    }

    public void parse() {
        this.handler.startDocument(this.input.toCharArray());
        while (this.offset < this.input.length()) {
            if (this.input.charAt(this.offset) == '[') {
                int n2 = this.offset;
                int n3 = this.input.indexOf(93, this.offset);
                if (n3 == -1) {
                    ++this.offset;
                    continue;
                }
                int n4 = n3 - n2 + 1;
                if (n4 == 2) {
                    ++this.offset;
                    continue;
                }
                if (this.input.charAt(n2 + 1) != '/') {
                    boolean bl2;
                    if (this.openTags.isEmpty()) {
                        this.handleCharacters(this.lastClosingPos > 0 ? this.lastClosingPos + 1 : 0, this.lastClosingPos > 0 ? this.offset - this.lastClosingPos - 1 : this.offset);
                    }
                    if (!(bl2 = this.handleStartTag(n2, n4, var4_4 = this.input.charAt(n3 - 1) == '/')) && this.openTags.isEmpty()) {
                        this.handleCharacters(n2, n4);
                        this.offset += n4;
                        this.lastClosingPos = n3 + 1;
                        continue;
                    }
                    if (var4_4) {
                        this.lastClosingPos = n3;
                    }
                } else {
                    var4_4 = this.handleEndTag(n2, n4);
                    if (!var4_4 && this.openTags.isEmpty()) {
                        this.handleCharacters(this.lastClosingPos, n3 - this.lastClosingPos + 1);
                    }
                    this.lastClosingPos = n3;
                }
                this.offset = n3 + 1;
                continue;
            }
            ++this.offset;
        }
        if (!this.openTags.isEmpty()) {
            throw new IllegalStateException("Invalid BBCode: Opening tags without closing tags: " + this.openTags);
        }
        if (this.lastClosingPos < this.input.length()) {
            this.handleCharacters(this.lastClosingPos > 0 ? this.lastClosingPos + 1 : this.lastClosingPos, this.lastClosingPos > 0 ? this.input.length() - this.lastClosingPos - 1 : this.input.length());
        }
        this.handler.endDocument();
    }

    public static TextFlow createFormattedText(String string) {
        return BBCodeParser.createLayout(string, new TextFlow());
    }

    public static VBox createLayout(String string) {
        VBox vBox = new VBox(10.0);
        vBox.setAlignment(Pos.TOP_LEFT);
        return BBCodeParser.createLayout(string, vBox);
    }

    public static <T extends Pane> T createLayout(String string, T t2) {
        BBCodeHandler.Default<T> default_ = new BBCodeHandler.Default<T>(t2);
        BBCodeParser bBCodeParser = new BBCodeParser(string, default_);
        bBCodeParser.parse();
        return t2;
    }

    protected boolean handleStartTag(int n2, int n3, boolean bl2) {
        List<String> list = this.splitBySpace(this.input, n2 + 1, !bl2 ? n3 - 1 : n3 - 2);
        String string = list.get(0).toLowerCase();
        HashMap<String, String> hashMap = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2 = list.get(i2);
            int n4 = string2.indexOf("=");
            if (n4 < 0) continue;
            String string3 = string2.substring(0, n4).toLowerCase();
            String string4 = string2.substring(n4 + 1);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            if (i2 == 0) {
                string = string3;
            }
            hashMap.put(string3, string4);
        }
        if (!this.processedTags.contains(string)) {
            return false;
        }
        this.handler.startTag(string, hashMap, n2, n3);
        if (!bl2) {
            this.openTags.push(string);
        }
        return true;
    }

    protected boolean handleEndTag(int n2, int n3) {
        String string = this.input.substring(n2 + 2, n2 + n3 - 1).toLowerCase();
        if (!this.processedTags.contains(string)) {
            return false;
        }
        if (this.openTags.isEmpty()) {
            throw new IllegalStateException("Invalid BBCode: Closing tag without corresponding opening tag: '" + string + "'");
        }
        String string2 = this.openTags.pop();
        if (!string2.equals(string)) {
            throw new IllegalStateException("Invalid BBCode: Closing tag '" + string + "' does not match opening tag '" + string2 + "'");
        }
        this.handler.endTag(string, n2, n3);
        return true;
    }

    protected void handleCharacters(int n2, int n3) {
        this.handler.characters(n2, n3);
    }

    protected List<String> splitBySpace(String string, int n2, int n3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i2 = n2; i2 < n2 + n3 - 1; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ' && !bl2) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                continue;
            }
            if (c2 == '\"' || c2 == '\'') {
                bl2 = !bl2;
                continue;
            }
            stringBuilder.append(c2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }
}

