/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.calibrate;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.dataset.DataSet;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javafx.scene.Parent;
import lombok.Generated;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.ano;
import us.hebi.gui.lib.bbq;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.beb;
import us.hebi.gui.lib.bmx;
import us.hebi.gui.lib.bnm;
import us.hebi.gui.lib.boi;
import us.hebi.gui.lib.boj;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.CalibrationResultDialog;

public class ViewCalibrationTableDialog
extends CalibrationDialog<bbq> {
    final ano targetEncoder;

    @Override
    protected void fillResultGrid(bbq bbq2) {
        this.addResult("Type", (Object)bbq2.f, "");
        this.addResult("Size", bbq2.M(), "");
        this.addResult("Mean", bbq2.dn(), "");
        ViewCalibrationTableDialog viewCalibrationTableDialog = this;
        viewCalibrationTableDialog.addChart(viewCalibrationTableDialog.createChart(bbq2));
    }

    private Chart createChart(bbq bbq2) {
        XYChart xYChart = bdc.c();
        xYChart.setTitle("Calibration Table");
        xYChart.getXAxis().setName("Position");
        xYChart.getYAxis().setUnit("rad");
        xYChart.getYAxis().setName("Offset");
        xYChart.getYAxis().setUnit("rad");
        xYChart.getYAxis().setAutoUnitScaling(true);
        double[] dArray = bbq2.i();
        float[] fArray = (float[])bbq2.z.clone();
        Object[] objectArray = new DataSet[1];
        objectArray[0] = new beb("Offsets", bbq2::M, n2 -> dArray[n2], n2 -> fArray[n2]);
        xYChart.getDatasets().addAll(objectArray);
        return xYChart;
    }

    @Override
    protected Parent renderResult(bbq bbq2) {
        CalibrationResultDialog calibrationResultDialog = new CalibrationResultDialog();
        calibrationResultDialog.addResult("Type", (Object)bbq2.f, "");
        calibrationResultDialog.addResult("Size", bbq2.M(), "");
        calibrationResultDialog.addResult("Mean", bbq2.dn(), "");
        calibrationResultDialog.setPrimaryChart(this.createChart(bbq2));
        double[] dArray = bbq2.i();
        float[] fArray = bbq2.z;
        boj boj2 = bmx.a(bbq2.M(), 1, boi.g);
        boj boj3 = bmx.a(bbq2.M(), 1, boi.g);
        for (int i2 = 0; i2 < bbq2.M(); ++i2) {
            boj2.e(i2, dArray[i2]);
            boj3.e(i2, fArray[i2]);
        }
        calibrationResultDialog.setMatFileSupplier(() -> {
            bnm bnm2 = bmx.a(String.valueOf((Object)bbq2.l));
            String string = "target";
            return bmx.a().a("target", bnm2).a("type", bmx.a(String.valueOf((Object)bbq2.f))).a("tableSize", bmx.a(bbq2.M())).a("mean", bmx.a(bbq2.dn())).a("xBuckets", boj3).a("yOffsets", boj3);
        });
        return calibrationResultDialog;
    }

    @Override
    protected Callable<bbq> createTask(ald ald2) {
        ViewCalibrationTableDialog viewCalibrationTableDialog = this;
        return () -> {
            viewCalibrationTableDialog.updateProgress("Requesting calibration type...");
            bbq bbq2 = bbq.a(ald2, this.targetEncoder);
            bbq2.a(ald2, bzp2 -> viewCalibrationTableDialog.updateProgress("Requesting sector: " + bzp2.a.b.gy), bzp2 -> viewCalibrationTableDialog.updateProgress("Receiving sector: " + bzp2.a.b.gy));
            return bbq2;
        };
    }

    @Override
    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        super.initialize(uRL, resourceBundle);
        this.setTitle("View Calibration Table");
    }

    @Generated
    public ViewCalibrationTableDialog(ano ano2) {
        this.targetEncoder = ano2;
    }
}

