/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.transform.TransformerException;
import okhttp3.Headers;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.lib.afq;
import us.hebi.gui.lib.afs;
import us.hebi.gui.lib.aft;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.ama;
import us.hebi.gui.lib.amc;
import us.hebi.gui.lib.amk;
import us.hebi.gui.lib.aml;
import us.hebi.gui.lib.amo;
import us.hebi.gui.lib.ani;
import us.hebi.gui.lib.aog;
import us.hebi.gui.lib.aoq;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.avv;
import us.hebi.gui.lib.axd;
import us.hebi.gui.lib.axn;
import us.hebi.gui.lib.ayc;
import us.hebi.gui.lib.aye;
import us.hebi.gui.lib.ayh;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bbc;
import us.hebi.gui.lib.bbh;
import us.hebi.gui.lib.bcf;
import us.hebi.gui.lib.bgh;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bhb;
import us.hebi.gui.lib.bhl;
import us.hebi.gui.lib.bji;
import us.hebi.gui.lib.bjk;
import us.hebi.gui.lib.u;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.components.PidController;

public class GainsController {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button loadFileBtn;
    @FXML
    private Button loadDefaultsBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private Button sendDirectBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private HEnumInputField<amc> controlStrategy;
    @FXML
    private HEnumInputField<ani> mStopStrategy;
    @FXML
    private HEnumInputField<aog> posLimitStrategy;
    @FXML
    private Hyperlink docsLink;
    @FXML
    private Text docsText;
    @FXML
    private ToggleButton advancedToggle;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private HDoubleInputField minPosLimit;
    @FXML
    private HDoubleInputField maxPosLimit;
    @FXML
    private HDoubleInputField minVelLimit;
    @FXML
    private HDoubleInputField maxVelLimit;
    @FXML
    private HDoubleInputField minEffortLimit;
    @FXML
    private HDoubleInputField maxEffortLimit;
    @FXML
    private Parent positionPid;
    @FXML
    private PidController positionPidController;
    @FXML
    private Parent velocityPid;
    @FXML
    private PidController velocityPidController;
    @FXML
    private Parent effortPid;
    @FXML
    private PidController effortPidController;
    final ValidationSupport basicValidation = bgh.a();
    final ValidationSupport advancedValidation = bgh.a();
    @Inject
    ayh properties;
    @Inject
    bbh module;
    @Inject
    bcf fileChooser;
    @Inject
    bbc moduleSelector;
    @Inject
    bat commandService;
    aoq reusableCommand;
    @Inject
    bhl webViewer;
    private BooleanProperty advancedView;
    private final List<Runnable> clearers = new ArrayList<Runnable>();

    @FXML
    public void openGainsDocumentationInBrowser(ActionEvent actionEvent) {
        this.webViewer.showDocument("https://docs.hebi.us/core_concepts.html#motor_control");
    }

    @FXML
    private void sendGains(ActionEvent actionEvent) {
        aog aog2;
        ani ani2;
        aoq aoq2 = this.reusableCommand;
        ((aqt)aoq2).clear();
        amk amk2 = aoq2.getGains();
        if (this.persistToggle.isSelected()) {
            aoq2.setPersistAllFlag();
        }
        ama ama2 = aoq2.getSafetyLimits();
        GainsController.addSafetyLimit(this.minPosLimit, ama2::a);
        GainsController.addSafetyLimit(this.maxPosLimit, ama2::b);
        GainsController.addSafetyLimit(this.minVelLimit, ama2::c);
        GainsController.addSafetyLimit(this.maxVelLimit, ama2::d);
        GainsController.addSafetyLimit(this.minEffortLimit, ama2::e);
        GainsController.addSafetyLimit(this.maxEffortLimit, ama2::f);
        amc amc2 = this.controlStrategy.getValue();
        if (amc2 != null) {
            amk2.a(amc2);
        }
        if ((ani2 = this.mStopStrategy.getValue()) != null) {
            amk2.a(ani2);
        }
        if ((aog2 = this.posLimitStrategy.getValue()) != null) {
            ama2.a(aog2);
            ama2.b(aog2);
        }
        this.positionPidController.addGainsToMessage(amk2);
        this.velocityPidController.addGainsToMessage(amk2);
        this.effortPidController.addGainsToMessage(amk2);
        this.moduleSelector.getSelectedAddresses().forEach(ald2 -> this.commandService.a((ald)ald2, aoq2));
    }

    private static void addSafetyLimit(HDoubleInputField hDoubleInputField, DoubleConsumer doubleConsumer) {
        if (!hDoubleInputField.getTextInput().isDisable() && hDoubleInputField.isInputValid()) {
            doubleConsumer.accept(hDoubleInputField.getInputValue());
        }
    }

    @FXML
    void clearAllFields(ActionEvent actionEvent) {
        this.positionPidController.clearAllTextFields();
        this.velocityPidController.clearAllTextFields();
        this.effortPidController.clearAllTextFields();
        this.controlStrategy.clear();
        this.mStopStrategy.clear();
        this.posLimitStrategy.clear();
        Iterator<Runnable> iterator = this.clearers.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> Optional<T[]> readGainsFile(Function<afs, T[]> function) {
        Window window = this.getActiveWindow();
        bcf bcf2 = this.fileChooser;
        bcf2.a(bcf2.c, "lastGainsChoiceDirectory");
        bcf bcf3 = bcf2;
        File file = bcf3.b(bcf3.c.showOpenDialog(window), "lastGainsChoiceDirectory");
        if (file == null) {
            return Optional.empty();
        }
        T[] TArray = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            afs afs2 = afs.a(fileInputStream);
            TArray = function.apply(afs2);
            if (TArray.length != 0) return Optional.ofNullable(TArray);
            azy.a("Selected file did not contain gains", this.getActiveWindow());
            Optional<T[]> optional = Optional.empty();
            return optional;
        }
        catch (Exception exception) {
            azy.a(exception, this.getActiveWindow());
        }
        return Optional.ofNullable(TArray);
    }

    @FXML
    void loadDefaultGains(ActionEvent actionEvent) {
        if (this.module.isEmpty()) {
            return;
        }
        bji bji2 = bji.a();
        amc amc2 = Optional.ofNullable(this.controlStrategy.getValue()).orElse(this.module.getGains().a());
        Headers headers = bhb.a(this.module.getInfo());
        CompletableFuture.supplyAsync(() -> {
            try {
                Headers headers2 = headers;
                String string = this.toStrategyUrlName(amc2);
                String string2 = this.module.getModule().c().toString();
                String string3 = bjk.a(bji.b("gains", string, string2), headers2);
                return afs.a(new ByteArrayInputStream(string3.getBytes(u.a))).a();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).whenCompleteAsync((amlArray, throwable) -> {
            if (throwable != null) {
                azy.a("Could not load default gains because the \nserver could not be reached, or because there are \nno default gains for the selected module and \nstrategy '" + String.valueOf((Object)amc2) + "'.", this.getActiveWindow());
                return;
            }
            if (((aml[])amlArray).length != 1) {
                azy.a("Could not load gains due to invalid source format.", this.getActiveWindow());
                return;
            }
            this.setGainFields(amlArray[0]);
        }, bgt.c);
    }

    private String toStrategyUrlName(amc amc2) {
        switch (amc2) {
            case d: {
                return "strategy2";
            }
            case e: {
                return "strategy3";
            }
            case f: {
                return "strategy4";
            }
            case g: {
                return "strategy5";
            }
        }
        return amc2.toString();
    }

    @FXML
    void loadFromFileAndSend(ActionEvent actionEvent) {
        ObservableList<aye> observableList;
        int n2;
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        Optional<T[]> optional = this.readGainsFile(afs::a);
        if (!optional.isPresent()) {
            return;
        }
        aoq[] aoqArray = (aoq[])optional.get();
        if (aoqArray.length != (n2 = (observableList = this.moduleSelector.getSelectedModules()).size())) {
            azy.a(String.format("Selected file contains %d modules, but %d modules are selected", aoqArray.length, n2), this.getActiveWindow());
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            aye aye2 = (aye)observableList.get(i2);
            this.commandService.a(aye2.a(), aoqArray[i2]);
        }
    }

    @FXML
    void loadFromFile(ActionEvent actionEvent) {
        aml aml2;
        Optional<T[]> optional = this.readGainsFile(afs::a);
        if (!optional.isPresent()) {
            return;
        }
        aml[] amlArray = (aml[])optional.get();
        if (amlArray.length > 1) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < amlArray.length; ++i2) {
                arrayList.add(i2 + 1);
            }
            ChoiceDialog choiceDialog = new ChoiceDialog((Object)1, arrayList);
            choiceDialog.setTitle("Group Gain Selector");
            choiceDialog.setHeaderText("File contains gains for more than one device");
            choiceDialog.setContentText("Choose device index:");
            choiceDialog.initOwner(this.getActiveWindow());
            Optional optional2 = choiceDialog.showAndWait();
            if (!optional2.isPresent()) {
                return;
            }
            aml2 = amlArray[(Integer)optional2.get() - 1];
        } else {
            aml2 = amlArray[0];
        }
        this.setGainFields(aml2);
    }

    private void setGainFields(aml aml2) {
        amc amc2 = aml2.a();
        if (amc2 == amc.a) {
            amc2 = null;
        }
        this.controlStrategy.setValue(amc2);
        this.positionPidController.setTextFields(aml2);
        this.velocityPidController.setTextFields(aml2);
        this.effortPidController.setTextFields(aml2);
    }

    @FXML
    void saveGainsToFile(ActionEvent actionEvent) {
        if (this.moduleSelector.getSelectedModules().size() == 0) {
            return;
        }
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        File file = this.fileChooser.f(this.getActiveWindow());
        if (file == null) {
            return;
        }
        aft aft2 = aft.a((amo[])this.moduleSelector.getSelectedModules().stream().map(aye::getInfo).toArray(amo[]::new));
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            aft2.a(fileOutputStream);
            return;
        }
        catch (IOException | TransformerException exception) {
            azy.a(exception, this.getActiveWindow());
            return;
        }
    }

    private boolean tryShowGroupGainsNotice() {
        if (!this.moduleSelector.selectionMultiple().get()) {
            return true;
        }
        return azy.a("Gains from multiple devices are stored in a single file.\nWhen loading or saving gains from multiple devices,\nthe order within the file will match the order of selected\ndevices as shown on the left. The device order can be\nchanged using the ALT + UpDown shortcuts.", this.getActiveWindow());
    }

    private Window getActiveWindow() {
        return this.controlStrategy.getScene().getWindow();
    }

    @FXML
    void initialize() {
        this.advancedToggle.setSelected(this.properties.c.get());
        this.properties.c.bind((ObservableValue)this.advancedToggle.selectedProperty());
        this.persistToggle.setSelected(this.properties.m.get());
        this.properties.m.bind((ObservableValue)this.persistToggle.selectedProperty());
        this.positionPidController.initialize(afq.a, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.velocityPidController.initialize(afq.b, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.effortPidController.initialize(afq.c, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        avv.b((Node)this.advancedToggle, bgh.a(this.advancedValidation));
        avv.a((Node)this.advancedToggle, bgh.b(this.advancedValidation));
        avv.a((Node)this.sendBtn, bgh.b(this.basicValidation), bgh.b(this.advancedValidation));
        Object object = this.module.getGains();
        this.controlStrategy.initValues((ReadOnlyObjectProperty<amc>)((axn)object).v, amc.a);
        this.basicValidation.registerValidator((Control)this.controlStrategy.getChoiceBox(), false, bgh.a(this.controlStrategy));
        Object object2 = this.module.getGains();
        this.mStopStrategy.initValues((ReadOnlyObjectProperty<ani>)((axn)object2).w, ani.a);
        this.basicValidation.registerValidator((Control)this.mStopStrategy.getChoiceBox(), false, bgh.a(this.mStopStrategy));
        object2 = this.module.getSafetyLimits();
        this.posLimitStrategy.initValues((ReadOnlyObjectProperty<aog>)((ayc)object2).G, aog.a);
        this.basicValidation.registerValidator((Control)this.posLimitStrategy.getChoiceBox(), false, bgh.a(this.posLimitStrategy));
        GainsController gainsController = this;
        ayc ayc2 = this.module.getSafetyLimits();
        object = ayc2;
        object = this.module.getFeedback();
        gainsController.initializeSafetyLimit(gainsController.minPosLimit, (ReadOnlyDoubleProperty)ayc2.cH, (ReadOnlyDoubleProperty)((axd)object).E);
        GainsController gainsController2 = this;
        ayc ayc3 = this.module.getSafetyLimits();
        object = ayc3;
        object = this.module.getFeedback();
        gainsController2.initializeSafetyLimit(gainsController2.maxPosLimit, (ReadOnlyDoubleProperty)ayc3.cE, (ReadOnlyDoubleProperty)((axd)object).E);
        GainsController gainsController3 = this;
        ayc ayc4 = this.module.getSafetyLimits();
        object = ayc4;
        object = this.module.getFeedback();
        gainsController3.initializeSafetyLimit(gainsController3.minVelLimit, (ReadOnlyDoubleProperty)ayc4.cI, (ReadOnlyDoubleProperty)((axd)object).P);
        GainsController gainsController4 = this;
        ayc ayc5 = this.module.getSafetyLimits();
        object = ayc5;
        object = this.module.getFeedback();
        gainsController4.initializeSafetyLimit(gainsController4.maxVelLimit, (ReadOnlyDoubleProperty)ayc5.cF, (ReadOnlyDoubleProperty)((axd)object).P);
        GainsController gainsController5 = this;
        ayc ayc6 = this.module.getSafetyLimits();
        object = ayc6;
        object = this.module.getFeedback();
        gainsController5.initializeSafetyLimit(gainsController5.minEffortLimit, (ReadOnlyDoubleProperty)ayc6.cG, (ReadOnlyDoubleProperty)((axd)object).h);
        GainsController gainsController6 = this;
        ayc ayc7 = this.module.getSafetyLimits();
        object = ayc7;
        object = this.module.getFeedback();
        gainsController6.initializeSafetyLimit(gainsController6.maxEffortLimit, (ReadOnlyDoubleProperty)ayc7.cD, (ReadOnlyDoubleProperty)((axd)object).h);
        this.sendBtn.setOnAction(this::sendGains);
        this.sendBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty().or((ObservableBooleanValue)this.basicValidation.invalidProperty()).or((ObservableBooleanValue)this.advancedValidation.invalidProperty()));
        this.saveFileBtn.setOnAction(this::saveGainsToFile);
        this.saveFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadDefaultsBtn.setOnAction(this::loadDefaultGains);
        this.loadDefaultsBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadFileBtn.setOnAction(this::loadFromFile);
        this.loadFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.sendDirectBtn.setOnAction(this::loadFromFileAndSend);
        this.sendDirectBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.clearBtn.setOnAction(this::clearAllFields);
    }

    private void initializeSafetyLimit(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        hDoubleInputField.setShowTarget(true);
        hDoubleInputField.setTargetSupplier(() -> ((ReadOnlyDoubleProperty)readOnlyDoubleProperty2).get());
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = bgh.a(customTextField, ParseUtils.NON_NAN_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.basicValidation.registerValidator((Control)customTextField, false, validator);
        this.clearers.add(() -> ((CustomTextField)customTextField).clear());
    }

    @PostConstruct
    public void postConstruct() {
        GainsController gainsController = this;
        this.reusableCommand = gainsController.commandService.b();
        this.advancedView = this.properties.c;
    }
}

