/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.rima;

import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.dataset.DataSet;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Box;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;
import javax.inject.Inject;
import us.hebi.gui.lib.atp;
import us.hebi.gui.lib.auu;
import us.hebi.gui.lib.avx;
import us.hebi.gui.lib.avy;
import us.hebi.gui.lib.awq;
import us.hebi.gui.lib.awr;
import us.hebi.gui.lib.awu;
import us.hebi.gui.lib.axb;
import us.hebi.gui.lib.axc;
import us.hebi.gui.lib.ayh;
import us.hebi.gui.lib.azc;
import us.hebi.gui.lib.azg;
import us.hebi.gui.lib.azk;
import us.hebi.gui.lib.azo;
import us.hebi.gui.lib.azq;
import us.hebi.gui.lib.bcf;
import us.hebi.gui.lib.bdc;
import us.hebi.gui.lib.bdf;
import us.hebi.gui.lib.bek;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bik;

public class RimaPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Pane root;
    @FXML
    private Pane pane3d;
    @FXML
    private Pane pane2d;
    @FXML
    private Pane panePaut;
    @FXML
    private Pane paneControls;
    @FXML
    private Pane paneChart;
    @FXML
    private ImageView pautView;
    @FXML
    private CheckBox selectionEnabled;
    @FXML
    private CheckBox selectionFlipped;
    @FXML
    private Slider colorSliderMin;
    @FXML
    private Slider colorSliderMax;
    @FXML
    private Slider smartMinSlider;
    @FXML
    private Button saveGridImgButton;
    @FXML
    private Button saveRawImgButton;
    awr mappedSurface = null;
    awq gridData = new awq();
    avy mappedPoint = new avy();
    final Property<awu> surfaceMap = new SimpleObjectProperty();
    final azc surface3d = new azc();
    final azc probeMesh = new azc();
    final Box probeModel = new bik(this);
    final azo probe3d;
    final azq world;
    static final double PROBE_SIZE_M = 0.053;
    bdf chartTrace;
    XYChart chart;
    @Inject
    ayh properties;
    @Inject
    avx MAPS;
    @Inject
    axc tfmImageAnalysis;
    @Inject
    bcf fileChooser;

    public RimaPresenter() {
        this.probe3d = new azo(new Node[]{this.probeMesh.e, this.probeModel, azk.a(10.0)});
        this.world = new azq(new Node[]{this.surface3d.e, this.probe3d}).a();
        this.chartTrace = bdf.a("depth", 1000, new String[0]);
        this.chart = new XYChart();
        this.chart.getPlugins().add((Object)bdc.a());
        this.chart.setLegendVisible(false);
        this.chartTrace.addStyleClasses(new String[]{bek.c.D()});
        this.chart.getRenderers().setAll((Object[])new Renderer[]{bdc.a()});
        this.chart.getDatasets().add((Object)this.chartTrace);
        Axis axis = this.chart.getFirstAxis(Orientation.HORIZONTAL);
        axis.setUnit("mm");
        axis.setName("x");
        axis.setTickUnit(10.0);
        axis.setAutoRanging(false);
        axis.setAutoGrowRanging(false);
        Axis axis2 = this.chart.getFirstAxis(Orientation.VERTICAL);
        axis2.setUnit("mm");
        axis2.setName("z");
        axis2.setTickUnit(5.0);
        axis2.setAutoRanging(false);
        axis2.setAutoGrowRanging(false);
        axis.set(0.0, auu.a.f(0.053));
        axis2.set(0.0, 20.0);
    }

    @FXML
    void initialize() throws IOException {
        bgt.b(this::initializeOnFxThread);
    }

    private void initializeOnFxThread() {
        bgt.a(bl2 -> {
            if (!bl2) {
                awq awq2 = this.gridData;
                if (!awq2.aE()) {
                    Arrays.fill(awq2.aA, 0, awq2.j(), 0);
                    Arrays.fill(awq2.d, 0, awq2.j(), false);
                    awq2.aW = false;
                    awq2.aX = false;
                    awq2.a.bn();
                    awq2.a.a();
                }
                this.gridData.a(this.mappedSurface);
            }
        }, (ObservableBooleanValue)this.selectionEnabled.selectedProperty());
        bgt.a(d2 -> {
            double d3;
            double d4 = d2;
            awq awq2 = this.gridData;
            this.gridData.a.dV = d3 = d4;
            awq2.aX = true;
            this.gridData.aU();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMin.valueProperty());
        bgt.a(d2 -> {
            double d3;
            double d4 = d2;
            awq awq2 = this.gridData;
            this.gridData.a.D = d3 = d4;
            awq2.aX = true;
            this.gridData.aU();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.colorSliderMax.valueProperty());
        bgt.a(d2 -> {
            double d3 = d2;
            awq awq2 = this.gridData;
            awq2.cL = d3 < 0.0 ? 0.0 : (d3 > 100.0 ? 1.0 : d3 / 100.0);
            awq2.aX = true;
            this.gridData.aU();
            this.gridData.a(this.mappedSurface);
        }, (ObservableDoubleValue)this.smartMinSlider.valueProperty());
        this.probeMesh.e.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.probeMesh.f.diffuseMapProperty().bind((ObservableValue)this.pautView.imageProperty());
        this.tfmImageAnalysis.f(this::updatePlots);
        this.paneChart.getChildren().add((Object)this.chart);
        bgt.c(this.chart);
        this.world.a(this.pane3d);
        Optional.ofNullable(RimaPresenter.class.getResource("assets/aluminum-dark.jpg")).map(URL::toExternalForm).map(Image::new).ifPresent(this.surface3d::a);
        this.MAPS.c(this.probe3d::b);
        this.MAPS.d(avy2 -> {
            this.mappedPoint.a((avy)avy2);
            if (this.mappedSurface != null) {
                this.mappedSurface.a((avy)avy2, 0.053);
            }
        });
        this.MAPS.b(awu2 -> {
            this.surfaceMap.setValue(awu2);
            this.surface3d.a((Mesh)awu2.a());
            Point3D point3D = azg.a((Mesh)awu2.a());
            bgt.a((Node)this.world.f, point3D);
            this.mappedSurface = awr.a(awu2, 800.0, 400.0);
            this.surface3d.e.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.b).otherwise(this.mappedSurface.a));
            this.surface3d.f.diffuseMapProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.selectionFlipped.selectedProperty()).then(this.mappedSurface.a).otherwise(this.mappedSurface.b));
            this.pane2d.getChildren().setAll((Object[])new Node[]{this.mappedSurface.a});
            awq awq2 = this.gridData;
            this.gridData.cK = 0.001;
            awq2.resize();
            awu awu3 = awu2;
            awq2 = this.gridData;
            this.gridData.b = awu3;
            awq2.resize();
            this.mappedSurface.l(0.01);
        });
        CompletableFuture.runAsync(() -> atp.b(1L, TimeUnit.SECONDS)).thenRun(this.MAPS::a);
    }

    public void updatePlots(axb axb2) {
        TriangleMesh triangleMesh;
        if (axb2.a != null) {
            triangleMesh = axb2.a;
            Point3D point3D = azg.a((Mesh)triangleMesh);
            this.probeMesh.e.setTranslateX(-point3D.getX());
            this.probeMesh.e.setRotationAxis(Rotate.Z_AXIS);
            this.probeMesh.e.setRotate(-90.0);
            this.probeMesh.a((Mesh)triangleMesh);
        }
        axb axb3 = axb2;
        boolean cfr_ignored_0 = axb3.aZ;
        if (axb3.ba) {
            axb3 = axb2;
            triangleMesh = (axb3.ba ? axb3.c : axb3.b).a;
            this.pautView.setImage((Image)triangleMesh);
        }
        this.chartTrace.bF();
        if (axb2.L() > 0) {
            axb2.a(this.chartTrace::f);
            this.chartTrace.bE();
            if (this.mappedPoint.isInContact() && this.selectionEnabled.isSelected()) {
                axb2.a(this::addProbeMeasurement);
                this.gridData.aU();
                this.gridData.a(this.mappedSurface);
            }
        }
        this.chart.getDatasets().setAll((Object[])new DataSet[]{this.chartTrace});
    }

    private void addProbeMeasurement(double d2, double d3) {
        double d4 = d2 / 1000.0 - 0.0265;
        if (this.selectionFlipped.isSelected()) {
            d4 = -d4;
        }
        double d5 = d4 * this.mappedPoint.cy + (double)this.mappedPoint.o;
        double d6 = d4 * this.mappedPoint.cz + (double)this.mappedPoint.p;
        double d7 = d3;
        double d8 = d6;
        double d9 = d5;
        awq awq2 = this.gridData;
        if (!awq2.aE()) {
            int n2;
            int n3;
            int n4 = (int)(awq2.b.l(d9) * (double)awq2.aC);
            int n5 = (int)(awq2.b.m(d8) * (double)awq2.aB);
            if (n5 < 0 || n4 < 0 || n5 >= awq2.aB || n4 >= awq2.aC) {
                return;
            }
            int n6 = n4;
            int n7 = n5;
            awq awq3 = awq2;
            int n8 = n3 = n7 * awq3.aC + n6;
            int n9 = awq2.aA[n8];
            awq2.aA[n8] = n9 + 1;
            int n10 = n2 = n9 % 32;
            int n11 = n3;
            awq2.H[(n11 << 5) + n10] = d7;
            awq2.d[n3] = true;
            awq2.aW = true;
        }
    }
}

