/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components.dialogs;

import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.lib.avx;
import us.hebi.gui.lib.avz;
import us.hebi.gui.lib.awa;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.bge;
import us.hebi.gui.lib.bgh;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bgx;
import us.hebi.gui.lib.bhp;
import us.hebi.gui.lib.bjo;
import us.hebi.gui.lib.bjq;
import us.hebi.gui.lib.bjs;
import us.hebi.gui.lib.bjt;
import us.hebi.gui.lib.bju;
import us.hebi.gui.lib.cht;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.scope.components.ParseUtils;

public class FlatWizardController
extends bge {
    @FXML
    private ToggleButton bottomLeft;
    @FXML
    private ToggleButton bottomRight;
    @FXML
    private Button closeBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private Button generateBtn;
    @FXML
    private StackPane rectangleLines;
    @FXML
    private AnchorPane root;
    @FXML
    private ToggleButton topLeft;
    @FXML
    private ToggleButton topRight;
    @FXML
    private TextField paddingField;
    final IntegerProperty numSelectedPoints = new SimpleIntegerProperty(0);
    final BooleanBinding needsMorePoints = this.numSelectedPoints.lessThan(3);
    @Inject
    avx maps;
    @Inject
    awa registration;
    @Inject
    azz notification;
    @Inject
    MapsAppState state;

    @Override
    public void initializeFx() {
        bhp.e((Parent)this.root);
        ValidationSupport validationSupport = bgh.a();
        validationSupport.registerValidator((Control)this.paddingField, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.state.addUnitFields(this.paddingField);
        bgt.b(() -> {
            this.generateBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.needsMorePoints.get());
            this.rectangleLines.pseudoClassStateChanged(MapsCss.SELECTED, !this.needsMorePoints.get());
        }, new Observable[]{this.needsMorePoints});
        FlatWizardController flatWizardController = this;
        bjq bjq2 = flatWizardController.setupToggleButton(flatWizardController.topLeft, bgx.k);
        FlatWizardController flatWizardController2 = this;
        bjq bjq3 = flatWizardController2.setupToggleButton(flatWizardController2.topRight, bgx.l);
        FlatWizardController flatWizardController3 = this;
        bjq bjq4 = flatWizardController3.setupToggleButton(flatWizardController3.bottomLeft, bgx.m);
        FlatWizardController flatWizardController4 = this;
        bjq bjq5 = flatWizardController4.setupToggleButton(flatWizardController4.bottomRight, bgx.n);
        this.generateBtn.disableProperty().bind((ObservableValue)this.needsMorePoints.or((ObservableBooleanValue)validationSupport.invalidProperty()));
        this.generateBtn.setOnAction(actionEvent -> {
            this.registration.aS();
            if (!this.topLeft.isSelected()) {
                bjq2.c(this.deriveWaypointAndAddMarkers(bjq3, bjq4, bjq5));
            } else if (!this.topRight.isSelected()) {
                bjq3.c(this.deriveWaypointAndAddMarkers(bjq2, bjq5, bjq4));
            } else if (!this.bottomLeft.isSelected()) {
                bjq4.c(this.deriveWaypointAndAddMarkers(bjq2, bjq5, bjq3));
            } else if (!this.bottomRight.isSelected()) {
                bjq5.c(this.deriveWaypointAndAddMarkers(bjq4, bjq3, bjq2));
            }
            bjt bjt2 = bjq2.a().a(bjq3.a()).b();
            bjt bjt3 = bjq2.a().a(bjq4.a()).b();
            double d2 = this.state.getUnits().e(Optional.ofNullable(ParseUtils.tryParseDouble(this.paddingField.getText())).orElse(0.0));
            bjt bjt4 = bjt2.c().a(d2);
            bjt bjt5 = bjt3.c().a(d2);
            bjt bjt6 = bjt2.c().a(-d2);
            bjt bjt7 = bjt3.c().a(-d2);
            bjq bjq7 = bjq2.e().a(bjt4).a(bjt5);
            bjq bjq8 = bjq3.e().a(bjt6).a(bjt5);
            bjq bjq9 = bjq4.e().a(bjt4).a(bjt7);
            bjq bjq10 = bjq5.e().a(bjt6).a(bjt7);
            bjq[] bjqArray = new bjq[9];
            bjqArray[0] = bjq7.e();
            bjq bjq11 = bjq8;
            bjq bjq12 = bjq7;
            bjqArray[1] = bjs.a(bjq12, bjq11);
            bjqArray[2] = bjq8.e();
            bjq11 = bjq9;
            bjq12 = bjq7;
            bjqArray[3] = bjs.a(bjq12, bjq11);
            bjq11 = bjq10;
            bjq12 = bjq7;
            bjqArray[4] = bjs.a(bjq12, bjq11);
            bjq11 = bjq10;
            bjq12 = bjq8;
            bjqArray[5] = bjs.a(bjq12, bjq11);
            bjqArray[6] = bjq9.e();
            bjq11 = bjq10;
            bjq12 = bjq9;
            bjqArray[7] = bjs.a(bjq12, bjq11);
            bjqArray[8] = bjq10.e();
            avz avz2 = new avz(bjqArray);
            bjt bjt8 = bjt3;
            bjt bjt9 = bju.a(bjt2, bjt8, bjt.d()).b();
            bju.a(bjt9, bjt2, bjt3);
            avz2.e(bjq2 -> bjq2.a(bjt2.a1, bjt3.a1, bjt4.a1, bjt2.a2, bjt3.a2, bjt4.a2, bjt2.a3, bjt3.a3, bjt4.a3));
            this.registration.a(avz2);
            this.closeBtn.getOnAction().handle(actionEvent);
        });
        this.clearBtn.disableProperty().bind((ObservableValue)this.numSelectedPoints.isEqualTo(0));
        this.clearBtn.setOnAction(actionEvent -> {
            this.topLeft.setSelected(false);
            this.topRight.setSelected(false);
            this.bottomLeft.setSelected(false);
            this.bottomRight.setSelected(false);
            this.paddingField.setText("0");
        });
    }

    private bjq deriveWaypointAndAddMarkers(bjq bjq2, bjq bjq3, bjq bjq4) {
        this.registration.a(bjq2, bjq3, bjq4);
        bjq bjq5 = bjq.d();
        bjq[] bjqArray = new bjq[]{bjq2, bjq3, bjq4};
        int cfr_ignored_0 = bjqArray.length;
        cht.c(true, "need at least one transform");
        bjo bjo2 = new bjo();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        bjq[] bjqArray2 = bjqArray;
        int cfr_ignored_1 = bjqArray.length;
        for (int i2 = 0; i2 < 3; ++i2) {
            bjqArray2[i2].a(bjo2);
            d2 += bjo2.cM;
            d3 += bjo2.dm;
            d4 += bjo2.dn;
            d5 += bjo2.do;
        }
        int cfr_ignored_2 = bjqArray.length;
        bjo2.cM = d2 / 3.0;
        int cfr_ignored_3 = bjqArray.length;
        bjo2.dm = d3 / 3.0;
        int cfr_ignored_4 = bjqArray.length;
        bjo2.dn = d4 / 3.0;
        int cfr_ignored_5 = bjqArray.length;
        bjo2.do = d5 / 3.0;
        bjo2.cj();
        bjq5.a(bjo2);
        bjq5.ea = bjq2.ea + bjq3.ea - bjq4.ea;
        bjq5.ec = bjq2.ec + bjq3.ec - bjq4.ec;
        bjq5.eg = bjq2.eg + bjq3.eg - bjq4.eg;
        return bjq5;
    }

    private bjq setupToggleButton(ToggleButton toggleButton, KeyCombination keyCombination) {
        toggleButton.visibleProperty().bind((ObservableValue)toggleButton.selectedProperty().or((ObservableBooleanValue)this.needsMorePoints));
        bjq bjq2 = bjq.d();
        toggleButton.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                bjq2.c(this.maps.a);
                this.numSelectedPoints.set(this.numSelectedPoints.get() + 1);
                return;
            }
            this.numSelectedPoints.set(this.numSelectedPoints.get() - 1);
        });
        bgx.a((Node)toggleButton, keyCombination, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (!bgt.a((Node)toggleButton)) {
                return;
            }
            bgt.a(toggleButton.selectedProperty());
        }));
        return bjq2;
    }

    public Button getCloseButton() {
        return this.closeBtn;
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }
}

