/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import lombok.Generated;
import us.hebi.gui.lib.adk;
import us.hebi.gui.lib.adm;
import us.hebi.gui.lib.ags;
import us.hebi.gui.lib.ajg;
import us.hebi.gui.lib.amo;
import us.hebi.gui.lib.aul;
import us.hebi.gui.lib.ayj;
import us.hebi.gui.lib.ayk;
import us.hebi.gui.lib.bpd;
import us.hebi.gui.views.logviewer.hebilog.GroupFeedbackHandler;
import us.hebi.gui.views.logviewer.hebilog.HebiLogAnalysis$BasicLogInfo;
import us.hebi.gui.views.logviewer.hebilog.HebiLogAnalysis$FeedbackSynchronizer;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.hebilog.MobileIoFeedback;
import us.hebi.gui.views.logviewer.hebilog.XyzLogData;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.NamedChart;

public class HebiLogContent {
    List<Optional<amo>> deviceInfos = Collections.emptyList();
    BooleanProperty hasInfo = new SimpleBooleanProperty(false);
    BooleanProperty loading = new SimpleBooleanProperty(false);
    final ChartList chartList = new ChartList();
    final HebiLogFeedback logFeedback = new HebiLogFeedback();
    final XyzLogData xyzLogData = new XyzLogData();
    final ObservableList<MobileIoFeedback> mobileIoList = FXCollections.observableArrayList();
    final ayk logFile = new ayk();
    final ayj hrdfFile = new ayj();
    ajg robotConfig = null;

    public String getDeviceName(int n2) {
        return this.chartList.getVisibilityState().getDeviceName(n2);
    }

    public BooleanProperty hasInfoProperty() {
        return this.hasInfo;
    }

    public amo[] getInfo() {
        bpd.a(this.hasInfo(), "Info not available");
        return (amo[])this.deviceInfos.stream().map(Optional::get).toArray(amo[]::new);
    }

    public Optional<List<String>> getNames() {
        if (!this.hasInfo()) {
            return Optional.empty();
        }
        return Optional.of(this.deviceInfos.stream().map(Optional::get).map(amo::getName).toList());
    }

    public int getNumJoints() {
        return this.deviceInfos.size();
    }

    public ReadOnlyBooleanProperty loadingProperty() {
        return this.loading;
    }

    public String getFileName() {
        return this.logFile.getFile().getName();
    }

    public File getFile() {
        return this.logFile.getFile();
    }

    public boolean hasValidFeedback() {
        return this.logFeedback.time != null && this.logFeedback.time.size() > 0;
    }

    public HebiLogFeedback getFeedback() {
        return this.logFeedback;
    }

    public XyzLogData getXyzData() {
        return this.xyzLogData;
    }

    public BooleanBinding hasValidHrdf() {
        return this.hrdfFile.cT;
    }

    public ObservableList<MobileIoFeedback> getMobileIoList() {
        return this.mobileIoList;
    }

    public HebiLogContent setLogFile(File file) {
        this.logFile.b(file);
        bpd.a(this.logFile.o.get(), "Input file is not a valid .hebilog file");
        return this;
    }

    public HebiLogContent setRobotConfig(ajg ajg2) throws IOException {
        this.robotConfig = ajg2;
        return this;
    }

    public HebiLogContent setHrdfFile(File file, aul aul2) {
        this.hrdfFile.b(file);
        bpd.a(this.hrdfFile.cT.get(), "Input file is not a valid hrdf file");
        this.xyzLogData.setKinematics(this.hrdfFile.a().a(), aul2);
        return this;
    }

    public List<TreeItem<NamedChart>> createChartHierarchy() {
        this.chartList.clear();
        this.logFeedback.getCharts(this.chartList);
        this.xyzLogData.getCharts(this.chartList);
        Iterator iterator = this.mobileIoList.iterator();
        while (iterator.hasNext()) {
            ((MobileIoFeedback)iterator.next()).getCharts(this.chartList);
        }
        return this.chartList.createHierarchy();
    }

    public CompletableFuture<HebiLogContent> loadAsync() {
        this.hasInfo.set(false);
        this.loading.set(true);
        return CompletableFuture.supplyAsync(this::loadContents).thenApplyAsync(hebiLogContent -> {
            this.loading.set(false);
            this.hasInfo.set(this.hasInfo());
            return hebiLogContent;
        }, Platform::runLater);
    }

    private HebiLogContent loadContents() {
        block9: {
            if (this.logFile.o.get()) {
                try {
                    ayk ayk2 = this.logFile;
                    bpd.b(ayk2.o.get(), (Object)"file is not a valid .hebilog");
                    try (adm adm2 = adk.a(ayk2.getFile());){
                        HebiLogAnalysis$BasicLogInfo hebiLogAnalysis$BasicLogInfo = adm2.a(new HebiLogAnalysis$BasicLogInfo());
                        int n2 = hebiLogAnalysis$BasicLogInfo.getNumDevices();
                        this.deviceInfos = IntStream.range(0, n2).mapToObj(hebiLogAnalysis$BasicLogInfo::getInfo).collect(Collectors.toList());
                        this.mobileIoList.clear();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            this.chartList.getVisibilityState().deviceNameProperty(i2).set((Object)hebiLogAnalysis$BasicLogInfo.getName(i2));
                            if (!hebiLogAnalysis$BasicLogInfo.isMobileIO(i2)) continue;
                            this.mobileIoList.add((Object)new MobileIoFeedback().init(i2, hebiLogAnalysis$BasicLogInfo.getMinFeedbackCount()));
                        }
                        this.logFeedback.init(hebiLogAnalysis$BasicLogInfo.getNumDevices(), hebiLogAnalysis$BasicLogInfo.getMinFeedbackCount(), hebiLogAnalysis$BasicLogInfo.numUserStateEntries);
                        adm2.a(new HebiLogAnalysis$FeedbackSynchronizer().addHandler(this.logFeedback).addHandlers((Collection<? extends GroupFeedbackHandler>)this.mobileIoList));
                        this.xyzLogData.setLogData(this.logFeedback);
                        break block9;
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error reading input log.", iOException);
                }
            }
            throw new IllegalArgumentException("Input file does not have a supported log format");
        }
        return this;
    }

    private boolean hasInfo() {
        return this.deviceInfos.stream().allMatch(Optional::isPresent);
    }

    public Optional<ajg> getRobotConfig() {
        return Optional.ofNullable(this.robotConfig);
    }

    public aul getIndexMap() {
        Optional<List<String>> optional = this.getNames();
        Optional<List> optional2 = this.getRobotConfig().map(ajg::getNames);
        if (optional.isEmpty() || optional2.isEmpty()) {
            return XyzLogData.SAME_INDEX;
        }
        return XyzLogData.createIndexMap(optional.get(), optional2.get());
    }

    public ags getXmlContent() {
        return this.hrdfFile.getXmlContent();
    }

    @Generated
    public ChartList getChartList() {
        return this.chartList;
    }
}

