/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.bootloader;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.TaskProgressView;
import us.hebi.gui.lib.abt;
import us.hebi.gui.lib.abv;
import us.hebi.gui.lib.af;
import us.hebi.gui.lib.ah;
import us.hebi.gui.lib.ald;
import us.hebi.gui.lib.amq;
import us.hebi.gui.lib.aoq;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.atk;
import us.hebi.gui.lib.avt;
import us.hebi.gui.lib.avu;
import us.hebi.gui.lib.axd;
import us.hebi.gui.lib.axl;
import us.hebi.gui.lib.axn;
import us.hebi.gui.lib.axq;
import us.hebi.gui.lib.axs;
import us.hebi.gui.lib.axv;
import us.hebi.gui.lib.aya;
import us.hebi.gui.lib.aye;
import us.hebi.gui.lib.azy;
import us.hebi.gui.lib.baa;
import us.hebi.gui.lib.bac;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.baz;
import us.hebi.gui.lib.bbb;
import us.hebi.gui.lib.bbc;
import us.hebi.gui.lib.bbk;
import us.hebi.gui.lib.bbm;
import us.hebi.gui.lib.bgt;
import us.hebi.gui.lib.bhq;
import us.hebi.gui.lib.bjf;
import us.hebi.gui.lib.bjg;
import us.hebi.gui.lib.bjh;
import us.hebi.gui.lib.bwq;
import us.hebi.gui.lib.bye;
import us.hebi.gui.lib.el;

public class BootloaderPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private ToolBar topBar;
    @FXML
    private Button loginButton;
    @FXML
    private Button bootButton;
    @FXML
    private Button calibrateCurrentButton;
    @FXML
    private Button programRawButton;
    @FXML
    private Button programEncryptingButton;
    @FXML
    private Button showMacAddressesButton;
    @FXML
    private Button setBootloaderParametersButton;
    @FXML
    private Button setApplicationParametersButton;
    @FXML
    private Button fullUpdateButton;
    @FXML
    private Button updateApplicationButton;
    @FXML
    private Button updateBootloaderButton;
    @FXML
    private Button updateBootloaderLoaderButton;
    @FXML
    private Button eraseApplicationButton;
    @FXML
    private Button stopButton;
    @FXML
    private Button calibratePositionButton;
    @FXML
    private Button calibrateEffortButton;
    @FXML
    private Button setDatabaseValueButton;
    @FXML
    private Button eraseDatabaseButton;
    @FXML
    private Button resetButton;
    @FXML
    private Button saveApplicationButton;
    @FXML
    private Button saveBootloaderButton;
    @FXML
    private Button saveAllPartitionsButton;
    @FXML
    private Button saveDatabaseButton;
    @FXML
    private TaskProgressView<Task<?>> taskProgressView;
    @FXML
    private VBox buttonVBox;
    @FXML
    public TreeView<String> typeTree;
    @FXML
    private TreeView<aye> moduleTree;
    @FXML
    private RadioButton viewSelectorFamilyName;
    @FXML
    private ChoiceBox<String> interfaceChoiceBox;
    @FXML
    private TextField hwType;
    @FXML
    private TextField hwEceType;
    @FXML
    private TextField hwEceRevision;
    @FXML
    private TextField hwSerial;
    @FXML
    private TextField fwType;
    @FXML
    private TextField fwRevision;
    @FXML
    private TextField ethMacAddress;
    @FXML
    private TextField ethIpAddress;
    @FXML
    private TextField ethNetmask;
    @FXML
    private TextField ethGateway;
    @FXML
    private TextField fwMode;
    @FXML
    private TextField hwRevision;
    @FXML
    private TextField hwSpringConstant;
    private static final String DATABASE_MESSAGE = "Clearing the database will wipe any existing calibration data and requires an appropriate physical setup. Continuing may render the device unusable. Are you sure that you want to proceed?";
    private static final String CALIBRATION_MESSAGE = "Calibrating will wipe any existing calibration data and requires an appropriate physical setup.Are you sure that you want to proceed?";
    int dbAddress = 28672;
    Float floatVal = null;
    Integer intVal = null;
    @Inject
    baa authenticationService;
    @Inject
    bbb lookupService;
    @Inject
    bbc selector;
    @Inject
    baz interfaceChoiceService;
    @Inject
    bbm simpleCategoryTree;
    @Inject
    public bbk filteredFlatModuleTree;
    @Inject
    bat commandService;
    aoq command;
    @Inject
    avu moduleTreeCellFactory;
    @Inject
    bac bootloaderService;

    @FXML
    void refreshInterfaces(ActionEvent actionEvent) {
        this.interfaceChoiceService.refreshInterfaces();
    }

    @FXML
    void reset(ActionEvent actionEvent) {
        ((aqt)this.command).clear();
        this.command.setResetFlag();
        this.selector.getSelectedAddresses().forEach(ald2 -> this.commandService.a((ald)ald2, this.command));
    }

    @FXML
    void stopBoot(ActionEvent actionEvent) {
        ((aqt)this.command).clear();
        this.command.setStayInBootloaderFlag();
        this.selector.getSelectedAddresses().forEach(ald2 -> this.commandService.a((ald)ald2, this.command));
    }

    @FXML
    void boot(ActionEvent actionEvent) {
        ((aqt)this.command).clear();
        this.command.setBootFlag();
        this.selector.getSelectedAddresses().forEach(ald2 -> this.commandService.a((ald)ald2, this.command));
    }

    @FXML
    void setBootloaderHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setBootloaderHardwareParameters((List<aye>)this.selector.getSelectedModules(), this.authenticationService.cW.get());
    }

    @FXML
    void setApplicationHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setApplicationHardwareParameters((List<aye>)this.selector.getSelectedModules());
    }

    @FXML
    void programApplication(ActionEvent actionEvent) {
        this.bootloaderService.programApplicationMultiple((List<aye>)this.selector.getSelectedModules(), this.programRawButton.getScene().getWindow());
    }

    @FXML
    void programEncryptingFirmware(ActionEvent actionEvent) {
        this.bootloaderService.programEncryptingFirmwareMultiple((List<aye>)this.selector.getSelectedModules(), this.programEncryptingButton.getScene().getWindow());
    }

    @FXML
    void doFullUpdate(ActionEvent actionEvent) {
        this.bootloaderService.doFullUpdate(this.selector.getSingleSelection());
    }

    @FXML
    void updateApplication(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aye>)this.selector.getSelectedModules(), bjf.d);
    }

    @FXML
    void updateBootloader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aye>)this.selector.getSelectedModules(), bjf.e);
    }

    @FXML
    void updateBootloaderLoader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<aye>)this.selector.getSelectedModules(), bjf.f);
    }

    @FXML
    void eraseApplication(ActionEvent actionEvent) {
        for (aye aye2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(aye2), bwq.d);
        }
    }

    @FXML
    void eraseDatabase(ActionEvent actionEvent) {
        if (!azy.a(CALIBRATION_MESSAGE, bgt.a(actionEvent))) {
            return;
        }
        for (aye aye2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(aye2), bwq.e);
        }
    }

    @FXML
    void saveAllPartitions(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bwq.c, this.saveAllPartitionsButton.getScene().getWindow());
    }

    @FXML
    void saveBootloader(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bwq.f, this.saveBootloaderButton.getScene().getWindow());
    }

    @FXML
    void saveApplication(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bwq.d, this.saveApplicationButton.getScene().getWindow());
    }

    @FXML
    void saveDatabase(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bwq.e, this.saveDatabaseButton.getScene().getWindow());
    }

    @FXML
    void calibrateCurrent(ActionEvent actionEvent) {
        if (!azy.a(CALIBRATION_MESSAGE, bgt.a(actionEvent))) {
            return;
        }
        System.out.println("continue");
        this.selector.getSelectedAddresses().forEach(ald2 -> {
            ((aqt)this.command).clear();
            ((aqt)this.command).getRootMessage().a().e().d(true);
            this.commandService.a((ald)ald2, this.command);
        });
    }

    @FXML
    void calibratePosition(ActionEvent actionEvent) {
        if (!azy.a(CALIBRATION_MESSAGE, bgt.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(ald2 -> {
            ((aqt)this.command).clear();
            ((aqt)this.command).getRootMessage().a().e().a(true);
            this.commandService.a((ald)ald2, this.command);
        });
    }

    @FXML
    void calibrateEffort(ActionEvent actionEvent) {
        if (!azy.a(CALIBRATION_MESSAGE, bgt.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(ald2 -> {
            ((aqt)this.command).clear();
            ((aqt)this.command).getRootMessage().a().e().b(true);
            this.commandService.a((ald)ald2, this.command);
        });
    }

    @FXML
    void showMacAddresses(ActionEvent actionEvent) {
        aye aye22;
        Object object = "";
        for (aye aye22 : this.selector.getSelectedModules()) {
            object = (String)object + aye22.c().toString() + "\n";
        }
        Iterator iterator = new TextArea((String)object);
        aye22 = new Dialog();
        aye22.setTitle("Mac Address");
        DialogPane dialogPane = aye22.getDialogPane();
        dialogPane.setContent((Node)iterator);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        aye22.show();
    }

    @FXML
    void showLoginDialog(ActionEvent actionEvent) {
        bjg bjg2 = this.authenticationService.authClient;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("approval_prompt", "force");
        bjg2.a = bjg2.a.getAuthorizationUrlWithPKCE(hashMap);
        bjg2.webViewer.showDocument(bjg2.a.getAuthorizationUrl());
    }

    @FXML
    void setDatabaseValue(ActionEvent actionEvent) {
        Optional optional = avt.a("Set Database Value", el.a("Address", "FloatValue", "IntValue"), el.a("0x" + Integer.toHexString(this.dbAddress), this.floatVal == null ? "" : this.floatVal.toString(), this.intVal == null ? "" : this.intVal.toString())).showAndWait();
        if (!optional.isPresent()) {
            return;
        }
        List list = (List)optional.get();
        try {
            boolean bl2 = !af.a((String)list.get(1));
            boolean bl3 = !af.a((String)list.get(2));
            ah.a(!af.a((String)list.get(0)), "Address must not be empty");
            ah.a(bl2 || bl3, "Expected a value field to be set.");
            ah.a(!bl2 || !bl3, "Expected only one value field to be set.");
            this.dbAddress = Integer.decode((String)list.get(0));
            this.floatVal = bl2 ? Float.valueOf(Float.parseFloat((String)list.get(1))) : null;
            this.intVal = bl3 ? Integer.decode((String)list.get(2)) : null;
            ((aqt)this.command).clear();
            bye bye2 = ((aqt)this.command).getRootMessage().d().d();
            bye2.b(this.dbAddress);
            if (bl2) {
                bye2.a(this.floatVal.floatValue());
            }
            if (bl3) {
                bye2.a(this.intVal);
            }
            this.selector.getSelectedAddresses().forEach(ald2 -> this.commandService.a((ald)ald2, this.command));
            return;
        }
        catch (Exception exception) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error");
            alert.setHeaderText(null);
            alert.setContentText(exception.getMessage());
            alert.showAndWait();
            return;
        }
    }

    @FXML
    void initialize() {
        assert (this.bootButton != null) : "fx:id=\"bootButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibrateCurrentButton != null) : "fx:id=\"calibrateCurrentButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.taskProgressView != null) : "fx:id=\"taskProgressView\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.moduleTree != null) : "fx:id=\"moduleTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.typeTree != null) : "fx:id=\"typeTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programRawButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programEncryptingButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.updateApplicationButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseApplicationButton != null) : "fx:id=\"eraseApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.stopButton != null) : "fx:id=\"stopButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibratePositionButton != null) : "fx:id=\"calibratePositionButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseDatabaseButton != null) : "fx:id=\"eraseDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.resetButton != null) : "fx:id=\"resetButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveAllPartitionsButton != null) : "fx:id=\"saveAllPartitionsButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveApplicationButton != null) : "fx:id=\"saveApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveBootloaderButton != null) : "fx:id=\"saveBootloaderButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveDatabaseButton != null) : "fx:id=\"saveDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        this.typeTree.setRoot(this.simpleCategoryTree.getCategoryTree());
        this.typeTree.setShowRoot(false);
        this.typeTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.moduleTreeCellFactory.d.bind((ObservableValue)this.viewSelectorFamilyName.selectedProperty());
        this.moduleTree.setCellFactory((Callback)this.moduleTreeCellFactory);
        this.moduleTree.setRoot(this.filteredFlatModuleTree.getModuleTree());
        this.moduleTree.setShowRoot(false);
        this.moduleTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.selector.setDataSource((ObservableList<TreeItem<aye>>)this.moduleTree.getSelectionModel().getSelectedItems());
        this.typeTree.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new bhq(this));
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> !this.taskProgressView.getTasks().isEmpty(), (Observable[])new Observable[]{this.taskProgressView.getTasks()});
        this.taskProgressView.visibleProperty().bind((ObservableValue)booleanBinding);
        this.bootloaderService.setTaskList(this.taskProgressView.getTasks());
        this.taskProgressView.getTasks().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                block5: for (Task task : change.getRemoved()) {
                    if (task.getState() != Worker.State.FAILED) {
                        atk.i("hebi.bootloader.showSuccessNotifications");
                    }
                    Notifications notifications = Notifications.create().position(Pos.BOTTOM_RIGHT).hideAfter(Duration.INDEFINITE).owner(this.taskProgressView).title(task.getTitle()).text(task.getMessage());
                    switch (task.getState()) {
                        case FAILED: {
                            notifications.showError();
                            continue block5;
                        }
                        case CANCELLED: {
                            notifications.showWarning();
                            continue block5;
                        }
                    }
                    notifications.showInformation();
                }
            }
        });
        BooleanBinding booleanBinding2 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionEmpty());
        BooleanBinding booleanBinding3 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionSingle().not());
        BooleanBinding booleanBinding4 = this.authenticationService.cW.not();
        bgt.a((ObservableBooleanValue)booleanBinding2, new Node[]{this.bootButton, this.stopButton, this.updateApplicationButton, this.updateBootloaderButton, this.showMacAddressesButton, this.programRawButton, this.eraseApplicationButton, this.resetButton, this.calibrateCurrentButton, this.calibratePositionButton, this.calibrateEffortButton});
        bgt.a((ObservableBooleanValue)booleanBinding3, new Node[]{this.fullUpdateButton});
        bgt.a((ObservableBooleanValue)booleanBinding4.or((ObservableBooleanValue)booleanBinding2), new Node[]{this.updateBootloaderLoaderButton, this.programEncryptingButton, this.eraseDatabaseButton, this.setDatabaseValueButton, this.setBootloaderParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        bjh.a();
        if (!bjh.aX()) {
            this.topBar.getItems().remove((Object)this.loginButton);
            this.buttonVBox.getChildren().removeAll((Object[])new Node[]{this.programEncryptingButton, this.setBootloaderParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        }
        this.setBootloaderParametersButton.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.authenticationService.cW).then("Set Key / Info (BL)").otherwise("Set Info (BL)"));
        this.interfaceChoiceService.init(this.interfaceChoiceBox);
        this.selector.addSingleSelectionChangeListener(this::bindToModule);
        this.bindToModule(bbc.EMPTY_DEVICE);
    }

    private void bindToModule(aye aye2) {
        if (aye2 == null) {
            System.out.println("can't bind to null module");
            return;
        }
        axs axs2 = aye2.getInfo();
        Object object = axs2;
        axl axl2 = axs2.a;
        object = axs2;
        axq axq2 = ((axs)object).a;
        object = axs2;
        aya aya2 = ((axs)object).a;
        object = axs2;
        axd axd2 = ((axs)object).a;
        object = axs2;
        axv cfr_ignored_0 = ((axs)object).a;
        object = axs2;
        axn cfr_ignored_1 = ((axs)object).a;
        object = axq2;
        this.hwType.visibleProperty().bind((ObservableValue)((axq)object).q.isNotEmpty());
        object = axq2;
        this.hwType.textProperty().bind((ObservableValue)((axq)object).q);
        object = axq2;
        this.hwRevision.visibleProperty().bind((ObservableValue)((axq)object).p.isNotEmpty());
        object = axq2;
        this.hwRevision.textProperty().bind((ObservableValue)((axq)object).p);
        object = axq2;
        this.hwEceType.visibleProperty().bind((ObservableValue)((axq)object).o.isNotEmpty());
        object = axq2;
        this.hwEceType.textProperty().bind((ObservableValue)((axq)object).o);
        object = axq2;
        this.hwEceRevision.visibleProperty().bind((ObservableValue)((axq)object).n.isNotEmpty());
        object = axq2;
        this.hwEceRevision.textProperty().bind((ObservableValue)((axq)object).n);
        object = axq2;
        this.hwSerial.visibleProperty().bind((ObservableValue)((axq)object).r.isNotEmpty());
        object = axq2;
        this.hwSerial.textProperty().bind((ObservableValue)((axq)object).r);
        axd axd3 = axd2;
        object = axd3;
        object = axd2;
        DoubleBinding doubleBinding = axd3.h.divide((ObservableNumberValue)((axd)object).f).multiply(-1);
        this.hwSpringConstant.textProperty().bind((ObservableValue)doubleBinding.asString("%.3f"));
        object = axl2;
        this.fwType.visibleProperty().bind((ObservableValue)((axl)object).m.isNotEmpty());
        object = axl2;
        this.fwType.textProperty().bind((ObservableValue)((axl)object).m);
        object = axl2;
        this.fwRevision.visibleProperty().bind((ObservableValue)((axl)object).l.isNotEmpty());
        object = axl2;
        this.fwRevision.textProperty().bind((ObservableValue)((axl)object).l);
        object = axl2;
        this.fwMode.visibleProperty().bind((ObservableValue)((axl)object).u.isNotEqualTo((Object)amq.a));
        object = axl2;
        this.fwMode.textProperty().bind((ObservableValue)((axl)object).u.asString());
        object = aya2;
        this.ethMacAddress.visibleProperty().bind((ObservableValue)((aya)object).C.isNotEqualTo(abv.a));
        object = aya2;
        this.ethMacAddress.textProperty().bind((ObservableValue)((aya)object).C.asString());
        object = aya2;
        this.ethIpAddress.visibleProperty().bind((ObservableValue)((aya)object).z.isNotEqualTo((Object)abt.a));
        Observable[] observableArray = new Observable[2];
        object = aya2;
        observableArray[0] = ((aya)object).z;
        object = aya2;
        observableArray[1] = ((aya)object).A;
        this.ethIpAddress.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String string = aya2.b().toString();
            switch (aya2.a()) {
                case b: {
                    return string + " (dhcp)";
                }
                case c: {
                    return string + " (static)";
                }
            }
            return string;
        }, (Observable[])observableArray));
        object = aya2;
        this.ethNetmask.visibleProperty().bind((ObservableValue)((aya)object).E.isNotEqualTo((Object)abt.a));
        object = aya2;
        this.ethNetmask.textProperty().bind((ObservableValue)((aya)object).E.asString());
        object = aya2;
        this.ethGateway.visibleProperty().bind((ObservableValue)((aya)object).B.isNotEqualTo((Object)abt.a));
        object = aya2;
        this.ethGateway.textProperty().bind((ObservableValue)((aya)object).B.asString());
        BooleanBinding booleanBinding = this.selector.selectionMultiple().not();
        this.authenticationService.cW.not();
        object = axl2;
        BooleanBinding booleanBinding2 = ((axl)object).u.isNotEqualTo((Object)amq.b);
        object = axl2;
        BooleanBinding booleanBinding3 = ((axl)object).u.isNotEqualTo((Object)amq.c);
        bgt.a((ObservableBooleanValue)booleanBinding2.and((ObservableBooleanValue)booleanBinding), new Node[]{this.setBootloaderParametersButton});
        bgt.a((ObservableBooleanValue)booleanBinding3.and((ObservableBooleanValue)booleanBinding), new Node[]{this.setApplicationParametersButton});
    }

    @PostConstruct
    public void postConstruct() {
        this.lookupService.setFrequency(5.0);
        BootloaderPresenter bootloaderPresenter = this;
        this.command = bootloaderPresenter.commandService.b();
    }
}

