/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.tools.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import us.hebi.gui.lib.ah;
import us.hebi.gui.lib.bgc;

public class UdpRecorder {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.out.println("Expected arguments: [port] [filename]");
            return;
        }
        File file = new File(stringArray[1]);
        if (file.exists()) {
            ah.a(file.delete(), "File already exists and could not be deleted.");
        }
        int n2 = Integer.parseInt(stringArray[0]);
        System.out.println("Logging data to: " + file.getAbsolutePath());
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            try (bgc bgc2 = new bgc(n2);){
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        System.out.println("Closing UDP server");
                        bgc2.close();
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return;
                    }
                }));
                bgc2.run();
            }
            return;
        }
    }
}

