/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.FontSelectorDialog;
import org.controlsfx.property.editor.AbstractObjectField;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.NumericField;
import org.controlsfx.property.editor.PropertyEditor;

public class Editors {
    private Editors() {
    }

    public static final PropertyEditor<?> createTextEditor(PropertySheet.Item item) {
        return new AbstractPropertyEditor<String, TextField>(item, new TextField()){
            {
                Editors.enableAutoSelectAll((TextInputControl)this.getEditor());
            }

            protected StringProperty getObservableValue() {
                return ((TextField)this.getEditor()).textProperty();
            }

            @Override
            public void setValue(String string) {
                ((TextField)this.getEditor()).setText(string);
            }
        };
    }

    public static final PropertyEditor<?> createNumericEditor(final PropertySheet.Item item) {
        return new AbstractPropertyEditor<Number, NumericField>(item, new NumericField(item.getType())){
            private Class<? extends Number> sourceClass;
            {
                super(item3, numericField);
                this.sourceClass = item.getType();
                Editors.enableAutoSelectAll((TextInputControl)this.getEditor());
            }

            @Override
            protected ObservableValue<Number> getObservableValue() {
                return ((NumericField)((Object)this.getEditor())).valueProperty();
            }

            @Override
            public Number getValue() {
                if (this.sourceClass == Byte.class) {
                    return Byte.valueOf(((NumericField)((Object)this.getEditor())).getText());
                }
                if (this.sourceClass == Short.class) {
                    return Short.valueOf(((NumericField)((Object)this.getEditor())).getText());
                }
                if (this.sourceClass == Integer.class) {
                    return Integer.valueOf(((NumericField)((Object)this.getEditor())).getText());
                }
                if (this.sourceClass == Long.class) {
                    return Long.valueOf(((NumericField)((Object)this.getEditor())).getText());
                }
                if (this.sourceClass == Float.class) {
                    return Float.valueOf(((NumericField)((Object)this.getEditor())).getText());
                }
                if (this.sourceClass == Double.class) {
                    return Double.valueOf(((NumericField)((Object)this.getEditor())).getText());
                }
                if (this.sourceClass == BigInteger.class) {
                    return new BigInteger(((NumericField)((Object)this.getEditor())).getText());
                }
                if (this.sourceClass == BigDecimal.class) {
                    return new BigDecimal(((NumericField)((Object)this.getEditor())).getText());
                }
                try {
                    return this.sourceClass.getConstructor(String.class).newInstance(((NumericField)((Object)this.getEditor())).getText());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    exception.printStackTrace();
                    return null;
                }
            }

            @Override
            public void setValue(Number number) {
                this.sourceClass = number.getClass();
                ((NumericField)((Object)this.getEditor())).setValue(number);
                ((NumericField)((Object)this.getEditor())).setText(number.toString());
            }
        };
    }

    public static final PropertyEditor<?> createCheckEditor(PropertySheet.Item item) {
        return new AbstractPropertyEditor<Boolean, CheckBox>(item, new CheckBox()){

            protected BooleanProperty getObservableValue() {
                return ((CheckBox)this.getEditor()).selectedProperty();
            }

            @Override
            public void setValue(Boolean bl2) {
                ((CheckBox)this.getEditor()).setSelected(bl2.booleanValue());
            }
        };
    }

    public static final <T> PropertyEditor<?> createChoiceEditor(PropertySheet.Item item, final Collection<T> collection) {
        return new AbstractPropertyEditor<T, ComboBox<T>>(item, new ComboBox()){
            {
                super(item, comboBox);
                ((ComboBox)this.getEditor()).setItems(FXCollections.observableArrayList((Collection)collection));
            }

            @Override
            protected ObservableValue<T> getObservableValue() {
                return ((ComboBox)this.getEditor()).getSelectionModel().selectedItemProperty();
            }

            @Override
            public void setValue(T t2) {
                ((ComboBox)this.getEditor()).getSelectionModel().select(t2);
            }
        };
    }

    public static final PropertyEditor<?> createColorEditor(PropertySheet.Item item) {
        return new AbstractPropertyEditor<Color, ColorPicker>(item, new ColorPicker()){

            @Override
            protected ObservableValue<Color> getObservableValue() {
                return ((ColorPicker)this.getEditor()).valueProperty();
            }

            @Override
            public void setValue(Color color) {
                ((ColorPicker)this.getEditor()).setValue((Object)color);
            }
        };
    }

    public static final PropertyEditor<?> createDateEditor(PropertySheet.Item item) {
        return new AbstractPropertyEditor<LocalDate, DatePicker>(item, new DatePicker()){

            @Override
            protected ObservableValue<LocalDate> getObservableValue() {
                return ((DatePicker)this.getEditor()).valueProperty();
            }

            @Override
            public void setValue(LocalDate localDate) {
                ((DatePicker)this.getEditor()).setValue((Object)localDate);
            }
        };
    }

    public static final PropertyEditor<?> createFontEditor(PropertySheet.Item item) {
        return new AbstractPropertyEditor<Font, AbstractObjectField<Font>>(item, (AbstractObjectField)new AbstractObjectField<Font>(){

            @Override
            protected Class<Font> getType() {
                return Font.class;
            }

            @Override
            protected String objectToString(Font font) {
                return font == null ? "" : String.format("%s, %.1f", font.getName(), font.getSize());
            }

            @Override
            protected Font edit(Font font) {
                FontSelectorDialog fontSelectorDialog = new FontSelectorDialog(font);
                Optional optional = fontSelectorDialog.showAndWait();
                return optional.orElse(null);
            }
        }){

            @Override
            protected ObservableValue<Font> getObservableValue() {
                return ((AbstractObjectField)((Object)this.getEditor())).getObjectProperty();
            }

            @Override
            public void setValue(Font font) {
                ((AbstractObjectField)((Object)this.getEditor())).getObjectProperty().set((Object)font);
            }
        };
    }

    public static final Optional<PropertyEditor<?>> createCustomEditor(PropertySheet.Item item) {
        return item.getPropertyEditorClass().map(clazz -> {
            try {
                Constructor constructor = clazz.getConstructor(PropertySheet.Item.class);
                if (constructor != null) {
                    return (PropertyEditor)constructor.newInstance(item);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
            return null;
        });
    }

    private static void enableAutoSelectAll(TextInputControl textInputControl) {
        textInputControl.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                Platform.runLater(() -> textInputControl.selectAll());
            }
        });
    }
}

