/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.cell;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class TextField2TableCell<S, T>
extends TextFieldTableCell<S, T> {
    private TextField textField;

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
        return TextField2TableCell.forTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> stringConverter) {
        return tableColumn -> new TextField2TableCell(stringConverter);
    }

    public TextField2TableCell() {
        this(null);
    }

    public TextField2TableCell(final StringConverter<T> stringConverter) {
        super(stringConverter);
        this.graphicProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (TextField2TableCell.this.getGraphic() != null && TextField2TableCell.this.getGraphic() instanceof TextField) {
                    TextField2TableCell.this.textField = (TextField)TextField2TableCell.this.getGraphic();
                    TextField2TableCell.this.textField.focusedProperty().addListener((observableValue, bl2, bl3) -> {
                        if (!bl3.booleanValue()) {
                            TextField2TableCell.this.commitEdit(stringConverter.fromString(TextField2TableCell.this.textField.getText()));
                        }
                    });
                    TextField2TableCell.this.textField.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
                        TableView.TableViewSelectionModel tableViewSelectionModel = TextField2TableCell.this.getTableView().getSelectionModel();
                        if (keyEvent.getCode() == null || tableViewSelectionModel == null) {
                            return;
                        }
                        switch (keyEvent.getCode()) {
                            case ESCAPE: {
                                TextField2TableCell.this.textField.setText(stringConverter.toString(TextField2TableCell.this.getItem()));
                                TextField2TableCell.this.cancelEdit();
                                keyEvent.consume();
                                break;
                            }
                            case TAB: {
                                TextField2TableCell.this.cancelEdit();
                                keyEvent.consume();
                                if (tableViewSelectionModel.isCellSelectionEnabled()) {
                                    int n2 = TextField2TableCell.this.getTableView().getVisibleLeafIndex(TextField2TableCell.this.getTableColumn());
                                    if (keyEvent.isShiftDown()) {
                                        if (n2 > 0) {
                                            tableViewSelectionModel.clearAndSelect(TextField2TableCell.this.getIndex(), TextField2TableCell.this.getTableView().getVisibleLeafColumn(n2 - 1));
                                            break;
                                        }
                                        if (TextField2TableCell.this.getIndex() <= 0) break;
                                        tableViewSelectionModel.clearAndSelect(TextField2TableCell.this.getIndex() - 1, TextField2TableCell.this.getTableView().getVisibleLeafColumn(TextField2TableCell.this.getTableView().getVisibleLeafColumns().size() - 1));
                                        break;
                                    }
                                    if (n2 + 1 < TextField2TableCell.this.getTableView().getVisibleLeafColumns().size()) {
                                        tableViewSelectionModel.clearAndSelect(TextField2TableCell.this.getIndex(), TextField2TableCell.this.getTableView().getVisibleLeafColumn(n2 + 1));
                                        break;
                                    }
                                    if (TextField2TableCell.this.getIndex() >= TextField2TableCell.this.getTableView().getItems().size() - 1) break;
                                    tableViewSelectionModel.clearAndSelect(TextField2TableCell.this.getIndex() + 1, TextField2TableCell.this.getTableView().getVisibleLeafColumn(0));
                                    break;
                                }
                                tableViewSelectionModel.clearAndSelect(keyEvent.isShiftDown() ? TextField2TableCell.this.getIndex() - 1 : TextField2TableCell.this.getIndex() + 1);
                                break;
                            }
                            case UP: {
                                TextField2TableCell.this.cancelEdit();
                                keyEvent.consume();
                                tableViewSelectionModel.clearAndSelect(TextField2TableCell.this.getIndex() - 1, TextField2TableCell.this.getTableColumn());
                                break;
                            }
                            case DOWN: {
                                TextField2TableCell.this.cancelEdit();
                                keyEvent.consume();
                                tableViewSelectionModel.clearAndSelect(TextField2TableCell.this.getIndex() + 1, TextField2TableCell.this.getTableColumn());
                                break;
                            }
                        }
                    });
                    TextField2TableCell.this.graphicProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    public void commitEdit(T t2) {
        TableView tableView;
        if (!this.isEditing() && !t2.equals(this.getItem()) && (tableView = this.getTableView()) != null) {
            TableColumn tableColumn = this.getTableColumn();
            TableColumn.CellEditEvent cellEditEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), t2);
            Event.fireEvent((EventTarget)tableColumn, (Event)cellEditEvent);
        }
        super.commitEdit(t2);
    }
}

