/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.i18n.Localization;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public abstract class SpreadsheetCellEditor {
    private static final double MAX_EDITOR_HEIGHT = 50.0;
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.##########");
    SpreadsheetView view;

    public SpreadsheetCellEditor(SpreadsheetView spreadsheetView) {
        this.view = spreadsheetView;
    }

    public final void endEdit(boolean bl2) {
        this.view.getCellsViewSkin().getSpreadsheetCellEditorImpl().endEdit(bl2);
    }

    public void startEdit(Object object) {
        this.startEdit(object, null, new Object[0]);
    }

    public abstract void startEdit(Object var1, String var2, Object ... var3);

    public abstract Control getEditor();

    public abstract String getControlValue();

    public abstract void end();

    public double getMaxHeight() {
        return 50.0;
    }

    public static class DateEditor
    extends SpreadsheetCellEditor {
        private final DatePicker datePicker = new DatePicker();
        private EventHandler<KeyEvent> eh;
        private ChangeListener<LocalDate> cl;
        private boolean ending = false;

        public DateEditor(SpreadsheetView spreadsheetView, StringConverter<LocalDate> stringConverter) {
            super(spreadsheetView);
            this.datePicker.setConverter(stringConverter);
        }

        @Override
        public void startEdit(Object object, String string, Object ... objectArray) {
            if (object instanceof LocalDate) {
                this.datePicker.setValue((Object)((LocalDate)object));
            }
            this.attachEnterEscapeEventHandler();
            this.datePicker.show();
            this.datePicker.getEditor().requestFocus();
        }

        @Override
        public void end() {
            if (this.datePicker.isShowing()) {
                this.datePicker.hide();
            }
            this.datePicker.removeEventFilter(KeyEvent.KEY_PRESSED, this.eh);
            this.datePicker.valueProperty().removeListener(this.cl);
        }

        public DatePicker getEditor() {
            return this.datePicker;
        }

        @Override
        public String getControlValue() {
            return this.datePicker.getEditor().getText();
        }

        private void attachEnterEscapeEventHandler() {
            this.eh = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.ENTER) {
                        ending = true;
                        this.endEdit(true);
                        ending = false;
                    } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        this.endEdit(false);
                    }
                }
            };
            this.datePicker.addEventFilter(KeyEvent.KEY_PRESSED, this.eh);
            this.cl = new ChangeListener<LocalDate>(){

                public void changed(ObservableValue<? extends LocalDate> observableValue, LocalDate localDate, LocalDate localDate2) {
                    if (!ending) {
                        this.endEdit(true);
                    }
                }
            };
            this.datePicker.valueProperty().addListener(this.cl);
        }
    }

    public static class ListEditor<R>
    extends SpreadsheetCellEditor {
        private final List<String> itemList;
        private final ComboBox<String> cb;
        private String originalValue;

        public ListEditor(SpreadsheetView spreadsheetView, List<String> list) {
            super(spreadsheetView);
            this.itemList = list;
            this.cb = new ComboBox();
            this.cb.setVisibleRowCount(5);
        }

        @Override
        public void startEdit(Object object, String string, Object ... objectArray) {
            this.originalValue = object instanceof String ? object.toString() : null;
            ObservableList observableList = FXCollections.observableList(this.itemList);
            this.cb.setItems(observableList);
            this.cb.setValue((Object)this.originalValue);
            this.attachEnterEscapeEventHandler();
            this.cb.show();
            this.cb.requestFocus();
        }

        @Override
        public void end() {
            this.cb.setOnKeyPressed(null);
        }

        public ComboBox<String> getEditor() {
            return this.cb;
        }

        @Override
        public String getControlValue() {
            return (String)this.cb.getSelectionModel().getSelectedItem();
        }

        private void attachEnterEscapeEventHandler() {
            this.cb.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        cb.setValue((Object)originalValue);
                        this.endEdit(false);
                    } else if (keyEvent.getCode() == KeyCode.ENTER) {
                        this.endEdit(true);
                    }
                }
            });
        }
    }

    public static class IntegerEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField();

        public IntegerEditor(SpreadsheetView spreadsheetView) {
            super(spreadsheetView);
        }

        @Override
        public void startEdit(Object object, String string, Object ... objectArray) {
            if (object instanceof Integer) {
                this.tf.setText(Integer.toString((Integer)object));
            } else {
                this.tf.setText(null);
            }
            this.tf.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.selectAll();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    block6: {
                        if (keyEvent.getCode() == KeyCode.ENTER) {
                            try {
                                if (tf.getText().equals("")) {
                                    this.endEdit(true);
                                    break block6;
                                }
                                Integer.parseInt(tf.getText());
                                this.endEdit(true);
                            }
                            catch (Exception exception) {}
                        } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                            this.endEdit(false);
                        }
                    }
                }
            });
            this.tf.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    try {
                        if (tf.getText().equals("")) {
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        } else {
                            Integer.parseInt(tf.getText());
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        }
                    }
                    catch (Exception exception) {
                        tf.getStyleClass().add((Object)"error");
                    }
                }
            });
        }
    }

    public static class DoubleEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField(){

            public void insertText(int n2, String string) {
                String string2 = this.fixText(string);
                super.insertText(n2, string2);
            }

            public void replaceText(int n2, int n3, String string) {
                String string2 = this.fixText(string);
                super.replaceText(n2, n3, string2);
            }

            public void replaceText(IndexRange indexRange, String string) {
                this.replaceText(indexRange.getStart(), indexRange.getEnd(), string);
            }

            private String fixText(String string) {
                DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Localization.getLocale());
                string = string.replace(' ', '\u00a0');
                return string.replaceAll("\\.", Character.toString(decimalFormatSymbols.getDecimalSeparator()));
            }
        };

        public DoubleEditor(SpreadsheetView spreadsheetView) {
            super(spreadsheetView);
        }

        @Override
        public void startEdit(Object object, String string, Object ... objectArray) {
            if (object instanceof Double) {
                decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Localization.getLocale()));
                this.tf.setText(((Double)object).isNaN() ? "" : decimalFormat.format(object));
            } else {
                this.tf.setText(null);
            }
            this.tf.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.selectAll();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        @Override
        public String getControlValue() {
            Number number;
            NumberFormat numberFormat = NumberFormat.getInstance(Localization.getLocale());
            ParsePosition parsePosition = new ParsePosition(0);
            if (this.tf.getText() != null && (number = numberFormat.parse(this.tf.getText(), parsePosition)) != null && parsePosition.getIndex() == this.tf.getText().length()) {
                return String.valueOf(number.doubleValue());
            }
            return this.tf.getText();
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    block6: {
                        if (keyEvent.getCode() == KeyCode.ENTER) {
                            try {
                                if (tf.getText().equals("")) {
                                    this.endEdit(true);
                                    break block6;
                                }
                                this.tryParsing();
                                this.endEdit(true);
                            }
                            catch (Exception exception) {}
                        } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                            this.endEdit(false);
                        }
                    }
                }
            });
            this.tf.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    try {
                        if (tf.getText().equals("")) {
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        } else {
                            this.tryParsing();
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        }
                    }
                    catch (Exception exception) {
                        tf.getStyleClass().add((Object)"error");
                    }
                }
            });
        }

        private void tryParsing() throws ParseException {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Localization.getLocale());
            ParsePosition parsePosition = new ParsePosition(0);
            numberFormat.parse(this.tf.getText(), parsePosition);
            if (parsePosition.getIndex() != this.tf.getText().length()) {
                throw new ParseException("Invalid input", parsePosition.getIndex());
            }
        }
    }

    public static class TextAreaEditor
    extends SpreadsheetCellEditor {
        private final TextArea textArea = new TextArea();

        public TextAreaEditor(SpreadsheetView spreadsheetView) {
            super(spreadsheetView);
            this.textArea.setWrapText(true);
            this.textArea.minHeightProperty().bind((ObservableValue)this.textArea.maxHeightProperty());
        }

        @Override
        public void startEdit(Object object, String string, Object ... objectArray) {
            if (object instanceof String || object == null) {
                this.textArea.setText((String)object);
            }
            this.attachEnterEscapeEventHandler();
            this.textArea.requestFocus();
            this.textArea.selectAll();
        }

        @Override
        public String getControlValue() {
            return this.textArea.getText();
        }

        @Override
        public void end() {
            this.textArea.setOnKeyPressed(null);
        }

        public TextArea getEditor() {
            return this.textArea;
        }

        @Override
        public double getMaxHeight() {
            return Double.MAX_VALUE;
        }

        private void attachEnterEscapeEventHandler() {
            this.textArea.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.ENTER) {
                        if (keyEvent.isShiftDown()) {
                            textArea.replaceSelection("\n");
                        } else {
                            this.endEdit(true);
                        }
                    } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        this.endEdit(false);
                    } else if (keyEvent.getCode() == KeyCode.TAB) {
                        if (keyEvent.isShiftDown()) {
                            textArea.replaceSelection("\t");
                            keyEvent.consume();
                        } else {
                            this.endEdit(true);
                        }
                    }
                }
            });
        }
    }

    public static class StringEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField();

        public StringEditor(SpreadsheetView spreadsheetView) {
            super(spreadsheetView);
        }

        @Override
        public void startEdit(Object object, String string, Object ... objectArray) {
            if (object instanceof String || object == null) {
                this.tf.setText((String)object);
            }
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.selectAll();
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.ENTER) {
                        this.endEdit(true);
                    } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        this.endEdit(false);
                    }
                }
            });
        }
    }

    public static class ObjectEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField();

        public ObjectEditor(SpreadsheetView spreadsheetView) {
            super(spreadsheetView);
        }

        @Override
        public void startEdit(Object object, String string, Object ... objectArray) {
            if (object instanceof String) {
                this.tf.setText(object.toString());
            }
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent keyEvent) {
                    if (keyEvent.getCode() == KeyCode.ENTER) {
                        this.endEdit(true);
                    } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        this.endEdit(false);
                    }
                }
            });
        }
    }
}

