/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import org.controlsfx.control.CheckModel;

public class CheckTreeView<T>
extends TreeView<T> {
    private ObjectProperty<CheckModel<TreeItem<T>>> checkModel = new SimpleObjectProperty((Object)this, "checkModel");

    public CheckTreeView() {
        this(null);
    }

    public CheckTreeView(CheckBoxTreeItem<T> checkBoxTreeItem) {
        super(checkBoxTreeItem);
        this.rootProperty().addListener(observable -> this.updateCheckModel());
        this.updateCheckModel();
        this.setCellFactory(CheckBoxTreeCell.forTreeView());
    }

    protected void updateCheckModel() {
        if (this.getRoot() != null) {
            this.setCheckModel(new CheckTreeViewCheckModel(this));
        }
    }

    public BooleanProperty getItemBooleanProperty(int n2) {
        CheckBoxTreeItem checkBoxTreeItem = (CheckBoxTreeItem)this.getTreeItem(n2);
        return checkBoxTreeItem.selectedProperty();
    }

    public final void setCheckModel(CheckModel<TreeItem<T>> checkModel) {
        this.checkModelProperty().set(checkModel);
    }

    public final CheckModel<TreeItem<T>> getCheckModel() {
        return this.checkModel == null ? null : (CheckModel)this.checkModel.get();
    }

    public final ObjectProperty<CheckModel<TreeItem<T>>> checkModelProperty() {
        return this.checkModel;
    }

    private static class CheckTreeViewCheckModel<T>
    implements CheckModel<TreeItem<T>> {
        private final CheckTreeView<T> treeView;
        private final TreeItem<T> root;
        private ObservableList<TreeItem<T>> checkedItems = FXCollections.observableArrayList();

        CheckTreeViewCheckModel(CheckTreeView<T> checkTreeView) {
            this.treeView = checkTreeView;
            this.root = checkTreeView.getRoot();
            this.root.addEventHandler(CheckBoxTreeItem.checkBoxSelectionChangedEvent(), treeModificationEvent -> {
                CheckBoxTreeItem checkBoxTreeItem = treeModificationEvent.getTreeItem();
                if (checkBoxTreeItem.isSelected()) {
                    this.check((TreeItem<T>)checkBoxTreeItem);
                } else {
                    this.clearCheck((TreeItem<T>)checkBoxTreeItem);
                }
            });
            this.clearChecks();
            for (int i2 = 0; i2 < checkTreeView.getExpandedItemCount(); ++i2) {
                CheckBoxTreeItem checkBoxTreeItem = (CheckBoxTreeItem)checkTreeView.getTreeItem(i2);
                if (!checkBoxTreeItem.isSelected() || checkBoxTreeItem.isIndeterminate()) continue;
                this.check((TreeItem<T>)checkBoxTreeItem);
            }
        }

        @Override
        public int getItemCount() {
            return this.treeView.getExpandedItemCount();
        }

        @Override
        public ObservableList<TreeItem<T>> getCheckedItems() {
            return this.checkedItems;
        }

        @Override
        public void checkAll() {
            this.iterateOverTree(this::check);
        }

        @Override
        public void clearCheck(TreeItem<T> treeItem) {
            if (treeItem instanceof CheckBoxTreeItem) {
                ((CheckBoxTreeItem)treeItem).setSelected(false);
            }
            this.checkedItems.remove(treeItem);
        }

        @Override
        public void clearChecks() {
            ArrayList<TreeItem<T>> arrayList = new ArrayList<TreeItem<T>>(this.checkedItems);
            for (TreeItem treeItem : arrayList) {
                this.clearCheck(treeItem);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.checkedItems.isEmpty();
        }

        @Override
        public boolean isChecked(TreeItem<T> treeItem) {
            return this.checkedItems.contains(treeItem);
        }

        @Override
        public void check(TreeItem<T> treeItem) {
            if (treeItem instanceof CheckBoxTreeItem) {
                ((CheckBoxTreeItem)treeItem).setSelected(true);
            }
            if (!this.checkedItems.contains(treeItem)) {
                this.checkedItems.add(treeItem);
            }
        }

        @Override
        public void toggleCheckState(TreeItem<T> treeItem) {
            if (this.isChecked(treeItem)) {
                this.clearCheck(treeItem);
            } else {
                this.check(treeItem);
            }
        }

        private void iterateOverTree(Consumer<TreeItem<T>> consumer) {
            this.processNode(consumer, this.root);
        }

        private void processNode(Consumer<TreeItem<T>> consumer, TreeItem<T> treeItem) {
            if (treeItem == null) {
                return;
            }
            consumer.accept(treeItem);
            this.processChildren((Consumer<TreeItem<T>>)consumer, (List<TreeItem<T>>)treeItem.getChildren());
        }

        private void processChildren(Consumer<TreeItem<T>> consumer, List<TreeItem<T>> list) {
            if (list == null) {
                return;
            }
            for (TreeItem<T> treeItem : list) {
                this.processNode(consumer, treeItem);
            }
        }
    }
}

