/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.Protocol;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

public final class Http2Connection
implements Closeable {
    private static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private static final ExecutorService listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkHttp Http2Connection", true));
    final boolean client;
    final Listener listener;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    final String hostname;
    int lastGoodStreamId;
    int nextStreamId;
    boolean shutdown;
    private final ScheduledExecutorService writerExecutor;
    private final ExecutorService pushExecutor;
    final PushObserver pushObserver;
    private boolean awaitingPong;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    final Settings peerSettings = new Settings();
    boolean receivedInitialPeerSettings = false;
    final Socket socket;
    final Http2Writer writer;
    final ReaderRunnable readerRunnable;
    final Set<Integer> currentPushRequests = new LinkedHashSet<Integer>();

    Http2Connection(Builder builder) {
        this.pushObserver = builder.pushObserver;
        this.client = builder.client;
        this.listener = builder.listener;
        int n2 = this.nextStreamId = builder.client ? 1 : 2;
        if (builder.client) {
            this.nextStreamId += 2;
        }
        if (builder.client) {
            this.okHttpSettings.set(7, 0x1000000);
        }
        this.hostname = builder.hostname;
        this.writerExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", this.hostname), false));
        if (builder.pingIntervalMillis != 0) {
            this.writerExecutor.scheduleAtFixedRate(new PingRunnable(false, 0, 0), builder.pingIntervalMillis, builder.pingIntervalMillis, TimeUnit.MILLISECONDS);
        }
        this.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory(Util.format("OkHttp %s Push Observer", this.hostname), true));
        this.peerSettings.set(7, 65535);
        this.peerSettings.set(5, 16384);
        this.bytesLeftInWriteWindow = this.peerSettings.getInitialWindowSize();
        this.socket = builder.socket;
        this.writer = new Http2Writer(builder.sink, this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.source, this.client));
    }

    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized Http2Stream getStream(int n2) {
        return this.streams.get(n2);
    }

    synchronized Http2Stream removeStream(int n2) {
        Http2Stream http2Stream = this.streams.remove(n2);
        this.notifyAll();
        return http2Stream;
    }

    public synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    public Http2Stream pushStream(int n2, List<Header> list, boolean bl2) throws IOException {
        if (this.client) {
            throw new IllegalStateException("Client cannot push requests.");
        }
        return this.newStream(n2, list, bl2);
    }

    public Http2Stream newStream(List<Header> list, boolean bl2) throws IOException {
        return this.newStream(0, list, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2Stream newStream(int n2, List<Header> list, boolean bl2) throws IOException {
        boolean bl3;
        Http2Stream http2Stream;
        boolean bl4 = !bl2;
        boolean bl5 = false;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                n3 = this.nextStreamId;
                this.nextStreamId += 2;
                http2Stream = new Http2Stream(n3, this, bl4, bl5, list);
                boolean bl6 = bl3 = !bl2 || this.bytesLeftInWriteWindow == 0L || http2Stream.bytesLeftInWriteWindow == 0L;
                if (http2Stream.isOpen()) {
                    this.streams.put(n3, http2Stream);
                }
            }
            if (n2 == 0) {
                this.writer.synStream(bl4, n3, n2, list);
            } else {
                if (this.client) {
                    throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                }
                this.writer.pushPromise(n2, n3, list);
            }
        }
        if (bl3) {
            this.writer.flush();
        }
        return http2Stream;
    }

    void writeSynReply(int n2, boolean bl2, List<Header> list) throws IOException {
        this.writer.synReply(bl2, n2, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(int n2, boolean bl2, Buffer buffer, long l2) throws IOException {
        if (l2 == 0L) {
            this.writer.data(bl2, n2, buffer, 0);
            return;
        }
        while (l2 > 0L) {
            int n3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.bytesLeftInWriteWindow <= 0L) {
                        if (!this.streams.containsKey(n2)) {
                            throw new IOException("stream closed");
                        }
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                n3 = (int)Math.min(l2, this.bytesLeftInWriteWindow);
                n3 = Math.min(n3, this.writer.maxDataLength());
                this.bytesLeftInWriteWindow -= (long)n3;
            }
            this.writer.data(bl2 && (l2 -= (long)n3) == 0L, n2, buffer, n3);
        }
    }

    void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    void writeSynResetLater(final int n2, final ErrorCode errorCode) {
        try {
            this.writerExecutor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{this.hostname, n2}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writeSynReset(n2, errorCode);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void writeSynReset(int n2, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n2, errorCode);
    }

    void writeWindowUpdateLater(final int n2, final long l2) {
        try {
            this.writerExecutor.execute(new NamedRunnable("OkHttp Window Update %s stream %d", new Object[]{this.hostname, n2}){

                @Override
                public void execute() {
                    try {
                        Http2Connection.this.writer.windowUpdate(n2, l2);
                    }
                    catch (IOException iOException) {
                        Http2Connection.this.failConnection();
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePing(boolean bl2, int n2, int n3) {
        if (!bl2) {
            boolean bl3;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                bl3 = this.awaitingPong;
                this.awaitingPong = true;
            }
            if (bl3) {
                this.failConnection();
                return;
            }
        }
        try {
            this.writer.ping(bl2, n2, n3);
        }
        catch (IOException iOException) {
            this.failConnection();
        }
    }

    void writePingAndAwaitPong() throws IOException, InterruptedException {
        this.writePing(false, 1330343787, -257978967);
        this.awaitPong();
    }

    synchronized void awaitPong() throws IOException, InterruptedException {
        while (this.awaitingPong) {
            this.wait();
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int n2;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    return;
                }
                this.shutdown = true;
                n2 = this.lastGoodStreamId;
            }
            this.writer.goAway(n2, errorCode, Util.EMPTY_BYTE_ARRAY);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(ErrorCode errorCode, ErrorCode errorCode2) throws IOException {
        IOException iOException;
        block16: {
            assert (!Thread.holdsLock(this));
            iOException = null;
            try {
                this.shutdown(errorCode);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            Http2Stream[] http2StreamArray = null;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (!this.streams.isEmpty()) {
                    http2StreamArray = this.streams.values().toArray(new Http2Stream[this.streams.size()]);
                    this.streams.clear();
                }
            }
            if (http2StreamArray != null) {
                for (Http2Connection http2Connection2 : http2StreamArray) {
                    try {
                        ((Http2Stream)((Object)http2Connection2)).close(errorCode2);
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) continue;
                        iOException = iOException3;
                    }
                }
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException4) {
                if (iOException != null) break block16;
                iOException = iOException4;
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException5) {
            iOException = iOException5;
        }
        this.writerExecutor.shutdown();
        this.pushExecutor.shutdown();
        if (iOException != null) {
            throw iOException;
        }
    }

    private void failConnection() {
        try {
            this.close(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        this.start(true);
    }

    void start(boolean bl2) throws IOException {
        if (bl2) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int n2 = this.okHttpSettings.getInitialWindowSize();
            if (n2 != 65535) {
                this.writer.windowUpdate(0, n2 - 65535);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(Settings settings) throws IOException {
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.shutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
            }
            this.writer.settings(settings);
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    boolean pushedStream(int n2) {
        return n2 != 0 && (n2 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushRequestLater(final int n2, final List<Header> list) {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.currentPushRequests.contains(n2)) {
                this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(n2);
        }
        try {
            this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Request[%s]", new Object[]{this.hostname, n2}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    block5: {
                        boolean bl2 = Http2Connection.this.pushObserver.onRequest(n2, list);
                        try {
                            if (!bl2) break block5;
                            Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                            Http2Connection http2Connection = Http2Connection.this;
                            synchronized (http2Connection) {
                                Http2Connection.this.currentPushRequests.remove(n2);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void pushHeadersLater(final int n2, final List<Header> list, final boolean bl2) {
        try {
            this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Headers[%s]", new Object[]{this.hostname, n2}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() {
                    block6: {
                        boolean bl22 = Http2Connection.this.pushObserver.onHeaders(n2, list, bl2);
                        try {
                            if (bl22) {
                                Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                            }
                            if (!bl22 && !bl2) break block6;
                            Http2Connection http2Connection = Http2Connection.this;
                            synchronized (http2Connection) {
                                Http2Connection.this.currentPushRequests.remove(n2);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    void pushDataLater(final int n2, BufferedSource bufferedSource, final int n3, final boolean bl2) throws IOException {
        final Buffer buffer = new Buffer();
        bufferedSource.require(n3);
        bufferedSource.read(buffer, n3);
        if (buffer.size() != (long)n3) {
            throw new IOException(buffer.size() + " != " + n3);
        }
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Data[%s]", new Object[]{this.hostname, n2}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    try {
                        boolean bl22 = Http2Connection.this.pushObserver.onData(n2, buffer, n3, bl2);
                        if (bl22) {
                            Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                        }
                        if (!bl22 && !bl2) break block6;
                        Http2Connection http2Connection = Http2Connection.this;
                        synchronized (http2Connection) {
                            Http2Connection.this.currentPushRequests.remove(n2);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void pushResetLater(final int n2, final ErrorCode errorCode) {
        this.pushExecutor.execute(new NamedRunnable("OkHttp %s Push Reset[%s]", new Object[]{this.hostname, n2}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                Http2Connection.this.pushObserver.onReset(n2, errorCode);
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(n2);
                }
            }
        });
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection http2Connection) {
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;

        ReaderRunnable(Http2Reader http2Reader) {
            super("OkHttp %s", Http2Connection.this.hostname);
            this.reader = http2Reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            ErrorCode errorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode errorCode2 = ErrorCode.INTERNAL_ERROR;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                errorCode = ErrorCode.NO_ERROR;
                errorCode2 = ErrorCode.CANCEL;
            }
            catch (IOException iOException) {
                errorCode = ErrorCode.PROTOCOL_ERROR;
                errorCode2 = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                try {
                    Http2Connection.this.close(errorCode, errorCode2);
                }
                catch (IOException iOException) {}
                Util.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean bl2, int n2, BufferedSource bufferedSource, int n3) throws IOException {
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushDataLater(n2, bufferedSource, n3, bl2);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n2);
            if (http2Stream == null) {
                Http2Connection.this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                bufferedSource.skip(n3);
                return;
            }
            http2Stream.receiveData(bufferedSource, n3);
            if (bl2) {
                http2Stream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean bl2, int n2, int n3, List<Header> list) {
            Http2Stream http2Stream;
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushHeadersLater(n2, list, bl2);
                return;
            }
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                http2Stream = Http2Connection.this.getStream(n2);
                if (http2Stream == null) {
                    if (Http2Connection.this.shutdown) {
                        return;
                    }
                    if (n2 <= Http2Connection.this.lastGoodStreamId) {
                        return;
                    }
                    if (n2 % 2 == Http2Connection.this.nextStreamId % 2) {
                        return;
                    }
                    final Http2Stream http2Stream2 = new Http2Stream(n2, Http2Connection.this, false, bl2, list);
                    Http2Connection.this.lastGoodStreamId = n2;
                    Http2Connection.this.streams.put(n2, http2Stream2);
                    listenerExecutor.execute(new NamedRunnable("OkHttp %s stream %d", new Object[]{Http2Connection.this.hostname, n2}){

                        @Override
                        public void execute() {
                            try {
                                Http2Connection.this.listener.onStream(http2Stream2);
                            }
                            catch (IOException iOException) {
                                Platform.get().log(4, "Http2Connection.Listener failure for " + Http2Connection.this.hostname, iOException);
                                try {
                                    http2Stream2.close(ErrorCode.PROTOCOL_ERROR);
                                }
                                catch (IOException iOException2) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return;
                }
            }
            http2Stream.receiveHeaders(list);
            if (bl2) {
                http2Stream.receiveFin();
            }
        }

        @Override
        public void rstStream(int n2, ErrorCode errorCode) {
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushResetLater(n2, errorCode);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.removeStream(n2);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean bl2, Settings settings) {
            int n2;
            int n3;
            long l2 = 0L;
            Http2Stream[] http2StreamArray = null;
            Http2Connection http2Connection = Http2Connection.this;
            synchronized (http2Connection) {
                n3 = Http2Connection.this.peerSettings.getInitialWindowSize();
                if (bl2) {
                    Http2Connection.this.peerSettings.clear();
                }
                Http2Connection.this.peerSettings.merge(settings);
                this.applyAndAckSettings(settings);
                n2 = Http2Connection.this.peerSettings.getInitialWindowSize();
                if (n2 != -1 && n2 != n3) {
                    l2 = n2 - n3;
                    if (!Http2Connection.this.receivedInitialPeerSettings) {
                        Http2Connection.this.addBytesToWriteWindow(l2);
                        Http2Connection.this.receivedInitialPeerSettings = true;
                    }
                    if (!Http2Connection.this.streams.isEmpty()) {
                        http2StreamArray = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                    }
                }
                listenerExecutor.execute(new NamedRunnable("OkHttp %s settings", new Object[]{Http2Connection.this.hostname}){

                    @Override
                    public void execute() {
                        Http2Connection.this.listener.onSettings(Http2Connection.this);
                    }
                });
            }
            if (http2StreamArray != null && l2 != 0L) {
                http2Connection = http2StreamArray;
                n3 = ((Http2Connection)http2Connection).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Http2Connection http2Connection2;
                    Http2Connection http2Connection3 = http2Connection2 = http2Connection[n2];
                    synchronized (http2Connection3) {
                        ((Http2Stream)((Object)http2Connection2)).addBytesToWriteWindow(l2);
                        continue;
                    }
                }
            }
        }

        private void applyAndAckSettings(final Settings settings) {
            try {
                Http2Connection.this.writerExecutor.execute(new NamedRunnable("OkHttp %s ACK Settings", new Object[]{Http2Connection.this.hostname}){

                    @Override
                    public void execute() {
                        try {
                            Http2Connection.this.writer.applyAndAckSettings(settings);
                        }
                        catch (IOException iOException) {
                            Http2Connection.this.failConnection();
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean bl2, int n2, int n3) {
            if (bl2) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.awaitingPong = false;
                    Http2Connection.this.notifyAll();
                }
            }
            try {
                Http2Connection.this.writerExecutor.execute(new PingRunnable(true, n2, n3));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n2, ErrorCode errorCode, ByteString byteString) {
            if (byteString.size() > 0) {
                // empty if block
            }
            Http2Stream[] http2StreamArray = Http2Connection.this;
            synchronized (Http2Connection.this) {
                Http2Stream[] http2StreamArray2 = Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                Http2Connection.this.shutdown = true;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                for (Http2Stream http2Stream : http2StreamArray2) {
                    if (http2Stream.getId() <= n2 || !http2Stream.isLocallyInitiated()) continue;
                    http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    Http2Connection.this.removeStream(http2Stream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int n2, long l2) {
            if (n2 == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.bytesLeftInWriteWindow += l2;
                    Http2Connection.this.notifyAll();
                }
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n2);
            if (http2Stream != null) {
                Http2Stream http2Stream2 = http2Stream;
                synchronized (http2Stream2) {
                    http2Stream.addBytesToWriteWindow(l2);
                }
            }
        }

        @Override
        public void priority(int n2, int n3, int n4, boolean bl2) {
        }

        @Override
        public void pushPromise(int n2, int n3, List<Header> list) {
            Http2Connection.this.pushRequestLater(n3, list);
        }

        @Override
        public void alternateService(int n2, String string, ByteString byteString, String string2, int n3, long l2) {
        }
    }

    public static class Builder {
        Socket socket;
        String hostname;
        BufferedSource source;
        BufferedSink sink;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        PushObserver pushObserver = PushObserver.CANCEL;
        boolean client;
        int pingIntervalMillis;

        public Builder(boolean bl2) {
            this.client = bl2;
        }

        public Builder socket(Socket socket) throws IOException {
            return this.socket(socket, ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName(), Okio.buffer(Okio.source(socket)), Okio.buffer(Okio.sink(socket)));
        }

        public Builder socket(Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.hostname = string;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder pingIntervalMillis(int n2) {
            this.pingIntervalMillis = n2;
            return this;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    final class PingRunnable
    extends NamedRunnable {
        final boolean reply;
        final int payload1;
        final int payload2;

        PingRunnable(boolean bl2, int n2, int n3) {
            super("OkHttp %s ping %08x%08x", Http2Connection.this.hostname, n2, n3);
            this.reply = bl2;
            this.payload1 = n2;
            this.payload2 = n3;
        }

        @Override
        public void execute() {
            Http2Connection.this.writePing(this.reply, this.payload1, this.payload2);
        }
    }
}

