/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.internal.http.HttpHeaders;

public final class CacheControl {
    public static final CacheControl FORCE_NETWORK = new Builder().noCache().build();
    public static final CacheControl FORCE_CACHE = new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    private final boolean noTransform;
    private final boolean immutable;
    @Nullable
    String headerValue;

    private CacheControl(boolean bl2, boolean bl3, int n2, int n3, boolean bl4, boolean bl5, boolean bl6, int n4, int n5, boolean bl7, boolean bl8, boolean bl9, @Nullable String string) {
        this.noCache = bl2;
        this.noStore = bl3;
        this.maxAgeSeconds = n2;
        this.sMaxAgeSeconds = n3;
        this.isPrivate = bl4;
        this.isPublic = bl5;
        this.mustRevalidate = bl6;
        this.maxStaleSeconds = n4;
        this.minFreshSeconds = n5;
        this.onlyIfCached = bl7;
        this.noTransform = bl8;
        this.immutable = bl9;
        this.headerValue = string;
    }

    CacheControl(Builder builder) {
        this.noCache = builder.noCache;
        this.noStore = builder.noStore;
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.sMaxAgeSeconds = -1;
        this.isPrivate = false;
        this.isPublic = false;
        this.mustRevalidate = false;
        this.maxStaleSeconds = builder.maxStaleSeconds;
        this.minFreshSeconds = builder.minFreshSeconds;
        this.onlyIfCached = builder.onlyIfCached;
        this.noTransform = builder.noTransform;
        this.immutable = builder.immutable;
    }

    public boolean noCache() {
        return this.noCache;
    }

    public boolean noStore() {
        return this.noStore;
    }

    public int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public int sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    public int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    public boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    public boolean noTransform() {
        return this.noTransform;
    }

    public boolean immutable() {
        return this.immutable;
    }

    public static CacheControl parse(Headers headers) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = -1;
        int n3 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n4 = -1;
        int n5 = -1;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = true;
        String string = null;
        int n6 = headers.size();
        for (int i2 = 0; i2 < n6; ++i2) {
            String string2 = headers.name(i2);
            String string3 = headers.value(i2);
            if (string2.equalsIgnoreCase("Cache-Control")) {
                if (string != null) {
                    bl10 = false;
                } else {
                    string = string3;
                }
            } else {
                if (!string2.equalsIgnoreCase("Pragma")) continue;
                bl10 = false;
            }
            int n7 = 0;
            while (n7 < string3.length()) {
                String string4;
                int n8 = n7;
                n7 = HttpHeaders.skipUntil(string3, n7, "=,;");
                String string5 = string3.substring(n8, n7).trim();
                if (n7 == string3.length() || string3.charAt(n7) == ',' || string3.charAt(n7) == ';') {
                    ++n7;
                    string4 = null;
                } else {
                    int n9;
                    ++n7;
                    if ((n7 = HttpHeaders.skipWhitespace(string3, n7)) < string3.length() && string3.charAt(n7) == '\"') {
                        n9 = ++n7;
                        n7 = HttpHeaders.skipUntil(string3, n7, "\"");
                        string4 = string3.substring(n9, n7);
                        ++n7;
                    } else {
                        n9 = n7;
                        n7 = HttpHeaders.skipUntil(string3, n7, ",;");
                        string4 = string3.substring(n9, n7).trim();
                    }
                }
                if ("no-cache".equalsIgnoreCase(string5)) {
                    bl2 = true;
                    continue;
                }
                if ("no-store".equalsIgnoreCase(string5)) {
                    bl3 = true;
                    continue;
                }
                if ("max-age".equalsIgnoreCase(string5)) {
                    n2 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("s-maxage".equalsIgnoreCase(string5)) {
                    n3 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("private".equalsIgnoreCase(string5)) {
                    bl4 = true;
                    continue;
                }
                if ("public".equalsIgnoreCase(string5)) {
                    bl5 = true;
                    continue;
                }
                if ("must-revalidate".equalsIgnoreCase(string5)) {
                    bl6 = true;
                    continue;
                }
                if ("max-stale".equalsIgnoreCase(string5)) {
                    n4 = HttpHeaders.parseSeconds(string4, Integer.MAX_VALUE);
                    continue;
                }
                if ("min-fresh".equalsIgnoreCase(string5)) {
                    n5 = HttpHeaders.parseSeconds(string4, -1);
                    continue;
                }
                if ("only-if-cached".equalsIgnoreCase(string5)) {
                    bl7 = true;
                    continue;
                }
                if ("no-transform".equalsIgnoreCase(string5)) {
                    bl8 = true;
                    continue;
                }
                if (!"immutable".equalsIgnoreCase(string5)) continue;
                bl9 = true;
            }
        }
        if (!bl10) {
            string = null;
        }
        return new CacheControl(bl2, bl3, n2, n3, bl4, bl5, bl6, n4, n5, bl7, bl8, bl9, string);
    }

    public String toString() {
        String string = this.headerValue;
        return string != null ? string : (this.headerValue = this.headerValue());
    }

    private String headerValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.noCache) {
            stringBuilder.append("no-cache, ");
        }
        if (this.noStore) {
            stringBuilder.append("no-store, ");
        }
        if (this.maxAgeSeconds != -1) {
            stringBuilder.append("max-age=").append(this.maxAgeSeconds).append(", ");
        }
        if (this.sMaxAgeSeconds != -1) {
            stringBuilder.append("s-maxage=").append(this.sMaxAgeSeconds).append(", ");
        }
        if (this.isPrivate) {
            stringBuilder.append("private, ");
        }
        if (this.isPublic) {
            stringBuilder.append("public, ");
        }
        if (this.mustRevalidate) {
            stringBuilder.append("must-revalidate, ");
        }
        if (this.maxStaleSeconds != -1) {
            stringBuilder.append("max-stale=").append(this.maxStaleSeconds).append(", ");
        }
        if (this.minFreshSeconds != -1) {
            stringBuilder.append("min-fresh=").append(this.minFreshSeconds).append(", ");
        }
        if (this.onlyIfCached) {
            stringBuilder.append("only-if-cached, ");
        }
        if (this.noTransform) {
            stringBuilder.append("no-transform, ");
        }
        if (this.immutable) {
            stringBuilder.append("immutable, ");
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public static final class Builder {
        boolean noCache;
        boolean noStore;
        int maxAgeSeconds = -1;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean onlyIfCached;
        boolean noTransform;
        boolean immutable;

        public Builder noCache() {
            this.noCache = true;
            return this;
        }

        public Builder noStore() {
            this.noStore = true;
            return this;
        }

        public Builder maxAge(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("maxAge < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            this.maxAgeSeconds = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            return this;
        }

        public Builder maxStale(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("maxStale < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            this.maxStaleSeconds = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            return this;
        }

        public Builder minFresh(int n2, TimeUnit timeUnit) {
            if (n2 < 0) {
                throw new IllegalArgumentException("minFresh < 0: " + n2);
            }
            long l2 = timeUnit.toSeconds(n2);
            this.minFreshSeconds = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            return this;
        }

        public Builder onlyIfCached() {
            this.onlyIfCached = true;
            return this;
        }

        public Builder noTransform() {
            this.noTransform = true;
            return this;
        }

        public Builder immutable() {
            this.immutable = true;
            return this;
        }

        public CacheControl build() {
            return new CacheControl(this);
        }
    }
}

