/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer wrappedBuffer;
    private final boolean autoEnlarge;

    public ByteBufferOutputStream(ByteBuffer byteBuffer, boolean ... blArray) {
        this.wrappedBuffer = byteBuffer;
        this.autoEnlarge = blArray.length > 0 && blArray[0];
    }

    public ByteBuffer buffer() {
        return this.wrappedBuffer;
    }

    private void growTo(int n2) {
        int n3 = this.wrappedBuffer.capacity();
        int n4 = n3 << 1;
        if (n4 - n2 < 0) {
            n4 = n2;
        }
        ByteBuffer byteBuffer = this.wrappedBuffer;
        this.wrappedBuffer = this.wrappedBuffer.isDirect() ? ByteBuffer.allocateDirect(n4) : ByteBuffer.allocate(n4);
        byteBuffer.flip();
        this.wrappedBuffer.put(byteBuffer);
    }

    @Override
    public void write(int n2) {
        try {
            this.wrappedBuffer.put((byte)n2);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (this.autoEnlarge) {
                int n3 = this.wrappedBuffer.capacity() * 2;
                this.growTo(n3);
                this.write(n2);
            }
            throw bufferOverflowException;
        }
    }

    @Override
    public void write(byte[] byArray) {
        int n2 = 0;
        try {
            n2 = this.wrappedBuffer.position();
            this.wrappedBuffer.put(byArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (this.autoEnlarge) {
                int n3 = Math.max(this.wrappedBuffer.capacity() * 2, n2 + byArray.length);
                this.growTo(n3);
                this.write(byArray);
            }
            throw bufferOverflowException;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        try {
            n4 = this.wrappedBuffer.position();
            this.wrappedBuffer.put(byArray, n2, n3);
        }
        catch (BufferOverflowException bufferOverflowException) {
            if (this.autoEnlarge) {
                int n5 = Math.max(this.wrappedBuffer.capacity() * 2, n4 + n3);
                this.growTo(n5);
                this.write(byArray, n2, n3);
            }
            throw bufferOverflowException;
        }
    }

    public void position(int n2) {
        if (n2 >= this.wrappedBuffer.capacity()) {
            if (this.autoEnlarge) {
                this.growTo(n2);
            } else {
                throw new BufferOverflowException();
            }
        }
        this.wrappedBuffer.position(n2);
    }

    public int position() {
        return this.wrappedBuffer.position();
    }

    public void write(ByteBuffer byteBuffer) {
        this.wrappedBuffer.put(byteBuffer);
    }
}

