/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import io.fair_acc.chartfx.utils.WriteFxImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicScreenCapture
implements Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicScreenCapture.class);
    private static final String DEFAULT_TIME_FORMAT = "yyyyMMdd_HHmmss";
    private static final String FILE_LOGGING_SUFFIX = ".png";
    private final Scene primaryScene;
    private final Path path;
    private final String fileName;
    private final double delay;
    private final double period;
    private Timeline periodicTask;
    private String isoDateTimeFormatString = "yyyyMMdd_HHmmss";
    private final boolean addDateTime;
    protected final List<InvalidationListener> listeners = new LinkedList<InvalidationListener>();
    private final Timer timer = new Timer("sample-update-timer", true);

    public PeriodicScreenCapture(Path path, String string, Scene scene, double d2, double d3) {
        this(path, string, scene, d2, d3, false);
    }

    public PeriodicScreenCapture(Path path, String string, Scene scene, double d2, double d3, boolean bl2) {
        this.path = path;
        this.fileName = string.replace(FILE_LOGGING_SUFFIX, "").replace(".PNG", "");
        this.primaryScene = scene;
        this.delay = d2;
        this.period = d3;
        this.addDateTime = bl2;
    }

    public void addListener(InvalidationListener invalidationListener) {
        Objects.requireNonNull(invalidationListener, "InvalidationListener must not be null");
        if (!this.listeners.contains(invalidationListener)) {
            this.listeners.add(invalidationListener);
        }
    }

    protected void executeFireInvalidated() {
        for (InvalidationListener invalidationListener : new ArrayList<InvalidationListener>(this.listeners)) {
            invalidationListener.invalidated((Observable)this);
        }
    }

    public void fireInvalidated() {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.executeFireInvalidated();
        } else {
            Platform.runLater(this::executeFireInvalidated);
        }
    }

    public String getIsoDateTimeFormatterString() {
        return this.isoDateTimeFormatString;
    }

    public void performScreenCapture() {
        try {
            final WritableImage writableImage = this.primaryScene.snapshot(null);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PeriodicScreenCapture.this.writeImage((Image)writableImage);
                }
            }, 0L);
            LOGGER.debug("this is called periodic on UI thread");
        }
        catch (Exception exception) {
            LOGGER.error("error while writing screen captured image to file", exception);
        }
    }

    public void removeListener(InvalidationListener invalidationListener) {
        this.listeners.remove(invalidationListener);
    }

    public void setIsoDateTimeFormatterString(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("new format must not be null or empty");
        }
        this.isoDateTimeFormatString = string;
    }

    public void start() {
        if (this.periodicTask != null) {
            this.periodicTask.stop();
        }
        this.periodicTask = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)this.period), actionEvent -> this.performScreenCapture(), new KeyValue[0])});
        this.periodicTask.setDelay(Duration.seconds((double)this.delay));
        this.periodicTask.setCycleCount(-1);
        this.periodicTask.play();
    }

    public void stop() {
        if (this.periodicTask != null) {
            this.periodicTask.stop();
        }
    }

    private void writeImage(Image image) {
        long l2 = System.currentTimeMillis();
        try {
            String string = this.getIsoDateTimeFormatterString();
            String string2 = this.addDateTime && string != null && !string.isEmpty() ? this.path.toFile() + String.format("/%s_%s%s", this.fileName, PeriodicScreenCapture.getISODate(l2, string), FILE_LOGGING_SUFFIX) : this.path.toFile() + "/" + this.fileName;
            String string3 = string2 + "_temp.png";
            File file = new File(string3);
            if (file.getParentFile() != null && file.getParentFile().mkdirs()) {
                LOGGER.info("needed to create directory for file: " + string2);
            }
            WriteFxImage.savePng(image, file);
            Files.move(Paths.get(string3, new String[0]), Paths.get(string2, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            this.fireInvalidated();
            LOGGER.debug("write screenshot to " + string3 + " -> " + string2);
        }
        catch (Exception exception) {
            LOGGER.error("could not write to file: '" + this.fileName + "'", exception);
        }
    }

    protected static String getISODate(long l2, String string) {
        long l3 = TimeUnit.MILLISECONDS.toMillis(l2);
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(new Date(l3));
    }
}

