/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class DragResizerUtil {
    private static final int MARGIN = 8;
    private static final double MIN_HEIGHT = 20.0;
    private static final double MIN_WIDTH = 30.0;
    private final Node node;
    protected static final OnDragResizeEventListener DEFAULT_LISTENER = new DefaultListener();
    private final OnDragResizeEventListener listener;
    private double clickX;
    private double clickY;
    private double nodeHeight;
    private double nodeWidth;
    private double nodePositionX;
    private double nodePositionY;
    private DragDirection state = DragDirection.DEFAULT;

    protected DragResizerUtil() {
        this.node = new Region();
        this.listener = DEFAULT_LISTENER;
    }

    protected DragResizerUtil(Node node, OnDragResizeEventListener onDragResizeEventListener) {
        this.node = node;
        OnDragResizeEventListener onDragResizeEventListener2 = this.listener = onDragResizeEventListener != null ? onDragResizeEventListener : DEFAULT_LISTENER;
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        node.setOnMousePressed(this::mousePressed);
        node.setOnMouseDragged(this::mouseDragged);
        node.setOnMouseMoved(this::mouseOver);
        node.setOnMouseReleased(this::mouseReleased);
        node.setOnMouseClicked(this::resetNodeSize);
    }

    protected DragDirection currentMouseState(MouseEvent mouseEvent) {
        boolean bl2 = DragResizerUtil.isLeftResizeZone(mouseEvent);
        boolean bl3 = this.isRightResizeZone(mouseEvent);
        boolean bl4 = DragResizerUtil.isTopResizeZone(mouseEvent);
        boolean bl5 = this.isBottomResizeZone(mouseEvent);
        if (bl2 && bl4) {
            return DragDirection.NW_RESIZE;
        }
        if (bl2 && bl5) {
            return DragDirection.SW_RESIZE;
        }
        if (bl3 && bl4) {
            return DragDirection.NE_RESIZE;
        }
        if (bl3 && bl5) {
            return DragDirection.SE_RESIZE;
        }
        if (bl3) {
            return DragDirection.E_RESIZE;
        }
        if (bl2) {
            return DragDirection.W_RESIZE;
        }
        if (bl4) {
            return DragDirection.N_RESIZE;
        }
        if (bl5) {
            return DragDirection.S_RESIZE;
        }
        if (this.isInDragZone(mouseEvent)) {
            return DragDirection.DRAG;
        }
        return DragDirection.DEFAULT;
    }

    protected static boolean intersect(double d2, double d3) {
        return d2 + 8.0 > d3 && d2 - 8.0 < d3;
    }

    protected boolean isBottomResizeZone(MouseEvent mouseEvent) {
        return DragResizerUtil.intersect(this.node.getBoundsInParent().getHeight(), mouseEvent.getY());
    }

    protected boolean isInDragZone(MouseEvent mouseEvent) {
        Bounds bounds = this.node.getBoundsInParent();
        double d2 = bounds.getMinX() + mouseEvent.getX();
        double d3 = bounds.getMinY() + mouseEvent.getY();
        double d4 = bounds.getMinX() + 8.0;
        double d5 = bounds.getMinY() + 8.0;
        double d6 = bounds.getMinX() + bounds.getWidth() - 8.0;
        double d7 = bounds.getMinY() + bounds.getHeight() - 8.0;
        return d2 > d4 && d2 < d6 && d3 > d5 && d3 < d7;
    }

    protected boolean isInResizeZone(MouseEvent mouseEvent) {
        return DragResizerUtil.isLeftResizeZone(mouseEvent) || this.isRightResizeZone(mouseEvent) || this.isBottomResizeZone(mouseEvent) || DragResizerUtil.isTopResizeZone(mouseEvent);
    }

    protected static boolean isLeftResizeZone(MouseEvent mouseEvent) {
        return DragResizerUtil.intersect(0.0, mouseEvent.getX());
    }

    protected boolean isRightResizeZone(MouseEvent mouseEvent) {
        Bounds bounds = this.node.getBoundsInParent();
        return DragResizerUtil.intersect(bounds.getWidth(), mouseEvent.getX());
    }

    protected static boolean isTopResizeZone(MouseEvent mouseEvent) {
        return DragResizerUtil.intersect(0.0, mouseEvent.getY());
    }

    protected void resetNodeSize(MouseEvent mouseEvent) {
        if (!mouseEvent.isPrimaryButtonDown() || mouseEvent.getClickCount() < 2) {
            return;
        }
        if (!(this.node instanceof Region)) {
            return;
        }
        ((Region)this.node).setPrefWidth(-1.0);
        ((Region)this.node).setPrefHeight(-1.0);
    }

    protected void setNewInitialEventCoordinates(MouseEvent mouseEvent) {
        Bounds bounds = this.node.getBoundsInParent();
        this.nodePositionX = bounds.getMinX();
        this.nodePositionY = bounds.getMinY();
        this.nodeHeight = bounds.getHeight();
        this.nodeWidth = bounds.getWidth();
        this.clickX = mouseEvent.getX();
        this.clickY = mouseEvent.getY();
    }

    protected void mouseDragged(MouseEvent mouseEvent) {
        Bounds bounds = this.node.getBoundsInParent();
        double d2 = bounds.getMinX() + mouseEvent.getX();
        double d3 = bounds.getMinY() + mouseEvent.getY();
        if (this.state == DragDirection.DRAG) {
            this.listener.onDrag(this.node, d2 - this.clickX, d3 - this.clickY, this.nodeWidth, this.nodeHeight);
            return;
        }
        if (this.state == DragDirection.DEFAULT) {
            return;
        }
        double d4 = this.nodePositionX;
        double d5 = this.nodePositionY;
        double d6 = this.nodeHeight;
        double d7 = this.nodeWidth;
        if (this.state.isEast()) {
            d7 = d2 - this.nodePositionX;
        }
        if (this.state.isWest()) {
            d4 = d2;
            d7 = this.nodeWidth + this.nodePositionX - d4;
        }
        if (this.state.isSouth()) {
            d6 = d3 - this.nodePositionY;
        }
        if (this.state.isNorth()) {
            d5 = d3;
            d6 = this.nodeHeight + this.nodePositionY - d5;
        }
        if (d7 < 30.0) {
            if (this.state == DragDirection.W_RESIZE || this.state == DragDirection.NW_RESIZE || this.state == DragDirection.SW_RESIZE) {
                d4 = d4 - 30.0 + d7;
            }
            d7 = 30.0;
        }
        if (d6 < 20.0) {
            if (this.state == DragDirection.N_RESIZE || this.state == DragDirection.NW_RESIZE || this.state == DragDirection.NE_RESIZE) {
                d5 = d5 + d6 - 20.0;
            }
            d6 = 20.0;
        }
        this.listener.onResize(this.node, d4, d5, d7, d6);
    }

    protected void mouseOver(MouseEvent mouseEvent) {
        DragDirection dragDirection = this.currentMouseState(mouseEvent);
        Cursor cursor = DragResizerUtil.getCursorForState(dragDirection);
        this.node.setCursor(cursor);
    }

    protected void mousePressed(MouseEvent mouseEvent) {
        if (this.isInResizeZone(mouseEvent)) {
            this.setNewInitialEventCoordinates(mouseEvent);
            this.state = this.currentMouseState(mouseEvent);
            this.resetNodeSize(mouseEvent);
        } else if (this.isInDragZone(mouseEvent)) {
            this.setNewInitialEventCoordinates(mouseEvent);
            this.state = DragDirection.DRAG;
        } else {
            this.state = DragDirection.DEFAULT;
        }
    }

    protected void mouseReleased(MouseEvent mouseEvent) {
        this.node.setCursor(Cursor.DEFAULT);
        this.state = DragDirection.DEFAULT;
    }

    public static void makeResizable(Node node) {
        DragResizerUtil.makeResizable(node, null);
    }

    public static void makeResizable(Node node, OnDragResizeEventListener onDragResizeEventListener) {
        new DragResizerUtil(node, onDragResizeEventListener);
    }

    protected static Cursor getCursorForState(DragDirection dragDirection) {
        switch (dragDirection) {
            case NW_RESIZE: {
                return Cursor.NW_RESIZE;
            }
            case SW_RESIZE: {
                return Cursor.SW_RESIZE;
            }
            case NE_RESIZE: {
                return Cursor.NE_RESIZE;
            }
            case SE_RESIZE: {
                return Cursor.SE_RESIZE;
            }
            case E_RESIZE: {
                return Cursor.E_RESIZE;
            }
            case W_RESIZE: {
                return Cursor.W_RESIZE;
            }
            case N_RESIZE: {
                return Cursor.N_RESIZE;
            }
            case S_RESIZE: {
                return Cursor.S_RESIZE;
            }
        }
        return Cursor.DEFAULT;
    }

    public static enum DragDirection {
        DEFAULT,
        DRAG,
        E_RESIZE,
        N_RESIZE,
        NE_RESIZE,
        NW_RESIZE,
        S_RESIZE,
        SE_RESIZE,
        SW_RESIZE,
        W_RESIZE;


        public boolean isEast() {
            switch (this) {
                case NE_RESIZE: 
                case SE_RESIZE: 
                case E_RESIZE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isWest() {
            switch (this) {
                case NW_RESIZE: 
                case SW_RESIZE: 
                case W_RESIZE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isNorth() {
            switch (this) {
                case NW_RESIZE: 
                case NE_RESIZE: 
                case N_RESIZE: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSouth() {
            switch (this) {
                case SW_RESIZE: 
                case SE_RESIZE: 
                case S_RESIZE: {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface OnDragResizeEventListener {
        public void onDrag(Node var1, double var2, double var4, double var6, double var8);

        public void onResize(Node var1, double var2, double var4, double var6, double var8);
    }

    private static class DefaultListener
    implements OnDragResizeEventListener {
        private DefaultListener() {
        }

        @Override
        public void onDrag(Node node, double d2, double d3, double d4, double d5) {
            this.setNodeSize(node, d2, d3, d4, d5);
        }

        @Override
        public void onResize(Node node, double d2, double d3, double d4, double d5) {
            this.setNodeSize(node, d2, d3, d4, d5);
        }

        protected void setNodeSize(Node node, double d2, double d3, double d4, double d5) {
            node.setLayoutX(d2);
            node.setLayoutY(d3);
            if (node instanceof Canvas) {
                ((Canvas)node).setWidth(d4);
                ((Canvas)node).setHeight(d5);
            } else if (node instanceof Rectangle) {
                ((Rectangle)node).setWidth(d4);
                ((Rectangle)node).setHeight(d5);
            } else if (node instanceof Region) {
                ((Region)node).setPrefWidth(d4);
                ((Region)node).setPrefHeight(d5);
            }
        }
    }
}

