/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.css;

import io.fair_acc.chartfx.marker.DefaultMarker;
import io.fair_acc.chartfx.marker.Marker;
import io.fair_acc.chartfx.ui.css.AbstractStyleParser;
import java.util.Optional;
import java.util.OptionalDouble;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class DataSetStyleParser
extends AbstractStyleParser {
    private Boolean visible;
    private double intensity;
    private Marker markerType;
    private double markerLineWidth;
    private double markerSize;
    private Paint markerColor;
    private double[] markerLineDashes;
    private double lineWidth;
    private Color lineColor;
    private double[] lineDashes;
    private Paint fillColor;
    private Paint strokeColor;
    private double strokeWidth;
    private double[] strokeDashPattern;
    private Font font;
    private FontWeight fontWeight;
    private double fontSize;
    private FontPosture fontStyle;

    public static DataSetStyleParser newInstance() {
        return new DataSetStyleParser();
    }

    protected DataSetStyleParser() {
    }

    @Override
    protected boolean parseEntry(String string2, String string3) {
        switch (string2) {
            case "visibility": {
                this.visible = this.parse(string3, string -> {
                    switch (string) {
                        case "visible": {
                            return true;
                        }
                        case "hidden": {
                            return false;
                        }
                    }
                    return null;
                });
                return this.isValid(this.visible);
            }
            case "-fx-intensity": {
                this.intensity = this.parseDouble(string3);
                return this.isValid(this.intensity);
            }
            case "-fx-marker-type": {
                this.markerType = this.parse(string3, DefaultMarker::get);
                return this.isValid(this.markerType);
            }
            case "-fx-marker-line-width": {
                this.markerLineWidth = this.parseDouble(string3);
                return this.isValid(this.markerLineWidth);
            }
            case "-fx-marker-size": {
                this.markerSize = this.parseDouble(string3);
                return this.isValid(this.markerSize);
            }
            case "-fx-marker-color": {
                this.markerColor = this.parseColor(string3);
                return this.isValid(this.markerColor);
            }
            case "-fx-marker-line-dash-array": {
                this.markerLineDashes = this.parseDoubleArray(string3);
                return this.isValid(this.markerLineDashes);
            }
            case "-fx-line-width": {
                this.lineWidth = this.parseDouble(string3);
                return this.isValid(this.lineWidth);
            }
            case "-fx-line-color": {
                this.lineColor = this.parseColor(string3);
                return this.isValid(this.lineColor);
            }
            case "-fx-line-dash-array": {
                this.lineDashes = this.parseDoubleArray(string3);
                return this.isValid(this.lineDashes);
            }
            case "-fx-fill": {
                this.fillColor = this.parseColor(string3);
                return this.isValid(this.fillColor);
            }
            case "-fx-stroke": {
                this.strokeColor = this.parseColor(string3);
                return this.isValid(this.strokeColor);
            }
            case "-fx-stroke-width": {
                this.strokeWidth = this.parseDouble(string3);
                return this.isValid(this.strokeWidth);
            }
            case "-fx-stroke-dash-array": {
                this.strokeDashPattern = this.parseDoubleArray(string3);
                return this.isValid(this.strokeDashPattern);
            }
            case "-fx-font": {
                this.font = this.parse(string3, Font::font);
                return this.isValid(this.font);
            }
            case "-fx-font-weight": {
                this.fontWeight = this.parse(string3, FontWeight::findByName);
                return this.isValid(this.fontWeight);
            }
            case "-fx-font-size": {
                this.fontSize = this.parseDouble(string3);
                return this.isValid(this.fontSize);
            }
            case "-fx-font-style": {
                this.fontStyle = this.parse(string3, FontPosture::findByName);
                return this.isValid(this.fontStyle);
            }
        }
        return false;
    }

    public Optional<Boolean> getVisible() {
        return this.optional(this.visible);
    }

    public OptionalDouble getIntensity() {
        return this.optional(this.intensity);
    }

    public Optional<Marker> getMarkerType() {
        return this.optional(this.markerType);
    }

    public OptionalDouble getMarkerLineWidth() {
        return this.optional(this.markerLineWidth);
    }

    public OptionalDouble getMarkerSize() {
        return this.optional(this.markerSize);
    }

    public Optional<Paint> getMarkerColor() {
        return this.optional(this.markerColor);
    }

    public Optional<double[]> getMarkerLineDashes() {
        return this.optional(this.markerLineDashes);
    }

    public OptionalDouble getLineWidth() {
        return this.optional(this.lineWidth);
    }

    public Optional<Paint> getLineColor() {
        return this.optional(this.lineColor);
    }

    public Optional<double[]> getLineDashes() {
        return this.optional(this.lineDashes);
    }

    public Optional<Paint> getFillColor() {
        return this.optional(this.fillColor);
    }

    public Optional<Paint> getStrokeColor() {
        return this.optional(this.strokeColor);
    }

    public OptionalDouble getStrokeWidth() {
        return this.optional(this.strokeWidth);
    }

    public Optional<double[]> getStrokeDashes() {
        return this.optional(this.strokeDashPattern);
    }

    public Optional<Font> getFont() {
        return this.optional(this.font);
    }

    public Optional<FontWeight> getFontWeight() {
        return this.optional(this.fontWeight);
    }

    public OptionalDouble getFontSize() {
        return this.optional(this.fontSize);
    }

    public Optional<FontPosture> getFontStyle() {
        return this.optional(this.fontStyle);
    }

    public Optional<Font> getFontFull() {
        if (this.font == null && Double.isNaN(this.fontSize) && this.fontStyle == null && this.fontWeight == null) {
            return Optional.empty();
        }
        if (this.fontWeight == null && this.fontStyle == null && Double.isNaN(this.fontSize)) {
            return Optional.of(this.font);
        }
        if (this.fontWeight == null && this.fontStyle == null) {
            return Optional.of(Font.font((String)(this.font == null ? null : this.font.getName()), (double)(Double.isNaN(this.fontSize) ? -1.0 : this.fontSize)));
        }
        if (this.fontWeight == null) {
            return Optional.of(Font.font((String)(this.font == null ? null : this.font.getName()), (FontPosture)this.fontStyle, (double)(Double.isNaN(this.fontSize) ? -1.0 : this.fontSize)));
        }
        if (this.fontStyle == null) {
            return Optional.of(Font.font((String)(this.font == null ? null : this.font.getName()), (FontWeight)this.fontWeight, (double)(Double.isNaN(this.fontSize) ? -1.0 : this.fontSize)));
        }
        return Optional.of(Font.font((String)(this.font == null ? null : this.font.getName()), (FontWeight)this.fontWeight, (FontPosture)this.fontStyle, (double)(Double.isNaN(this.fontSize) ? -1.0 : this.fontSize)));
    }

    @Override
    protected void clear() {
        this.visible = null;
        this.intensity = Double.NaN;
        this.markerType = null;
        this.markerLineWidth = Double.NaN;
        this.markerSize = Double.NaN;
        this.markerColor = null;
        this.markerLineDashes = null;
        this.lineWidth = Double.NaN;
        this.lineColor = null;
        this.lineDashes = null;
        this.fillColor = null;
        this.strokeColor = null;
        this.strokeWidth = Double.NaN;
        this.strokeDashPattern = null;
        this.font = null;
        this.fontWeight = null;
        this.fontSize = Double.NaN;
        this.fontStyle = null;
    }
}

