/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import io.fair_acc.chartfx.ui.SidesPane;
import io.fair_acc.chartfx.ui.geometry.Side;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class SidesPaneSample
extends Application {
    protected static final int SHUTDOWN_PERIOD = 5000;
    protected static final int UPDATE_PERIOD = 100;

    public void start(Stage stage) {
        stage.setTitle("TitledPane");
        Label label = new Label("top content\ntop content");
        Pane pane = new Pane(new Node[]{label});
        pane.setStyle("-fx-background-color: rgba(0,255,0,0.2)");
        Pane pane2 = new Pane(new Node[]{new Label("left content")});
        pane2.setStyle("-fx-background-color: rgba(255,0,0,0.2)");
        Button button = new Button("press me to shrink");
        button.setOnAction(actionEvent -> pane.setPrefHeight(50.0));
        Button button2 = new Button("press me to enlarge");
        button2.setOnAction(actionEvent -> pane.setPrefHeight(100.0));
        Pane pane3 = new Pane(new Node[]{new HBox(new Node[]{new Label("main content"), button, button2})});
        SidesPane sidesPane = new SidesPane();
        sidesPane.setTriggerDistance(50.0);
        Scene scene = new Scene((Parent)sidesPane, 800.0, 600.0);
        sidesPane.setTop((Node)pane);
        sidesPane.setLeft((Node)pane2);
        sidesPane.setContent((Node)pane3);
        pane.setOnMouseClicked(mouseEvent -> {
            boolean bl2 = sidesPane.isPinned(Side.TOP) == false;
            sidesPane.setPinned(Side.TOP, bl2);
            label.textProperty().set((Object)String.format("top content(%b)%ntop content(%b)", bl2, bl2));
        });
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] stringArray) {
        Application.launch((String[])stringArray);
    }
}

