/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.utils;

import io.fair_acc.dataset.utils.AssertUtils;
import java.util.WeakHashMap;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;

public final class FillPatternStyleHelper {
    private static final int HATCH_WINDOW_SIZE = 8;
    private static int hatchSpacing = 10;
    private static int hatchAngle = 45;
    protected static WeakHashMap<Color, ImagePattern> defaultHatchCache = new WeakHashMap();
    protected static WeakHashMap<Paint, WeakHashMap<Double, Image>> defaultHatchCacheWithStrokeWidth = new WeakHashMap();

    private static Image createDefaultHatch(Paint paint, double d2) {
        Pane pane;
        WeakHashMap<Double, Image> weakHashMap = defaultHatchCacheWithStrokeWidth.get(paint);
        if (weakHashMap != null && (pane = weakHashMap.get(d2)) != null) {
            return pane;
        }
        pane = new Pane();
        pane.setPrefSize(10.0, 10.0);
        Line line = new Line(-5.0, -5.0, 25.0, 25.0);
        Line line2 = new Line(-5.0, 25.0, 25.0, -5.0);
        line.setSmooth(false);
        line2.setSmooth(false);
        line.setStroke(paint);
        line2.setStroke(paint);
        line.setStrokeWidth(d2);
        line2.setStrokeWidth(d2);
        pane.getChildren().addAll((Object[])new Node[]{line, line2});
        pane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.0)");
        Scene scene = new Scene((Parent)pane);
        scene.setFill((Paint)Color.TRANSPARENT);
        WritableImage writableImage = pane.snapshot(null, null);
        if (weakHashMap == null) {
            WeakHashMap<Double, WritableImage> weakHashMap2 = new WeakHashMap<Double, WritableImage>();
            weakHashMap2.put(d2, writableImage);
            defaultHatchCacheWithStrokeWidth.put(paint, weakHashMap2);
        } else {
            weakHashMap.put(d2, (Image)writableImage);
        }
        return writableImage;
    }

    private static Image createHatch(FillPattern fillPattern, Paint paint, double d2) {
        Pane pane = new Pane();
        pane.setPrefSize(8.0, 8.0);
        pane.setStyle("-fx-background-color: rgba(0, 0, 0, 0.0)");
        int n2 = 45;
        int n3 = 40;
        FillPatternStyleHelper.drawHatching(pane, fillPattern, -40, -40, 40, 40, paint, d2, 45, hatchSpacing);
        Scene scene = new Scene((Parent)pane);
        scene.setFill((Paint)Color.TRANSPARENT);
        return pane.snapshot(null, null);
    }

    private static void drawHatching(Pane pane, FillPattern fillPattern, int n2, int n3, int n4, int n5, Paint paint, double d2, int n6, int n7) {
        int n8 = n6;
        switch (fillPattern) {
            case HATCH0: {
                n8 = 0;
                break;
            }
            case HATCH30: {
                n8 = 30;
                break;
            }
            case HATCH45: 
            case HATCHCROSS1: {
                n8 = 45;
                break;
            }
            case HATCH60: {
                n8 = 60;
                break;
            }
            case HATCH90: 
            case HATCHCROSS2: {
                n8 = 90;
                break;
            }
        }
        if (fillPattern != FillPattern.HATCHCROSS1 && fillPattern != FillPattern.HATCHCROSS2) {
            int n9 = n7;
            int n10 = (n5 - n3) / 2;
            int n11 = n3 + n10;
            if (n8 % 180 != 0 && (n8 + 90) % 180 != 0) {
                double d3 = Math.sin(Math.PI * (double)n8 / 180.0);
                double d4 = Math.cos(Math.PI * (double)n8 / 180.0);
                n9 = (int)((double)n7 / d4);
                int n12 = (int)((double)n10 / d4);
                int n13 = (int)((double)n10 / d3);
                for (int i2 = n2 - n12; i2 < n4 + n12; i2 += n9) {
                    int n14 = i2 - n12;
                    int n15 = i2 + n12;
                    int n16 = n11 + n13;
                    int n17 = n11 - n13;
                    Line line = new Line((double)n14, (double)n16, (double)n15, (double)n17);
                    line.setStroke(paint);
                    line.setStrokeWidth(d2);
                    pane.getChildren().add((Object)line);
                }
            } else if (n8 % 180 != 0) {
                int n18 = n11 + n10;
                int n19 = n11 - n10;
                for (int i3 = n2; i3 < n4; i3 += n9) {
                    Line line = new Line((double)i3, (double)n18, (double)i3, (double)n19);
                    line.setStroke(paint);
                    line.setStrokeWidth(d2);
                    pane.getChildren().add((Object)line);
                }
            } else {
                for (int i4 = n3; i4 < n5; i4 += n9) {
                    Line line = new Line((double)n2, (double)i4, (double)n4, (double)i4);
                    line.setStroke(paint);
                    line.setStrokeWidth(d2);
                    pane.getChildren().add((Object)line);
                }
            }
        } else if (fillPattern == FillPattern.HATCHCROSS1) {
            n8 = 45;
            int n20 = (n5 - n3) / 2;
            int n21 = n3 + n20;
            double d5 = Math.sin(Math.PI * (double)n8 / 180.0);
            double d6 = Math.cos(Math.PI * (double)n8 / 180.0);
            int n22 = (int)((double)n7 / d6);
            int n23 = (int)((double)n20 / d6);
            int n24 = (int)((double)n20 / d5);
            for (int i5 = n2 - n23; i5 < n4 + n23; i5 += n22) {
                Line line = new Line((double)(i5 - n23), (double)(n21 + n24), (double)(i5 + n23), (double)(n21 - n24));
                line.setStroke(paint);
                line.setStrokeWidth(d2);
                pane.getChildren().add((Object)line);
                line = new Line((double)(i5 + n23), (double)(n21 + n24), (double)(i5 - n23), (double)(n21 - n24));
                line.setStroke(paint);
                line.setStrokeWidth(d2);
                pane.getChildren().add((Object)line);
            }
        } else {
            Line line;
            int n25;
            int n26 = n7;
            int n27 = (n5 - n3) / 2;
            int n28 = n3 + n27;
            int n29 = n28 + n27;
            int n30 = n28 - n27;
            for (n25 = n2; n25 < n4; n25 += n26) {
                line = new Line((double)n25, (double)n29, (double)n25, (double)n30);
                line.setStroke(paint);
                line.setStrokeWidth(d2);
            }
            for (n25 = n3; n25 < n5; n25 += n26) {
                line = new Line((double)n2, (double)n25, (double)n4, (double)n25);
                line.setStroke(paint);
                line.setStrokeWidth(d2);
            }
        }
    }

    public static ImagePattern getDefaultHatch(Color color) {
        ImagePattern imagePattern = defaultHatchCache.get(color);
        if (imagePattern == null) {
            imagePattern = FillPatternStyleHelper.getDefaultHatch((Paint)color, 0.0);
            defaultHatchCache.put(color, imagePattern);
        }
        return imagePattern;
    }

    public static ImagePattern getDefaultHatch(Paint paint, double d2) {
        return new ImagePattern(FillPatternStyleHelper.createDefaultHatch(paint, 1.0), d2, d2, 8.0, 8.0, false);
    }

    public static int getDefaultHatchAngle() {
        return hatchAngle;
    }

    public static int getDefaultHatchSpacing() {
        return hatchSpacing;
    }

    public static ImagePattern getHatch(FillPattern fillPattern, Paint paint) {
        return FillPatternStyleHelper.getHatch(fillPattern, paint, 1.0);
    }

    public static ImagePattern getHatch(FillPattern fillPattern, Paint paint, double d2) {
        Image image = FillPatternStyleHelper.createHatch(fillPattern, paint, d2);
        return new ImagePattern(image, 0.0, 0.0, 8.0, 8.0, false);
    }

    public static void setDefaultHatchAngle(int n2) {
        AssertUtils.gtEqThanZero("setDefaultHatchSpacing", n2);
        hatchAngle = n2;
    }

    public static void setDefaultHatchSpacing(int n2) {
        AssertUtils.gtEqThanZero("setDefaultHatchSpacing", n2);
        hatchSpacing = n2;
    }

    public static enum FillPattern {
        SOLID,
        HATCH,
        HATCH0,
        HATCH30,
        HATCH45,
        HATCH60,
        HATCH90,
        HATCHCROSS1,
        HATCHCROSS2;

    }
}

