/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.marchingsquares;

import io.fair_acc.chartfx.renderer.spi.marchingsquares.Cell;
import io.fair_acc.chartfx.renderer.spi.marchingsquares.GeneralPath;
import io.fair_acc.chartfx.renderer.spi.marchingsquares.Grid;
import javafx.geometry.Side;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathGenerator.class);
    private static final double EPSILON = 1.0E-7;

    PathGenerator() {
    }

    public GeneralPath generalPath(Grid grid) {
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < grid.rowCount; ++i2) {
            for (int i3 = 0; i3 < grid.colCount; ++i3) {
                Cell cell = grid.getCellAt(i2, i3);
                if (cell == null || cell.isTrivial() || cell.isSaddle()) continue;
                this.update(grid, i2, i3, generalPath);
            }
        }
        return generalPath;
    }

    private Side nextSide(Cell cell, Side side) {
        return this.secondSide(cell, side);
    }

    private Side secondSide(Cell cell, Side side) {
        switch (cell.getCellNdx()) {
            case 8: 
            case 12: 
            case 14: {
                return Side.LEFT;
            }
            case 1: 
            case 9: 
            case 13: {
                return Side.BOTTOM;
            }
            case 2: 
            case 3: 
            case 11: {
                return Side.RIGHT;
            }
            case 4: 
            case 6: 
            case 7: {
                return Side.TOP;
            }
            case 5: {
                if (side == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument(cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (side) {
                    case LEFT: {
                        return cell.isFlipped() ? Side.BOTTOM : Side.TOP;
                    }
                    case RIGHT: {
                        return cell.isFlipped() ? Side.TOP : Side.BOTTOM;
                    }
                }
                String string = "Saddle w/ no connected neighbour; Cell = " + cell + ", previous side = " + side;
                throw new IllegalStateException(string);
            }
            case 10: {
                if (side == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument(cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (side) {
                    case BOTTOM: {
                        return cell.isFlipped() ? Side.RIGHT : Side.LEFT;
                    }
                    case TOP: {
                        return cell.isFlipped() ? Side.LEFT : Side.RIGHT;
                    }
                }
                String string = "Saddle w/ no connected neighbour; Cell = " + cell + ", previous side = " + side;
                throw new IllegalStateException(string);
            }
        }
        String string = "Attempt to use a trivial Cell as a node: " + cell;
        throw new IllegalStateException(string);
    }

    private void update(Grid grid, int n2, int n3, GeneralPath generalPath) {
        Side side = null;
        int n4 = n2;
        int n5 = n3;
        Cell cell = grid.getCellAt(n4, n5);
        float[] fArray = cell.getXY(PathGenerator.firstSide(cell, side));
        float f2 = (float)n5 + fArray[0];
        float f3 = (float)n4 + fArray[1];
        generalPath.moveTo(f2, f3);
        fArray = cell.getXY(this.secondSide(cell, side));
        float f4 = (float)n5 + fArray[0];
        float f5 = (float)n4 + fArray[1];
        side = this.nextSide(cell, side);
        switch (side) {
            case BOTTOM: {
                --n4;
                break;
            }
            case LEFT: {
                --n5;
                break;
            }
            case RIGHT: {
                ++n5;
                break;
            }
            case TOP: {
                ++n4;
                break;
            }
        }
        cell.clear();
        Cell cell2 = grid.getCellAt(n4, n5);
        while (!cell.equals(cell2)) {
            fArray = cell2.getXY(this.secondSide(cell2, side));
            f2 = (float)n5 + fArray[0];
            f3 = (float)n4 + fArray[1];
            if ((double)Math.abs(f2 - f4) > 1.0E-7 && (double)Math.abs(f3 - f5) > 1.0E-7) {
                generalPath.lineTo(f2, f3);
            }
            f4 = f2;
            f5 = f3;
            side = this.nextSide(cell2, side);
            switch (side) {
                case BOTTOM: {
                    --n4;
                    break;
                }
                case LEFT: {
                    --n5;
                    break;
                }
                case RIGHT: {
                    ++n5;
                    break;
                }
                case TOP: {
                    ++n4;
                    break;
                }
            }
            cell2.clear();
            cell2 = grid.getCellAt(n4, n5);
        }
        generalPath.closePath();
    }

    private static Side firstSide(Cell cell, Side side) {
        switch (cell.getCellNdx()) {
            case 1: 
            case 3: 
            case 7: {
                return Side.LEFT;
            }
            case 2: 
            case 6: 
            case 14: {
                return Side.BOTTOM;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: {
                return Side.RIGHT;
            }
            case 8: 
            case 9: {
                return Side.TOP;
            }
            case 5: {
                if (side == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument(cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (side) {
                    case LEFT: {
                        return Side.RIGHT;
                    }
                    case RIGHT: {
                        return Side.LEFT;
                    }
                }
                throw new NoSaddlePointException(cell, side);
            }
            case 10: {
                if (side == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.atError().addArgument(cell).log("cell '{}' switch case 5, prev is null");
                    }
                    throw new IllegalStateException("cell " + cell + " prev is null");
                }
                switch (side) {
                    case BOTTOM: {
                        return Side.TOP;
                    }
                    case TOP: {
                        return Side.BOTTOM;
                    }
                }
                throw new NoSaddlePointException(cell, side);
            }
        }
        String string = "Attempt to use a trivial cell as a start node: " + cell;
        throw new IllegalStateException(string);
    }

    protected static class NoSaddlePointException
    extends IllegalStateException {
        private static final long serialVersionUID = -5628254997299110176L;

        NoSaddlePointException(Cell cell, Side side) {
            super("Saddle w/ no connected neighbour; Cell = " + cell + ", previous side = " + side);
        }
    }
}

