/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.renderer.ErrorStyle;
import io.fair_acc.chartfx.renderer.LineStyle;
import io.fair_acc.chartfx.renderer.RendererDataReducer;
import io.fair_acc.chartfx.renderer.datareduction.DefaultDataReducer;
import io.fair_acc.chartfx.renderer.spi.AbstractPointReducingRenderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRenderer;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Collection;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;

public abstract class AbstractErrorDataSetRendererParameter<R extends AbstractErrorDataSetRendererParameter<R>>
extends AbstractPointReducingRenderer<R> {
    protected static final double DEFAULT_HISTORY_INTENSITY_FADING = 0.65;
    private final ObjectProperty<ErrorStyle> errorStyle = this.css().createEnumProperty((Styleable)this, "errorStyle", ErrorStyle.ERRORCOMBO, true, ErrorStyle.class);
    private final ObjectProperty<RendererDataReducer> rendererDataReducer = new SimpleObjectProperty((Object)this, "rendererDataReducer", (Object)new DefaultDataReducer());
    private final IntegerProperty dashSize = this.css().createIntegerProperty(this, "dashSize", 3, new Runnable[0]);
    private final BooleanProperty drawMarker = this.css().createBooleanProperty(this, "drawMarker", true, new Runnable[0]);
    private final ObjectProperty<LineStyle> polyLineStyle = this.css().createEnumProperty((Styleable)this, "polyLineStyle", LineStyle.NORMAL, false, LineStyle.class);
    private final BooleanProperty drawBars = this.css().createBooleanProperty(this, "drawBars", false, new Runnable[0]);
    private final BooleanProperty shiftBar = this.css().createBooleanProperty(this, "shiftBar", true, new Runnable[0]);
    private final IntegerProperty shiftBarOffset = this.css().createIntegerProperty(this, "shiftBarOffset", 3, new Runnable[0]);
    private final BooleanProperty dynamicBarWidth = this.css().createBooleanProperty(this, "dynamicBarWidth", true, new Runnable[0]);
    private final DoubleProperty barWidthPercentage = this.css().createDoubleProperty(this, "barWidthPercentage", 70.0, new Runnable[0]);
    private final IntegerProperty barWidth = this.css().createIntegerProperty(this, "barWidth", 5, new Runnable[0]);
    private final DoubleProperty intensityFading = this.css().createDoubleProperty(this, "intensityFading", 0.65, new Runnable[0]);
    private final BooleanProperty drawBubbles = this.css().createBooleanProperty(this, "drawBubbles", false, new Runnable[0]);
    private final BooleanProperty allowNans = this.css().createBooleanProperty(this, "allowNans", false, new Runnable[0]);
    private static final CssPropertyFactory<AbstractRenderer<?>> CSS = new CssPropertyFactory(AbstractPointReducingRenderer.getClassCssMetaData());

    public AbstractErrorDataSetRendererParameter() {
        StyleUtil.addStyles(this, "error-dataset-renderer");
        PropUtil.runOnChange(this::invalidateCanvas, new ObservableValue[]{this.errorStyle, this.rendererDataReducer, this.dashSize, this.drawMarker, this.polyLineStyle, this.drawBars, this.shiftBar, this.shiftBarOffset, this.dynamicBarWidth, this.barWidthPercentage, this.barWidth, this.intensityFading, this.drawBubbles, this.allowNans});
    }

    public BooleanProperty allowNaNsProperty() {
        return this.allowNans;
    }

    public DoubleProperty barWidthPercentageProperty() {
        return this.barWidthPercentage;
    }

    public IntegerProperty barWidthProperty() {
        return this.barWidth;
    }

    public IntegerProperty dashSizeProperty() {
        return this.dashSize;
    }

    public BooleanProperty drawBarsProperty() {
        return this.drawBars;
    }

    public BooleanProperty drawBubblesProperty() {
        return this.drawBubbles;
    }

    public BooleanProperty drawMarkerProperty() {
        return this.drawMarker;
    }

    public BooleanProperty dynamicBarWidthProperty() {
        return this.dynamicBarWidth;
    }

    public ObjectProperty<ErrorStyle> errorStyleProperty() {
        return this.errorStyle;
    }

    public int getBarWidth() {
        return this.barWidthProperty().get();
    }

    public double getBarWidthPercentage() {
        return this.barWidthPercentageProperty().get();
    }

    public int getDashSize() {
        return this.dashSizeProperty().get();
    }

    public ErrorStyle getErrorType() {
        ErrorStyle errorStyle = (ErrorStyle)((Object)this.errorStyleProperty().get());
        return errorStyle == null ? ErrorStyle.NONE : errorStyle;
    }

    public double getIntensityFading() {
        return this.intensityFadingProperty().get();
    }

    public LineStyle getPolyLineStyle() {
        return (LineStyle)((Object)this.polyLineStyleProperty().get());
    }

    public RendererDataReducer getRendererDataReducer() {
        return (RendererDataReducer)this.rendererDataReducerProperty().get();
    }

    public int getShiftBarOffset() {
        return this.shiftBarOffsetProperty().get();
    }

    public DoubleProperty intensityFadingProperty() {
        return this.intensityFading;
    }

    public boolean isallowNaNs() {
        return this.allowNaNsProperty().get();
    }

    public boolean isDrawBars() {
        return this.drawBarsProperty().get();
    }

    public boolean isDrawBubbles() {
        return this.drawBubblesProperty().get();
    }

    public boolean isDrawMarker() {
        return this.drawMarkerProperty().get();
    }

    public boolean isDynamicBarWidth() {
        return this.dynamicBarWidthProperty().get();
    }

    public boolean isShiftBar() {
        return this.shiftBarProperty().get();
    }

    public ObjectProperty<LineStyle> polyLineStyleProperty() {
        return this.polyLineStyle;
    }

    public ObjectProperty<RendererDataReducer> rendererDataReducerProperty() {
        return this.rendererDataReducer;
    }

    public R setAllowNaNs(boolean bl2) {
        this.allowNaNsProperty().set(bl2);
        return (R)this.getThis();
    }

    public R setBarWidth(int n2) {
        AssertUtils.gtEqThanZero("barWidth", n2);
        this.barWidthProperty().setValue((Number)n2);
        return (R)this.getThis();
    }

    public R setBarWidthPercentage(double d2) {
        AssertUtils.gtEqThanZero("barWidthPercentage", d2);
        this.barWidthPercentageProperty().setValue((Number)d2);
        return (R)this.getThis();
    }

    public R setDashSize(int n2) {
        AssertUtils.gtEqThanZero("dash size", n2);
        this.dashSizeProperty().setValue((Number)n2);
        return (R)this.getThis();
    }

    public R setDrawBars(boolean bl2) {
        this.drawBarsProperty().set(bl2);
        return (R)this.getThis();
    }

    public R setDrawBubbles(boolean bl2) {
        this.drawBubblesProperty().set(bl2);
        return (R)this.getThis();
    }

    public R setDrawMarker(boolean bl2) {
        this.drawMarkerProperty().set(bl2);
        return (R)this.getThis();
    }

    public R setDynamicBarWidth(boolean bl2) {
        this.dynamicBarWidthProperty().set(bl2);
        return (R)this.getThis();
    }

    public R setErrorStyle(ErrorStyle errorStyle) {
        this.errorStyleProperty().set((Object)errorStyle);
        return (R)this.getThis();
    }

    public R setIntensityFading(double d2) {
        this.intensityFadingProperty().setValue((Number)d2);
        return (R)this.getThis();
    }

    public R setPolyLineStyle(LineStyle lineStyle) {
        this.polyLineStyleProperty().set((Object)lineStyle);
        return (R)this.getThis();
    }

    public R setRendererDataReducer(RendererDataReducer rendererDataReducer) {
        this.rendererDataReducerProperty().set((Object)Objects.requireNonNullElseGet(rendererDataReducer, DefaultDataReducer::new));
        return (R)this.getThis();
    }

    public R setShiftBar(boolean bl2) {
        this.shiftBarProperty().set(bl2);
        return (R)this.getThis();
    }

    public R setshiftBarOffset(int n2) {
        AssertUtils.gtEqThanZero("shiftBarOffset", n2);
        this.shiftBarOffsetProperty().setValue((Number)n2);
        return (R)this.getThis();
    }

    public IntegerProperty shiftBarOffsetProperty() {
        return this.shiftBarOffset;
    }

    public BooleanProperty shiftBarProperty() {
        return this.shiftBar;
    }

    protected R bind(R r2) {
        this.chartProperty().bind(((AbstractRenderer)r2).chartProperty());
        this.errorStyleProperty().bind(((AbstractErrorDataSetRendererParameter)r2).errorStyleProperty());
        this.pointReductionProperty().bind((ObservableValue)((AbstractPointReducingRenderer)r2).pointReductionProperty());
        this.assumeSortedDataProperty().bind((ObservableValue)((AbstractPointReducingRenderer)r2).assumeSortedDataProperty());
        this.dashSizeProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).dashSizeProperty());
        this.minRequiredReductionSizeProperty().bind((ObservableValue)((AbstractPointReducingRenderer)r2).minRequiredReductionSizeProperty());
        this.drawMarkerProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).drawMarkerProperty());
        this.polyLineStyleProperty().bind(((AbstractErrorDataSetRendererParameter)r2).polyLineStyleProperty());
        this.drawBarsProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).drawBarsProperty());
        this.drawBubblesProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).drawBubblesProperty());
        this.allowNaNsProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).allowNaNsProperty());
        this.shiftBarProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).shiftBarProperty());
        this.shiftBarOffsetProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).shiftBarOffsetProperty());
        this.dynamicBarWidthProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).dynamicBarWidthProperty());
        this.barWidthPercentageProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).barWidthPercentageProperty());
        this.barWidthProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).barWidthProperty());
        this.getAxes().setAll(((AbstractRenderer)r2).getAxes());
        this.intensityFadingProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)r2).intensityFadingProperty());
        ((AbstractRenderer)r2).getAxes().addListener(change -> {
            while (change.next()) {
                this.getAxes().addAll((Collection)change.getAddedSubList());
                this.getAxes().removeAll((Collection)change.getRemoved());
            }
        });
        return (R)this.getThis();
    }

    @Override
    protected abstract R getThis();

    protected R unbind() {
        this.chartProperty().unbind();
        this.errorStyleProperty().unbind();
        this.pointReductionProperty().unbind();
        this.dashSizeProperty().unbind();
        this.minRequiredReductionSizeProperty().unbind();
        this.drawMarkerProperty().unbind();
        this.polyLineStyleProperty().unbind();
        this.drawBarsProperty().unbind();
        this.drawBubblesProperty().unbind();
        this.allowNaNsProperty().unbind();
        this.shiftBarProperty().unbind();
        this.shiftBarOffsetProperty().unbind();
        this.dynamicBarWidthProperty().unbind();
        this.barWidthPercentageProperty().unbind();
        this.barWidthProperty().unbind();
        this.intensityFadingProperty().unbind();
        return (R)this.getThis();
    }

    @Override
    protected CssPropertyFactory<AbstractRenderer<?>> css() {
        return CSS;
    }
}

