/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.renderer.ContourType;
import io.fair_acc.chartfx.renderer.datareduction.ReductionType;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXYZ;
import io.fair_acc.chartfx.renderer.spi.utils.ColorGradient;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;

public abstract class AbstractContourDataSetRendererParameter<R extends AbstractContourDataSetRendererParameter<R>>
extends AbstractRendererXYZ<R> {
    private final BooleanProperty altImplementation = new SimpleBooleanProperty((Object)this, "altImplementation", false);
    private final IntegerProperty reductionFactorX = new SimpleIntegerProperty((Object)this, "reductionFactorX", 2);
    private final IntegerProperty reductionFactorY = new SimpleIntegerProperty((Object)this, "reductionFactorY", 2);
    private final ObjectProperty<ReductionType> reductionType = new SimpleObjectProperty((Object)this, "reductionType", (Object)ReductionType.AVERAGE);
    private final ObjectProperty<ColorGradient> colorGradient = new SimpleObjectProperty((Object)this, "colorGradient", (Object)ColorGradient.DEFAULT);
    private final BooleanProperty computeLocalZRange = new SimpleBooleanProperty((Object)this, "computeLocalZRange", true);
    private final ObjectProperty<ContourType> contourType = new SimpleObjectProperty((Object)this, "contourType", (Object)ContourType.HEATMAP);
    private final IntegerProperty maxContourSegments = new SimpleIntegerProperty(this, "maxContourSegments", 500){

        public void set(int n2) {
            super.set(Math.max(2, n2));
        }
    };
    private final IntegerProperty minHexTileSize = new SimpleIntegerProperty(this, "minHexTileSize", 5){

        public void set(int n2) {
            super.set(Math.max(2, n2));
        }
    };
    private final IntegerProperty quantisationLevels = new SimpleIntegerProperty(this, "quantisationLevels", 20){

        public void set(int n2) {
            super.set(Math.max(2, n2));
        }
    };
    private final BooleanProperty smooth = new SimpleBooleanProperty(this, "smooth", false){

        protected void invalidated() {
        }
    };

    public AbstractContourDataSetRendererParameter() {
        this.setMinRequiredReductionSize(3);
    }

    public BooleanProperty altImplementationProperty() {
        return this.altImplementation;
    }

    public ObjectProperty<ColorGradient> colorGradientProperty() {
        return this.colorGradient;
    }

    public boolean computeLocalRange() {
        return this.computeLocalRangeProperty().get();
    }

    public BooleanProperty computeLocalRangeProperty() {
        return this.computeLocalZRange;
    }

    public ObjectProperty<ContourType> contourTypeProperty() {
        return this.contourType;
    }

    public ColorGradient getColorGradient() {
        return (ColorGradient)this.colorGradientProperty().get();
    }

    public ContourType getContourType() {
        return (ContourType)((Object)this.contourTypeProperty().get());
    }

    public int getMaxContourSegments() {
        return this.maxContourSegmentsProperty().get();
    }

    public int getMinHexTileSizeProperty() {
        return this.minHexTileSizeProperty().get();
    }

    public int getNumberQuantisationLevels() {
        return this.quantisationLevelsProperty().get();
    }

    public int getReductionFactorX() {
        return this.reductionFactorXProperty().get();
    }

    public int getReductionFactorY() {
        return this.reductionFactorYProperty().get();
    }

    public ReductionType getReductionType() {
        return (ReductionType)((Object)this.reductionTypeProperty().get());
    }

    public boolean isAltImplementation() {
        return this.altImplementationProperty().get();
    }

    public boolean isSmooth() {
        return this.smoothProperty().get();
    }

    public IntegerProperty maxContourSegmentsProperty() {
        return this.maxContourSegments;
    }

    public IntegerProperty minHexTileSizeProperty() {
        return this.minHexTileSize;
    }

    public IntegerProperty quantisationLevelsProperty() {
        return this.quantisationLevels;
    }

    public IntegerProperty reductionFactorXProperty() {
        return this.reductionFactorX;
    }

    public IntegerProperty reductionFactorYProperty() {
        return this.reductionFactorY;
    }

    public ObjectProperty<ReductionType> reductionTypeProperty() {
        return this.reductionType;
    }

    public void setAltImplementation(boolean bl2) {
        this.altImplementationProperty().set(bl2);
    }

    public void setColorGradient(ColorGradient colorGradient) {
        this.colorGradientProperty().set((Object)colorGradient);
    }

    public void setComputeLocalRange(boolean bl2) {
        this.computeLocalRangeProperty().set(bl2);
    }

    public void setContourType(ContourType contourType) {
        this.contourTypeProperty().set((Object)contourType);
    }

    public void setMaxContourSegments(int n2) {
        this.maxContourSegmentsProperty().set(n2);
    }

    public void setMinHexTileSizeProperty(int n2) {
        this.minHexTileSizeProperty().set(n2);
    }

    public void setNumberQuantisationLevels(int n2) {
        this.quantisationLevelsProperty().set(n2);
    }

    public void setReductionFactorX(int n2) {
        this.reductionFactorXProperty().set(n2);
    }

    public void setReductionFactorY(int n2) {
        this.reductionFactorYProperty().set(n2);
    }

    public void setReductionType(ReductionType reductionType) {
        this.reductionTypeProperty().set((Object)reductionType);
    }

    public void setSmooth(boolean bl2) {
        this.smoothProperty().set(bl2);
    }

    public BooleanProperty smoothProperty() {
        return this.smooth;
    }
}

