/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements.utils;

import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CheckedNumberTextField
extends TextField {
    private static final String NUMBER_REGEX = "[\\x00-\\x20]*[+-]?((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.(\\p{Digit}+)([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?)[\\x00-\\x20]*";

    public CheckedNumberTextField(double d2) {
        super(Double.toString(d2));
        ValidationSupport validationSupport = new ValidationSupport();
        Validator validator = (control, string) -> {
            boolean bl2 = string == null || !string.matches(NUMBER_REGEX) && !CheckedNumberTextField.isNumberInfinity(string);
            this.setStyle(bl2 ? "-fx-text-inner-color: red;" : "-fx-text-inner-color: black;");
            return ValidationResult.fromMessageIf(control, "not a number", Severity.ERROR, bl2);
        };
        validationSupport.registerValidator((Control)this, true, validator);
        this.snappedTopInset();
        this.snappedBottomInset();
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
    }

    public double getValue() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    private static boolean isNumberInfinity(String string) {
        return string.toUpperCase(Locale.UK).contains("INFINITY");
    }
}

