/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.MouseEventsHelper;
import io.fair_acc.chartfx.plugins.TableViewer;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.EditConstraints;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.ChartBits;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Popup;
import javafx.util.Pair;
import org.kordamp.ikonli.javafx.FontIcon;

public class EditDataSet
extends TableViewer {
    protected static final String STYLE_CLASS_SELECT_RECT = "chart-select-rect";
    protected static final String STYLE_CLASS_SELECT_PATH = "chart-select-marker";
    protected static final PseudoClass NOEDIT_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"noEdit");
    protected static final int DEFAULT_MARKER_RADIUS = 5;
    public static final int DEFAULT_PICKING_DISTANCE = 10;
    protected static final int SELECT_RECT_MIN_SIZE = 5;
    protected static final int FONT_SIZE_COMBO = 18;
    private static boolean shiftDown;
    private static boolean controlDown;
    protected boolean isPointDragActive;
    protected final Predicate<MouseEvent> defaultSelectFilter = mouseEvent -> MouseEventsHelper.isOnlyPrimaryButtonDown(mouseEvent) && mouseEvent.isControlDown() && this.isMouseEventWithinCanvas((MouseEvent)mouseEvent) && !this.isPointDragActive;
    protected final ConcurrentHashMap<EditableDataSet, ConcurrentHashMap<Integer, SelectedDataPoint>> markedPoints = new ConcurrentHashMap();
    protected final Rectangle selectRectangle = new Rectangle();
    protected Point2D selectStartPoint;
    protected Point2D selectEndPoint;
    protected Cursor originalCursor;
    protected final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor");
    protected BooleanProperty editEnable;
    protected BooleanProperty allowShiftX = new SimpleBooleanProperty((Object)this, "allowShiftX", true);
    protected BooleanProperty allowShiftY = new SimpleBooleanProperty((Object)this, "allowShiftY", true);
    protected Predicate<MouseEvent> zoomInMouseFilter = this.defaultSelectFilter;
    protected Pane markerPane = new Pane();
    private double mouseOriginX = -1.0;
    private double mouseOriginY = -1.0;
    protected PointEditionPopup popup = new PointEditionPopup();
    private final EventHandler<KeyEvent> keyReleasedHandler = keyEvent -> {
        if (keyEvent.getCode() == KeyCode.CONTROL) {
            this.uninstallCursor();
            controlDown = false;
        }
        if (keyEvent.getCode() == KeyCode.SHIFT) {
            shiftDown = false;
        }
    };
    private final EventHandler<KeyEvent> keyPressedHandler = keyEvent -> {
        if (keyEvent.getCode() == KeyCode.CONTROL) {
            this.installCursor();
            controlDown = true;
            this.isPointDragActive = false;
            keyEvent.consume();
        }
        if (keyEvent.getCode() == KeyCode.SHIFT) {
            shiftDown = true;
        }
        if (!(keyEvent.getCode() != KeyCode.ESCAPE || shiftDown && controlDown)) {
            this.markerPane.getChildren().clear();
        }
    };
    private final EventHandler<MouseEvent> selectionStartHandler = mouseEvent -> {
        if (this.getSelectionMouseFilter() == null || this.getSelectionMouseFilter().test((MouseEvent)mouseEvent)) {
            this.selectionStarted((MouseEvent)mouseEvent);
            mouseEvent.consume();
        }
        if (mouseEvent.isSecondaryButtonDown()) {
            if (mouseEvent.getSource() != null && mouseEvent.getSource() instanceof SelectedDataPoint) {
                this.popup.showPopup((MouseEvent)mouseEvent, (SelectedDataPoint)((Object)((Object)mouseEvent.getSource())));
                mouseEvent.consume();
            } else {
                this.popup.showPopup((MouseEvent)mouseEvent, null);
                mouseEvent.consume();
            }
        }
    };
    private final EventHandler<MouseEvent> selectionDragHandler = mouseEvent -> {
        this.performPointDrag((MouseEvent)mouseEvent);
        if (this.selectionOngoing() && !this.isPointDragActive) {
            this.selectionDragged((MouseEvent)mouseEvent);
            mouseEvent.consume();
        }
    };
    private final EventHandler<MouseEvent> selectionEndHandler = mouseEvent -> {
        if (this.selectionOngoing() && !this.isPointDragActive) {
            this.selectionEnded();
            mouseEvent.consume();
        }
    };
    protected EventHandler<MouseEvent> dragHandler = this::performPointDrag;
    private final DoubleProperty pickingDistance = new SimpleDoubleProperty(this, "pickingDistance", 10.0){

        public void set(double d2) {
            super.set(Math.max(1.0, d2));
        }
    };

    @Override
    public void runPostLayout() {
        super.runPostLayout();
        if (this.getChart().getBitState().isDirty(ChartBits.AxisMask | ChartBits.DataSetMask)) {
            this.updateMarker();
        }
    }

    public EditDataSet() {
        this.editable = true;
        this.setDragCursor(Cursor.CROSSHAIR);
        this.selectRectangle.setManaged(false);
        this.selectRectangle.getStyleClass().add((Object)STYLE_CLASS_SELECT_RECT);
        this.getChartChildren().add((Object)this.selectRectangle);
        this.registerMouseHandlers();
        this.registerKeyHandlers();
        this.markerPane.setManaged(false);
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getCanvasForeground().getChildren().remove((Object)this.markerPane);
                chart.getPlotArea().setBottom(null);
            }
            if (chart2 != null) {
                chart2.getCanvasForeground().getChildren().add((Object)this.markerPane);
                this.markerPane.toFront();
                this.markerPane.setVisible(true);
            }
        });
    }

    protected void addPoint(double d2, double d3) {
        if (!(this.getChart() instanceof XYChart)) {
            return;
        }
        XYChart xYChart = (XYChart)this.getChart();
        Pane pane = this.getChart().getCanvasForeground();
        Bounds bounds = pane.getBoundsInLocal();
        Bounds bounds2 = pane.localToScreen(bounds);
        int n2 = (int)bounds2.getMinX();
        int n3 = (int)bounds2.getMinY();
        DataPoint dataPoint = this.findNearestDataPoint(this.getChart(), new Point2D(d2 - (double)n2, d3 - (double)n3));
        if (dataPoint != null && dataPoint.getDataSet() instanceof EditableDataSet) {
            Axis axis = xYChart.getFirstAxis(Orientation.HORIZONTAL);
            Axis axis2 = xYChart.getFirstAxis(Orientation.VERTICAL);
            int n4 = dataPoint.getIndex();
            double d4 = axis.getValueForDisplay(d2 - (double)n2);
            double d5 = axis2.getValueForDisplay(d3 - (double)n3);
            EditableDataSet editableDataSet = (EditableDataSet)dataPoint.getDataSet();
            double d6 = editableDataSet.get(0, n4);
            if (d6 <= d4) {
                editableDataSet.add(n4, d4, d5);
            } else {
                editableDataSet.add(n4 - 1, d4, d5);
            }
        }
        this.updateMarker();
    }

    protected void applyDrag(double d2, double d3) {
        for (Node node : this.markerPane.getChildren()) {
            if (!(node instanceof SelectedDataPoint)) continue;
            SelectedDataPoint selectedDataPoint = (SelectedDataPoint)node;
            selectedDataPoint.applyDrag(d2, d3);
        }
        this.updateMarker();
    }

    protected void deleteAllMarkedPoints() {
        for (EditableDataSet editableDataSet : this.markedPoints.keySet()) {
            ConcurrentHashMap<Integer, SelectedDataPoint> concurrentHashMap = this.markedPoints.get(editableDataSet);
            for (Integer n2 : concurrentHashMap.keySet()) {
                SelectedDataPoint selectedDataPoint = concurrentHashMap.get(n2);
                if (!selectedDataPoint.delete()) continue;
                concurrentHashMap.remove(n2);
            }
        }
        this.updateMarker();
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public final ReadOnlyBooleanProperty editEnableProperty() {
        return this.editEnable;
    }

    protected void findDataPoint(Axis axis, Axis axis2, List<DataSet> list) {
        if (axis == null || axis2 == null || list == null) {
            return;
        }
        double d2 = Math.min(this.selectStartPoint.getX(), this.selectEndPoint.getX());
        double d3 = Math.max(this.selectStartPoint.getX(), this.selectEndPoint.getX());
        double d4 = Math.min(this.selectStartPoint.getY(), this.selectEndPoint.getY());
        double d5 = Math.max(this.selectStartPoint.getY(), this.selectEndPoint.getY());
        for (DataSet dataSet : list) {
            if (!(dataSet instanceof EditableDataSet)) continue;
            EditableDataSet editableDataSet2 = (EditableDataSet)dataSet;
            int n2 = Math.max(0, dataSet.getIndex(0, axis.getValueForDisplay(d2)));
            int n3 = Math.min(dataSet.getIndex(0, axis.getValueForDisplay(d3)) + 1, dataSet.getDataCount());
            double d6 = axis2.getValueForDisplay(d4);
            double d7 = axis2.getValueForDisplay(d5);
            ConcurrentHashMap concurrentHashMap = this.markedPoints.computeIfAbsent(editableDataSet2, editableDataSet -> new ConcurrentHashMap());
            for (int i2 = n2; i2 < n3; ++i2) {
                double d8 = editableDataSet2.get(1, i2);
                if (!(d8 >= d7) || !(d8 <= d6)) continue;
                if (EditDataSet.isShiftDown()) {
                    if (concurrentHashMap.get(i2) != null) {
                        concurrentHashMap.remove(i2);
                        continue;
                    }
                    concurrentHashMap.put(i2, new SelectedDataPoint(axis, axis2, editableDataSet2, i2));
                    continue;
                }
                concurrentHashMap.put(i2, new SelectedDataPoint(axis, axis2, editableDataSet2, i2));
            }
        }
    }

    protected DataPoint findNearestDataPoint(Chart chart, Point2D point2D) {
        if (!(chart instanceof XYChart)) {
            return null;
        }
        XYChart xYChart = (XYChart)chart;
        double d2 = xYChart.getXAxis().getValueForDisplay(point2D.getX());
        DataPoint dataPoint = null;
        for (DataPoint dataPoint2 : this.findNeighborPoints(xYChart, d2)) {
            if (this.getChart().getFirstAxis(Orientation.HORIZONTAL) == null) continue;
            double d3 = xYChart.getXAxis().getDisplayPosition(dataPoint2.getX());
            double d4 = xYChart.getYAxis().getDisplayPosition(dataPoint2.getY());
            Point2D point2D2 = new Point2D(d3, d4);
            dataPoint2.setDistanceFromMouse(point2D2.distance(point2D));
            if (dataPoint != null && !(dataPoint2.getDistanceFromMouse() < dataPoint.getDistanceFromMouse())) continue;
            dataPoint = dataPoint2;
        }
        return dataPoint;
    }

    protected Pair<DataPoint, DataPoint> findNeighborPoints(DataSet dataSet, double d2) {
        int n2 = -1;
        int n3 = -1;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
            double d5 = dataSet.get(0, i2);
            if (d5 <= d2) {
                if (!(d3 <= d5)) continue;
                n2 = i2;
                d3 = d5;
                continue;
            }
            if (!(d4 > d5)) continue;
            n3 = i2;
            d4 = d5;
        }
        DataPoint dataPoint = n2 == -1 ? null : new DataPoint(this.getChart(), dataSet, n2, dataSet.get(0, n2), dataSet.get(1, n2), dataSet.getDataLabel(n2));
        DataPoint dataPoint2 = n3 == -1 || n3 == n2 ? null : new DataPoint(this.getChart(), dataSet, n3, dataSet.get(0, n3), dataSet.get(1, n3), dataSet.getDataLabel(n3));
        return new Pair((Object)dataPoint, (Object)dataPoint2);
    }

    protected List<DataPoint> findNeighborPoints(XYChart xYChart, double d2) {
        LinkedList<DataPoint> linkedList = new LinkedList<DataPoint>();
        for (DataSet dataSet : xYChart.getAllDatasets()) {
            Pair<DataPoint, DataPoint> pair = this.findNeighborPoints(dataSet, d2);
            if (pair.getKey() != null) {
                linkedList.add((DataPoint)pair.getKey());
            }
            if (pair.getValue() == null) continue;
            linkedList.add((DataPoint)pair.getValue());
        }
        return linkedList;
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    @Override
    protected HBox getInteractorBar() {
        HBox hBox = super.getInteractorBar();
        FontIcon fontIcon = new FontIcon("fa-edit:22");
        FontIcon fontIcon2 = new FontIcon("fa-plus-circle:22");
        FontIcon fontIcon3 = new FontIcon("fa-minus-circle:22");
        Button button = new Button(null, (Node)fontIcon);
        button.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button.setTooltip(new Tooltip("enables edit interactor"));
        hBox.getChildren().add((Object)button);
        Button button2 = new Button(null, (Node)fontIcon2);
        fontIcon2.setFill((Paint)Color.DARKGREEN);
        button2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button2.setTooltip(new Tooltip("add data point"));
        hBox.getChildren().add((Object)button2);
        Button button3 = new Button(null, (Node)fontIcon3);
        fontIcon3.setFill((Paint)Color.DARKRED);
        button3.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        button3.setTooltip(new Tooltip("remove data point"));
        hBox.getChildren().add((Object)button3);
        ComboBox comboBox = new ComboBox();
        comboBox.setPrefSize(-1.0, -1.0);
        comboBox.setPadding(Insets.EMPTY);
        comboBox.setBorder(null);
        comboBox.setValue((Object)ShiftConstraint.SHIFTXY);
        comboBox.getItems().addAll((Object[])ShiftConstraint.values());
        comboBox.setButtonCell((ListCell)new ShiftConstraintListCell());
        comboBox.setCellFactory(listView -> new ShiftConstraintListCell());
        comboBox.valueProperty().addListener((observableValue, shiftConstraint, shiftConstraint2) -> {
            if (shiftConstraint2 == null) {
                return;
            }
            switch (shiftConstraint2) {
                case SHIFTX: {
                    this.allowShiftX.set(true);
                    this.allowShiftY.set(false);
                    break;
                }
                case SHIFTY: {
                    this.allowShiftX.set(false);
                    this.allowShiftY.set(true);
                    break;
                }
                default: {
                    this.allowShiftX.set(true);
                    this.allowShiftY.set(true);
                }
            }
        });
        hBox.getChildren().add((Object)comboBox);
        if (this.editEnable == null) {
            this.editEnable = new SimpleBooleanProperty((Object)this, "editEnable", false);
        }
        this.editEnable.addListener((observableValue, bl2, bl3) -> {
            button3.setDisable(bl3 == false);
            comboBox.setDisable(bl3 == false);
        });
        return hBox;
    }

    public final double getPickingDistance() {
        return this.pickingDistanceProperty().get();
    }

    public Predicate<MouseEvent> getSelectionMouseFilter() {
        return this.zoomInMouseFilter;
    }

    protected void installCursor() {
        Chart chart = this.getChart();
        this.originalCursor = chart.getCursor();
        if (this.getDragCursor() != null) {
            chart.setCursor(this.getDragCursor());
        }
    }

    public final boolean isEditable() {
        return this.editEnableProperty().get();
    }

    protected void performPointDrag(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY && !controlDown && this.isPointDragActive) {
            if (this.mouseOriginX < 0.0) {
                this.mouseOriginX = mouseEvent.getSceneX();
            }
            if (this.mouseOriginY < 0.0) {
                this.mouseOriginY = mouseEvent.getSceneY();
            }
            double d2 = mouseEvent.getSceneX() - this.mouseOriginX;
            double d3 = mouseEvent.getSceneY() - this.mouseOriginY;
            this.mouseOriginX = mouseEvent.getSceneX();
            this.mouseOriginY = mouseEvent.getSceneY();
            this.applyDrag(d2, d3);
            mouseEvent.consume();
        } else {
            this.isPointDragActive = false;
        }
    }

    protected void performSelection() {
        if (!(this.getChart() instanceof XYChart)) {
            return;
        }
        XYChart xYChart = (XYChart)this.getChart();
        if (!EditDataSet.isShiftDown()) {
            this.markedPoints.clear();
        }
        this.findDataPoint(xYChart.getFirstAxis(Orientation.HORIZONTAL), xYChart.getFirstAxis(Orientation.VERTICAL), (List<DataSet>)xYChart.getDatasets());
        for (Renderer renderer : xYChart.getRenderers()) {
            ObservableList<Axis> observableList = renderer.getAxes();
            this.findDataPoint(EditDataSet.getFirstAxis(observableList, Orientation.HORIZONTAL), EditDataSet.getFirstAxis(observableList, Orientation.VERTICAL), (List<DataSet>)renderer.getDatasets());
        }
        this.editEnable.set(!this.markedPoints.isEmpty());
        this.updateMarker();
    }

    public final DoubleProperty pickingDistanceProperty() {
        return this.pickingDistance;
    }

    private void registerKeyHandlers() {
        this.registerInputEventHandler(KeyEvent.KEY_PRESSED, this.keyPressedHandler);
        this.registerInputEventHandler(KeyEvent.KEY_RELEASED, this.keyReleasedHandler);
    }

    private void registerMouseHandlers() {
        this.registerInputEventHandler(MouseEvent.MOUSE_PRESSED, this.selectionStartHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_DRAGGED, this.selectionDragHandler);
        this.registerInputEventHandler(MouseEvent.MOUSE_RELEASED, this.selectionEndHandler);
    }

    protected void selectionDragged(MouseEvent mouseEvent) {
        Bounds bounds = this.getChart().getPlotArea().getBoundsInLocal();
        this.selectEndPoint = EditDataSet.limitToPlotArea(mouseEvent, bounds);
        this.selectRectangle.setX(Math.min(this.selectStartPoint.getX(), this.selectEndPoint.getX()));
        this.selectRectangle.setY(Math.min(this.selectStartPoint.getY(), this.selectEndPoint.getY()));
        this.selectRectangle.setWidth(Math.abs(this.selectEndPoint.getX() - this.selectStartPoint.getX()));
        this.selectRectangle.setHeight(Math.abs(this.selectEndPoint.getY() - this.selectStartPoint.getY()));
    }

    protected void selectionEnded() {
        this.selectRectangle.setVisible(false);
        if (this.selectRectangle.getWidth() > 5.0 && this.selectRectangle.getHeight() > 5.0) {
            this.performSelection();
        }
        this.selectEndPoint = null;
        this.selectStartPoint = null;
    }

    protected boolean selectionOngoing() {
        return this.selectStartPoint != null;
    }

    protected void selectionStarted(MouseEvent mouseEvent) {
        this.selectStartPoint = new Point2D(mouseEvent.getX(), mouseEvent.getY());
        this.selectRectangle.setX(this.selectStartPoint.getX());
        this.selectRectangle.setY(this.selectStartPoint.getY());
        this.selectRectangle.setWidth(0.0);
        this.selectRectangle.setHeight(0.0);
        this.selectRectangle.setVisible(true);
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final void setPickingDistance(double d2) {
        this.pickingDistanceProperty().set(d2);
    }

    public void setZoomInMouseFilter(Predicate<MouseEvent> predicate) {
        this.zoomInMouseFilter = predicate;
    }

    protected EventHandler<MouseEvent> startDragHandler(SelectedDataPoint selectedDataPoint) {
        return mouseEvent -> {
            if (mouseEvent.isPrimaryButtonDown() && !controlDown && !shiftDown) {
                this.isPointDragActive = true;
                this.mouseOriginX = mouseEvent.getSceneX();
                this.mouseOriginY = mouseEvent.getSceneY();
                selectedDataPoint.setCursor(Cursor.CLOSED_HAND);
                mouseEvent.consume();
            }
            if (mouseEvent.isSecondaryButtonDown()) {
                this.popup.showPopup((MouseEvent)mouseEvent, selectedDataPoint);
            }
        };
    }

    protected void uninstallCursor() {
        this.getChart().setCursor(this.originalCursor);
    }

    protected void updateMarker() {
        this.markerPane.getChildren().clear();
        this.markerPane.getParent().setMouseTransparent(false);
        for (EditableDataSet editableDataSet : this.markedPoints.keySet()) {
            ConcurrentHashMap<Integer, SelectedDataPoint> concurrentHashMap = this.markedPoints.get(editableDataSet);
            if (concurrentHashMap == null) continue;
            for (Integer n2 : concurrentHashMap.keySet()) {
                SelectedDataPoint selectedDataPoint = concurrentHashMap.get(n2);
                selectedDataPoint.update();
                this.markerPane.getChildren().add((Object)selectedDataPoint);
            }
        }
        if (this.markerPane.getChildren().isEmpty()) {
            this.markerPane.getParent().setMouseTransparent(true);
        }
    }

    private static Axis getFirstAxis(List<Axis> list, Orientation orientation) {
        block3: for (Axis axis : list) {
            if (axis.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis.getSide().isVertical()) continue block3;
                    return axis;
                }
            }
            if (!axis.getSide().isHorizontal()) continue;
            return axis;
        }
        return null;
    }

    public static boolean isControlDown() {
        return controlDown;
    }

    public static boolean isShiftDown() {
        return shiftDown;
    }

    private static Point2D limitToPlotArea(MouseEvent mouseEvent, Bounds bounds) {
        double d2 = Math.max(Math.min(mouseEvent.getX() - bounds.getMinX(), bounds.getMaxX()), bounds.getMinX());
        double d3 = Math.max(Math.min(mouseEvent.getY() - bounds.getMinY(), bounds.getMaxY()), bounds.getMinY());
        return new Point2D(d2, d3);
    }

    protected int findIndex(DataSet dataSet, int n2, double d2, double d3) {
        if (n2 >= 0 && n2 < dataSet.getDataCount() && dataSet.get(0, n2) == d2 && dataSet.get(1, n2) == d3) {
            return n2;
        }
        for (int i2 = 0; i2 < dataSet.getDataCount(); ++i2) {
            if (dataSet.get(0, i2) != d2 || dataSet.get(1, i2) != d3) continue;
            return i2;
        }
        return -1;
    }

    protected class PointEditionPopup
    extends Popup {
        private final Button addPoint = new Button("add");
        private final Button deletePoint = new Button("delete");
        private final Button deletePoints = new Button("delete all");

        public PointEditionPopup() {
            this.setAutoFix(true);
            this.setAutoHide(true);
            this.setHideOnEscape(true);
            this.setAutoHide(true);
            this.getContent().add((Object)this.initContent());
            this.addPoint.setOnAction(actionEvent -> {
                double d2 = this.getX();
                double d3 = this.getY();
                EditDataSet.this.addPoint(d2, d3);
            });
            this.deletePoints.setOnAction(actionEvent -> EditDataSet.this.deleteAllMarkedPoints());
        }

        private VBox initContent() {
            VBox vBox = new VBox();
            vBox.getChildren().add((Object)new Label("popup"));
            vBox.getChildren().add((Object)this.addPoint);
            vBox.getChildren().add((Object)this.deletePoint);
            vBox.getChildren().add((Object)this.deletePoints);
            return vBox;
        }

        public void showPopup(MouseEvent mouseEvent, SelectedDataPoint selectedDataPoint) {
            this.deletePoints.setDisable(EditDataSet.this.markerPane.getChildren().isEmpty());
            if (selectedDataPoint == null) {
                this.deletePoint.setDisable(true);
            } else {
                this.deletePoint.setDisable(false);
                this.deletePoint.setOnAction(actionEvent -> {
                    if (selectedDataPoint.delete()) {
                        EditDataSet.this.markedPoints.get(selectedDataPoint.getDataSet()).remove(selectedDataPoint.getIndex());
                    }
                    EditDataSet.this.updateMarker();
                });
            }
            this.show(EditDataSet.this.getChart().getScene().getWindow(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
        }
    }

    public static class DataPoint {
        private final Chart chart;
        private final double x;
        private final double y;
        private final String label;
        private double distanceFromMouse;
        private final DataSet dataSet;
        private final int index;

        public DataPoint(Chart chart, DataSet dataSet, int n2, double d2, double d3, String string) {
            this.chart = chart;
            this.dataSet = dataSet;
            this.index = n2;
            this.x = d2;
            this.y = d3;
            this.label = string;
        }

        public Chart getChart() {
            return this.chart;
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }

        public double getDistanceFromMouse() {
            return this.distanceFromMouse;
        }

        public int getIndex() {
            return this.index;
        }

        public String getLabel() {
            return this.label;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setDistanceFromMouse(double d2) {
            this.distanceFromMouse = d2;
        }

        public String toString() {
            return "DataSet= '" + this.dataSet.getName() + "' index=" + this.index;
        }
    }

    protected class SelectedDataPoint
    extends Circle {
        private final Axis xAxis;
        private final Axis yAxis;
        private final EditableDataSet dataSet;
        private double xValue;
        private double yValue;
        private int cachedIndex;

        SelectedDataPoint(Axis axis, Axis axis2, EditableDataSet editableDataSet, int n2) {
            this.getStyleClass().add((Object)EditDataSet.STYLE_CLASS_SELECT_PATH);
            this.setManaged(false);
            EditConstraints editConstraints = editableDataSet.getEditConstraints();
            if (editConstraints == null) {
                this.pseudoClassStateChanged(NOEDIT_PSEUDO_CLASS, false);
            } else {
                boolean bl2 = editConstraints.canChange(n2);
                if (!bl2) {
                    this.pseudoClassStateChanged(NOEDIT_PSEUDO_CLASS, true);
                }
            }
            this.xAxis = axis;
            this.yAxis = axis2;
            this.dataSet = editableDataSet;
            this.xValue = editableDataSet.get(0, n2);
            this.yValue = editableDataSet.get(1, n2);
            this.cachedIndex = n2;
            this.setCenterX(this.getX());
            this.setCenterY(this.getY());
            this.setRadius(5.0);
            EventHandler eventHandler = inputEvent -> {
                EditDataSet.this.isPointDragActive = false;
                this.setCursor(Cursor.DEFAULT);
            };
            this.setOnMouseEntered(mouseEvent -> this.setCursor(Cursor.OPEN_HAND));
            this.addEventFilter(MouseDragEvent.MOUSE_DRAG_OVER, eventHandler);
            this.setOnMousePressed(EditDataSet.this.startDragHandler(this));
            this.setOnMouseReleased(eventHandler);
            this.setOnMouseDragOver(eventHandler);
        }

        public void applyDrag(double d2, double d3) {
            double d4 = this.getX();
            double d5 = this.getY();
            int n2 = this.getIndex();
            EditConstraints editConstraints = this.dataSet.getEditConstraints();
            if (editConstraints == null) {
                if (EditDataSet.this.allowShiftX.get()) {
                    d4 += d2;
                }
                if (EditDataSet.this.allowShiftY.get()) {
                    d5 += d3;
                }
                double d6 = this.xAxis.getValueForDisplay(d4);
                double d7 = this.yAxis.getValueForDisplay(d5);
                this.dataSet.set(n2, d6, d7);
                this.xValue = d6;
                this.yValue = d7;
                return;
            }
            boolean bl2 = editConstraints.canChange(n2);
            if (bl2 && editConstraints.isEditable(0) && EditDataSet.this.allowShiftX.get()) {
                d4 += d2;
            }
            if (bl2 && editConstraints.isEditable(1) && EditDataSet.this.allowShiftY.get()) {
                d5 += d3;
            }
            double d8 = this.xAxis.getValueForDisplay(d4);
            double d9 = this.yAxis.getValueForDisplay(d5);
            this.dataSet.set(n2, d8, d9);
            this.xValue = d8;
            this.yValue = d9;
        }

        public boolean delete() {
            EditConstraints editConstraints = this.dataSet.getEditConstraints();
            int n2 = this.getIndex();
            if (editConstraints == null || editConstraints.canDelete(n2)) {
                this.dataSet.remove(n2);
                return true;
            }
            return false;
        }

        public EditableDataSet getDataSet() {
            return this.dataSet;
        }

        public int getIndex() {
            this.cachedIndex = EditDataSet.this.findIndex(this.dataSet, this.cachedIndex, this.xValue, this.yValue);
            return this.cachedIndex;
        }

        public double getX() {
            return this.xAxis.getDisplayPosition(this.xValue);
        }

        public double getY() {
            return this.yAxis.getDisplayPosition(this.yValue);
        }

        public String toString() {
            return "selected index=" + this.getIndex();
        }

        public void update() {
            this.setCenterX(this.getX());
            this.setCenterY(this.getY());
        }
    }

    static enum ShiftConstraint {
        SHIFTXY,
        SHIFTX,
        SHIFTY;

    }

    static class ShiftConstraintListCell
    extends ListCell<ShiftConstraint> {
        public ShiftConstraintListCell() {
            this.setContentDisplay(ContentDisplay.LEFT);
        }

        protected void updateItem(ShiftConstraint shiftConstraint, boolean bl2) {
            FontIcon fontIcon;
            super.updateItem((Object)shiftConstraint, bl2);
            if (shiftConstraint == null || bl2) {
                this.setGraphic(null);
                return;
            }
            Tooltip tooltip = new Tooltip();
            switch (shiftConstraint) {
                case SHIFTX: {
                    fontIcon = new FontIcon("fa-arrows-h:18");
                    tooltip.setText("Allow to modify the points's x values");
                    this.setText("shift x");
                    break;
                }
                case SHIFTXY: {
                    fontIcon = new FontIcon("fa-arrows:18");
                    tooltip.setText("Allow to modify the points freely");
                    this.setText("shift xy");
                    break;
                }
                case SHIFTY: {
                    fontIcon = new FontIcon("fa-arrows-v:18");
                    tooltip.setText("Allow to modify the point's y values");
                    this.setText("shift y");
                    break;
                }
                default: {
                    fontIcon = new FontIcon("fa-question-circle-o:18");
                    this.setText("-");
                }
            }
            fontIcon.setFill((Paint)Color.DARKBLUE);
            this.setGraphic((Node)fontIcon);
        }
    }
}

