/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.plugins.AbstractValueIndicator;
import io.fair_acc.chartfx.plugins.ValueIndicator;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.events.ChartBits;
import java.util.function.IntSupplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;

public abstract class AbstractSingleValueIndicator
extends AbstractValueIndicator
implements ValueIndicator {
    protected static final int DEFAULT_PICKING_DISTANCE = 30;
    protected static final double MIDDLE_POSITION = 0.5;
    protected static final String STYLE_CLASS_LABEL = "value-indicator-label";
    protected static final String STYLE_CLASS_LINE = "value-indicator-line";
    protected static final String STYLE_CLASS_MARKER = "value-indicator-marker";
    protected static double triangleHalfWidth = 5.0;
    private boolean autoRemove = false;
    protected final Line line = new Line();
    protected final Line pickLine = new Line();
    protected final Polygon triangle = new Polygon();
    private final DoubleProperty pickingDistance = new SimpleDoubleProperty(this, "pickingDistance", 30.0){

        protected void invalidated() {
            if (this.get() <= 0.0) {
                throw new IllegalArgumentException("The " + this.getName() + " must be a positive value");
            }
        }
    };
    private final DoubleProperty value = new SimpleDoubleProperty(this, "value"){

        protected void invalidated() {
            AbstractSingleValueIndicator.this.runPostLayout();
        }
    };
    private final DoubleProperty labelPosition = new SimpleDoubleProperty(this, "labelPosition", 0.5){

        protected void invalidated() {
            if (this.get() < 0.0 || this.get() > 1.0) {
                throw new IllegalArgumentException("labelPosition must be in rage [0,1]");
            }
            AbstractSingleValueIndicator.this.runPostLayout();
        }
    };

    protected AbstractSingleValueIndicator(Axis axis, double d2, String string) {
        super(axis, string);
        this.setValue(d2);
        this.initLine();
        this.initTriangle();
        this.editableIndicatorProperty().addListener((observableValue, bl2, bl3) -> this.updateMouseListener((boolean)bl3));
        this.updateMouseListener(this.isEditable());
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getPlotForeground().getChildren().remove((Object)this.triangle);
            }
        });
        this.getChartChildren().addAll((Object[])new Node[]{this.line, this.label});
        PropUtil.runOnChange(this.getBitState().onAction(ChartBits.ChartPluginState, new IntSupplier[0]), new ObservableValue[]{this.value});
    }

    public final double getLabelPosition() {
        return this.labelPositionProperty().get();
    }

    public final double getPickingDistance() {
        return this.pickingDistanceProperty().get();
    }

    @Override
    public final double getValue() {
        return this.valueProperty().get();
    }

    private void initLine() {
        this.line.setMouseTransparent(true);
        this.pickLine.setPickOnBounds(true);
        this.pickLine.setStroke((Paint)Color.TRANSPARENT);
        this.pickLine.setStrokeWidth(this.getPickingDistance());
        this.pickLine.mouseTransparentProperty().bind((ObservableValue)this.editableIndicatorProperty().not());
        this.pickLine.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.isPrimaryButtonDown()) {
                this.dragDelta.x = this.pickLine.getStartX() - mouseEvent.getX();
                this.dragDelta.y = -(this.pickLine.getStartY() - mouseEvent.getY());
                this.pickLine.setCursor(Cursor.MOVE);
                mouseEvent.consume();
            }
        });
    }

    private void initTriangle() {
        this.triangle.visibleProperty().bind((ObservableValue)this.editableIndicatorProperty());
        this.triangle.mouseTransparentProperty().bind((ObservableValue)this.editableIndicatorProperty().not());
        this.triangle.setPickOnBounds(true);
        this.triangle.setManaged(false);
        this.triangle.setOpacity(0.7);
        double d2 = triangleHalfWidth;
        this.triangle.getPoints().setAll((Object[])new Double[]{-d2, -d2, -d2, d2, d2, d2, d2, -d2});
        this.triangle.setOnMousePressed(mouseEvent -> {
            this.dragDelta.x = this.triangle.getLayoutX() - mouseEvent.getX();
            this.dragDelta.y = this.triangle.getLayoutY() - mouseEvent.getY();
            this.triangle.setCursor(Cursor.MOVE);
            mouseEvent.consume();
        });
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    public final DoubleProperty labelPositionProperty() {
        return this.labelPosition;
    }

    protected void layoutLine(double d2, double d3, double d4, double d5) {
        this.line.setStartX(d2);
        this.line.setStartY(d3);
        this.line.setEndX(d4);
        this.line.setEndY(d5);
        this.pickLine.setStartX(d2);
        this.pickLine.setStartY(d3);
        this.pickLine.setEndX(d4);
        this.pickLine.setEndY(d5);
        this.addChildNodeIfNotPresent((Node)this.pickLine);
        this.addChildNodeIfNotPresent((Node)this.line);
    }

    protected void layoutMarker(double d2, double d3, double d4, double d5) {
        if (!this.triangle.isVisible()) {
            return;
        }
        this.triangle.setTranslateX(d2);
        this.triangle.setTranslateY(d3);
        this.triangle.toFront();
        if (!this.getChart().getPlotForeground().getChildren().contains((Object)this.triangle)) {
            this.getChart().getPlotForeground().getChildren().add((Object)this.triangle);
        }
    }

    public final DoubleProperty pickingDistanceProperty() {
        return this.pickingDistance;
    }

    public void setAutoRemove(boolean bl2) {
        this.autoRemove = bl2;
    }

    public final void setLabelPosition(double d2) {
        this.labelPositionProperty().set(d2);
    }

    public final void setPickingDistance(double d2) {
        this.pickingDistanceProperty().set(d2);
    }

    @Override
    public final void setValue(double d2) {
        this.valueProperty().set(d2);
    }

    private void updateMouseListener(boolean bl2) {
        if (bl2) {
            this.pickLine.setOnMouseReleased(mouseEvent -> this.pickLine.setCursor(Cursor.HAND));
            this.pickLine.setOnMouseEntered(mouseEvent -> this.pickLine.setCursor(Cursor.HAND));
            this.triangle.setOnMouseReleased(mouseEvent -> this.triangle.setCursor(Cursor.HAND));
            this.triangle.setOnMouseEntered(mouseEvent -> this.triangle.setCursor(Cursor.HAND));
            this.label.setOnMouseReleased(mouseEvent -> this.label.setCursor(Cursor.HAND));
            this.label.setOnMouseEntered(mouseEvent -> this.label.setCursor(Cursor.HAND));
        } else {
            this.pickLine.setOnMouseReleased(null);
            this.pickLine.setOnMouseEntered(null);
            this.triangle.setOnMouseReleased(null);
            this.triangle.setOnMouseEntered(null);
            this.label.setOnMouseReleased(null);
            this.label.setOnMouseEntered(null);
        }
    }

    @Override
    public final DoubleProperty valueProperty() {
        return this.value;
    }
}

