/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.bench;

import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.bench.TimeMeasure;
import io.fair_acc.dataset.utils.AssertUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.SingleWriterRecorder;

public class HdrHistogramRecorder
implements MeasurementRecorder,
Closeable {
    private final OutputStream out;
    private final HistogramLogWriter logWriter;
    private final List<HdrHistogramMeasure> measurements = new ArrayList<HdrHistogramMeasure>(8);
    private final List<Histogram> histograms = new ArrayList<Histogram>(8);
    private volatile boolean closed = false;
    private final ScheduledFuture<?> task;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public static HdrHistogramRecorder createStarted(String string, long l2, TimeUnit timeUnit) {
        try {
            Path path = Path.of(string, new String[0]);
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            return new HdrHistogramRecorder(path, l2, timeUnit);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeMeasure newTime(String string, IntSupplier intSupplier) {
        HdrHistogramMeasure hdrHistogramMeasure = new HdrHistogramMeasure(string);
        List<HdrHistogramMeasure> list = this.measurements;
        synchronized (list) {
            this.measurements.add(hdrHistogramMeasure);
        }
        return hdrHistogramMeasure;
    }

    private HdrHistogramRecorder(Path path, long l2, TimeUnit timeUnit) throws FileNotFoundException {
        this.out = new FileOutputStream(path.toFile());
        this.logWriter = new HistogramLogWriter(this.out);
        this.logWriter.outputLogFormatVersion();
        long l3 = System.currentTimeMillis();
        this.logWriter.setBaseTime(l3);
        this.logWriter.outputStartTime(l3);
        this.logWriter.outputLegend();
        this.logWriter.outputComment("Units: microseconds");
        this.task = this.executor.scheduleAtFixedRate(this::persistToDisk, l2, l2, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistToDisk() {
        if (this.closed) {
            return;
        }
        try {
            List<HdrHistogramMeasure> list = this.measurements;
            synchronized (list) {
                for (HdrHistogramMeasure hdrHistogramMeasure : this.measurements) {
                    this.histograms.add(hdrHistogramMeasure.getTaggedIntervalHistogram());
                }
            }
            for (Histogram histogram : this.histograms) {
                if (histogram.getTotalCount() == 0L) continue;
                this.logWriter.outputIntervalHistogram(histogram);
            }
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.histograms.clear();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.task.cancel(false);
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static class HdrHistogramMeasure
    implements TimeMeasure {
        final String tag;
        final SingleWriterRecorder histogramRecorder;
        Histogram interval = null;
        private static final long defaultMinValue = 1L;
        private static final long defaultMaxValue = TimeUnit.SECONDS.toMicros(10L);
        private static final int numberOfSignificantDigits = 2;

        HdrHistogramMeasure(String string) {
            this.tag = AssertUtils.notNull("tag", string);
            this.histogramRecorder = new SingleWriterRecorder(1L, defaultMaxValue, 2);
        }

        @Override
        public void recordTime(TimeUnit timeUnit, long l2) {
            try {
                this.histogramRecorder.recordValue(timeUnit.toMicros(l2));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("Measurement on '" + this.tag + "' exceeded recordable range. Measured: " + l2 + " ns");
            }
        }

        public Histogram getTaggedIntervalHistogram() {
            this.interval = this.histogramRecorder.getIntervalHistogram(this.interval);
            this.interval.setTag(this.tag);
            return this.interval;
        }
    }
}

