/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.bench;

import io.fair_acc.bench.AggregateDurationMeasure;
import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.TimeMeasure;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;

public class RecordingDurationMeasure
implements DurationMeasure {
    final LongSupplier clock;
    final TimeUnit clockUnit;
    final TimeMeasure recorder;
    protected static final long UNDEFINED_START_TIME = -1L;
    long startTime = -1L;
    protected boolean ignoreMissingStart = false;

    public static DurationMeasure newNanoTime(TimeMeasure timeMeasure) {
        return new RecordingDurationMeasure(TimeUnit.NANOSECONDS, System::nanoTime, timeMeasure);
    }

    public static AggregateDurationMeasure newNanoTimeSum(TimeMeasure timeMeasure) {
        return new Sum(TimeUnit.NANOSECONDS, System::nanoTime, timeMeasure);
    }

    public RecordingDurationMeasure(TimeUnit timeUnit, LongSupplier longSupplier, TimeMeasure timeMeasure) {
        this.clock = RecordingDurationMeasure.checkNotNull("clock", longSupplier);
        this.clockUnit = RecordingDurationMeasure.checkNotNull("clockUnit", timeUnit);
        this.recorder = RecordingDurationMeasure.checkNotNull("recorder", timeMeasure);
    }

    private static <T> T checkNotNull(String string, T t2) {
        if (t2 == null) {
            throw new NullPointerException(string);
        }
        return t2;
    }

    protected void recordDuration(TimeUnit timeUnit, long l2) {
        this.recorder.recordTime(timeUnit, l2);
    }

    @Override
    public void start() {
        this.startTime = this.clock.getAsLong();
    }

    @Override
    public void stop() {
        if (this.startTime == -1L) {
            if (this.ignoreMissingStart) {
                return;
            }
            throw new IllegalStateException("Invalid start time. start() must be called before stop()");
        }
        long l2 = this.clock.getAsLong();
        this.recordDuration(this.clockUnit, l2 - this.startTime);
        this.startTime = -1L;
    }

    @Override
    public DurationMeasure ignoreMissingStart() {
        this.ignoreMissingStart = true;
        return this;
    }

    public static class Sum
    extends RecordingDurationMeasure
    implements AggregateDurationMeasure {
        long sum = 0L;

        public Sum(TimeUnit timeUnit, LongSupplier longSupplier, TimeMeasure timeMeasure) {
            super(timeUnit, longSupplier, timeMeasure);
        }

        @Override
        protected void recordDuration(TimeUnit timeUnit, long l2) {
            this.sum += l2;
        }

        @Override
        public void recordResult() {
            if (this.sum > 0L) {
                super.recordDuration(this.clockUnit, this.sum);
                this.sum = 0L;
            }
        }
    }
}

