/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.exceptions.AeronException;
import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class StatusMessageFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 36;
    public static final short SEND_SETUP_FLAG = 128;
    public static final short END_OF_STREAM_FLAG = 64;
    private static final int SESSION_ID_FIELD_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int CONSUMPTION_TERM_ID_FIELD_OFFSET = 16;
    private static final int CONSUMPTION_TERM_OFFSET_FIELD_OFFSET = 20;
    private static final int RECEIVER_WINDOW_FIELD_OFFSET = 24;
    private static final int RECEIVER_ID_FIELD_OFFSET = 28;
    private static final int APP_SPECIFIC_FEEDBACK_FIELD_OFFSET = 36;
    private static final int GROUP_TAG_FIELD_OFFSET = 36;

    public StatusMessageFlyweight() {
    }

    public StatusMessageFlyweight(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public StatusMessageFlyweight(UnsafeBuffer unsafeBuffer) {
        super(unsafeBuffer);
    }

    public int sessionId() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight sessionId(int n2) {
        this.putInt(8, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight streamId(int n2) {
        this.putInt(12, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int consumptionTermOffset() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight consumptionTermOffset(int n2) {
        this.putInt(20, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int consumptionTermId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight consumptionTermId(int n2) {
        this.putInt(16, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int receiverWindowLength() {
        return this.getInt(24, ByteOrder.LITTLE_ENDIAN);
    }

    public StatusMessageFlyweight receiverWindowLength(int n2) {
        this.putInt(24, n2, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public long receiverId() {
        return this.getLongUnaligned(28);
    }

    public StatusMessageFlyweight receiverId(long l2) {
        return this.putLongUnaligned(28, l2);
    }

    public int asfLength() {
        return this.frameLength() - 36;
    }

    public long groupTag() {
        int n2 = this.frameLength();
        if (n2 > 36) {
            if (n2 > 44) {
                throw new AeronException("SM has longer application specific feedback (" + (n2 - 36) + ") than gtag");
            }
            return this.getLongUnaligned(36);
        }
        return 0L;
    }

    public StatusMessageFlyweight groupTag(Long l2) {
        if (null != l2) {
            this.frameLength(44);
            this.putLongUnaligned(36, l2);
        } else {
            this.frameLength(36);
        }
        return this;
    }

    public static int groupTagFieldOffset() {
        return 36;
    }

    public long getLongUnaligned(int n2) {
        long l2 = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? (long)this.getByte(n2 + 7) << 56 | ((long)this.getByte(n2 + 6) & 0xFFL) << 48 | ((long)this.getByte(n2 + 5) & 0xFFL) << 40 | ((long)this.getByte(n2 + 4) & 0xFFL) << 32 | ((long)this.getByte(n2 + 3) & 0xFFL) << 24 | ((long)this.getByte(n2 + 2) & 0xFFL) << 16 | ((long)this.getByte(n2 + 1) & 0xFFL) << 8 | (long)this.getByte(n2) & 0xFFL : (long)this.getByte(n2) << 56 | ((long)this.getByte(n2 + 1) & 0xFFL) << 48 | ((long)this.getByte(n2 + 2) & 0xFFL) << 40 | ((long)this.getByte(n2 + 3) & 0xFFL) << 32 | ((long)this.getByte(n2 + 4) & 0xFFL) << 24 | ((long)this.getByte(n2 + 5) & 0xFFL) << 16 | ((long)this.getByte(n2 + 6) & 0xFFL) << 8 | (long)this.getByte(n2 + 7) & 0xFFL;
        return l2;
    }

    public StatusMessageFlyweight putLongUnaligned(int n2, long l2) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.putByte(n2 + 7, (byte)(l2 >> 56));
            this.putByte(n2 + 6, (byte)(l2 >> 48));
            this.putByte(n2 + 5, (byte)(l2 >> 40));
            this.putByte(n2 + 4, (byte)(l2 >> 32));
            this.putByte(n2 + 3, (byte)(l2 >> 24));
            this.putByte(n2 + 2, (byte)(l2 >> 16));
            this.putByte(n2 + 1, (byte)(l2 >> 8));
            this.putByte(n2, (byte)l2);
        } else {
            this.putByte(n2, (byte)(l2 >> 56));
            this.putByte(n2 + 1, (byte)(l2 >> 48));
            this.putByte(n2 + 2, (byte)(l2 >> 40));
            this.putByte(n2 + 3, (byte)(l2 >> 32));
            this.putByte(n2 + 4, (byte)(l2 >> 24));
            this.putByte(n2 + 5, (byte)(l2 >> 16));
            this.putByte(n2 + 6, (byte)(l2 >> 8));
            this.putByte(n2 + 7, (byte)l2);
        }
        return this;
    }

    @Override
    public String toString() {
        return "STATUS{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(StatusMessageFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " consumption-term-id=" + this.consumptionTermId() + " consumption-term-offset=" + this.consumptionTermOffset() + " receiver-window-length=" + this.receiverWindowLength() + "}";
    }
}

